/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.xwiki.macros;

import com.vladsch.flexmark.ast.CustomNode;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.xwiki.macros.MacroAttribute;
import com.vladsch.flexmark.ext.xwiki.macros.MacroBlock;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.LinkedHashMap;
import java.util.Map;

public class Macro
extends CustomNode {
    protected BasedSequence openingMarker = BasedSequence.NULL;
    protected BasedSequence name = BasedSequence.NULL;
    protected BasedSequence attributeText = BasedSequence.NULL;
    protected BasedSequence closingMarker = BasedSequence.NULL;

    @Override
    public BasedSequence[] getSegments() {
        return new BasedSequence[]{this.openingMarker, this.name, this.attributeText, this.closingMarker};
    }

    @Override
    public void getAstExtra(StringBuilder out) {
        Macro.segmentSpanChars(out, this.openingMarker, "open");
        Macro.segmentSpanChars(out, this.name, "name");
        Macro.segmentSpanChars(out, this.attributeText, "attributes");
        Macro.segmentSpanChars(out, this.closingMarker, "close");
        if (this.isClosedTag()) {
            out.append(" isClosed");
        }
        if (this.isBlockMacro()) {
            out.append(" isBlockMacro");
        }
        Macro.segmentSpanChars(out, this.getMacroContentChars(), "macroContent");
    }

    public Macro() {
    }

    public Macro(BasedSequence chars) {
        super(chars);
    }

    public Macro(BasedSequence openingMarker, BasedSequence name, BasedSequence closingMarker) {
        super(openingMarker.baseSubSequence(openingMarker.getStartOffset(), closingMarker.getEndOffset()));
        this.openingMarker = openingMarker;
        this.name = name;
        this.closingMarker = closingMarker;
    }

    public BasedSequence getOpeningMarker() {
        return this.openingMarker;
    }

    public void setOpeningMarker(BasedSequence openingMarker) {
        this.openingMarker = openingMarker;
    }

    public BasedSequence getName() {
        return this.name;
    }

    public void setName(BasedSequence name) {
        this.name = name;
    }

    public BasedSequence getClosingMarker() {
        return this.closingMarker;
    }

    public void setClosingMarker(BasedSequence closingMarker) {
        this.closingMarker = closingMarker;
    }

    public BasedSequence getAttributeText() {
        return this.attributeText;
    }

    public void setAttributeText(BasedSequence attributeText) {
        this.attributeText = attributeText;
    }

    public boolean isBlockMacro() {
        Node parent = this.getParent();
        return parent instanceof MacroBlock && parent.getFirstChild() == this;
    }

    public Map<String, String> getAttributes() {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        for (Node child = this.getFirstChild(); child != null; child = child.getNext()) {
            if (!(child instanceof MacroAttribute)) continue;
            MacroAttribute attribute = (MacroAttribute)child;
            attributes.put(attribute.getAttribute().toString(), attribute.getValue().toString());
        }
        return attributes;
    }

    public BasedSequence getMacroContentChars() {
        Node lastChild = this.getLastChild();
        int startOffset = this.getClosingMarker().getEndOffset();
        int endOffset = lastChild == null || lastChild instanceof MacroAttribute ? this.getEndOffset() : lastChild.getStartOffset();
        return this.isClosedTag() ? BasedSequence.NULL : this.getChars().baseSubSequence(startOffset, endOffset);
    }

    public boolean isClosedTag() {
        return this.getClosingMarker().length() > 2;
    }
}

