/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gitlab.internal;

import com.vladsch.flexmark.ext.gitlab.GitLabExtension;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.MutableDataHolder;
import com.vladsch.flexmark.util.options.MutableDataSetter;
import java.util.HashSet;

public class GitLabOptions
implements MutableDataSetter {
    public final boolean insParser;
    public final boolean delParser;
    public final boolean inlineMathParser;
    public final boolean blockQuoteParser;
    public final boolean nestedBlockQuotes;
    public final boolean renderBlockMath;
    public final boolean renderBlockMermaid;
    public final boolean renderVideoImages;
    public final boolean renderVideoLink;
    public final String inlineMathClass;
    public final String blockMathClass;
    public final String blockMermaidClass;
    public final String blockInfoDelimiters;
    public final String videoImageClass;
    public final String videoImageLinkTextFormat;
    public final String videoImageExtensions;
    public final HashSet<String> videoImageExtensionSet;

    public GitLabOptions(DataHolder options) {
        String[] extensions;
        this.insParser = GitLabExtension.INS_PARSER.getFrom(options);
        this.delParser = GitLabExtension.DEL_PARSER.getFrom(options);
        this.inlineMathParser = GitLabExtension.INLINE_MATH_PARSER.getFrom(options);
        this.blockQuoteParser = GitLabExtension.BLOCK_QUOTE_PARSER.getFrom(options);
        this.nestedBlockQuotes = GitLabExtension.NESTED_BLOCK_QUOTES.getFrom(options);
        this.inlineMathClass = GitLabExtension.INLINE_MATH_CLASS.getFrom(options);
        this.renderBlockMath = GitLabExtension.RENDER_BLOCK_MATH.getFrom(options);
        this.renderBlockMermaid = GitLabExtension.RENDER_BLOCK_MERMAID.getFrom(options);
        this.renderVideoImages = GitLabExtension.RENDER_VIDEO_IMAGES.getFrom(options);
        this.renderVideoLink = GitLabExtension.RENDER_VIDEO_LINK.getFrom(options);
        this.blockMathClass = GitLabExtension.BLOCK_MATH_CLASS.getFrom(options);
        this.blockMermaidClass = GitLabExtension.BLOCK_MERMAID_CLASS.getFrom(options);
        this.blockInfoDelimiters = GitLabExtension.BLOCK_INFO_DELIMITERS.getFrom(options);
        this.videoImageClass = GitLabExtension.VIDEO_IMAGE_CLASS.getFrom(options);
        this.videoImageLinkTextFormat = GitLabExtension.VIDEO_IMAGE_LINK_TEXT_FORMAT.getFrom(options);
        this.videoImageExtensions = GitLabExtension.VIDEO_IMAGE_EXTENSIONS.getFrom(options);
        this.videoImageExtensionSet = new HashSet();
        for (String ext : extensions = this.videoImageExtensions.split(",")) {
            String trimmed = ext.trim();
            if (trimmed.isEmpty()) continue;
            this.videoImageExtensionSet.add(trimmed);
        }
    }

    @Override
    public MutableDataHolder setIn(MutableDataHolder dataHolder) {
        dataHolder.set(GitLabExtension.INS_PARSER, this.insParser);
        dataHolder.set(GitLabExtension.DEL_PARSER, this.delParser);
        dataHolder.set(GitLabExtension.INLINE_MATH_PARSER, this.inlineMathParser);
        dataHolder.set(GitLabExtension.BLOCK_QUOTE_PARSER, this.blockQuoteParser);
        dataHolder.set(GitLabExtension.NESTED_BLOCK_QUOTES, this.nestedBlockQuotes);
        dataHolder.set(GitLabExtension.INLINE_MATH_CLASS, this.inlineMathClass);
        dataHolder.set(GitLabExtension.RENDER_BLOCK_MATH, this.renderBlockMath);
        dataHolder.set(GitLabExtension.RENDER_BLOCK_MERMAID, this.renderBlockMermaid);
        dataHolder.set(GitLabExtension.RENDER_VIDEO_IMAGES, this.renderVideoImages);
        dataHolder.set(GitLabExtension.RENDER_VIDEO_LINK, this.renderVideoLink);
        dataHolder.set(GitLabExtension.BLOCK_MATH_CLASS, this.blockMathClass);
        dataHolder.set(GitLabExtension.BLOCK_MERMAID_CLASS, this.blockMermaidClass);
        dataHolder.set(GitLabExtension.BLOCK_INFO_DELIMITERS, this.blockInfoDelimiters);
        dataHolder.set(GitLabExtension.VIDEO_IMAGE_CLASS, this.videoImageClass);
        dataHolder.set(GitLabExtension.VIDEO_IMAGE_LINK_TEXT_FORMAT, this.videoImageLinkTextFormat);
        dataHolder.set(GitLabExtension.VIDEO_IMAGE_EXTENSIONS, this.videoImageExtensions);
        return dataHolder;
    }
}

