/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gitlab.internal;

import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ext.gitlab.GitLabDel;
import com.vladsch.flexmark.ext.gitlab.GitLabInline;
import com.vladsch.flexmark.ext.gitlab.GitLabIns;
import com.vladsch.flexmark.ext.gitlab.internal.GitLabOptions;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.InlineParserExtension;
import com.vladsch.flexmark.parser.InlineParserExtensionFactory;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class GitLabInlineParser
implements InlineParserExtension {
    private final List<GitLabInline> openInlines = new ArrayList<GitLabInline>();
    private final GitLabOptions options;

    public GitLabInlineParser(InlineParser inlineParser) {
        this.options = new GitLabOptions(inlineParser.getDocument());
    }

    @Override
    public void finalizeDocument(InlineParser inlineParser) {
    }

    @Override
    public void finalizeBlock(InlineParser inlineParser) {
        int j = this.openInlines.size();
        while (j-- > 0) {
            GitLabInline gitLabInline = this.openInlines.get(j);
            Text textNode = new Text(gitLabInline.getChars());
            gitLabInline.insertBefore(textNode);
            gitLabInline.unlink();
        }
        this.openInlines.clear();
    }

    @Override
    public boolean parse(InlineParser inlineParser) {
        char firstChar = inlineParser.peek();
        char secondChar = inlineParser.peek(1);
        if ((firstChar == '{' || firstChar == '[') && (this.options.insParser && secondChar == '+' || this.options.delParser && secondChar == '-')) {
            BasedSequence input = inlineParser.getInput().subSequence(inlineParser.getIndex());
            GitLabInline open = secondChar == '+' ? new GitLabIns(input.subSequence(0, 2)) : new GitLabDel(input.subSequence(0, 2));
            inlineParser.flushTextNode();
            inlineParser.getBlock().appendChild(open);
            this.openInlines.add(open);
            inlineParser.setIndex(inlineParser.getIndex() + 2);
            return true;
        }
        if ((this.options.insParser && firstChar == '+' || this.options.delParser && firstChar == '-') && (secondChar == ']' || secondChar == '}')) {
            BasedSequence input = inlineParser.getInput().subSequence(inlineParser.getIndex());
            BasedSequence matchOpen = BasedSequenceImpl.of(secondChar == ']' ? (firstChar == '+' ? "[+" : "[-") : (firstChar == '+' ? "{+" : "{-"));
            int i = this.openInlines.size();
            while (i-- > 0) {
                GitLabInline open = this.openInlines.get(i);
                BasedSequence openMarker = open.getChars();
                if (!openMarker.equals(matchOpen)) continue;
                inlineParser.setIndex(inlineParser.getIndex() + 2);
                BasedSequence closingMarker = input.subSequence(0, 2);
                open.setOpeningMarker(openMarker);
                open.setClosingMarker(closingMarker);
                open.setText(openMarker.baseSubSequence(openMarker.getEndOffset(), closingMarker.getStartOffset()));
                inlineParser.flushTextNode();
                Node last = inlineParser.getBlock().getLastChild();
                inlineParser.moveNodes(open, last);
                if (i == 0) {
                    this.openInlines.clear();
                } else {
                    this.openInlines.subList(i, this.openInlines.size()).clear();
                }
                return true;
            }
        }
        return false;
    }

    public static class Factory
    implements InlineParserExtensionFactory {
        @Override
        public Set<Class<? extends InlineParserExtensionFactory>> getAfterDependents() {
            return null;
        }

        @Override
        public CharSequence getCharacters() {
            return "{[-+";
        }

        @Override
        public Set<Class<? extends InlineParserExtensionFactory>> getBeforeDependents() {
            return null;
        }

        @Override
        public InlineParserExtension create(InlineParser inlineParser) {
            return new GitLabInlineParser(inlineParser);
        }

        @Override
        public boolean affectsGlobalScope() {
            return false;
        }
    }
}

