/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.jira.converter.internal;

import com.vladsch.flexmark.ast.AutoLink;
import com.vladsch.flexmark.ast.BlockQuote;
import com.vladsch.flexmark.ast.BulletList;
import com.vladsch.flexmark.ast.BulletListItem;
import com.vladsch.flexmark.ast.Code;
import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Emphasis;
import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.ast.HardLineBreak;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.HtmlBlock;
import com.vladsch.flexmark.ast.HtmlBlockBase;
import com.vladsch.flexmark.ast.HtmlCommentBlock;
import com.vladsch.flexmark.ast.HtmlEntity;
import com.vladsch.flexmark.ast.HtmlInline;
import com.vladsch.flexmark.ast.HtmlInlineBase;
import com.vladsch.flexmark.ast.HtmlInlineComment;
import com.vladsch.flexmark.ast.HtmlInnerBlock;
import com.vladsch.flexmark.ast.HtmlInnerBlockComment;
import com.vladsch.flexmark.ast.Image;
import com.vladsch.flexmark.ast.ImageRef;
import com.vladsch.flexmark.ast.IndentedCodeBlock;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.ast.LinkRef;
import com.vladsch.flexmark.ast.ListBlock;
import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.MailLink;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.OrderedList;
import com.vladsch.flexmark.ast.OrderedListItem;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.ParagraphItemContainer;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.ast.SoftLineBreak;
import com.vladsch.flexmark.ast.StrongEmphasis;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ast.ThematicBreak;
import com.vladsch.flexmark.ast.util.ReferenceRepository;
import com.vladsch.flexmark.ast.util.TextCollectingVisitor;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.parser.ListOptions;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.html.Escaping;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class JiraConverterNodeRenderer
implements NodeRenderer {
    private static String fromChars = " +/<>";
    private static String toChars = "-----";
    private final ReferenceRepository referenceRepository;
    private final ListOptions listOptions;
    private int inBlockQuote = 0;

    public JiraConverterNodeRenderer(DataHolder options) {
        this.referenceRepository = (ReferenceRepository)options.get(Parser.REFERENCES);
        this.listOptions = ListOptions.getFrom((DataHolder)options);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        return new HashSet(Arrays.asList(new NodeRenderingHandler(AutoLink.class, (CustomNodeRenderer)new CustomNodeRenderer<AutoLink>(){

            public void render(AutoLink node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(BlockQuote.class, (CustomNodeRenderer)new CustomNodeRenderer<BlockQuote>(){

            public void render(BlockQuote node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(BulletList.class, (CustomNodeRenderer)new CustomNodeRenderer<BulletList>(){

            public void render(BulletList node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(BulletListItem.class, (CustomNodeRenderer)new CustomNodeRenderer<BulletListItem>(){

            public void render(BulletListItem node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(Code.class, (CustomNodeRenderer)new CustomNodeRenderer<Code>(){

            public void render(Code node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(Document.class, (CustomNodeRenderer)new CustomNodeRenderer<Document>(){

            public void render(Document node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(Emphasis.class, (CustomNodeRenderer)new CustomNodeRenderer<Emphasis>(){

            public void render(Emphasis node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(FencedCodeBlock.class, (CustomNodeRenderer)new CustomNodeRenderer<FencedCodeBlock>(){

            public void render(FencedCodeBlock node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(HardLineBreak.class, (CustomNodeRenderer)new CustomNodeRenderer<HardLineBreak>(){

            public void render(HardLineBreak node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(Heading.class, (CustomNodeRenderer)new CustomNodeRenderer<Heading>(){

            public void render(Heading node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(HtmlBlock.class, (CustomNodeRenderer)new CustomNodeRenderer<HtmlBlock>(){

            public void render(HtmlBlock node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(HtmlCommentBlock.class, (CustomNodeRenderer)new CustomNodeRenderer<HtmlCommentBlock>(){

            public void render(HtmlCommentBlock node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(HtmlEntity.class, (CustomNodeRenderer)new CustomNodeRenderer<HtmlEntity>(){

            public void render(HtmlEntity node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(HtmlInline.class, (CustomNodeRenderer)new CustomNodeRenderer<HtmlInline>(){

            public void render(HtmlInline node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(HtmlInlineComment.class, (CustomNodeRenderer)new CustomNodeRenderer<HtmlInlineComment>(){

            public void render(HtmlInlineComment node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(HtmlInnerBlock.class, (CustomNodeRenderer)new CustomNodeRenderer<HtmlInnerBlock>(){

            public void render(HtmlInnerBlock node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(HtmlInnerBlockComment.class, (CustomNodeRenderer)new CustomNodeRenderer<HtmlInnerBlockComment>(){

            public void render(HtmlInnerBlockComment node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(Image.class, (CustomNodeRenderer)new CustomNodeRenderer<Image>(){

            public void render(Image node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(ImageRef.class, (CustomNodeRenderer)new CustomNodeRenderer<ImageRef>(){

            public void render(ImageRef node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(IndentedCodeBlock.class, (CustomNodeRenderer)new CustomNodeRenderer<IndentedCodeBlock>(){

            public void render(IndentedCodeBlock node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(Link.class, (CustomNodeRenderer)new CustomNodeRenderer<Link>(){

            public void render(Link node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(LinkRef.class, (CustomNodeRenderer)new CustomNodeRenderer<LinkRef>(){

            public void render(LinkRef node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(MailLink.class, (CustomNodeRenderer)new CustomNodeRenderer<MailLink>(){

            public void render(MailLink node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(OrderedList.class, (CustomNodeRenderer)new CustomNodeRenderer<OrderedList>(){

            public void render(OrderedList node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(OrderedListItem.class, (CustomNodeRenderer)new CustomNodeRenderer<OrderedListItem>(){

            public void render(OrderedListItem node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(Paragraph.class, (CustomNodeRenderer)new CustomNodeRenderer<Paragraph>(){

            public void render(Paragraph node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(Reference.class, (CustomNodeRenderer)new CustomNodeRenderer<Reference>(){

            public void render(Reference node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(SoftLineBreak.class, (CustomNodeRenderer)new CustomNodeRenderer<SoftLineBreak>(){

            public void render(SoftLineBreak node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(StrongEmphasis.class, (CustomNodeRenderer)new CustomNodeRenderer<StrongEmphasis>(){

            public void render(StrongEmphasis node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(Text.class, (CustomNodeRenderer)new CustomNodeRenderer<Text>(){

            public void render(Text node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(TextBase.class, (CustomNodeRenderer)new CustomNodeRenderer<TextBase>(){

            public void render(TextBase node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(ThematicBreak.class, (CustomNodeRenderer)new CustomNodeRenderer<ThematicBreak>(){

            public void render(ThematicBreak node, NodeRendererContext context, HtmlWriter html) {
                JiraConverterNodeRenderer.this.render(node, context, html);
            }
        })));
    }

    private void render(Document node, NodeRendererContext context, HtmlWriter html) {
        context.renderChildren((Node)node);
    }

    private void render(Heading node, NodeRendererContext context, HtmlWriter html) {
        ((HtmlWriter)html.line()).raw((CharSequence)("h" + node.getLevel() + ". "));
        context.renderChildren((Node)node);
        html.blankLine();
    }

    private void render(BlockQuote node, NodeRendererContext context, HtmlWriter html) {
        ((HtmlWriter)((HtmlWriter)html.line()).raw((CharSequence)"{quote}")).line();
        ++this.inBlockQuote;
        context.renderChildren((Node)node);
        --this.inBlockQuote;
        ((HtmlWriter)((HtmlWriter)html.line()).raw((CharSequence)"{quote}")).blankLine();
    }

    private void render(FencedCodeBlock node, NodeRendererContext context, HtmlWriter html) {
        BasedSequence info = node.getInfo();
        if (info.isNotNull() && !info.isBlank()) {
            ((HtmlWriter)((HtmlWriter)html.line()).raw((CharSequence)("{code:lang=" + info.unescape() + "}"))).line();
        } else {
            ((HtmlWriter)((HtmlWriter)html.line()).raw((CharSequence)"{code}")).line();
        }
        html.raw((CharSequence)node.getContentChars().normalizeEOL());
        ((HtmlWriter)((HtmlWriter)html.line()).raw((CharSequence)"{code}")).blankLine();
    }

    private void render(ThematicBreak node, NodeRendererContext context, HtmlWriter html) {
        ((HtmlWriter)((HtmlWriter)html.line()).raw((CharSequence)"----")).blankLine();
    }

    private void render(IndentedCodeBlock node, NodeRendererContext context, HtmlWriter html) {
        ((HtmlWriter)((HtmlWriter)html.line()).raw((CharSequence)"{noformat}")).line();
        html.raw((CharSequence)node.getContentChars().trimTailBlankLines().normalizeEndWithEOL());
        ((HtmlWriter)((HtmlWriter)html.line()).raw((CharSequence)"{noformat}")).line();
    }

    private void renderListItemPrefix(ListItem node, NodeRendererContext context, HtmlWriter html) {
        ListItem parent = node;
        StringBuilder prefix = new StringBuilder();
        while (parent instanceof ListBlock || parent instanceof ListItem) {
            if (parent instanceof BulletList) {
                prefix.append('*');
            } else if (parent instanceof OrderedList) {
                prefix.append('#');
            }
            parent = parent.getParent();
        }
        if (prefix.length() > 0) {
            prefix.append(' ');
        }
        ((HtmlWriter)html.line()).raw((CharSequence)prefix.toString());
    }

    private void renderListItem(ListItem node, NodeRendererContext context, HtmlWriter html) {
        this.renderListItemPrefix(node, context, html);
        if (this.listOptions.isTightListItem(node)) {
            context.renderChildren((Node)node);
        } else {
            context.renderChildren((Node)node);
            if (node.getFirstChild().getNext() != null) {
                html.blankLine();
            }
        }
    }

    private void renderList(ListBlock node, NodeRendererContext context, HtmlWriter html) {
        context.renderChildren((Node)node);
        if (node.getParent() instanceof Document && (node.getLastChild() == null || this.listOptions.isTightListItem((ListItem)node.getLastChild()))) {
            html.blankLine();
        }
    }

    private void render(BulletList node, NodeRendererContext context, HtmlWriter html) {
        this.renderList((ListBlock)node, context, html);
    }

    private void render(OrderedList node, NodeRendererContext context, HtmlWriter html) {
        this.renderList((ListBlock)node, context, html);
    }

    private void render(BulletListItem node, NodeRendererContext context, HtmlWriter html) {
        this.renderListItem((ListItem)node, context, html);
    }

    private void render(OrderedListItem node, NodeRendererContext context, HtmlWriter html) {
        this.renderListItem((ListItem)node, context, html);
    }

    private static void renderTextBlockParagraphLines(Node node, NodeRendererContext context, HtmlWriter html) {
        context.renderChildren(node);
        html.line();
    }

    private void renderLooseParagraph(Paragraph node, NodeRendererContext context, HtmlWriter html) {
        JiraConverterNodeRenderer.renderTextBlockParagraphLines((Node)node, context, html);
        if (this.inBlockQuote > 0 && node.getNext() == null) {
            html.line();
        } else {
            html.blankLine();
        }
    }

    private void render(Paragraph node, NodeRendererContext context, HtmlWriter html) {
        if (!(node.getParent() instanceof ParagraphItemContainer) || !((ParagraphItemContainer)node.getParent()).isParagraphWrappingDisabled(node, this.listOptions, context.getOptions())) {
            this.renderLooseParagraph(node, context, html);
        } else {
            JiraConverterNodeRenderer.renderTextBlockParagraphLines((Node)node, context, html);
        }
    }

    public static BasedSequence getSoftLineBreakSpan(Node node) {
        if (node == null) {
            return BasedSequence.NULL;
        }
        Node lastNode = node;
        for (Node nextNode = node.getNext(); nextNode != null && !(nextNode instanceof SoftLineBreak); nextNode = nextNode.getNext()) {
            lastNode = nextNode;
        }
        return Node.spanningChars((BasedSequence[])new BasedSequence[]{node.getChars(), lastNode.getChars()});
    }

    private void render(SoftLineBreak node, NodeRendererContext context, HtmlWriter html) {
        html.raw((CharSequence)" ");
    }

    private void render(HardLineBreak node, NodeRendererContext context, HtmlWriter html) {
        html.line();
    }

    private void render(Emphasis node, NodeRendererContext context, HtmlWriter html) {
        html.raw((CharSequence)"_");
        context.renderChildren((Node)node);
        html.raw((CharSequence)"_");
    }

    private void render(StrongEmphasis node, NodeRendererContext context, HtmlWriter html) {
        html.raw((CharSequence)"*");
        context.renderChildren((Node)node);
        html.raw((CharSequence)"*");
    }

    private void render(Text node, NodeRendererContext context, HtmlWriter html) {
        html.raw((CharSequence)Escaping.normalizeEOL((CharSequence)node.getChars().unescape()));
    }

    private void render(TextBase node, NodeRendererContext context, HtmlWriter html) {
        context.renderChildren((Node)node);
    }

    private void render(Code node, NodeRendererContext context, HtmlWriter html) {
        html.raw((CharSequence)"{{");
        html.raw((CharSequence)Escaping.collapseWhitespace((CharSequence)node.getText(), (boolean)true));
        html.raw((CharSequence)"}}");
    }

    private void render(HtmlBlock node, NodeRendererContext context, HtmlWriter html) {
        if (node.hasChildren()) {
            context.renderChildren((Node)node);
        } else {
            this.renderHtmlBlock((HtmlBlockBase)node, context, html, context.getHtmlOptions().suppressHtmlBlocks, context.getHtmlOptions().escapeHtmlBlocks);
        }
    }

    private void render(HtmlCommentBlock node, NodeRendererContext context, HtmlWriter html) {
        this.renderHtmlBlock((HtmlBlockBase)node, context, html, context.getHtmlOptions().suppressHtmlCommentBlocks, context.getHtmlOptions().escapeHtmlCommentBlocks);
    }

    private void render(HtmlInnerBlock node, NodeRendererContext context, HtmlWriter html) {
        this.renderHtmlBlock((HtmlBlockBase)node, context, html, context.getHtmlOptions().suppressHtmlBlocks, context.getHtmlOptions().escapeHtmlBlocks);
    }

    private void render(HtmlInnerBlockComment node, NodeRendererContext context, HtmlWriter html) {
        this.renderHtmlBlock((HtmlBlockBase)node, context, html, context.getHtmlOptions().suppressHtmlCommentBlocks, context.getHtmlOptions().escapeHtmlCommentBlocks);
    }

    public void renderHtmlBlock(HtmlBlockBase node, NodeRendererContext context, HtmlWriter html, boolean suppress, boolean escape) {
        if (suppress) {
            return;
        }
        ((HtmlWriter)((HtmlWriter)html.line()).raw((CharSequence)"{code:html}")).line();
        html.raw((CharSequence)node.getContentChars().normalizeEOL());
        ((HtmlWriter)((HtmlWriter)html.line()).raw((CharSequence)"{code:html}")).line();
    }

    private void render(HtmlInline node, NodeRendererContext context, HtmlWriter html) {
        this.renderInlineHtml((HtmlInlineBase)node, context, html, context.getHtmlOptions().suppressInlineHtml, context.getHtmlOptions().escapeInlineHtml);
    }

    private void render(HtmlInlineComment node, NodeRendererContext context, HtmlWriter html) {
        this.renderInlineHtml((HtmlInlineBase)node, context, html, context.getHtmlOptions().suppressInlineHtmlComments, context.getHtmlOptions().escapeInlineHtmlComments);
    }

    public void renderInlineHtml(HtmlInlineBase node, NodeRendererContext context, HtmlWriter html, boolean suppress, boolean escape) {
        if (suppress) {
            return;
        }
        ((HtmlWriter)((HtmlWriter)html.raw((CharSequence)"{{")).raw((CharSequence)node.getChars().normalizeEOL())).raw((CharSequence)"}}");
    }

    private void render(Reference node, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(HtmlEntity node, NodeRendererContext context, HtmlWriter html) {
        html.raw((CharSequence)node.getChars().unescape());
    }

    private void render(AutoLink node, NodeRendererContext context, HtmlWriter html) {
        BasedSequence text = node.getText();
        if (context.isDoNotRenderLinks()) {
            html.text((CharSequence)text);
        } else {
            ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, (CharSequence)text, null);
            ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.raw((CharSequence)"[")).raw((CharSequence)text)).raw((CharSequence)"|")).raw((CharSequence)resolvedLink.getUrl());
        }
    }

    private void render(MailLink node, NodeRendererContext context, HtmlWriter html) {
        String text = node.getText().unescape();
        if (context.isDoNotRenderLinks()) {
            html.text((CharSequence)text);
        } else {
            ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, (CharSequence)text, null);
            ((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)html.raw((CharSequence)"[")).raw((CharSequence)text)).raw((CharSequence)"|mailto:")).raw((CharSequence)resolvedLink.getUrl())).raw((CharSequence)"]");
        }
    }

    private void render(Image node, NodeRendererContext context, HtmlWriter html) {
        if (!context.isDoNotRenderLinks()) {
            String altText = new TextCollectingVisitor().collectAndGetText((Node)node);
            ResolvedLink resolvedLink = context.resolveLink(LinkType.IMAGE, (CharSequence)node.getUrl().unescape(), null);
            ((HtmlWriter)((HtmlWriter)html.raw((CharSequence)"!")).raw((CharSequence)resolvedLink.getUrl())).raw((CharSequence)"!");
        }
    }

    private void render(Link node, NodeRendererContext context, HtmlWriter html) {
        if (context.isDoNotRenderLinks()) {
            context.renderChildren((Node)node);
        } else {
            ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, (CharSequence)node.getUrl().unescape(), null);
            html.raw((CharSequence)"[");
            context.renderChildren((Node)node);
            ((HtmlWriter)((HtmlWriter)html.raw((CharSequence)"|")).raw((CharSequence)resolvedLink.getUrl())).raw((CharSequence)"]");
        }
    }

    private void render(ImageRef node, NodeRendererContext context, HtmlWriter html) {
        if (!node.isDefined()) {
            assert (!node.isDefined());
            html.text((CharSequence)node.getChars().unescape());
        } else if (!context.isDoNotRenderLinks()) {
            Reference reference = node.getReferenceNode(this.referenceRepository);
            assert (reference != null);
            String altText = new TextCollectingVisitor().collectAndGetText((Node)node);
            ResolvedLink resolvedLink = context.resolveLink(LinkType.IMAGE, (CharSequence)reference.getUrl().unescape(), null);
            ((HtmlWriter)((HtmlWriter)html.raw((CharSequence)"!")).raw((CharSequence)resolvedLink.getUrl())).raw((CharSequence)"!");
        }
    }

    private void render(LinkRef node, NodeRendererContext context, HtmlWriter html) {
        if (!node.isDefined()) {
            assert (!node.isDefined());
            html.raw((CharSequence)"[");
            context.renderChildren((Node)node);
            html.raw((CharSequence)"]");
            if (!node.isReferenceTextCombined()) {
                html.raw((CharSequence)"[");
                html.raw((CharSequence)node.getReference().unescape());
                html.raw((CharSequence)"]");
            }
        } else if (context.isDoNotRenderLinks()) {
            context.renderChildren((Node)node);
        } else {
            Reference reference = node.getReferenceNode(this.referenceRepository);
            assert (reference != null);
            ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, (CharSequence)reference.getUrl().unescape(), null);
            html.raw((CharSequence)"[");
            context.renderChildren((Node)node);
            html.raw((CharSequence)"|");
            html.raw((CharSequence)resolvedLink.getUrl());
            html.raw((CharSequence)"]");
        }
    }
}

