/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html2md.converter.internal;

import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.ast.util.ReferenceRepository;
import com.vladsch.flexmark.ext.emoji.internal.EmojiReference;
import com.vladsch.flexmark.ext.emoji.internal.EmojiShortcuts;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.html2md.converter.FlexmarkHtmlConverter;
import com.vladsch.flexmark.html2md.converter.HtmlConverterOptions;
import com.vladsch.flexmark.html2md.converter.HtmlConverterPhase;
import com.vladsch.flexmark.html2md.converter.HtmlMarkdownWriter;
import com.vladsch.flexmark.html2md.converter.HtmlNodeConverterContext;
import com.vladsch.flexmark.html2md.converter.HtmlNodeRendererHandler;
import com.vladsch.flexmark.html2md.converter.LinkConversion;
import com.vladsch.flexmark.html2md.converter.ListState;
import com.vladsch.flexmark.html2md.converter.PhasedHtmlNodeRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.format.MarkdownTable;
import com.vladsch.flexmark.util.format.RomanNumeral;
import com.vladsch.flexmark.util.format.TableCell;
import com.vladsch.flexmark.util.html.CellAlignment;
import com.vladsch.flexmark.util.html.LineFormattingAppendable;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import com.vladsch.flexmark.util.sequence.RepeatedCharSequence;
import com.vladsch.flexmark.util.sequence.SubSequence;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

public class HtmlConverterCoreNodeRenderer
implements PhasedHtmlNodeRenderer {
    public static final String EMOJI_ALT_PREFIX = "emoji ";
    public static final Pattern NUMERIC_DOT_LIST_PAT = Pattern.compile("^(\\d+)\\.\\s*$");
    public static final Pattern NUMERIC_PAREN_LIST_PAT = Pattern.compile("^(\\d+)\\)\\s*$");
    public static final Pattern NON_NUMERIC_DOT_LIST_PAT = Pattern.compile("^((?:(?:" + RomanNumeral.ROMAN_NUMERAL.pattern() + ")|(?:" + RomanNumeral.LOWERCASE_ROMAN_NUMERAL.pattern() + ")|[a-z]+|[A-Z]+))\\.\\s*$");
    public static final Pattern NON_NUMERIC_PAREN_LIST_PAT = Pattern.compile("^((?:[a-z]+|[A-Z]+))\\)\\s*$");
    public static final Pattern BULLET_LIST_PAT = Pattern.compile("^([\u00b7])\\s*$");
    public static final Pattern ALPHA_NUMERAL_PAT = Pattern.compile("^[a-z]+|[A-Z]+$");
    public static HashSet<String> explicitLinkTextTags = new HashSet<String>(Arrays.asList(FlexmarkHtmlConverter.EXPLICIT_LINK_TEXT_TAGS));
    private HashMap<String, String> myAbbreviations;
    private HashMap<String, String> myMacrosMap;
    private final HtmlConverterOptions myHtmlConverterOptions;
    private MarkdownTable myTable;
    private boolean myTableSuppressColumns = false;

    public HtmlConverterCoreNodeRenderer(DataHolder options) {
        this.myHtmlConverterOptions = new HtmlConverterOptions(options);
        this.myAbbreviations = new HashMap();
        this.myMacrosMap = new HashMap();
    }

    @Override
    public Set<HtmlConverterPhase> getHtmlConverterPhases() {
        return new HashSet<HtmlConverterPhase>(Arrays.asList(HtmlConverterPhase.COLLECT, HtmlConverterPhase.DOCUMENT_BOTTOM));
    }

    @Override
    public Set<HtmlNodeRendererHandler<?>> getHtmlNodeRendererHandlers() {
        HashSet result = new HashSet(Arrays.asList(new HtmlNodeRendererHandler<Comment>("#comment", Comment.class, this::processComment), new HtmlNodeRendererHandler<Element>("a", Element.class, this::processA), new HtmlNodeRendererHandler<Element>("abbr", Element.class, this::processAbbr), new HtmlNodeRendererHandler<Element>("aside", Element.class, this::processAside), new HtmlNodeRendererHandler<Element>("b", Element.class, this::processStrong), new HtmlNodeRendererHandler<Element>("blockquote", Element.class, this::processBlockQuote), new HtmlNodeRendererHandler<Element>("br", Element.class, this::processBr), new HtmlNodeRendererHandler<Element>("code", Element.class, this::processCode), new HtmlNodeRendererHandler<Element>("del", Element.class, this::processDel), new HtmlNodeRendererHandler<Element>("div", Element.class, this::processDiv), new HtmlNodeRendererHandler<Element>("dl", Element.class, this::processDl), new HtmlNodeRendererHandler<Element>("em", Element.class, this::processEmphasis), new HtmlNodeRendererHandler<Element>("g-emoji", Element.class, this::processEmoji), new HtmlNodeRendererHandler<Element>("h1", Element.class, this::processHeading), new HtmlNodeRendererHandler<Element>("h2", Element.class, this::processHeading), new HtmlNodeRendererHandler<Element>("h3", Element.class, this::processHeading), new HtmlNodeRendererHandler<Element>("h4", Element.class, this::processHeading), new HtmlNodeRendererHandler<Element>("h5", Element.class, this::processHeading), new HtmlNodeRendererHandler<Element>("h6", Element.class, this::processHeading), new HtmlNodeRendererHandler<Element>("hr", Element.class, this::processHr), new HtmlNodeRendererHandler<Element>("i", Element.class, this::processEmphasis), new HtmlNodeRendererHandler<Element>("img", Element.class, this::processImg), new HtmlNodeRendererHandler<Element>("input", Element.class, this::processInput), new HtmlNodeRendererHandler<Element>("ins", Element.class, this::processIns), new HtmlNodeRendererHandler<Element>("li", Element.class, this::processLi), new HtmlNodeRendererHandler<Element>("math", Element.class, this::processMath), new HtmlNodeRendererHandler<Element>("ol", Element.class, this::processOl), new HtmlNodeRendererHandler<Element>("p", Element.class, this::processP), new HtmlNodeRendererHandler<Element>("pre", Element.class, this::processPre), new HtmlNodeRendererHandler<Element>("span", Element.class, this::processSpan), new HtmlNodeRendererHandler<Element>("strike", Element.class, this::processDel), new HtmlNodeRendererHandler<Element>("strong", Element.class, this::processStrong), new HtmlNodeRendererHandler<Element>("sub", Element.class, this::processSub), new HtmlNodeRendererHandler<Element>("sup", Element.class, this::processSup), new HtmlNodeRendererHandler<Element>("svg", Element.class, this::processSvg), new HtmlNodeRendererHandler<Element>("table", Element.class, this::processTable), new HtmlNodeRendererHandler<Element>("u", Element.class, this::processIns), new HtmlNodeRendererHandler<Element>("ul", Element.class, this::processUl), new HtmlNodeRendererHandler<TextNode>("#text", TextNode.class, this::processText), new HtmlNodeRendererHandler<Node>("", Node.class, this::processDefault)));
        if (this.myHtmlConverterOptions.unwrappedTags.length > 0) {
            for (String tag : this.myHtmlConverterOptions.unwrappedTags) {
                result.add(new HtmlNodeRendererHandler<Node>(tag, Node.class, this::processUnwrapped));
            }
        }
        if (this.myHtmlConverterOptions.wrappedTags.length > 0) {
            for (String tag : this.myHtmlConverterOptions.wrappedTags) {
                result.add(new HtmlNodeRendererHandler<Node>(tag, Node.class, this::processWrapped));
            }
        }
        return result;
    }

    @Override
    public void renderDocument(HtmlNodeConverterContext context, LineFormattingAppendable out, org.jsoup.nodes.Document document, HtmlConverterPhase phase) {
        switch (phase) {
            case COLLECT: {
                ReferenceRepository referenceRepository;
                Document myForDocument = context.getForDocument();
                if (myForDocument == null || (referenceRepository = (ReferenceRepository)Parser.REFERENCES.getFrom((DataHolder)myForDocument)) == null) break;
                HashMap<String, Reference> referenceUrlToReferenceMap = context.getReferenceUrlToReferenceMap();
                HashSet<Reference> externalReferences = context.getExternalReferences();
                for (Reference reference : referenceRepository.getValues()) {
                    referenceUrlToReferenceMap.put(reference.getUrl().toString(), reference);
                    referenceUrlToReferenceMap.put(reference.getReference().toString(), reference);
                    externalReferences.add(reference);
                }
                break;
            }
            case DOCUMENT_BOTTOM: {
                HashMap<String, Reference> referenceUrlToReferenceMap;
                if (!this.myAbbreviations.isEmpty()) {
                    out.blankLine();
                    for (Map.Entry<String, String> entry : this.myAbbreviations.entrySet()) {
                        out.line().append((CharSequence)"*[").append((CharSequence)entry.getKey()).append((CharSequence)"]: ").append((CharSequence)entry.getValue()).line();
                    }
                    out.blankLine();
                }
                if (!(referenceUrlToReferenceMap = context.getReferenceUrlToReferenceMap()).isEmpty()) {
                    boolean first = true;
                    HashSet<Reference> externalReferences = context.getExternalReferences();
                    for (Map.Entry<String, Reference> entry : referenceUrlToReferenceMap.entrySet()) {
                        if (externalReferences.contains(entry.getValue())) continue;
                        if (first) {
                            first = false;
                            out.blankLine();
                        }
                        out.line().append((CharSequence)entry.getValue().getChars()).line();
                    }
                    if (!first) {
                        out.blankLine();
                    }
                }
                if (this.myMacrosMap.isEmpty()) break;
                for (Map.Entry<String, String> entry : this.myMacrosMap.entrySet()) {
                    out.blankLine();
                    out.append((CharSequence)">>>").append((CharSequence)entry.getKey()).line();
                    BasedSequence value = BasedSequenceImpl.of((CharSequence)entry.getValue());
                    out.append((CharSequence)value.trimEnd()).append((CharSequence)"\n");
                    out.append((CharSequence)"<<<\n");
                    out.blankLine();
                }
                break;
            }
        }
    }

    public static int getMaxRepeatedChars(CharSequence text, char c, int minCount) {
        int pos;
        BasedSequence chars = BasedSequenceImpl.of((CharSequence)text);
        int lastPos = 0;
        while (lastPos < chars.length() && (pos = chars.indexOf(c, lastPos)) >= 0) {
            int count = chars.countLeading(c, pos);
            if (minCount <= count) {
                minCount = count + 1;
            }
            lastPos = pos + count;
        }
        return minCount;
    }

    public static boolean hasChildrenOfType(Element element, Set<String> nodeNames) {
        for (Node child : element.children()) {
            if (!nodeNames.contains(child.nodeName().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static boolean isFirstChild(Element element) {
        for (Node node : element.parent().childNodes()) {
            if (node instanceof Element) {
                return element == node;
            }
            if (!node.nodeName().equals("#text") || node.outerHtml().trim().isEmpty()) continue;
            break;
        }
        return false;
    }

    public static boolean isLastChild(Element element) {
        Elements children = element.parent().children();
        int i = children.size();
        while (i-- > 0) {
            Node node = (Node)children.get(i);
            if (!(node instanceof Element)) continue;
            return element == node;
        }
        return false;
    }

    private void processDefault(Node node, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        context.renderDefault(node);
    }

    private void processA(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        if (element.hasAttr("href")) {
            LinkConversion conv = this.myHtmlConverterOptions.extInlineLink;
            if (conv.isSuppressed()) {
                return;
            }
            String href = element.attr("href");
            ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, href, false);
            String useHref = resolvedLink.getUrl();
            if (out.isPreFormatted()) {
                int hashIndex;
                int slashIndex = useHref.lastIndexOf(47);
                if (slashIndex != -1 && (hashIndex = useHref.indexOf(35, slashIndex)) != -1 && slashIndex + 1 == hashIndex) {
                    useHref = useHref.substring(0, slashIndex) + useHref.substring(hashIndex);
                }
                out.append(useHref);
            } else if (conv.isParsed()) {
                String title;
                context.pushState((Node)element);
                String textNodes = context.processTextNodes((Node)element);
                String text = textNodes.trim();
                String string = title = element.hasAttr("title") ? element.attr("title") : null;
                if (!text.isEmpty() || !useHref.contains("#")) {
                    if (this.myHtmlConverterOptions.extractAutoLinks && href.equals(text) && (title == null || title.isEmpty())) {
                        if (this.myHtmlConverterOptions.wrapAutoLinks) {
                            out.append('<');
                        }
                        out.append(useHref);
                        if (this.myHtmlConverterOptions.wrapAutoLinks) {
                            out.append('>');
                        }
                        context.transferIdToParent();
                    } else if (!conv.isTextOnly() && !useHref.startsWith("javascript:")) {
                        Reference reference;
                        boolean handled = false;
                        if (conv.isReference() && !HtmlConverterCoreNodeRenderer.hasChildrenOfType(element, explicitLinkTextTags) && (reference = context.getOrCreateReference(useHref, text, title)) != null) {
                            handled = true;
                            if (reference.getReference().equals(text)) {
                                ((HtmlMarkdownWriter)((HtmlMarkdownWriter)out.append('[')).append(text)).append("][]");
                            } else {
                                ((HtmlMarkdownWriter)((HtmlMarkdownWriter)((HtmlMarkdownWriter)((HtmlMarkdownWriter)out.append('[')).append(text)).append("][")).append((CharSequence)reference.getReference())).append(']');
                            }
                        }
                        if (!handled) {
                            out.append('[');
                            out.append(text);
                            out.append(']');
                            ((HtmlMarkdownWriter)out.append('(')).append(useHref);
                            if (title != null) {
                                ((HtmlMarkdownWriter)((HtmlMarkdownWriter)out.append(" \"")).append(title.replace("\n", this.myHtmlConverterOptions.eolInTitleAttribute).replace("\"", "\\\""))).append('\"');
                            }
                            out.append(")");
                        }
                    } else if (href.equals(text)) {
                        out.append(useHref);
                    } else {
                        out.append(text);
                    }
                    context.excludeAttributes("href", "title");
                    context.popState((LineFormattingAppendable)out);
                } else {
                    context.transferIdToParent();
                    context.popState(null);
                }
            } else if (!conv.isSuppressed()) {
                context.processWrapped((Node)element, null, true);
            }
        } else {
            boolean stripIdAttribute = false;
            if (element.childNodeSize() == 0 && element.parent().tagName().equals("body")) {
                stripIdAttribute = true;
            }
            context.processTextNodes((Node)element, stripIdAttribute);
        }
    }

    private void processAbbr(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        if (element.hasAttr("title")) {
            String text = context.processTextNodes((Node)element).trim();
            this.myAbbreviations.put(text, element.attr("title"));
        }
    }

    private void processAside(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        if (HtmlConverterCoreNodeRenderer.isFirstChild(element)) {
            out.line();
        }
        out.pushPrefix();
        out.addPrefix("| ");
        context.renderChildren((Node)element, true, null);
        out.line();
        out.popPrefix();
    }

    private void processBlockQuote(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        if (HtmlConverterCoreNodeRenderer.isFirstChild(element)) {
            out.line();
        }
        out.pushPrefix();
        out.addPrefix("> ");
        context.renderChildren((Node)element, true, null);
        out.line();
        out.popPrefix();
    }

    private void processBr(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        if (out.isPreFormatted()) {
            out.append('\n');
        } else {
            int options = out.getOptions();
            out.setOptions(options & 0xFFFFFFF9);
            if (out.getPendingEOL() == 0) {
                ((HtmlMarkdownWriter)out.repeat(' ', 2)).line();
            } else if (out.getPendingEOL() == 1) {
                String s = out.toString();
                if (!s.endsWith("<br />")) {
                    if (this.myHtmlConverterOptions.brAsParaBreaks) {
                        out.blankLine();
                    }
                } else if (this.myHtmlConverterOptions.brAsExtraBlankLines) {
                    ((HtmlMarkdownWriter)out.append("<br />")).blankLine();
                }
            } else if (this.myHtmlConverterOptions.brAsExtraBlankLines) {
                ((HtmlMarkdownWriter)out.append("<br />")).blankLine();
            }
            out.setOptions(options);
        }
    }

    private void processCode(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        context.processConditional(this.myHtmlConverterOptions.extInlineCode, (Node)element, () -> {
            BasedSequence text = SubSequence.of((CharSequence)element.ownText());
            int backTickCount = HtmlConverterCoreNodeRenderer.getMaxRepeatedChars((CharSequence)text, '`', 1);
            RepeatedCharSequence backTicks = RepeatedCharSequence.of((CharSequence)"`", (int)backTickCount);
            context.inlineCode(() -> this.lambda$null$0(context, element, (CharSequence)backTicks));
        });
    }

    private void processDel(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        context.processConditional(this.myHtmlConverterOptions.extInlineDel, (Node)element, () -> {
            if (!this.myHtmlConverterOptions.preCodePreserveEmphasis && out.isPreFormatted()) {
                context.wrapTextNodes((Node)element, "", false);
            } else {
                context.wrapTextNodes((Node)element, this.myHtmlConverterOptions.extInlineDel.isTextOnly() ? "" : "~~", element.nextElementSibling() != null);
            }
        });
    }

    private void processDiv(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        if (!HtmlConverterCoreNodeRenderer.isFirstChild(element)) {
            if (!this.myHtmlConverterOptions.divAsParagraph) {
                CharSequence lineContent;
                int pendingSpace;
                int lineCount;
                int pendingEOL = out.getPendingEOL();
                if (pendingEOL == 0) {
                    int pendingSpace2 = out.getPendingSpace();
                    out.lineWithTrailingSpaces(Utils.minLimit((int)0, (int[])new int[]{2 - pendingSpace2}));
                } else if (pendingEOL == 1 && (lineCount = out.getLineCount()) > 0 && (pendingSpace = BasedSequenceImpl.of((CharSequence)(lineContent = out.getLineContent(lineCount - 1))).countTrailing((CharSequence)" \t")) < 2) {
                    out.removeLines(lineCount - 1, lineCount);
                    out.append(lineContent);
                    out.lineWithTrailingSpaces(2 - pendingSpace);
                }
            } else {
                out.blankLine();
            }
        }
        context.renderChildren((Node)element, false, null);
        if (!HtmlConverterCoreNodeRenderer.isLastChild(element)) {
            out.line();
            if (this.myHtmlConverterOptions.divAsParagraph) {
                out.blankLine();
            }
        }
    }

    private void processDl(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        Node item;
        context.pushState((Node)element);
        boolean lastWasDefinition = true;
        boolean firstItem = true;
        while ((item = context.next()) != null) {
            switch (item.nodeName().toLowerCase()) {
                case "dt": {
                    ((HtmlMarkdownWriter)out.blankLineIf(lastWasDefinition)).lineIf(!firstItem);
                    context.processTextNodes(item, false);
                    out.line();
                    lastWasDefinition = false;
                    firstItem = false;
                    break;
                }
                case "dd": {
                    this.handleDefinition((Element)item, context, out);
                    lastWasDefinition = true;
                    firstItem = false;
                    break;
                }
            }
        }
        context.popState((LineFormattingAppendable)out);
    }

    private void handleDefinition(Element item, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        context.pushState((Node)item);
        int options = out.getOptions();
        Elements children = item.children();
        boolean firstIsPara = false;
        if (!children.isEmpty() && ((Element)children.get(0)).tagName().equalsIgnoreCase("p")) {
            out.blankLine();
            firstIsPara = true;
        }
        RepeatedCharSequence childPrefix = RepeatedCharSequence.of((CharSequence)" ", (int)(this.myHtmlConverterOptions.listContentIndent ? this.myHtmlConverterOptions.definitionMarkerSpaces + 1 : 4));
        ((HtmlMarkdownWriter)out.line()).setOptions(options & 0xFFFFFFFD);
        ((HtmlMarkdownWriter)out.append(':')).repeat(' ', this.myHtmlConverterOptions.definitionMarkerSpaces);
        out.pushPrefix();
        out.addPrefix((CharSequence)childPrefix, true);
        out.setOptions(options);
        if (firstIsPara) {
            context.renderChildren((Node)item, true, null);
        } else {
            context.processTextNodes((Node)item, false);
        }
        out.line();
        out.popPrefix();
        context.popState((LineFormattingAppendable)out);
    }

    private void processEmoji(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        EmojiReference.Emoji emoji;
        if (element.hasAttr("alias")) {
            ((HtmlMarkdownWriter)((HtmlMarkdownWriter)out.append(':')).append(element.attr("alias"))).append(':');
            return;
        }
        if (element.hasAttr("fallback-src") && (emoji = EmojiShortcuts.getEmojiFromURI((String)element.attr("fallback-src"))) != null) {
            ((HtmlMarkdownWriter)((HtmlMarkdownWriter)out.append(':')).append(emoji.shortcut)).append(':');
            return;
        }
        context.renderDefault((Node)element);
    }

    private void processEmphasis(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        context.processConditional(this.myHtmlConverterOptions.extInlineEmphasis, (Node)element, () -> {
            if (!this.myHtmlConverterOptions.preCodePreserveEmphasis && out.isPreFormatted()) {
                context.wrapTextNodes((Node)element, "", false);
            } else {
                context.wrapTextNodes((Node)element, this.myHtmlConverterOptions.extInlineEmphasis.isTextOnly() ? "" : "*", element.nextElementSibling() != null);
            }
        });
    }

    private void processHr(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        ((HtmlMarkdownWriter)((HtmlMarkdownWriter)out.blankLine()).append(this.myHtmlConverterOptions.thematicBreak)).blankLine();
    }

    private void processImg(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        if (element.hasAttr("src")) {
            String emojiAlt;
            String src = element.attr("src");
            EmojiReference.Emoji emoji = EmojiShortcuts.getEmojiFromURI((String)src);
            if (emoji == null && element.hasAttr("alt") && (emojiAlt = element.attr("alt")).startsWith(EMOJI_ALT_PREFIX)) {
                List emojiList = EmojiReference.getEmojiList();
                int pos = emojiAlt.indexOf(":", EMOJI_ALT_PREFIX.length());
                if (pos > 0) {
                    String category = emojiAlt.substring(EMOJI_ALT_PREFIX.length(), pos);
                    String shortcut = emojiAlt.substring(pos + 1);
                    EmojiReference.Emoji emoji2 = EmojiShortcuts.getEmojiFromShortcut((String)shortcut);
                    if (emoji2.category.equals(category)) {
                        emoji = emoji2;
                    }
                }
            }
            if (emoji != null) {
                ((HtmlMarkdownWriter)((HtmlMarkdownWriter)out.append(':')).append(emoji.shortcut)).append(':');
            } else {
                LinkConversion conv = this.myHtmlConverterOptions.extInlineImage;
                if (conv.isSuppressed()) {
                    return;
                }
                if (conv.isParsed()) {
                    String title;
                    String alt;
                    String string = alt = !element.hasAttr("alt") ? null : element.attr("alt").trim().replace("[", "\\[").replace("]", "\\]");
                    if (alt != null && alt.isEmpty()) {
                        alt = null;
                    }
                    String string2 = title = !element.hasAttr("title") ? null : element.attr("title").replace("\n", this.myHtmlConverterOptions.eolInTitleAttribute).replace("\"", "\\\"");
                    if (title != null && title.isEmpty()) {
                        title = null;
                    }
                    if (!conv.isTextOnly()) {
                        Reference reference;
                        ResolvedLink resolvedLink = context.resolveLink(LinkType.IMAGE, src, false);
                        String useSrc = resolvedLink.getUrl();
                        int pos = useSrc.indexOf(63);
                        int eol = pos < 0 ? pos : useSrc.indexOf("%0A", pos);
                        boolean isMultiLineUrl = pos > 0 && eol > 0;
                        boolean handled = false;
                        if (conv.isReference() && !isMultiLineUrl && (reference = context.getOrCreateReference(useSrc, alt == null ? "image" : alt, title)) != null) {
                            handled = true;
                            if (alt == null || reference.getReference().equals(alt)) {
                                ((HtmlMarkdownWriter)((HtmlMarkdownWriter)out.append("![")).append((CharSequence)reference.getReference())).append("][]");
                            } else {
                                ((HtmlMarkdownWriter)((HtmlMarkdownWriter)((HtmlMarkdownWriter)((HtmlMarkdownWriter)out.append("![")).append(alt)).append("][")).append((CharSequence)reference.getReference())).append("]");
                            }
                        }
                        if (!handled) {
                            out.append("![");
                            if (alt != null) {
                                out.append(alt);
                            }
                            ((HtmlMarkdownWriter)out.append(']')).append('(');
                            if (isMultiLineUrl) {
                                out.append(useSrc, 0, pos + 1);
                                String decoded = Utils.urlDecode((String)useSrc.substring(pos + 1).replace("+", "%2B"), (String)"UTF8");
                                ((HtmlMarkdownWriter)out.line()).append(decoded);
                            } else {
                                out.append(useSrc);
                            }
                            if (title != null) {
                                ((HtmlMarkdownWriter)((HtmlMarkdownWriter)out.append(" \"")).append(title)).append('\"');
                            }
                            out.append(")");
                        }
                    } else if (alt != null) {
                        out.append(alt);
                    } else if (title != null) {
                        out.append(title);
                    }
                } else if (!conv.isSuppressed()) {
                    context.processWrapped((Node)element, null, false);
                }
            }
        }
    }

    private void processInput(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        boolean isItemParagraph = false;
        Element firstElementSibling = element.firstElementSibling();
        if (firstElementSibling == null || element == firstElementSibling) {
            String tagName = element.parent().tagName();
            isItemParagraph = tagName.equalsIgnoreCase("li");
        }
        if (isItemParagraph && element.hasAttr("type") && "checkbox".equalsIgnoreCase(element.attr("type"))) {
            if (element.hasAttr("checked")) {
                out.append("[x] ");
            } else {
                out.append("[ ] ");
            }
            return;
        }
        context.renderDefault((Node)element);
    }

    private void processIns(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        context.processConditional(this.myHtmlConverterOptions.extInlineIns, (Node)element, () -> {
            if (!this.myHtmlConverterOptions.preCodePreserveEmphasis && out.isPreFormatted()) {
                context.wrapTextNodes((Node)element, "", false);
            } else {
                context.wrapTextNodes((Node)element, this.myHtmlConverterOptions.extInlineIns.isTextOnly() ? "" : "++", element.nextElementSibling() != null);
            }
        });
    }

    private void processStrong(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        context.processConditional(this.myHtmlConverterOptions.extInlineStrong, (Node)element, () -> {
            if (!this.myHtmlConverterOptions.preCodePreserveEmphasis && out.isPreFormatted()) {
                context.wrapTextNodes((Node)element, "", false);
            } else {
                context.wrapTextNodes((Node)element, this.myHtmlConverterOptions.extInlineStrong.isTextOnly() ? "" : "**", element.nextElementSibling() != null);
            }
        });
    }

    private void processSub(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        context.processConditional(this.myHtmlConverterOptions.extInlineSub, (Node)element, () -> {
            if (this.myHtmlConverterOptions.extInlineSub.isTextOnly() || !this.myHtmlConverterOptions.preCodePreserveEmphasis && out.isPreFormatted()) {
                context.wrapTextNodes((Node)element, "", false);
            } else {
                context.wrapTextNodes((Node)element, "~", false);
            }
        });
    }

    private void processSup(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        context.processConditional(this.myHtmlConverterOptions.extInlineSup, (Node)element, () -> {
            if (this.myHtmlConverterOptions.extInlineSup.isTextOnly() || !this.myHtmlConverterOptions.preCodePreserveEmphasis && out.isPreFormatted()) {
                context.wrapTextNodes((Node)element, "", false);
            } else {
                context.wrapTextNodes((Node)element, "^", false);
            }
        });
    }

    private void processMath(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        context.processConditional(this.myHtmlConverterOptions.extMath, (Node)element, () -> {
            boolean noWraps = this.myHtmlConverterOptions.extMath.isTextOnly();
            context.processTextNodes((Node)element, false, noWraps ? "" : "$`", noWraps ? "" : "`$");
        });
    }

    private void handleListItem(HtmlNodeConverterContext context, HtmlMarkdownWriter out, Element item, ListState listState) {
        context.pushState((Node)item);
        ++listState.itemCount;
        String itemPrefix = listState.getItemPrefix(this.myHtmlConverterOptions);
        RepeatedCharSequence childPrefix = RepeatedCharSequence.of((CharSequence)" ", (int)(this.myHtmlConverterOptions.listContentIndent ? itemPrefix.length() : 4));
        ((HtmlMarkdownWriter)out.line()).append(itemPrefix);
        out.pushPrefix();
        out.addPrefix((CharSequence)childPrefix, true);
        int offset = out.offsetWithPending();
        context.renderChildren((Node)item, true, null);
        if (offset == out.offsetWithPending()) {
            int options = out.getOptions();
            out.setOptions((options | 0x20) & 0xFFFFFFFB);
            out.line();
            out.setOptions(options);
        } else {
            out.line();
        }
        out.popPrefix();
        context.popState((LineFormattingAppendable)out);
    }

    private boolean hasListItemParent(Element element) {
        for (Element parent = element.parent(); parent != null; parent = parent.parent()) {
            if (!parent.tagName().equalsIgnoreCase("li")) continue;
            return true;
        }
        return false;
    }

    private boolean haveListItemAncestor(Node node) {
        for (Node parent = node.parent(); parent != null; parent = parent.parent()) {
            if (!parent.nodeName().toLowerCase().equals("li")) continue;
            return true;
        }
        return false;
    }

    private void handleList(HtmlNodeConverterContext context, HtmlMarkdownWriter out, Element element, boolean isNumbered, boolean isFakeList) {
        Element previousElementSibling;
        String tag;
        if (!isFakeList) {
            context.pushState((Node)element);
            if (!this.haveListItemAncestor(context.getState().getParent()) && !HtmlConverterCoreNodeRenderer.isFirstChild(element)) {
                out.blankLine();
            }
        }
        String string = tag = (previousElementSibling = element.previousElementSibling()) == null ? null : previousElementSibling.tagName().toUpperCase();
        if (tag != null && tag.equals(element.tagName().toUpperCase()) && (tag.equals("UL") || tag.equals("OL"))) {
            if (this.myHtmlConverterOptions.listsEndOnDoubleBlank) {
                out.blankLine(2);
            } else {
                ((HtmlMarkdownWriter)((HtmlMarkdownWriter)out.line()).append("<!-- -->")).blankLine();
            }
        }
        ListState listState = new ListState(isNumbered);
        if (listState.isNumbered && element.hasAttr("start")) {
            try {
                int i = Integer.parseInt(element.attr("start"));
                listState.itemCount = i - 1;
            }
            catch (NumberFormatException i) {
                // empty catch block
            }
        }
        Element item = element;
        do {
            switch (item.nodeName().toLowerCase()) {
                case "li": {
                    this.handleListItem(context, out, item, listState);
                    break;
                }
                case "p": {
                    if (item.childNodeSize() <= 0) break;
                    this.handleListItem(context, out, item, listState);
                    break;
                }
            }
        } while ((item = context.next()) != null);
        if (element.nextElementSibling() != null) {
            out.blankLine();
        }
        if (!isFakeList) {
            context.popState((LineFormattingAppendable)out);
        }
    }

    private void processLi(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        this.handleList(context, out, element, false, true);
    }

    private void processOl(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        this.handleList(context, out, element, true, false);
    }

    private void processUl(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        this.handleList(context, out, element, false, false);
    }

    private void processSvg(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        if (!element.hasClass("octicon")) {
            context.renderDefault((Node)element);
        }
    }

    private void processP(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        boolean isItemParagraph = false;
        boolean isDefinitionItemParagraph = false;
        Element firstElementSibling = element.firstElementSibling();
        if (firstElementSibling == null || element == firstElementSibling) {
            String tagName = element.parent().tagName();
            isItemParagraph = tagName.equalsIgnoreCase("li");
            isDefinitionItemParagraph = tagName.equalsIgnoreCase("dd");
        }
        out.blankLineIf(!isItemParagraph && !isDefinitionItemParagraph && !HtmlConverterCoreNodeRenderer.isFirstChild(element));
        if (element.childNodeSize() == 0) {
            if (this.myHtmlConverterOptions.brAsExtraBlankLines) {
                ((HtmlMarkdownWriter)out.append("<br />")).blankLine();
            }
        } else {
            context.processTextNodes((Node)element, false);
        }
        out.line();
        if (isItemParagraph || isDefinitionItemParagraph) {
            out.tailBlankLine();
        }
    }

    private void processHeading(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        String headingText;
        int level;
        boolean skipHeading = false;
        switch (element.nodeName().toLowerCase()) {
            case "h1": {
                level = 1;
                skipHeading = this.myHtmlConverterOptions.skipHeading1;
                break;
            }
            case "h2": {
                level = 2;
                skipHeading = this.myHtmlConverterOptions.skipHeading2;
                break;
            }
            case "h3": {
                level = 3;
                skipHeading = this.myHtmlConverterOptions.skipHeading3;
                break;
            }
            case "h4": {
                level = 4;
                skipHeading = this.myHtmlConverterOptions.skipHeading4;
                break;
            }
            case "h5": {
                level = 5;
                skipHeading = this.myHtmlConverterOptions.skipHeading5;
                break;
            }
            default: {
                level = 6;
                skipHeading = this.myHtmlConverterOptions.skipHeading6;
            }
        }
        if (level >= 1 && level <= 6 && !(headingText = context.processTextNodes((Node)element).trim()).isEmpty()) {
            out.blankLine();
            if (skipHeading) {
                out.append(headingText);
            } else {
                if (this.myHtmlConverterOptions.setextHeadings && level <= 2) {
                    out.append(headingText);
                    int extraChars = context.outputAttributes((LineFormattingAppendable)out, " ");
                    ((HtmlMarkdownWriter)out.line()).repeat(level == 1 ? (char)'=' : '-', Utils.minLimit((int)(headingText.length() + extraChars), (int[])new int[]{this.myHtmlConverterOptions.minSetextHeadingMarkerLength}));
                } else {
                    ((HtmlMarkdownWriter)out.repeat('#', level)).append(' ');
                    out.append(headingText);
                    context.outputAttributes((LineFormattingAppendable)out, " ");
                }
                out.blankLine();
            }
        }
    }

    private void processPre(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        Node next;
        context.pushState((Node)element);
        boolean hadCode = false;
        String className = "";
        HtmlNodeConverterContext preText = context.getSubContext();
        preText.getMarkdown().setOptions(out.getOptions() & 0xFFFFFFF9);
        preText.getMarkdown().openPreFormatted(false);
        while ((next = context.next()) != null) {
            if (next.nodeName().equalsIgnoreCase("code") || next.nodeName().equalsIgnoreCase("tt")) {
                hadCode = true;
                Element code = (Element)next;
                preText.renderChildren((Node)code, false, null);
                if (!className.isEmpty()) continue;
                className = Utils.removeStart((String)code.className(), (String)"language-");
                continue;
            }
            if (next.nodeName().equalsIgnoreCase("br")) {
                preText.getMarkdown().append("\n");
                continue;
            }
            if (next.nodeName().equalsIgnoreCase("#text")) {
                preText.getMarkdown().append(((TextNode)next).getWholeText());
                continue;
            }
            preText.renderChildren(next, false, null);
        }
        preText.getMarkdown().closePreFormatted();
        String text = preText.getMarkdown().toString(2);
        int backTickCount = HtmlConverterCoreNodeRenderer.getMaxRepeatedChars(text, '`', 3);
        RepeatedCharSequence backTicks = RepeatedCharSequence.of((CharSequence)"`", (int)backTickCount);
        if (!(this.myHtmlConverterOptions.skipFencedCode || className.isEmpty() && !text.trim().isEmpty() && hadCode)) {
            ((HtmlMarkdownWriter)out.blankLine()).append((CharSequence)backTicks);
            if (!className.isEmpty()) {
                out.append(className);
            }
            out.line();
            out.openPreFormatted(true);
            out.append(text.isEmpty() ? "\n" : text);
            out.closePreFormatted();
            ((HtmlMarkdownWriter)((HtmlMarkdownWriter)out.line()).append((CharSequence)backTicks)).line();
            out.tailBlankLine();
        } else {
            out.blankLine();
            out.pushPrefix();
            out.addPrefix(this.myHtmlConverterOptions.codeIndent);
            out.openPreFormatted(true);
            out.append(text.isEmpty() ? "\n" : text);
            out.closePreFormatted();
            out.line();
            out.tailBlankLine();
            out.popPrefix();
        }
        context.popState((LineFormattingAppendable)out);
    }

    private void processTable(Element table, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        Node item;
        MarkdownTable oldTable = this.myTable;
        context.pushState((Node)table);
        this.myTable = new MarkdownTable(this.myHtmlConverterOptions.tableOptions);
        this.myTableSuppressColumns = false;
        while ((item = context.next()) != null) {
            String nodeName;
            switch (nodeName = item.nodeName().toLowerCase()) {
                case "caption": {
                    this.handleTableCaption((Element)item, context, out);
                    break;
                }
                case "tbody": {
                    this.myTable.setHeader(false);
                    this.handleTableSection(context, out, (Element)item);
                    break;
                }
                case "thead": {
                    this.myTable.setHeader(true);
                    this.handleTableSection(context, out, (Element)item);
                    break;
                }
                case "tr": {
                    Element tableRow = (Element)item;
                    Elements children = tableRow.children();
                    this.myTable.setHeader(!children.isEmpty() && ((Element)children.get(0)).tagName().equalsIgnoreCase("th"));
                    this.handleTableRow(context, out, (Element)item);
                }
            }
        }
        this.myTable.finalizeTable();
        int sepColumns = this.myTable.getMaxColumns();
        if (sepColumns > 0) {
            out.blankLine();
            this.myTable.appendTable((LineFormattingAppendable)out);
            out.tailBlankLine();
        }
        this.myTable = oldTable;
        context.popState((LineFormattingAppendable)out);
    }

    private void handleTableSection(HtmlNodeConverterContext context, HtmlMarkdownWriter out, Element element) {
        Node node;
        context.pushState((Node)element);
        while ((node = context.next()) != null) {
            if (!node.nodeName().equalsIgnoreCase("tr")) continue;
            Element tableRow = (Element)node;
            Elements children = tableRow.children();
            boolean wasHeading = this.myTable.getHeader();
            if (!children.isEmpty() && ((Element)children.get(0)).tagName().equalsIgnoreCase("th")) {
                this.myTable.setHeader(true);
            }
            if (this.myTable.getHeader() && this.myTable.body.rows.size() > 0) {
                if (this.myHtmlConverterOptions.ignoreTableHeadingAfterRows) {
                    this.myTableSuppressColumns = true;
                } else {
                    this.myTable.setHeader(false);
                }
            }
            this.handleTableRow(context, out, tableRow);
            this.myTableSuppressColumns = false;
            this.myTable.setHeader(wasHeading);
        }
        context.popState((LineFormattingAppendable)out);
    }

    private void handleTableRow(HtmlNodeConverterContext context, HtmlMarkdownWriter out, Element element) {
        Node node;
        context.pushState((Node)element);
        while ((node = context.next()) != null) {
            switch (node.nodeName().toLowerCase()) {
                case "th": 
                case "td": {
                    this.handleTableCell((Element)node, context, out);
                    break;
                }
            }
        }
        this.myTable.nextRow();
        context.popState((LineFormattingAppendable)out);
    }

    private void handleTableCaption(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        this.myTable.setCaption((CharSequence)context.processTextNodes((Node)element).trim());
    }

    private void handleTableCell(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        String cellText = context.processTextNodes((Node)element).trim().replaceAll("\\s*\n\\s*", " ");
        int colSpan = 1;
        int rowSpan = 1;
        CellAlignment alignment = null;
        if (element.hasAttr("colSpan")) {
            try {
                colSpan = Integer.parseInt(element.attr("colSpan"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (element.hasAttr("rowSpan")) {
            try {
                rowSpan = Integer.parseInt(element.attr("rowSpan"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (element.hasAttr("align")) {
            alignment = CellAlignment.getAlignment((String)element.attr("align"));
        } else {
            Set classNames = element.classNames();
            if (!classNames.isEmpty()) {
                for (String clazz : classNames) {
                    CellAlignment cellAlignment = this.myHtmlConverterOptions.tableCellAlignmentMap.get(clazz);
                    if (cellAlignment == null) continue;
                    alignment = cellAlignment;
                    break;
                }
                if (alignment == null) {
                    for (Object key : this.myHtmlConverterOptions.tableCellAlignmentMap.keySet()) {
                        if (!(key instanceof Pattern)) continue;
                        Pattern pattern = (Pattern)key;
                        for (String clazz : classNames) {
                            if (!pattern.matcher(clazz).find()) continue;
                            alignment = this.myHtmlConverterOptions.tableCellAlignmentMap.get(key);
                            break;
                        }
                        if (alignment == null) continue;
                        break;
                    }
                }
            }
        }
        if (!this.myTableSuppressColumns) {
            this.myTable.addCell(new TableCell((CharSequence)SubSequence.NULL, (CharSequence)cellText.replace("\n", " "), (CharSequence)BasedSequence.NULL, rowSpan, colSpan, alignment));
        }
    }

    private boolean matchingText(Pattern pattern, String text, String[] match) {
        Matcher matcher = pattern.matcher(text);
        if (matcher.matches()) {
            match[0] = matcher.groupCount() > 0 ? matcher.group(1) : matcher.group();
            return true;
        }
        return false;
    }

    private String convertNumeric(String text) {
        if (RomanNumeral.LIMITED_ROMAN_NUMERAL.matcher(text = text.trim()).matches() || RomanNumeral.LIMITED_LOWERCASE_ROMAN_NUMERAL.matcher(text).matches()) {
            RomanNumeral numeral = new RomanNumeral(text);
            return String.valueOf(numeral.toInt());
        }
        if (ALPHA_NUMERAL_PAT.matcher(text).matches()) {
            int value = 0;
            text = text.toUpperCase();
            int iMax = text.length();
            for (int i = 0; i < iMax; ++i) {
                char c = text.charAt(i);
                value *= 26;
                value += c - 65 + 1;
            }
            return String.valueOf(value);
        }
        return "1";
    }

    private void processUnwrapped(Node node, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        context.processUnwrapped(node);
    }

    private void processWrapped(Node node, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        context.processWrapped(node, false, false);
    }

    private void processSpan(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        String style;
        if (element.hasAttr("style") && (style = element.attr("style")).equals("mso-list:Ignore")) {
            String[] match = new String[]{"1"};
            String text = context.processTextNodes((Node)element);
            if (this.matchingText(NUMERIC_DOT_LIST_PAT, text, match)) {
                ((HtmlMarkdownWriter)out.append(text)).append(' ');
            } else if (this.matchingText(NUMERIC_PAREN_LIST_PAT, text, match)) {
                if (this.myHtmlConverterOptions.dotOnlyNumericLists) {
                    ((HtmlMarkdownWriter)out.append(match[0])).append(". ");
                } else {
                    ((HtmlMarkdownWriter)out.append(match[0])).append(") ");
                }
            } else if (this.matchingText(NON_NUMERIC_DOT_LIST_PAT, text, match)) {
                ((HtmlMarkdownWriter)out.append(this.convertNumeric(match[0]))).append(". ");
                if (this.myHtmlConverterOptions.commentOriginalNonNumericListItem) {
                    ((HtmlMarkdownWriter)((HtmlMarkdownWriter)out.append(" <!-- ")).append(match[0])).append(" -->");
                }
            } else if (this.matchingText(NON_NUMERIC_PAREN_LIST_PAT, text, match)) {
                if (this.myHtmlConverterOptions.dotOnlyNumericLists) {
                    ((HtmlMarkdownWriter)out.append(this.convertNumeric(match[0]))).append(". ");
                    if (this.myHtmlConverterOptions.commentOriginalNonNumericListItem) {
                        ((HtmlMarkdownWriter)((HtmlMarkdownWriter)out.append(" <!-- ")).append(match[0])).append(" -->");
                    }
                } else {
                    ((HtmlMarkdownWriter)out.append(this.convertNumeric(match[0]))).append(") ");
                    if (this.myHtmlConverterOptions.commentOriginalNonNumericListItem) {
                        ((HtmlMarkdownWriter)((HtmlMarkdownWriter)out.append(" <!-- ")).append(match[0])).append(" -->");
                    }
                }
            } else if (BULLET_LIST_PAT.matcher(text).matches()) {
                out.append("* ");
            } else {
                ((HtmlMarkdownWriter)out.append("* ")).append(text);
            }
            context.transferIdToParent();
            return;
        }
        context.renderChildren((Node)element, true, context::transferIdToParent);
    }

    private void processComment(Comment element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        if (this.myHtmlConverterOptions.renderComments) {
            ((HtmlMarkdownWriter)((HtmlMarkdownWriter)out.append("<!--")).append(element.getData())).append("-->");
        }
    }

    private void processText(TextNode node, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        if (out.isPreFormatted()) {
            out.append(context.prepareText(node.getWholeText(), true));
        } else {
            String text = context.prepareText(node.text());
            if (out.offsetWithPending() != 0 || !text.trim().isEmpty()) {
                out.append(text);
            }
        }
    }

    private /* synthetic */ void lambda$null$0(HtmlNodeConverterContext context, Element element, CharSequence backTicks) {
        context.processTextNodes((Node)element, false, this.myHtmlConverterOptions.extInlineCode.isTextOnly() ? "" : backTicks);
    }
}

