/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.formatter.internal;

import com.vladsch.flexmark.ast.BlockQuote;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.formatter.internal.NodeFormatterContext;
import com.vladsch.flexmark.util.Consumer;
import com.vladsch.flexmark.util.Ref;
import com.vladsch.flexmark.util.html.ConditionalFormatter;
import com.vladsch.flexmark.util.html.FormattingAppendable;
import com.vladsch.flexmark.util.html.FormattingAppendableImpl;
import java.io.IOException;

public class MarkdownWriter
implements FormattingAppendable {
    private final FormattingAppendable myAppendable;
    private NodeFormatterContext context;

    public MarkdownWriter(Appendable out) {
        this(out, 0);
    }

    public String toString() {
        return this.myAppendable.getAppendable().toString();
    }

    public MarkdownWriter(Appendable out, int formatOptions) {
        this.myAppendable = new FormattingAppendableImpl(out, formatOptions);
    }

    public void setContext(NodeFormatterContext context) {
        this.context = context;
    }

    public NodeFormatterContext getContext() {
        return this.context;
    }

    public MarkdownWriter tailBlankLine() {
        return this.tailBlankLine(1);
    }

    public boolean isLastBlockQuoteChild(Node node) {
        Node parent = node.getParent();
        return parent instanceof BlockQuote && parent.getLastChild() == node;
    }

    public MarkdownWriter tailBlankLine(int count) {
        Node node = this.context.getCurrentNode();
        if (this.isLastBlockQuoteChild(node) && this.getPushedPrefixCount() > 0) {
            this.flush(-1);
            this.popPrefix();
            this.pushPrefix();
        }
        this.blankLine(count);
        return this;
    }

    public MarkdownWriter appendNonTranslating(CharSequence csq) {
        return this.appendNonTranslating(null, csq, null, null);
    }

    public MarkdownWriter appendNonTranslating(CharSequence prefix, CharSequence csq) {
        return this.appendNonTranslating(prefix, csq, null, null);
    }

    public MarkdownWriter appendNonTranslating(CharSequence prefix, CharSequence csq, CharSequence suffix) {
        return this.appendNonTranslating(prefix, csq, suffix, null);
    }

    public MarkdownWriter appendNonTranslating(CharSequence prefix, CharSequence csq, CharSequence suffix, CharSequence suffix2) {
        if (this.context.isTransformingText()) {
            this.append(this.context.transformNonTranslating(prefix, csq, suffix, suffix2));
        } else {
            this.append(csq);
        }
        return this;
    }

    public MarkdownWriter appendNonTranslating(CharSequence prefix, CharSequence csq, CharSequence suffix, CharSequence suffix2, Consumer<String> placeholderConsumer) {
        if (this.context.isTransformingText()) {
            this.append(this.context.transformNonTranslating(prefix, csq, suffix, suffix2));
        } else {
            this.append(csq);
        }
        return this;
    }

    public MarkdownWriter appendTranslating(CharSequence csq) {
        return this.appendTranslating(null, csq, null, null);
    }

    public MarkdownWriter appendTranslating(CharSequence prefix, CharSequence csq) {
        return this.appendTranslating(prefix, csq, null, null);
    }

    public MarkdownWriter appendTranslating(CharSequence prefix, CharSequence csq, CharSequence suffix) {
        return this.appendTranslating(prefix, csq, suffix, null);
    }

    public MarkdownWriter appendTranslating(CharSequence prefix, CharSequence csq, CharSequence suffix, CharSequence suffix2) {
        if (this.context.isTransformingText()) {
            this.append(this.context.transformTranslating(prefix, csq, suffix, suffix2));
        } else {
            if (prefix != null) {
                this.append(prefix);
            }
            this.append(csq);
            if (suffix != null) {
                this.append(suffix);
            }
        }
        return this;
    }

    public Appendable getAppendable() {
        return this.myAppendable.getAppendable();
    }

    public boolean isPendingEOL() {
        return this.myAppendable.isPendingEOL();
    }

    public boolean isPendingSpace() {
        return this.myAppendable.isPendingSpace();
    }

    public boolean isPreFormatted() {
        return this.myAppendable.isPreFormatted();
    }

    public CharSequence getIndentPrefix() {
        return this.myAppendable.getIndentPrefix();
    }

    public CharSequence getPrefix() {
        return this.myAppendable.getPrefix();
    }

    public CharSequence getTotalIndentPrefix() {
        return this.myAppendable.getTotalIndentPrefix();
    }

    public int getIndent() {
        return this.myAppendable.getIndent();
    }

    public int getLineCount() {
        return this.myAppendable.getLineCount();
    }

    public int getModCount() {
        return this.myAppendable.getModCount();
    }

    public int offset() {
        return this.myAppendable.offset();
    }

    public int column() {
        return this.myAppendable.column();
    }

    public int columnWith(CharSequence csq, int start, int end) {
        return this.myAppendable.columnWith(csq, start, end);
    }

    public int lastOffset() {
        return this.myAppendable.lastOffset();
    }

    public int getOptions() {
        return this.myAppendable.getOptions();
    }

    public int getPushedPrefixCount() {
        return this.myAppendable.getPushedPrefixCount();
    }

    public int getPendingEOL() {
        return this.myAppendable.getPendingEOL();
    }

    public IOException getIOException() {
        return this.myAppendable.getIOException();
    }

    public String getText() {
        return this.myAppendable.getText();
    }

    public String getText(int maxBlankLines) {
        return this.myAppendable.getText(maxBlankLines);
    }

    public MarkdownWriter addAfterEolRunnable(int atPendingEOL, Runnable runnable) {
        this.myAppendable.addAfterEolRunnable(atPendingEOL, runnable);
        return this;
    }

    public MarkdownWriter addLine() {
        this.myAppendable.addLine();
        return this;
    }

    public MarkdownWriter addPrefix(CharSequence prefix) {
        this.myAppendable.addPrefix(prefix);
        return this;
    }

    public MarkdownWriter append(char c) {
        this.myAppendable.append(c);
        return this;
    }

    public MarkdownWriter append(CharSequence csq) {
        this.myAppendable.append(csq);
        return this;
    }

    public MarkdownWriter append(CharSequence csq, int start, int end) {
        this.myAppendable.append(csq, start, end);
        return this;
    }

    public MarkdownWriter blankLine() {
        this.myAppendable.blankLine();
        return this;
    }

    public MarkdownWriter blankLine(int count) {
        this.myAppendable.blankLine(count);
        return this;
    }

    public MarkdownWriter blankLineIf(boolean predicate) {
        this.myAppendable.blankLineIf(predicate);
        return this;
    }

    public MarkdownWriter closeConditional(ConditionalFormatter closeFormatter) {
        this.myAppendable.closeConditional(closeFormatter);
        return this;
    }

    public MarkdownWriter closePreFormatted() {
        this.myAppendable.closePreFormatted();
        return this;
    }

    public MarkdownWriter flush() {
        this.myAppendable.flush();
        return this;
    }

    public MarkdownWriter flushWhitespaces() {
        this.myAppendable.flushWhitespaces();
        return this;
    }

    public MarkdownWriter flush(int maxBlankLines) {
        this.myAppendable.flush(maxBlankLines);
        return this;
    }

    public MarkdownWriter lastOffset(Ref<Integer> refOffset) {
        this.myAppendable.lastOffset(refOffset);
        return this;
    }

    public MarkdownWriter indent() {
        this.myAppendable.indent();
        return this;
    }

    public MarkdownWriter line() {
        this.myAppendable.line();
        return this;
    }

    public MarkdownWriter line(Ref<Boolean> lineRef) {
        this.myAppendable.line(lineRef);
        return this;
    }

    public MarkdownWriter lineIf(boolean predicate) {
        this.myAppendable.lineIf(predicate);
        return this;
    }

    public MarkdownWriter lineIf(Ref<Boolean> lineRef) {
        this.myAppendable.lineIf(lineRef);
        return this;
    }

    public MarkdownWriter openConditional(ConditionalFormatter openFormatter) {
        this.myAppendable.openConditional(openFormatter);
        return this;
    }

    public MarkdownWriter openPreFormatted(boolean keepIndent) {
        this.myAppendable.openPreFormatted(keepIndent);
        return this;
    }

    public MarkdownWriter popPrefix() {
        this.myAppendable.popPrefix();
        return this;
    }

    public MarkdownWriter pushPrefix() {
        this.myAppendable.pushPrefix();
        return this;
    }

    public MarkdownWriter repeat(char c, int count) {
        this.myAppendable.repeat(c, count);
        return this;
    }

    public MarkdownWriter repeat(CharSequence csq, int count) {
        this.myAppendable.repeat(csq, count);
        return this;
    }

    public MarkdownWriter repeat(CharSequence csq, int start, int end, int count) {
        this.myAppendable.repeat(csq, start, end, count);
        return this;
    }

    public MarkdownWriter setIndentOffset(int indentOffset) {
        this.myAppendable.setIndentOffset(indentOffset);
        return this;
    }

    public MarkdownWriter setIndentPrefix(CharSequence prefix) {
        this.myAppendable.setIndentPrefix(prefix);
        return this;
    }

    public MarkdownWriter setOptions(int options) {
        this.myAppendable.setOptions(options);
        return this;
    }

    public MarkdownWriter setPrefix(CharSequence prefix) {
        this.myAppendable.setPrefix(prefix);
        return this;
    }

    public MarkdownWriter unIndent() {
        this.myAppendable.unIndent();
        return this;
    }

    public MarkdownWriter willIndent() {
        this.myAppendable.willIndent();
        return this;
    }
}

