/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.formatter.internal;

import com.vladsch.flexmark.formatter.internal.Formatter;
import com.vladsch.flexmark.formatter.options.BlockQuoteMarker;
import com.vladsch.flexmark.formatter.options.CodeFenceMarker;
import com.vladsch.flexmark.formatter.options.DiscretionaryText;
import com.vladsch.flexmark.formatter.options.ElementPlacement;
import com.vladsch.flexmark.formatter.options.ElementPlacementSort;
import com.vladsch.flexmark.formatter.options.EqualizeTrailingMarker;
import com.vladsch.flexmark.formatter.options.ListBulletMarker;
import com.vladsch.flexmark.formatter.options.ListNumberedMarker;
import com.vladsch.flexmark.formatter.options.ListSpacing;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.ParserEmulationProfile;
import com.vladsch.flexmark.util.options.DataHolder;

public class FormatterOptions {
    public final boolean itemContentIndent;
    public final boolean setextHeaderEqualizeMarker;
    public final int formatFlags;
    public final int maxBlankLines;
    public final int maxTrailingBlankLines;
    public final int minSetextMarkerLength;
    public final DiscretionaryText spaceAfterAtxMarker;
    public final EqualizeTrailingMarker atxHeaderTrailingMarker;
    public final BlockQuoteMarker blockQuoteMarkers;
    public final String thematicBreak;
    public final boolean indentedCodeMinimizeIndent;
    public final boolean fencedCodeMinimizeIndent;
    public final boolean fencedCodeMatchClosingMarker;
    public final boolean fencedCodeSpaceBeforeInfo;
    public final int fencedCodeMarkerLength;
    public final CodeFenceMarker fencedCodeMarkerType;
    public final boolean listAddBlankLineBefore;
    public final boolean listRenumberItems;
    public final ListBulletMarker listBulletMarker;
    public final ListNumberedMarker listNumberedMarker;
    public final ListSpacing listSpacing;
    public final ElementPlacement referencePlacement;
    public final ElementPlacementSort referenceSort;
    public final boolean keepImageLinksAtStart;
    public final boolean keepExplicitLinksAtStart;

    public FormatterOptions(DataHolder options) {
        ParserEmulationProfile emulationProfile = (ParserEmulationProfile)Formatter.FORMATTER_EMULATION_PROFILE.getFrom(options);
        this.itemContentIndent = emulationProfile.family != ParserEmulationProfile.FIXED_INDENT;
        this.setextHeaderEqualizeMarker = (Boolean)Formatter.SETEXT_HEADER_EQUALIZE_MARKER.getFrom(options);
        this.formatFlags = (Integer)Formatter.FORMAT_FLAGS.getFrom(options);
        this.maxBlankLines = (Integer)Formatter.MAX_BLANK_LINES.getFrom(options);
        this.maxTrailingBlankLines = (Integer)Formatter.MAX_TRAILING_BLANK_LINES.getFrom(options);
        this.spaceAfterAtxMarker = (DiscretionaryText)((Object)Formatter.SPACE_AFTER_ATX_MARKER.getFrom(options));
        this.atxHeaderTrailingMarker = (EqualizeTrailingMarker)((Object)Formatter.ATX_HEADER_TRAILING_MARKER.getFrom(options));
        this.minSetextMarkerLength = (Integer)Parser.HEADING_SETEXT_MARKER_LENGTH.getFrom(options);
        this.thematicBreak = (String)Formatter.THEMATIC_BREAK.getFrom(options);
        this.blockQuoteMarkers = (BlockQuoteMarker)((Object)Formatter.BLOCK_QUOTE_MARKERS.getFrom(options));
        this.indentedCodeMinimizeIndent = (Boolean)Formatter.INDENTED_CODE_MINIMIZE_INDENT.getFrom(options);
        this.fencedCodeMinimizeIndent = (Boolean)Formatter.FENCED_CODE_MINIMIZE_INDENT.getFrom(options);
        this.fencedCodeMatchClosingMarker = (Boolean)Formatter.FENCED_CODE_MATCH_CLOSING_MARKER.getFrom(options);
        this.fencedCodeSpaceBeforeInfo = (Boolean)Formatter.FENCED_CODE_SPACE_BEFORE_INFO.getFrom(options);
        this.fencedCodeMarkerLength = (Integer)Formatter.FENCED_CODE_MARKER_LENGTH.getFrom(options);
        this.fencedCodeMarkerType = (CodeFenceMarker)((Object)Formatter.FENCED_CODE_MARKER_TYPE.getFrom(options));
        this.listAddBlankLineBefore = (Boolean)Formatter.LIST_ADD_BLANK_LINE_BEFORE.getFrom(options);
        this.listRenumberItems = (Boolean)Formatter.LIST_RENUMBER_ITEMS.getFrom(options);
        this.listBulletMarker = (ListBulletMarker)((Object)Formatter.LIST_BULLET_MARKER.getFrom(options));
        this.listNumberedMarker = (ListNumberedMarker)((Object)Formatter.LIST_NUMBERED_MARKER.getFrom(options));
        this.listSpacing = (ListSpacing)((Object)Formatter.LIST_SPACING.getFrom(options));
        this.referencePlacement = (ElementPlacement)((Object)Formatter.REFERENCE_PLACEMENT.getFrom(options));
        this.referenceSort = (ElementPlacementSort)((Object)Formatter.REFERENCE_SORT.getFrom(options));
        this.keepImageLinksAtStart = (Boolean)Formatter.KEEP_IMAGE_LINKS_AT_START.getFrom(options);
        this.keepExplicitLinksAtStart = (Boolean)Formatter.KEEP_EXPLICIT_LINKS_AT_START.getFrom(options);
    }
}

