/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.xwiki.macros.internal;

import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.util.Parsing;
import com.vladsch.flexmark.ext.xwiki.macros.Macro;
import com.vladsch.flexmark.ext.xwiki.macros.MacroAttribute;
import com.vladsch.flexmark.ext.xwiki.macros.MacroBlock;
import com.vladsch.flexmark.ext.xwiki.macros.MacroClose;
import com.vladsch.flexmark.ext.xwiki.macros.internal.MacroOptions;
import com.vladsch.flexmark.ext.xwiki.macros.internal.MacroParsing;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.BlockContent;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;

public class MacroBlockParser
extends AbstractBlockParser {
    private final MacroBlock block = new MacroBlock();
    private BlockContent content = new BlockContent();
    private final MacroOptions options;
    private final MacroParsing parsing;
    private final BasedSequence macroName;
    private final boolean oneLine;
    private boolean hadClose;

    MacroBlockParser(DataHolder options, MacroParsing parsing, BasedSequence macroName, boolean oneLine) {
        this.options = new MacroOptions(options);
        this.parsing = parsing;
        this.macroName = macroName;
        this.oneLine = oneLine;
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockContinue tryContinue(ParserState state) {
        if (this.hadClose) {
            return BlockContinue.none();
        }
        BasedSequence line = state.getLine();
        Matcher closeMatcher = this.parsing.MACRO_CLOSE.matcher((CharSequence)line);
        if (closeMatcher.find() && this.macroName.equals(closeMatcher.group(1))) {
            BlockParser parser;
            List parsers = state.getActiveBlockParsers();
            boolean isChildClose = false;
            int i = parsers.size();
            while (i-- > 0 && (parser = (BlockParser)parsers.get(i)) != this) {
                if (!(parser instanceof MacroBlockParser) || ((MacroBlockParser)parser).hadClose || !((MacroBlockParser)parser).macroName.equals(this.macroName)) continue;
                isChildClose = true;
            }
            if (!isChildClose) {
                this.hadClose = true;
                MacroClose macroClose = new MacroClose(line.subSequence(closeMatcher.start(), closeMatcher.start() + 3), line.subSequence(closeMatcher.start(1), closeMatcher.end(1)), line.subSequence(closeMatcher.end() - 2, closeMatcher.end()));
                macroClose.setCharsFromContent();
                this.block.appendChild((Node)macroClose);
                return BlockContinue.atIndex((int)state.getLineEndIndex());
            }
        }
        return BlockContinue.atIndex((int)state.getIndex());
    }

    public void addLine(ParserState state, BasedSequence line) {
        this.content.add(line, state.getIndent());
    }

    public boolean isContainer() {
        return true;
    }

    public boolean canContain(ParserState state, BlockParser blockParser, Block block) {
        return true;
    }

    public void closeBlock(ParserState state) {
        if (this.oneLine) {
            ArrayList<BasedSequence> lines = new ArrayList<BasedSequence>();
            Macro macro = (Macro)this.block.getFirstChild();
            Node node = this.block.getLastChild();
            BasedSequence contentLine = node instanceof MacroClose ? macro.getChars().baseSubSequence(macro.getEndOffset(), node.getStartOffset()) : macro.getChars().baseSubSequence(macro.getEndOffset(), macro.getEndOffset());
            lines.add(contentLine);
            this.block.setContent(lines);
        } else if (this.hadClose) {
            List lines = this.content.getLines();
            this.block.setContent(lines);
        } else {
            List lines = this.content.getLines();
            this.block.setContent(lines.subList(0, lines.size()));
        }
        this.block.setCharsFromContent();
        this.content = null;
    }

    public void parseInlines(InlineParser inlineParser) {
        Node node = this.block.getLastChild();
        if (node instanceof MacroClose) {
            node.unlink();
        }
        inlineParser.parse(this.block.getContentChars(), (Node)this.block);
        if (node instanceof MacroClose) {
            this.block.appendChild(node);
        }
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private final MacroOptions options;
        private final MacroParsing parsing;

        BlockFactory(DataHolder options) {
            super(options);
            this.options = new MacroOptions(options);
            this.parsing = new MacroParsing(new Parsing(options));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            BasedSequence tryLine;
            Matcher matcher;
            BasedSequence line = state.getLine();
            int currentIndent = state.getIndent();
            if (currentIndent != 0 || matchedBlockParser.getBlockParser().getBlock() instanceof Paragraph || !(matcher = this.parsing.MACRO_OPEN.matcher((CharSequence)(tryLine = line.subSequence(state.getIndex())))).find()) return BlockStart.none();
            BasedSequence macroName = line.subSequence(matcher.start(1), matcher.end(1));
            BasedSequence macroOpen = tryLine.subSequence(0, matcher.end());
            BasedSequence afterOpen = tryLine.subSequence(matcher.end());
            boolean oneLine = false;
            boolean isClosedTag = false;
            MacroClose macroClose = null;
            if (macroOpen.endsWith((CharSequence)"/}}")) {
                if (!afterOpen.isBlank()) return BlockStart.none();
                oneLine = true;
                isClosedTag = true;
            } else if (!afterOpen.isBlank()) {
                Matcher closeMatcher = this.parsing.MACRO_CLOSE_END.matcher((CharSequence)afterOpen);
                if (closeMatcher.find() && macroName.equals(closeMatcher.group(1)) && (closeMatcher.groupCount() < 2 || closeMatcher.start(2) == -1 || (closeMatcher.group(2).length() & 1) == 1)) {
                    oneLine = true;
                    macroClose = new MacroClose(afterOpen.subSequence(closeMatcher.start(), closeMatcher.start() + 3), afterOpen.subSequence(closeMatcher.start(1), closeMatcher.end(1)), afterOpen.subSequence(closeMatcher.end() - 2, closeMatcher.end()));
                    macroClose.setCharsFromContent();
                }
                if (!oneLine) {
                    return BlockStart.none();
                }
            }
            Macro macro = new Macro(macroOpen.subSequence(0, 2), macroName, macroOpen.endSequence(isClosedTag ? 3 : 2));
            macro.setCharsFromContent();
            BasedSequence attributeText = macroOpen.baseSubSequence(macroName.getEndOffset(), macro.getClosingMarker().getStartOffset()).trim();
            if (!attributeText.isEmpty()) {
                macro.setAttributeText(attributeText);
                Matcher attributeMatcher = this.parsing.MACRO_ATTRIBUTE.matcher((CharSequence)attributeText);
                while (attributeMatcher.find()) {
                    BasedSequence attributeClose;
                    BasedSequence attributeName = attributeText.subSequence(attributeMatcher.start(1), attributeMatcher.end(1));
                    BasedSequence attributeSeparator = attributeMatcher.groupCount() == 1 || attributeMatcher.start(2) == -1 ? BasedSequence.NULL : attributeText.subSequence(attributeMatcher.end(1), attributeMatcher.start(2)).trim();
                    BasedSequence attributeValue = attributeMatcher.groupCount() == 1 || attributeMatcher.start(2) == -1 ? BasedSequence.NULL : attributeText.subSequence(attributeMatcher.start(2), attributeMatcher.end(2));
                    boolean isQuoted = attributeValue.length() >= 2 && (attributeValue.charAt(0) == '\"' && attributeValue.endCharAt(1) == '\"' || attributeValue.charAt(0) == '\'' && attributeValue.endCharAt(1) == '\'');
                    BasedSequence attributeOpen = !isQuoted ? BasedSequence.NULL : attributeValue.subSequence(0, 1);
                    BasedSequence basedSequence = attributeClose = !isQuoted ? BasedSequence.NULL : attributeValue.endSequence(1, 0);
                    if (isQuoted) {
                        attributeValue = attributeValue.midSequence(1, -1);
                    }
                    MacroAttribute attribute = new MacroAttribute(attributeName, attributeSeparator, attributeOpen, attributeValue, attributeClose);
                    macro.appendChild((Node)attribute);
                }
            }
            MacroBlockParser parser = new MacroBlockParser((DataHolder)state.getProperties(), this.parsing, macroName, oneLine);
            if (oneLine) {
                parser.hadClose = true;
            }
            parser.block.appendChild((Node)macro);
            if (macroClose == null) return BlockStart.of((BlockParser[])new BlockParser[]{parser}).atIndex(state.getLineEndIndex());
            parser.block.appendChild((Node)macroClose);
            return BlockStart.of((BlockParser[])new BlockParser[]{parser}).atIndex(state.getLineEndIndex());
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        public Set<Class<? extends CustomBlockParserFactory>> getAfterDependents() {
            return null;
        }

        public Set<Class<? extends CustomBlockParserFactory>> getBeforeDependents() {
            return null;
        }

        public boolean affectsGlobalScope() {
            return false;
        }

        public BlockParserFactory create(DataHolder options) {
            return new BlockFactory(options);
        }
    }
}

