/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.wikilink.internal;

import com.vladsch.flexmark.ext.wikilink.WikiImage;
import com.vladsch.flexmark.ext.wikilink.WikiLink;
import com.vladsch.flexmark.ext.wikilink.WikiLinkExtension;
import com.vladsch.flexmark.ext.wikilink.internal.WikiLinkOptions;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class WikiLinkNodeRenderer
implements NodeRenderer {
    private final WikiLinkOptions options;

    public WikiLinkNodeRenderer(DataHolder options) {
        this.options = new WikiLinkOptions(options);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(WikiLink.class, this::render));
        set.add(new NodeRenderingHandler(WikiImage.class, this::render));
        return set;
    }

    private void render(WikiLink node, NodeRendererContext context, HtmlWriter html) {
        if (!context.isDoNotRenderLinks()) {
            if (this.options.disableRendering) {
                html.text((CharSequence)node.getChars().unescape());
            } else {
                ResolvedLink resolvedLink = context.resolveLink(WikiLinkExtension.WIKI_LINK, (CharSequence)node.getLink().unescape(), null);
                html.attr((CharSequence)"href", (CharSequence)resolvedLink.getUrl());
                html.srcPos(node.getChars()).withAttr(resolvedLink).tag((CharSequence)"a");
                context.renderChildren((Node)node);
                html.tag((CharSequence)"/a");
            }
        }
    }

    private void render(WikiImage node, NodeRendererContext context, HtmlWriter html) {
        if (!context.isDoNotRenderLinks()) {
            if (this.options.disableRendering) {
                html.text((CharSequence)node.getChars().unescape());
            } else {
                String altText = node.getText().isNotNull() ? node.getText().toString() : node.getLink().unescape();
                ResolvedLink resolvedLink = context.resolveLink(WikiLinkExtension.WIKI_LINK, (CharSequence)node.getLink().unescape(), null);
                String url = resolvedLink.getUrl();
                html.attr((CharSequence)"src", (CharSequence)url);
                html.attr((CharSequence)"alt", (CharSequence)altText);
                html.srcPos(node.getChars()).withAttr(resolvedLink).tagVoid((CharSequence)"img");
            }
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new WikiLinkNodeRenderer(options);
        }
    }
}

