/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.typographic.internal;

import com.vladsch.flexmark.ast.DoNotDecorate;
import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ext.typographic.TypographicSmarts;
import com.vladsch.flexmark.ext.typographic.internal.TypographicOptions;
import com.vladsch.flexmark.parser.block.NodePostProcessor;
import com.vladsch.flexmark.parser.block.NodePostProcessorFactory;
import com.vladsch.flexmark.util.NodeTracker;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TypographicNodePostProcessor
extends NodePostProcessor {
    public static final Pattern SMARTS_PATTERN = Pattern.compile("(\\?)(\\.\\.\\.|\\. \\. \\.|--|---|')");
    private final TypographicOptions myOptions;

    public TypographicNodePostProcessor(Document document) {
        this.myOptions = new TypographicOptions((DataHolder)document);
    }

    public void process(NodeTracker state, Node node) {
        TextBase textBase;
        BasedSequence original;
        BasedSequence literal = original = node.getChars();
        Matcher m = SMARTS_PATTERN.matcher((CharSequence)literal);
        int lastEscaped = 0;
        boolean wrapInTextBase = !(node.getParent() instanceof TextBase);
        TextBase textBase2 = textBase = wrapInTextBase ? null : (TextBase)node.getParent();
        while (m.find()) {
            if (m.group(1) != null) continue;
            BasedSequence toDecorateText = literal.subSequence(m.start(2), m.end(2));
            int startOffset = m.start(2);
            int endOffset = m.end(2);
            if (wrapInTextBase) {
                wrapInTextBase = false;
                textBase = new TextBase(original);
                node.insertBefore((Node)textBase);
                state.nodeAdded((Node)textBase);
            }
            if (startOffset != lastEscaped) {
                BasedSequence escapedChars = original.subSequence(lastEscaped, startOffset);
                Text node1 = new Text(escapedChars);
                textBase.appendChild((Node)node1);
                state.nodeAdded((Node)node1);
            }
            String typographicSmarts = toDecorateText.matches((CharSequence)"--") ? "&ndash;" : (toDecorateText.matches((CharSequence)"---") ? "&mdash;" : (toDecorateText.matches((CharSequence)"'") ? "&rsquo;" : "&hellip;"));
            BasedSequence origToDecorateText = original.subSequence(startOffset, endOffset);
            TypographicSmarts decorationNode = new TypographicSmarts(toDecorateText, typographicSmarts);
            decorationNode.setTypographicText(typographicSmarts);
            textBase.appendChild((Node)decorationNode);
            state.nodeAdded((Node)decorationNode);
            lastEscaped = endOffset;
        }
        if (lastEscaped > 0) {
            if (lastEscaped != original.length()) {
                BasedSequence escapedChars = original.subSequence(lastEscaped, original.length());
                Text node1 = new Text(escapedChars);
                textBase.appendChild((Node)node1);
                state.nodeAdded((Node)node1);
            }
            node.unlink();
            state.nodeRemoved(node);
        }
    }

    public static class Factory
    extends NodePostProcessorFactory {
        public Factory() {
            super(false);
            this.addNodeWithExclusions(Text.class, new Class[]{DoNotDecorate.class});
        }

        public NodePostProcessor create(Document document) {
            return new TypographicNodePostProcessor(document);
        }
    }
}

