/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.typographic.internal;

import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.typographic.TypographicQuotes;
import com.vladsch.flexmark.ext.typographic.TypographicSmarts;
import com.vladsch.flexmark.ext.typographic.internal.TypographicOptions;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.HashSet;
import java.util.Set;

public class TypographicNodeRenderer
implements NodeRenderer {
    private final TypographicOptions options;

    public TypographicNodeRenderer(DataHolder options) {
        this.options = new TypographicOptions(options);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(TypographicSmarts.class, (CustomNodeRenderer)new CustomNodeRenderer<TypographicSmarts>(){

            public void render(TypographicSmarts node, NodeRendererContext context, HtmlWriter html) {
                TypographicNodeRenderer.this.render(node, context, html);
            }
        }));
        set.add(new NodeRenderingHandler(TypographicQuotes.class, (CustomNodeRenderer)new CustomNodeRenderer<TypographicQuotes>(){

            public void render(TypographicQuotes node, NodeRendererContext context, HtmlWriter html) {
                TypographicNodeRenderer.this.render(node, context, html);
            }
        }));
        return set;
    }

    private void render(TypographicQuotes node, NodeRendererContext context, HtmlWriter html) {
        if (node.getTypographicOpening() != null && !node.getTypographicOpening().isEmpty()) {
            html.raw(node.getTypographicOpening());
        }
        context.renderChildren((Node)node);
        if (node.getTypographicClosing() != null && !node.getTypographicClosing().isEmpty()) {
            html.raw(node.getTypographicClosing());
        }
    }

    private void render(TypographicSmarts node, NodeRendererContext context, HtmlWriter html) {
        html.raw(node.getTypographicText());
    }
}

