/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.typographic.internal;

import com.vladsch.flexmark.ext.typographic.TypographicSmarts;
import com.vladsch.flexmark.ext.typographic.internal.SmartsParsing;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.InlineParserExtension;
import com.vladsch.flexmark.parser.InlineParserExtensionFactory;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Set;

public class SmartsInlineParser
implements InlineParserExtension {
    private final SmartsParsing parsing;

    public SmartsInlineParser(InlineParser inlineParser) {
        this.parsing = new SmartsParsing(inlineParser.getParsing());
    }

    public void finalizeDocument(InlineParser inlineParser) {
    }

    public void finalizeBlock(InlineParser inlineParser) {
    }

    public boolean parse(InlineParser inlineParser) {
        BasedSequence match = inlineParser.match(this.parsing.SMARTS);
        if (match != null) {
            String typographicSmarts;
            BasedSequence input = inlineParser.getInput();
            inlineParser.flushTextNode();
            if (match.matches((CharSequence)this.parsing.ELIPSIS)) {
                typographicSmarts = "&hellip;";
            } else if (match.matches((CharSequence)this.parsing.ELIPSIS_SPACED)) {
                typographicSmarts = "&hellip;";
            } else if (match.matches((CharSequence)this.parsing.EN_DASH)) {
                typographicSmarts = "&ndash;";
            } else if (match.matches((CharSequence)this.parsing.EM_DASH)) {
                typographicSmarts = "&mdash;";
            } else {
                return false;
            }
            TypographicSmarts smarts = new TypographicSmarts(match, typographicSmarts);
            inlineParser.getBlock().appendChild((Node)smarts);
            return true;
        }
        return false;
    }

    public static class Factory
    implements InlineParserExtensionFactory {
        public Set<Class<? extends InlineParserExtensionFactory>> getAfterDependents() {
            return null;
        }

        public CharSequence getCharacters() {
            return ".-";
        }

        public Set<Class<? extends InlineParserExtensionFactory>> getBeforeDependents() {
            return null;
        }

        public InlineParserExtension apply(InlineParser inlineParser) {
            return new SmartsInlineParser(inlineParser);
        }

        public boolean affectsGlobalScope() {
            return false;
        }
    }
}

