/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.typographic.internal;

import com.vladsch.flexmark.ast.DelimitedNode;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.typographic.TypographicQuotes;
import com.vladsch.flexmark.ext.typographic.TypographicSmarts;
import com.vladsch.flexmark.ext.typographic.internal.TypographicOptions;
import com.vladsch.flexmark.internal.Delimiter;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.delimiter.DelimiterProcessor;
import com.vladsch.flexmark.parser.delimiter.DelimiterRun;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public class QuoteDelimiterProcessorBase
implements DelimiterProcessor {
    protected final TypographicOptions myOptions;
    protected final char myOpenDelimiter;
    protected final char myCloseDelimiter;
    protected final String myOpener;
    protected final String myCloser;
    protected final String myUnmatched;

    public QuoteDelimiterProcessorBase(TypographicOptions options, char openDelimiter, char closeDelimiter, String opener, String closer, String unmatched) {
        this.myOptions = options;
        this.myOpenDelimiter = openDelimiter;
        this.myCloseDelimiter = closeDelimiter;
        this.myOpener = opener;
        this.myCloser = closer;
        this.myUnmatched = unmatched;
    }

    public final char getOpeningCharacter() {
        return this.myOpenDelimiter;
    }

    public final char getClosingCharacter() {
        return this.myCloseDelimiter;
    }

    public int getMinLength() {
        return 1;
    }

    protected boolean havePreviousOpener(DelimiterRun opener) {
        int minLength = this.getMinLength();
        for (DelimiterRun previous = opener.getPrevious(); previous != null; previous = previous.getPrevious()) {
            if (previous.getDelimiterChar() != this.myOpenDelimiter) continue;
            return this.canOpen(previous, minLength);
        }
        return false;
    }

    protected boolean haveNextCloser(DelimiterRun closer) {
        int minLength = this.getMinLength();
        for (DelimiterRun next = closer.getNext(); next != null; next = next.getNext()) {
            if (next.getDelimiterChar() != this.myCloseDelimiter) continue;
            return this.canClose(next, minLength);
        }
        return false;
    }

    protected boolean canClose(DelimiterRun closer, int minLength) {
        if (closer.canClose()) {
            BasedSequence closerChars = closer.getNode().getChars();
            if (closer.getNext() != null && closerChars.isContinuationOf(closer.getNext().getNode().getChars()) || closerChars.getEndOffset() >= closerChars.getBaseSequence().length() || this.isAllowed((CharSequence)closerChars.getBaseSequence(), closerChars.getEndOffset() + minLength - 1)) {
                return true;
            }
        }
        return false;
    }

    protected boolean canOpen(DelimiterRun opener, int minLength) {
        if (opener.canOpen()) {
            BasedSequence openerChars = opener.getNode().getChars();
            if (opener.getPrevious() != null && opener.getPrevious().getNode().getChars().isContinuationOf(openerChars) || openerChars.getStartOffset() == 0 || this.isAllowed((CharSequence)openerChars.getBaseSequence(), openerChars.getStartOffset() - minLength)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isAllowed(char c) {
        return !Character.isLetterOrDigit(c);
    }

    protected boolean isAllowed(CharSequence seq, int index) {
        return index < 0 || index >= seq.length() || !Character.isLetterOrDigit(seq.charAt(index));
    }

    public int getDelimiterUse(DelimiterRun opener, DelimiterRun closer) {
        int minLength = this.getMinLength();
        if (opener.length() >= minLength && closer.length() >= minLength && this.canOpen(opener, minLength) && this.canClose(closer, minLength)) {
            return minLength;
        }
        return 0;
    }

    public Node unmatchedDelimiterNode(InlineParser inlineParser, DelimiterRun delimiter) {
        BasedSequence chars;
        if (this.myUnmatched != null && this.myOptions.typographicSmarts && (chars = delimiter.getNode().getChars()).length() == 1) {
            return new TypographicSmarts(chars, this.myUnmatched);
        }
        return null;
    }

    public void process(Delimiter opener, Delimiter closer, int delimitersUsed) {
        TypographicQuotes node = new TypographicQuotes(opener.getTailChars(delimitersUsed), BasedSequence.NULL, closer.getLeadChars(delimitersUsed));
        node.setTypographicOpening(this.myOpener);
        node.setTypographicClosing(this.myCloser);
        opener.moveNodesBetweenDelimitersTo((DelimitedNode)node, closer);
    }
}

