/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.toc.internal;

import com.vladsch.flexmark.ast.Block;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.HtmlBlock;
import com.vladsch.flexmark.ast.ListBlock;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.util.Parsing;
import com.vladsch.flexmark.ext.toc.SimTocBlock;
import com.vladsch.flexmark.ext.toc.SimTocContent;
import com.vladsch.flexmark.ext.toc.SimTocOption;
import com.vladsch.flexmark.ext.toc.SimTocOptionList;
import com.vladsch.flexmark.ext.toc.internal.SimTocOptionsParser;
import com.vladsch.flexmark.ext.toc.internal.TocOptions;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.Pair;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.ParsedOption;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimTocBlockParser
extends AbstractBlockParser {
    static int HAVE_HTML = 1;
    static int HAVE_HEADING = 2;
    static int HAVE_LIST = 4;
    static int HAVE_BLANK_LINE = 8;
    private final SimTocBlock block;
    private final TocOptions options;
    private int haveChildren = 0;
    private BasedSequence blankLineSpacer = BasedSequence.NULL;

    SimTocBlockParser(DataHolder options, BasedSequence tocChars, BasedSequence styleChars, BasedSequence titleChars) {
        this.options = new TocOptions(options);
        this.block = new SimTocBlock(tocChars, styleChars, titleChars);
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockContinue tryContinue(ParserState state) {
        if ((!this.options.isBlankLineSpacer || this.haveChildren != 0) && state.isBlank()) {
            return BlockContinue.none();
        }
        if (state.isBlank()) {
            this.haveChildren |= HAVE_BLANK_LINE;
            this.blankLineSpacer = state.getLine();
        }
        return BlockContinue.atIndex((int)state.getIndex());
    }

    public boolean canContain(Block block) {
        if (block instanceof HtmlBlock) {
            if ((this.haveChildren & ~HAVE_BLANK_LINE) == 0) {
                this.haveChildren |= HAVE_HTML;
                return true;
            }
        } else if (block instanceof Heading) {
            if ((this.haveChildren & ~HAVE_BLANK_LINE) == 0) {
                this.haveChildren |= HAVE_HEADING;
                return true;
            }
        } else if (block instanceof ListBlock && (this.haveChildren & (HAVE_HTML | HAVE_LIST)) == 0) {
            this.haveChildren |= HAVE_LIST;
            return true;
        }
        return false;
    }

    public boolean isContainer() {
        return true;
    }

    public void addLine(ParserState state, BasedSequence line) {
    }

    public void closeBlock(ParserState state) {
        SimTocOptionsParser optionsParser;
        Pair pair;
        List options;
        if (this.block.hasChildren()) {
            SimTocContent tocContent = new SimTocContent();
            tocContent.takeChildren((Node)this.block);
            tocContent.setCharsFromContent();
            if (this.blankLineSpacer.isNotNull()) {
                tocContent.setChars(Node.spanningChars((BasedSequence[])new BasedSequence[]{this.blankLineSpacer, tocContent.getChars()}));
            }
            this.block.appendChild((Node)tocContent);
            this.block.setCharsFromContent();
            state.blockAddedWithChildren((Block)tocContent);
        }
        if (this.options.isAstAddOptions && !this.block.getStyle().isEmpty() && !(options = (List)(pair = (optionsParser = new SimTocOptionsParser()).parseOption(this.block.getStyle(), TocOptions.DEFAULT, null)).getSecond()).isEmpty()) {
            SimTocOptionList optionsNode = new SimTocOptionList();
            for (ParsedOption option : options) {
                SimTocOption optionNode = new SimTocOption(option.getSource());
                optionsNode.appendChild((Node)optionNode);
            }
            optionsNode.setCharsFromContent();
            this.block.prependChild((Node)optionsNode);
        }
        this.block.setCharsFromContent();
    }

    public void parseInlines(InlineParser inlineParser) {
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private final TocOptions options;
        private final TocParsing myParsing;

        BlockFactory(DataHolder options) {
            super(options);
            this.options = new TocOptions(options);
            this.myParsing = new TocParsing(options);
        }

        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            if (state.getIndent() >= 4) {
                return BlockStart.none();
            }
            BasedSequence line = state.getLine();
            int nextNonSpace = state.getNextNonSpaceIndex();
            BasedSequence trySequence = line.subSequence(nextNonSpace, line.length());
            Matcher matcher = this.myParsing.TOC_BLOCK_START.matcher((CharSequence)line);
            if (matcher.matches()) {
                BasedSequence tocChars = state.getLineWithEOL();
                BasedSequence styleChars = null;
                BasedSequence titleChars = null;
                if (matcher.start(1) != -1) {
                    styleChars = trySequence.subSequence(matcher.start(1), matcher.end(1));
                }
                if (matcher.start(2) != -1) {
                    titleChars = trySequence.subSequence(matcher.start(2), matcher.end(2));
                }
                SimTocBlockParser simTocBlockParser = new SimTocBlockParser((DataHolder)state.getProperties(), tocChars, styleChars, titleChars);
                return BlockStart.of((BlockParser[])new BlockParser[]{simTocBlockParser}).atIndex(state.getLineEndIndex() + state.getLineEolLength());
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        public Set<Class<? extends CustomBlockParserFactory>> getAfterDependents() {
            return null;
        }

        public Set<Class<? extends CustomBlockParserFactory>> getBeforeDependents() {
            return null;
        }

        public boolean affectsGlobalScope() {
            return false;
        }

        public BlockParserFactory create(DataHolder options) {
            return new BlockFactory(options);
        }
    }

    static class TocParsing
    extends Parsing {
        final Pattern TOC_BLOCK_START;

        public TocParsing(DataHolder options) {
            super(options);
            this.TOC_BLOCK_START = Pattern.compile("^\\[TOC(?:\\s+([^\\]]+))?]:\\s*#(?:\\s+(" + this.LINK_TITLE_STRING + "))?\\s*$");
        }
    }
}

