/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.tables.internal;

import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.tables.TableBlock;
import com.vladsch.flexmark.ext.tables.TableBody;
import com.vladsch.flexmark.ext.tables.TableCaption;
import com.vladsch.flexmark.ext.tables.TableCell;
import com.vladsch.flexmark.ext.tables.TableHead;
import com.vladsch.flexmark.ext.tables.TableRow;
import com.vladsch.flexmark.ext.tables.TableSeparator;
import com.vladsch.flexmark.ext.tables.internal.TableFormatOptions;
import com.vladsch.flexmark.formatter.CustomNodeFormatter;
import com.vladsch.flexmark.formatter.internal.MarkdownWriter;
import com.vladsch.flexmark.formatter.internal.NodeFormatter;
import com.vladsch.flexmark.formatter.internal.NodeFormatterContext;
import com.vladsch.flexmark.formatter.internal.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.internal.NodeFormattingHandler;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class TableNodeFormatter
implements NodeFormatter {
    private final TableFormatOptions options;
    private int rowNumber;
    private int columnNumber;
    private boolean isSeparator;

    public TableNodeFormatter(DataHolder options) {
        this.options = new TableFormatOptions(options);
    }

    public Set<Class<?>> getNodeClasses() {
        return null;
    }

    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler(TableBlock.class, (CustomNodeFormatter)new CustomNodeFormatter<TableBlock>(){

            public void render(TableBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(TableHead.class, (CustomNodeFormatter)new CustomNodeFormatter<TableHead>(){

            public void render(TableHead node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(TableSeparator.class, (CustomNodeFormatter)new CustomNodeFormatter<TableSeparator>(){

            public void render(TableSeparator node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(TableBody.class, (CustomNodeFormatter)new CustomNodeFormatter<TableBody>(){

            public void render(TableBody node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(TableRow.class, (CustomNodeFormatter)new CustomNodeFormatter<TableRow>(){

            public void render(TableRow node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(TableCell.class, (CustomNodeFormatter)new CustomNodeFormatter<TableCell>(){

            public void render(TableCell node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(TableCaption.class, (CustomNodeFormatter)new CustomNodeFormatter<TableCaption>(){

            public void render(TableCaption node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        })));
    }

    private void render(TableBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.rowNumber = 0;
        context.renderChildren((Node)node);
    }

    private void render(TableHead node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.rowNumber = 0;
        this.isSeparator = false;
        context.renderChildren((Node)node);
    }

    private void render(TableSeparator node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.rowNumber = 0;
        this.isSeparator = true;
        context.renderChildren((Node)node);
    }

    private void render(TableBody node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.rowNumber = 0;
        this.isSeparator = false;
        context.renderChildren((Node)node);
    }

    private void render(TableRow node, NodeFormatterContext context, MarkdownWriter markdown) {
        ++this.rowNumber;
        this.columnNumber = 0;
        context.renderChildren((Node)node);
        markdown.line();
    }

    private void render(TableCaption node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (!this.options.formatRemoveCaption) {
            markdown.line().append((CharSequence)node.getOpeningMarker());
            context.renderChildren((Node)node);
            markdown.append((CharSequence)node.getClosingMarker()).line();
        }
    }

    private void render(TableCell node, NodeFormatterContext context, MarkdownWriter markdown) {
        ++this.columnNumber;
        if (node.getPrevious() == null) {
            if (this.options.leadTrailPipes && node.getOpeningMarker().isEmpty()) {
                markdown.append('|');
            } else {
                markdown.append((CharSequence)node.getOpeningMarker());
            }
        } else {
            markdown.append((CharSequence)node.getOpeningMarker());
        }
        if (!this.isSeparator && this.options.spaceAroundPipe && !node.getText().startsWith((CharSequence)" ")) {
            markdown.append(' ');
        }
        context.renderChildren((Node)node);
        if (!this.isSeparator && this.options.spaceAroundPipe && !node.getText().endsWith((CharSequence)" ")) {
            markdown.append(' ');
        }
        if (node.getNext() == null) {
            if (this.options.leadTrailPipes && node.getClosingMarker().isEmpty()) {
                markdown.append('|');
            } else {
                markdown.append((CharSequence)node.getClosingMarker());
            }
        } else {
            markdown.append((CharSequence)node.getClosingMarker());
        }
    }

    public static class Factory
    implements NodeFormatterFactory {
        public NodeFormatter create(DataHolder options) {
            return new TableNodeFormatter(options);
        }
    }
}

