/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.tables.internal;

import com.vladsch.flexmark.ast.Block;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.NodeIterator;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ext.tables.TableBlock;
import com.vladsch.flexmark.ext.tables.TableBody;
import com.vladsch.flexmark.ext.tables.TableCaption;
import com.vladsch.flexmark.ext.tables.TableCell;
import com.vladsch.flexmark.ext.tables.TableHead;
import com.vladsch.flexmark.ext.tables.TableRow;
import com.vladsch.flexmark.ext.tables.TableSeparator;
import com.vladsch.flexmark.ext.tables.internal.TableColumnSeparator;
import com.vladsch.flexmark.ext.tables.internal.TableParserOptions;
import com.vladsch.flexmark.internal.ReferencePreProcessorFactory;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.block.CharacterNodeFactory;
import com.vladsch.flexmark.parser.block.ParagraphPreProcessor;
import com.vladsch.flexmark.parser.block.ParagraphPreProcessorFactory;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class TableParagraphPreProcessor
implements ParagraphPreProcessor {
    private static String COL = "(?:\\s*-{3,}\\s*|\\s*:-{2,}\\s*|\\s*-{2,}:\\s*|\\s*:-+:\\s*)";
    private static Pattern TABLE_HEADER_SEPARATOR = Pattern.compile("\\|" + COL + "\\|?\\s*|" + COL + "\\|\\s*|\\|?(?:" + COL + "\\|)+" + COL + "\\|?\\s*");
    private static BitSet pipeCharacters = new BitSet(1);
    private static BitSet separatorCharacters = new BitSet(3);
    private static HashMap<Character, CharacterNodeFactory> pipeNodeMap;
    private final TableParserOptions options;

    public static ParagraphPreProcessorFactory Factory() {
        return new ParagraphPreProcessorFactory(){

            public boolean affectsGlobalScope() {
                return false;
            }

            public Set<Class<? extends ParagraphPreProcessorFactory>> getAfterDependents() {
                HashSet<Class<? extends ParagraphPreProcessorFactory>> set = new HashSet<Class<? extends ParagraphPreProcessorFactory>>();
                set.add(ReferencePreProcessorFactory.class);
                return set;
            }

            public Set<Class<? extends ParagraphPreProcessorFactory>> getBeforeDependents() {
                return null;
            }

            public ParagraphPreProcessor create(ParserState state) {
                return new TableParagraphPreProcessor((DataHolder)state.getProperties());
            }
        };
    }

    private TableParagraphPreProcessor(DataHolder options) {
        this.options = new TableParserOptions(options);
    }

    private TableParagraphPreProcessor(TableParserOptions options) {
        this.options = options;
    }

    /*
     * WARNING - void declaration
     */
    public int preProcessBlock(Paragraph block, ParserState state) {
        void var11_14;
        InlineParser inlineParser = state.getInlineParser();
        ArrayList<Object> tableLines = new ArrayList<Object>();
        int separatorLineNumber = -1;
        Object separatorLine = null;
        int blockIndent = block.getLineIndent(0);
        BasedSequence captionLine = null;
        for (Object rowLine : block.getContentLines()) {
            BasedSequence fullRowLine;
            int n = tableLines.size();
            if (separatorLineNumber == -1 && n > this.options.maxHeaderRows) {
                return 0;
            }
            if (rowLine.indexOf('|') < 0) {
                BasedSequence trimmed;
                if (separatorLineNumber == -1) {
                    return 0;
                }
                if (!this.options.withCaption || !(trimmed = rowLine.trim()).startsWith((CharSequence)"[") || !trimmed.endsWith((CharSequence)"]")) break;
                captionLine = trimmed;
                break;
            }
            BasedSequence basedSequence = fullRowLine = block.getLineIndent(n) <= blockIndent ? rowLine.trimEOL() : rowLine.baseSubSequence(rowLine.getStartOffset() - (block.getLineIndent(n) - blockIndent), rowLine.getEndOffset() - rowLine.eolLength());
            if (separatorLineNumber == -1 && n >= this.options.minHeaderRows && (fullRowLine.charAt(0) != ' ' && fullRowLine.charAt(0) != '\t' || rowLine.charAt(0) != '|') && TABLE_HEADER_SEPARATOR.matcher((CharSequence)rowLine).matches()) {
                separatorLineNumber = n;
                separatorLine = rowLine;
            }
            tableLines.add(rowLine);
        }
        if (separatorLineNumber == -1) {
            return 0;
        }
        ArrayList<TableRow> tableRows = new ArrayList<TableRow>();
        for (BasedSequence basedSequence : tableLines) {
            int tableRowNumber;
            List sepList;
            int rowNumber = tableRows.size();
            BasedSequence fullRowLine = block.getLineIndent(rowNumber) <= blockIndent ? basedSequence.trimEOL() : basedSequence.baseSubSequence(basedSequence.getStartOffset() - (block.getLineIndent(rowNumber) - blockIndent), basedSequence.getEndOffset() - basedSequence.eolLength());
            TableRow tableRow = new TableRow(fullRowLine);
            if (rowNumber == separatorLineNumber) {
                sepList = inlineParser.parseCustom(fullRowLine, (Node)tableRow, separatorCharacters, pipeNodeMap);
                tableRowNumber = 0;
            } else {
                sepList = inlineParser.parseCustom(fullRowLine, (Node)tableRow, pipeCharacters, pipeNodeMap);
                tableRowNumber = rowNumber < separatorLineNumber ? rowNumber + 1 : rowNumber - separatorLineNumber;
            }
            if (sepList == null) {
                if (rowNumber > separatorLineNumber) break;
                return 0;
            }
            tableRow.setRowNumber(tableRowNumber);
            tableRows.add(tableRow);
        }
        TableBlock tableBlock = new TableBlock(tableLines.subList(0, tableRows.size()));
        TableHead tableHead = new TableHead();
        tableBlock.appendChild((Node)tableHead);
        List<TableCell.Alignment> alignments = TableParagraphPreProcessor.parseAlignment(separatorLine);
        int rowNumber = 0;
        int separatorColumns = alignments.size();
        for (TableRow tableRow : tableRows) {
            TableCell tableCell;
            if (rowNumber == separatorLineNumber) {
                var11_14.setCharsFromContent();
                TableSeparator tableSeparator = new TableSeparator();
                tableBlock.appendChild((Node)tableSeparator);
            } else if (rowNumber == separatorLineNumber + 1) {
                var11_14.setCharsFromContent();
                TableBody tableBody = new TableBody();
                tableBlock.appendChild((Node)tableBody);
            }
            boolean firstCell = true;
            int cellCount = 0;
            NodeIterator nodes = new NodeIterator(tableRow.getFirstChild());
            TableRow newTableRow = new TableRow(tableRow.getChars());
            newTableRow.setRowNumber(tableRow.getRowNumber());
            int accumulatedSpanOffset = 0;
            while (nodes.hasNext()) {
                if (cellCount >= separatorColumns && this.options.discardExtraColumns) {
                    if (!this.options.headerSeparatorColumnMatch || rowNumber >= separatorLineNumber) break;
                    return 0;
                }
                tableCell = new TableCell();
                if (firstCell && nodes.peek() instanceof TableColumnSeparator) {
                    Node columnSep = nodes.next();
                    tableCell.setOpeningMarker(columnSep.getChars());
                    columnSep.unlink();
                    firstCell = false;
                }
                TableCell.Alignment alignment = cellCount + accumulatedSpanOffset < separatorColumns ? alignments.get(cellCount + accumulatedSpanOffset) : null;
                tableCell.setHeader(rowNumber < separatorLineNumber);
                tableCell.setAlignment(alignment);
                while (nodes.hasNext() && !(nodes.peek() instanceof TableColumnSeparator)) {
                    tableCell.appendChild(nodes.next());
                }
                BasedSequence closingMarker = null;
                int span = 1;
                while (nodes.hasNext() && nodes.peek() instanceof TableColumnSeparator) {
                    if (closingMarker == null) {
                        closingMarker = nodes.next().getChars();
                        if (this.options.columnSpans) continue;
                        break;
                    }
                    BasedSequence nextSep = nodes.peek().getChars();
                    if (!closingMarker.isContinuedBy(nextSep)) break;
                    closingMarker = closingMarker.spliceAtEnd(nextSep);
                    nodes.next().unlink();
                    ++span;
                }
                accumulatedSpanOffset += span - 1;
                if (closingMarker != null) {
                    tableCell.setClosingMarker(closingMarker);
                }
                tableCell.setChars(tableCell.getChildChars());
                if (this.options.trimCellWhitespace) {
                    tableCell.trimWhiteSpace();
                } else {
                    tableCell.mergeWhiteSpace();
                }
                tableCell.setText(tableCell.getChildChars());
                tableCell.setCharsFromContent();
                tableCell.setSpan(span);
                newTableRow.appendChild((Node)tableCell);
                ++cellCount;
            }
            if (this.options.headerSeparatorColumnMatch && rowNumber < separatorLineNumber && cellCount < separatorColumns) {
                return 0;
            }
            while (this.options.appendMissingColumns && cellCount < separatorColumns) {
                tableCell = new TableCell();
                tableCell.setHeader(rowNumber < separatorLineNumber);
                tableCell.setAlignment(alignments.get(cellCount));
                newTableRow.appendChild((Node)tableCell);
                ++cellCount;
            }
            newTableRow.setCharsFromContent();
            var11_14.appendChild((Node)newTableRow);
            ++rowNumber;
        }
        var11_14.setCharsFromContent();
        if (var11_14 instanceof TableSeparator) {
            TableBody tableBody = new TableBody();
            tableBlock.appendChild((Node)tableBody);
        }
        if (captionLine != null) {
            TableCaption caption = new TableCaption(captionLine.subSequence(0, 1), captionLine.subSequence(1, captionLine.length() - 1), captionLine.subSequence(captionLine.length() - 1));
            inlineParser.parse(caption.getText(), (Node)caption);
            caption.setCharsFromContent();
            tableBlock.appendChild((Node)caption);
        }
        tableBlock.setCharsFromContent();
        block.insertBefore((Node)tableBlock);
        state.blockAdded((Block)tableBlock);
        return tableBlock.getChars().length();
    }

    private static List<TableCell.Alignment> parseAlignment(BasedSequence separatorLine) {
        List<BasedSequence> parts = TableParagraphPreProcessor.split(separatorLine, false, false);
        ArrayList<TableCell.Alignment> alignments = new ArrayList<TableCell.Alignment>();
        for (BasedSequence part : parts) {
            BasedSequence trimmed = part.trim();
            boolean left = trimmed.startsWith((CharSequence)":");
            boolean right = trimmed.endsWith((CharSequence)":");
            TableCell.Alignment alignment = TableParagraphPreProcessor.getAlignment(left, right);
            alignments.add(alignment);
        }
        return alignments;
    }

    private static List<BasedSequence> split(BasedSequence input, boolean columnSpans, boolean wantPipes) {
        BasedSequence line = input.trim();
        int lineLength = line.length();
        ArrayList<BasedSequence> segments = new ArrayList<BasedSequence>();
        if (line.startsWith((CharSequence)"|")) {
            if (wantPipes) {
                segments.add(line.subSequence(0, 1));
            }
            line = line.subSequence(1, lineLength);
            --lineLength;
        }
        boolean escape = false;
        int lastPos = 0;
        int cellChars = 0;
        block4: for (int i = 0; i < lineLength; ++i) {
            char c = line.charAt(i);
            if (escape) {
                escape = false;
                ++cellChars;
                continue;
            }
            switch (c) {
                case '\\': {
                    escape = true;
                    ++cellChars;
                    continue block4;
                }
                case '|': {
                    if (!columnSpans || lastPos < i) {
                        segments.add(line.subSequence(lastPos, i));
                    }
                    if (wantPipes) {
                        segments.add(line.subSequence(i, i + 1));
                    }
                    lastPos = i + 1;
                    cellChars = 0;
                    continue block4;
                }
                default: {
                    ++cellChars;
                }
            }
        }
        if (cellChars > 0) {
            segments.add(line.subSequence(lastPos, lineLength));
        }
        return segments;
    }

    private static TableCell.Alignment getAlignment(boolean left, boolean right) {
        if (left && right) {
            return TableCell.Alignment.CENTER;
        }
        if (left) {
            return TableCell.Alignment.LEFT;
        }
        if (right) {
            return TableCell.Alignment.RIGHT;
        }
        return null;
    }

    static {
        pipeCharacters.set(124);
        separatorCharacters.set(124);
        separatorCharacters.set(58);
        separatorCharacters.set(45);
        pipeNodeMap = new HashMap();
        pipeNodeMap.put(Character.valueOf('|'), new CharacterNodeFactory(){

            public boolean skipNext(char c) {
                return c == ' ' || c == '\t';
            }

            public boolean skipPrev(char c) {
                return c == ' ' || c == '\t';
            }

            public boolean wantSkippedWhitespace() {
                return true;
            }

            public Node create() {
                return new TableColumnSeparator();
            }
        });
    }
}

