/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.spec.example.internal;

import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.spec.example.SpecExampleAst;
import com.vladsch.flexmark.ext.spec.example.SpecExampleBlock;
import com.vladsch.flexmark.ext.spec.example.SpecExampleHtml;
import com.vladsch.flexmark.ext.spec.example.SpecExampleOption;
import com.vladsch.flexmark.ext.spec.example.SpecExampleOptionSeparator;
import com.vladsch.flexmark.ext.spec.example.SpecExampleOptionsList;
import com.vladsch.flexmark.ext.spec.example.SpecExampleSeparator;
import com.vladsch.flexmark.ext.spec.example.SpecExampleSource;
import com.vladsch.flexmark.ext.spec.example.internal.SpecExampleOptions;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.DelimitedBuilder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SpecExampleNodeRenderer
implements NodeRenderer {
    private static String fromChars = " +/<>";
    private static String toChars = "-----";
    private final SpecExampleOptions options;

    public SpecExampleNodeRenderer(DataHolder options) {
        this.options = new SpecExampleOptions(options);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        return new HashSet(Arrays.asList(new NodeRenderingHandler(SpecExampleBlock.class, (CustomNodeRenderer)new CustomNodeRenderer<SpecExampleBlock>(){

            public void render(SpecExampleBlock node, NodeRendererContext context, HtmlWriter html) {
                SpecExampleNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(SpecExampleOptionsList.class, (CustomNodeRenderer)new CustomNodeRenderer<SpecExampleOptionsList>(){

            public void render(SpecExampleOptionsList node, NodeRendererContext context, HtmlWriter html) {
                SpecExampleNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(SpecExampleOption.class, (CustomNodeRenderer)new CustomNodeRenderer<SpecExampleOption>(){

            public void render(SpecExampleOption node, NodeRendererContext context, HtmlWriter html) {
                SpecExampleNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(SpecExampleOptionSeparator.class, (CustomNodeRenderer)new CustomNodeRenderer<SpecExampleOptionSeparator>(){

            public void render(SpecExampleOptionSeparator node, NodeRendererContext context, HtmlWriter html) {
                SpecExampleNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(SpecExampleSeparator.class, (CustomNodeRenderer)new CustomNodeRenderer<SpecExampleSeparator>(){

            public void render(SpecExampleSeparator node, NodeRendererContext context, HtmlWriter html) {
                SpecExampleNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(SpecExampleSource.class, (CustomNodeRenderer)new CustomNodeRenderer<SpecExampleSource>(){

            public void render(SpecExampleSource node, NodeRendererContext context, HtmlWriter html) {
                SpecExampleNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(SpecExampleHtml.class, (CustomNodeRenderer)new CustomNodeRenderer<SpecExampleHtml>(){

            public void render(SpecExampleHtml node, NodeRendererContext context, HtmlWriter html) {
                SpecExampleNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(SpecExampleAst.class, (CustomNodeRenderer)new CustomNodeRenderer<SpecExampleAst>(){

            public void render(SpecExampleAst node, NodeRendererContext context, HtmlWriter html) {
                SpecExampleNodeRenderer.this.render(node, context, html);
            }
        })));
    }

    private void render(SpecExampleOptionsList node, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(SpecExampleOption node, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(SpecExampleOptionSeparator node, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(SpecExampleSeparator node, NodeRendererContext context, HtmlWriter html) {
        switch (this.options.renderAs) {
            case DEFINITION_LIST: {
                break;
            }
            case SECTIONS: {
                break;
            }
        }
    }

    private void render(SpecExampleSource node, NodeRendererContext context, HtmlWriter html) {
        BasedSequence text = node.getChars();
        switch (this.options.renderAs) {
            case DEFINITION_LIST: {
                html.tag("dt").text("Source").tag("/dt").line();
                html.tag("dd");
                this.render(text, "markdown", context, html);
                html.tag("/dd").line();
                break;
            }
            case SECTIONS: {
                if (text.isEmpty()) break;
                html.tagVoidLine("hr");
                this.render(text, "markdown", context, html);
                break;
            }
        }
    }

    private void render(SpecExampleHtml node, NodeRendererContext context, HtmlWriter html) {
        BasedSequence text = node.getChars();
        switch (this.options.renderAs) {
            case DEFINITION_LIST: {
                html.tag("dt").text("Html").tag("/dt").line();
                html.tag("dd");
                this.render(text, "html", context, html);
                html.tag("/dd").line();
                if (!this.options.renderHtml) break;
                html.tag("dt").text("Rendered Html").tag("/dt").line();
                html.tag("dd");
                html.raw(this.options.renderedHtmlPrefix).raw(text.normalizeEOL()).raw(this.options.renderedHtmlSuffix).line();
                html.tag("/dd").line();
                break;
            }
            case SECTIONS: {
                if (text.isEmpty()) break;
                html.tagVoidLine("hr");
                this.render(text, "html", context, html);
                if (!this.options.renderHtml) break;
                html.tagVoidLine("hr");
                html.raw(this.options.renderedHtmlPrefix).raw(text.normalizeEOL()).raw(this.options.renderedHtmlSuffix).line();
                break;
            }
        }
    }

    private void render(SpecExampleAst node, NodeRendererContext context, HtmlWriter html) {
        BasedSequence text = node.getChars();
        switch (this.options.renderAs) {
            case DEFINITION_LIST: {
                html.tag("dt").text("AST").tag("/dt").line();
                html.tag("dd");
                this.render(text, "text", context, html);
                html.tag("/dd").line();
                break;
            }
            case SECTIONS: {
                if (text.isEmpty()) break;
                html.tagVoidLine("hr");
                this.render(text, "text", context, html);
                break;
            }
        }
    }

    private void render(SpecExampleBlock node, NodeRendererContext context, HtmlWriter html) {
        switch (this.options.renderAs) {
            case DEFINITION_LIST: {
                html.tagVoidLine("hr");
                html.tag("dl").indent();
                html.tag("dt").text("example");
                if (node.getSection().isNotNull() || node.getNumberSeparator().isNotNull() || node.getNumber().isNotNull()) {
                    html.text(" ").text(node.getSection().toString()).text(": ").text(node.getNumber().toString());
                }
                if (node.getOptionsKeyword().isNotNull() || node.getOptionsOpeningMarker().isNotNull() || node.getOptions().isNotNull() || node.getOptionsClosingMarker().isNotNull()) {
                    String optionsText = "";
                    BasedSequence trimmed = node.getOptions().trim((CharSequence)" \t\r\n\u00a0");
                    if (!trimmed.isEmpty()) {
                        List optionsList = trimmed.split(',', 0, 6);
                        DelimitedBuilder out = new DelimitedBuilder(", ");
                        optionsText = out.appendAll(optionsList).getAndClear();
                    }
                    html.text(" options(").text(optionsText).text(")");
                }
                html.tag("/dt").line();
                context.renderChildren((Node)node);
                html.unIndent().tag("/dl").line();
                break;
            }
            case SECTIONS: {
                html.tagVoidLine("hr");
                if (node.getSection().isNotNull() || node.getNumberSeparator().isNotNull() || node.getNumber().isNotNull()) {
                    html.tag("h5").text(node.getSection().toString()).text(": ").text(node.getNumber().toString()).tag("/h5").line();
                }
                context.renderChildren((Node)node);
                break;
            }
            default: {
                this.render(node.getContentChars(), "text", context, html);
            }
        }
    }

    private void render(BasedSequence contentChars, String language, NodeRendererContext context, HtmlWriter html) {
        String text = contentChars.normalizeEOL();
        if (!text.isEmpty()) {
            if (!language.isEmpty()) {
                html.attr("class", context.getHtmlOptions().languageClassPrefix + language);
            }
            html.line();
            html.tag("pre").openPre();
            html.srcPos(contentChars).withAttr().tag("code");
            html.text(text);
            html.tag("/code");
            html.tag("/pre").closePre();
            html.line();
        }
    }
}

