/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.spec.example.internal;

import com.vladsch.flexmark.ext.spec.example.SpecExampleAst;
import com.vladsch.flexmark.ext.spec.example.SpecExampleBlock;
import com.vladsch.flexmark.ext.spec.example.SpecExampleHtml;
import com.vladsch.flexmark.ext.spec.example.SpecExampleOption;
import com.vladsch.flexmark.ext.spec.example.SpecExampleOptionSeparator;
import com.vladsch.flexmark.ext.spec.example.SpecExampleOptionsList;
import com.vladsch.flexmark.ext.spec.example.SpecExampleSeparator;
import com.vladsch.flexmark.ext.spec.example.SpecExampleSource;
import com.vladsch.flexmark.ext.spec.example.internal.SpecExampleOptions;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.parser.core.BlockQuoteParser;
import com.vladsch.flexmark.parser.core.FencedCodeBlockParser;
import com.vladsch.flexmark.parser.core.HeadingParser;
import com.vladsch.flexmark.parser.core.HtmlBlockParser;
import com.vladsch.flexmark.parser.core.IndentedCodeBlockParser;
import com.vladsch.flexmark.parser.core.ListBlockParser;
import com.vladsch.flexmark.parser.core.ThematicBreakParser;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.BlockContent;
import com.vladsch.flexmark.util.ast.CustomNode;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SpecExampleBlockParser
extends AbstractBlockParser {
    private static final Pattern OPTIONS_PATTERN = Pattern.compile("^\\s*(\\()?([^:()]*)(?:(:)\\s*([^\\s()]+)\\s*?)?(\\))?(?:\\s+(options)\\s*(\\()?([^()\\n\\r]*)(\\))?)?\\s*$".replace("options", "options"));
    private static final int GROUP_COORD_OPEN = 1;
    private static final int GROUP_SECTION = 2;
    private static final int GROUP_NUMBER_SEPARATOR = 3;
    private static final int GROUP_NUMBER = 4;
    private static final int GROUP_COORD_CLOSE = 5;
    private static final int GROUP_OPTION_KEYWORD = 6;
    private static final int GROUP_OPTIONS_OPEN = 7;
    private static final int GROUP_OPTIONS = 8;
    private static final int GROUP_OPTIONS_CLOSE = 9;
    private final SpecExampleBlock block = new SpecExampleBlock();
    private BlockContent content = new BlockContent();
    private final SpecExampleOptions myOptions;

    public SpecExampleBlockParser(DataHolder options) {
        this.myOptions = new SpecExampleOptions(options);
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockContinue tryContinue(ParserState state) {
        BasedSequence line = state.getLine();
        if (line.startsWith((CharSequence)this.myOptions.exampleBreak)) {
            this.block.setClosingMarker(line.subSequence(0, this.myOptions.exampleBreak.length()));
            return BlockContinue.finished();
        }
        return BlockContinue.atIndex((int)0);
    }

    public void addLine(ParserState state, BasedSequence line) {
        this.content.add(line, state.getIndent());
    }

    public boolean isPropagatingLastBlankLine(BlockParser lastMatchedBlockParser) {
        return false;
    }

    public void closeBlock(ParserState state) {
        List lines = this.content.getLines();
        if (lines.size() > 0) {
            BasedSequence info = (BasedSequence)lines.get(0);
            int exampleKeyWordStart = this.myOptions.exampleBreak.length() + 1;
            int exampleKeyWordEnd = exampleKeyWordStart + "example".length();
            BasedSequence exampleKeyword = info.subSequence(exampleKeyWordStart, exampleKeyWordEnd);
            BasedSequence optionsChars = info.subSequence(exampleKeyWordEnd);
            Matcher options = OPTIONS_PATTERN.matcher(optionsChars.toString().replace('\u00a0', ' '));
            this.block.setOpeningMarker(info.subSequence(0, this.myOptions.exampleBreak.length()));
            this.block.setExampleKeyword(exampleKeyword);
            if (options.matches()) {
                BasedSequence coordOpeningMarker = BasedSequence.NULL;
                BasedSequence section = BasedSequence.NULL;
                BasedSequence numberSeparator = BasedSequence.NULL;
                BasedSequence number = BasedSequence.NULL;
                BasedSequence coordClosingMarker = BasedSequence.NULL;
                BasedSequence optionsKeyword = BasedSequence.NULL;
                BasedSequence optionsOpeningMarker = BasedSequence.NULL;
                BasedSequence optionsText = BasedSequence.NULL;
                BasedSequence optionsClosingMarker = BasedSequence.NULL;
                if (options.group(1) != null && !options.group(1).trim().isEmpty()) {
                    coordOpeningMarker = optionsChars.subSequence(options.start(1), options.end(1)).trim((CharSequence)" \t\r\n\u00a0");
                }
                if (options.group(2) != null && !options.group(2).trim().isEmpty()) {
                    section = optionsChars.subSequence(options.start(2), options.end(2)).trim((CharSequence)" \t\r\n\u00a0");
                }
                if (options.group(3) != null && !options.group(3).trim().isEmpty()) {
                    numberSeparator = optionsChars.subSequence(options.start(3), options.end(3)).trim((CharSequence)" \t\r\n\u00a0");
                }
                if (options.group(4) != null && !options.group(4).trim().isEmpty()) {
                    number = optionsChars.subSequence(options.start(4), options.end(4)).trim((CharSequence)" \t\r\n\u00a0");
                }
                if (options.group(5) != null && !options.group(5).trim().isEmpty()) {
                    coordClosingMarker = optionsChars.subSequence(options.start(5), options.end(5)).trim((CharSequence)" \t\r\n\u00a0");
                }
                if (options.group(6) != null && !options.group(6).trim().isEmpty()) {
                    optionsKeyword = optionsChars.subSequence(options.start(6), options.end(6)).trim((CharSequence)" \t\r\n\u00a0");
                }
                if (options.group(7) != null && !options.group(7).trim().isEmpty()) {
                    optionsOpeningMarker = optionsChars.subSequence(options.start(7), options.end(7)).trim((CharSequence)" \t\r\n\u00a0");
                }
                if (options.group(8) != null) {
                    optionsText = optionsChars.subSequence(options.start(8), options.end(8));
                }
                if (options.group(9) != null && !options.group(9).trim().isEmpty()) {
                    optionsClosingMarker = optionsChars.subSequence(options.start(9), options.end(9)).trim((CharSequence)" \t\r\n\u00a0");
                }
                if (section.isNotNull() && optionsKeyword.isNull() && numberSeparator.isNull() && coordOpeningMarker.isNull() && section.matchChars((CharSequence)"options")) {
                    int pos = section.indexOfAny(' ', '\t', '\u00a0');
                    if (pos < 0) {
                        optionsKeyword = section;
                    } else {
                        optionsKeyword = section.subSequence(0, pos);
                        optionsText = section.subSequence(pos + 1);
                    }
                    optionsClosingMarker = coordClosingMarker;
                    section = BasedSequence.NULL;
                    coordClosingMarker = BasedSequence.NULL;
                }
                if (optionsText.isNull()) {
                    if (optionsClosingMarker.isNotNull()) {
                        optionsText = optionsClosingMarker.subSequence(0, 0);
                    } else if (optionsOpeningMarker.isNotNull()) {
                        optionsText = optionsOpeningMarker.subSequence(1, 1);
                    } else if (optionsKeyword.isNotNull()) {
                        optionsText = optionsKeyword.subSequence(optionsKeyword.length(), optionsKeyword.length());
                    }
                }
                this.block.setCoordOpeningMarker(coordOpeningMarker);
                this.block.setSection(section);
                this.block.setNumberSeparator(numberSeparator);
                this.block.setNumber(number);
                this.block.setCoordClosingMarker(coordClosingMarker);
                this.block.setOptionsKeyword(optionsKeyword);
                this.block.setOptionsOpeningMarker(optionsOpeningMarker);
                this.block.setOptions(optionsText);
                this.block.setOptionsClosingMarker(optionsClosingMarker);
            }
            if (this.myOptions.optionNodes && this.block.getOptionsKeyword().isNotNull()) {
                SpecExampleOptionsList optionsList = new SpecExampleOptionsList(this.block.getOptions());
                this.block.appendChild((Node)optionsList);
                BasedSequence trimmedOptionsList = this.block.getOptions().trim((CharSequence)" \t\r\n\u00a0");
                if (!trimmedOptionsList.isEmpty()) {
                    BasedSequence list;
                    for (BasedSequence item : list = trimmedOptionsList.split(',', 0, 8)) {
                        CustomNode optionNode;
                        BasedSequence option = item.trim((CharSequence)" \t\r\n\u00a0");
                        if (option.isEmpty()) continue;
                        if (option.matches((CharSequence)",")) {
                            optionNode = new SpecExampleOptionSeparator(option);
                            optionsList.appendChild((Node)optionNode);
                            continue;
                        }
                        optionNode = new SpecExampleOption(option);
                        optionsList.appendChild((Node)optionNode);
                    }
                }
            }
            BasedSequence chars = this.content.getSpanningChars();
            BasedSequence spanningChars = chars.baseSubSequence(chars.getStartOffset(), ((BasedSequence)lines.get(0)).getEndOffset());
            if (lines.size() > 1) {
                CustomNode node;
                this.block.setContent(spanningChars, lines.subList(1, lines.size()));
                boolean inSource = true;
                boolean inHtml = false;
                boolean inAst = false;
                int sectionStart = -1;
                BasedSequence prevLine = BasedSequence.NULL;
                BasedSequence lastLine = (BasedSequence)lines.get(lines.size() - 1);
                String typeBreak = this.myOptions.typeBreak;
                int typeBreakLength = typeBreak.length();
                for (BasedSequence line : lines.subList(1, lines.size())) {
                    if (line.length() == typeBreakLength + line.countTrailing((CharSequence)"\r\n") && line.matchChars((CharSequence)typeBreak)) {
                        if (inSource) {
                            inSource = false;
                            if (sectionStart != -1) {
                                this.block.setSource(line.baseSubSequence(sectionStart, line.getStartOffset() - prevLine.countTrailing((CharSequence)"\r\n")));
                            } else {
                                this.block.setSource(line.subSequence(0, 0));
                            }
                            this.block.setHtmlSeparator(line);
                            inHtml = true;
                            sectionStart = -1;
                        } else if (inHtml) {
                            inHtml = false;
                            if (sectionStart != -1) {
                                this.block.setHtml(line.baseSubSequence(sectionStart, line.getStartOffset() - prevLine.countTrailing((CharSequence)"\r\n")));
                            } else {
                                this.block.setHtml(line.subSequence(0, 0));
                            }
                            this.block.setAstSeparator(line);
                            inAst = true;
                            sectionStart = -1;
                        } else if (sectionStart == -1) {
                            sectionStart = line.getStartOffset();
                        }
                    } else if (sectionStart == -1) {
                        sectionStart = line.getStartOffset();
                    }
                    prevLine = line;
                    if (line != lastLine) continue;
                    if (inSource) {
                        if (sectionStart != -1) {
                            this.block.setSource(line.baseSubSequence(sectionStart, line.getEndOffset() - prevLine.countTrailing((CharSequence)"\r\n")));
                            break;
                        }
                        this.block.setSource(line.subSequence(line.length(), line.length()));
                        break;
                    }
                    if (inHtml) {
                        if (sectionStart != -1) {
                            this.block.setHtml(line.baseSubSequence(sectionStart, line.getEndOffset() - prevLine.countTrailing((CharSequence)"\r\n")));
                            break;
                        }
                        this.block.setHtml(line.subSequence(line.length(), line.length()));
                        break;
                    }
                    if (!inAst) break;
                    if (sectionStart != -1) {
                        this.block.setAst(line.baseSubSequence(sectionStart, line.getEndOffset() - prevLine.countTrailing((CharSequence)"\r\n")));
                        break;
                    }
                    this.block.setAst(line.subSequence(line.length(), line.length()));
                    break;
                }
                if (this.block.getSource().isNotNull()) {
                    node = new SpecExampleSource(this.block.getSource());
                    this.block.appendChild((Node)node);
                }
                if (this.block.getHtmlSeparator().isNotNull()) {
                    node = new SpecExampleSeparator(this.block.getHtmlSeparator());
                    this.block.appendChild((Node)node);
                    if (this.block.getHtml().isNotNull()) {
                        node = new SpecExampleHtml(this.block.getHtml());
                        this.block.appendChild((Node)node);
                    }
                    if (this.block.getAstSeparator().isNotNull()) {
                        node = new SpecExampleSeparator(this.block.getAstSeparator());
                        this.block.appendChild((Node)node);
                        if (this.block.getAst().isNotNull()) {
                            node = new SpecExampleAst(this.block.getAst());
                            this.block.appendChild((Node)node);
                        }
                    }
                }
            } else {
                SpecExampleSource node = new SpecExampleSource(this.block.getClosingMarker().subSequence(0, 0));
                this.block.appendChild((Node)node);
                this.block.setContent(spanningChars, BasedSequence.EMPTY_LIST);
            }
        } else {
            SpecExampleSource node = new SpecExampleSource(this.block.getClosingMarker().subSequence(0, 0));
            this.block.appendChild((Node)node);
            this.block.setContent(this.content);
        }
        this.block.setCharsFromContent();
        this.content = null;
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private final SpecExampleOptions myOptions;

        private BlockFactory(DataHolder options) {
            super(options);
            this.myOptions = new SpecExampleOptions(options);
        }

        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            BasedSequence line = state.getLine();
            if (state.getIndex() == 0) {
                int breakLength = this.myOptions.exampleBreak.length();
                if (line.length() >= breakLength + 1 + "example".length() && line.startsWith((CharSequence)this.myOptions.exampleBreak) && line.matchChars((CharSequence)"example", breakLength + 1) && " \t\u00a0".contains(String.valueOf(line.charAt(breakLength)))) {
                    SpecExampleBlockParser blockParser = new SpecExampleBlockParser((DataHolder)state.getProperties());
                    blockParser.block.setOpeningMarker(line.subSequence(0, breakLength));
                    return BlockStart.of((BlockParser[])new BlockParser[]{blockParser}).atIndex(-1);
                }
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        public Set<Class<? extends CustomBlockParserFactory>> getAfterDependents() {
            return new HashSet<Class<? extends CustomBlockParserFactory>>(Arrays.asList(BlockQuoteParser.Factory.class, HeadingParser.Factory.class));
        }

        public Set<Class<? extends CustomBlockParserFactory>> getBeforeDependents() {
            return new HashSet<Class<? extends CustomBlockParserFactory>>(Arrays.asList(FencedCodeBlockParser.Factory.class, HtmlBlockParser.Factory.class, ThematicBreakParser.Factory.class, ListBlockParser.Factory.class, IndentedCodeBlockParser.Factory.class));
        }

        public boolean affectsGlobalScope() {
            return false;
        }

        public BlockParserFactory create(DataHolder options) {
            return new BlockFactory(options);
        }
    }
}

