/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.macros.internal;

import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ext.macros.MacroDefinitionBlock;
import com.vladsch.flexmark.ext.macros.MacroReference;
import com.vladsch.flexmark.ext.macros.MacrosExtension;
import com.vladsch.flexmark.ext.macros.internal.MacroDefinitionRepository;
import com.vladsch.flexmark.ext.macros.internal.MacroFormatOptions;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.NodeFormatter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.NodeFormattingHandler;
import com.vladsch.flexmark.formatter.NodeRepositoryFormatter;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.format.options.ElementPlacement;
import com.vladsch.flexmark.util.format.options.ElementPlacementSort;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacrosNodeFormatter
extends NodeRepositoryFormatter<MacroDefinitionRepository, MacroDefinitionBlock, MacroReference> {
    public static final DataKey<Map<String, String>> MACROS_TRANSLATION_MAP = new DataKey("MACROS_TRANSLATION_MAP", new HashMap());
    public static final DataKey<Map<String, String>> MACROS_UNIQUIFICATION_MAP = new DataKey("MACROS_UNIQUIFICATION_MAP", new HashMap());
    private final MacroFormatOptions options;

    public MacrosNodeFormatter(DataHolder options) {
        super(options, MACROS_TRANSLATION_MAP, MACROS_UNIQUIFICATION_MAP);
        this.options = new MacroFormatOptions(options);
    }

    public MacroDefinitionRepository getRepository(DataHolder options) {
        return (MacroDefinitionRepository)((Object)MacrosExtension.MACRO_DEFINITIONS.get(options));
    }

    public ElementPlacement getReferencePlacement() {
        return this.options.macrosPlacement;
    }

    public ElementPlacementSort getReferenceSort() {
        return this.options.macrosSort;
    }

    public void renderReferenceBlock(MacroDefinitionBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        ((MarkdownWriter)((MarkdownWriter)((MarkdownWriter)markdown.blankLine()).append((CharSequence)">>>")).append((CharSequence)this.transformReferenceId(node.getName().toString(), context))).line();
        Node child = node.getFirstChild();
        if (child instanceof Paragraph && child == node.getLastChild()) {
            context.renderChildren(child);
        } else {
            context.renderChildren((Node)node);
        }
        ((MarkdownWriter)((MarkdownWriter)markdown.line()).append((CharSequence)"<<<")).blankLine();
    }

    @Nullable
    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler(MacroReference.class, this::render), new NodeFormattingHandler(MacroDefinitionBlock.class, this::render)));
    }

    @Nullable
    public Set<Class<?>> getNodeClasses() {
        if (this.options.macrosPlacement.isNoChange() || !this.options.macrosSort.isUnused()) {
            return null;
        }
        return new HashSet(Arrays.asList(MacroReference.class));
    }

    private void render(MacroDefinitionBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.renderReference((Node)node, context, markdown);
    }

    private void render(MacroReference node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.append((CharSequence)"<<<");
        if (context.isTransformingText()) {
            String referenceId = this.transformReferenceId(node.getText().toString(), context);
            context.nonTranslatingSpan((context1, markdown1) -> {
                MarkdownWriter cfr_ignored_0 = (MarkdownWriter)markdown1.append((CharSequence)referenceId);
            });
        } else {
            markdown.append((CharSequence)node.getText());
        }
        markdown.append((CharSequence)">>>");
    }

    public static class Factory
    implements NodeFormatterFactory {
        @NotNull
        public NodeFormatter create(@NotNull DataHolder options) {
            return new MacrosNodeFormatter(options);
        }
    }
}

