/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.macros.internal;

import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ext.macros.MacroDefinitionBlock;
import com.vladsch.flexmark.ext.macros.MacroReference;
import com.vladsch.flexmark.ext.macros.MacrosExtension;
import com.vladsch.flexmark.ext.macros.internal.MacroDefinitionRepository;
import com.vladsch.flexmark.ext.macros.internal.MacroFormatOptions;
import com.vladsch.flexmark.formatter.CustomNodeFormatter;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.NodeFormatter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.NodeFormattingHandler;
import com.vladsch.flexmark.formatter.NodeRepositoryFormatter;
import com.vladsch.flexmark.formatter.TranslatingSpanRender;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.format.options.ElementPlacement;
import com.vladsch.flexmark.util.format.options.ElementPlacementSort;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MacrosNodeFormatter
extends NodeRepositoryFormatter<MacroDefinitionRepository, MacroDefinitionBlock, MacroReference> {
    public static final DataKey<Map<String, String>> FOOTNOTE_TRANSLATION_MAP = new DataKey("FOOTNOTE_TRANSLATION_MAP", new HashMap());
    private final MacroFormatOptions options;

    public MacrosNodeFormatter(DataHolder options) {
        super(options, FOOTNOTE_TRANSLATION_MAP);
        this.options = new MacroFormatOptions(options);
    }

    public MacroDefinitionRepository getRepository(DataHolder options) {
        return (MacroDefinitionRepository)((Object)MacrosExtension.MACRO_DEFINITIONS.getFrom(options));
    }

    public ElementPlacement getReferencePlacement() {
        return this.options.macrosPlacement;
    }

    public ElementPlacementSort getReferenceSort() {
        return this.options.macrosSort;
    }

    public void renderReferenceBlock(MacroDefinitionBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.blankLine().append((CharSequence)">>>").append((CharSequence)this.transformReferenceId(node.getName().toString(), context)).line();
        Node child = node.getFirstChild();
        if (child instanceof Paragraph && child == node.getLastChild()) {
            context.renderChildren(child);
        } else {
            context.renderChildren((Node)node);
        }
        markdown.line().append((CharSequence)"<<<").blankLine();
    }

    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler(MacroReference.class, (CustomNodeFormatter)new CustomNodeFormatter<MacroReference>(){

            public void render(MacroReference node, NodeFormatterContext context, MarkdownWriter markdown) {
                MacrosNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(MacroDefinitionBlock.class, (CustomNodeFormatter)new CustomNodeFormatter<MacroDefinitionBlock>(){

            public void render(MacroDefinitionBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
                MacrosNodeFormatter.this.render(node, context, markdown);
            }
        })));
    }

    public Set<Class<?>> getNodeClasses() {
        if (this.options.macrosPlacement != ElementPlacement.AS_IS && this.options.macrosSort != ElementPlacementSort.SORT_UNUSED_LAST) {
            return null;
        }
        return new HashSet(Arrays.asList(MacroReference.class));
    }

    private void render(MacroDefinitionBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.renderReference((Node)node, context, markdown);
    }

    private void render(MacroReference node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.append((CharSequence)"<<<");
        if (context.isTransformingText()) {
            final String referenceId = this.transformReferenceId(node.getText().toString(), context);
            context.nonTranslatingSpan(new TranslatingSpanRender(){

                public void render(NodeFormatterContext context, MarkdownWriter markdown) {
                    markdown.append((CharSequence)referenceId);
                }
            });
        } else {
            markdown.append((CharSequence)node.getText());
        }
        markdown.append((CharSequence)">>>");
    }

    public static class Factory
    implements NodeFormatterFactory {
        public NodeFormatter create(DataHolder options) {
            return new MacrosNodeFormatter(options);
        }
    }
}

