/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gitlab.internal;

import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ext.gitlab.GitLabDel;
import com.vladsch.flexmark.ext.gitlab.GitLabInline;
import com.vladsch.flexmark.ext.gitlab.GitLabIns;
import com.vladsch.flexmark.ext.gitlab.internal.GitLabOptions;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.InlineParserExtension;
import com.vladsch.flexmark.parser.InlineParserExtensionFactory;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class GitLabInlineParser
implements InlineParserExtension {
    private final List<GitLabInline> openInlines = new ArrayList<GitLabInline>();
    private final GitLabOptions options;

    public GitLabInlineParser(InlineParser inlineParser) {
        this.options = new GitLabOptions((DataHolder)inlineParser.getDocument());
    }

    public void finalizeDocument(InlineParser inlineParser) {
    }

    public void finalizeBlock(InlineParser inlineParser) {
        int j = this.openInlines.size();
        while (j-- > 0) {
            GitLabInline gitLabInline = this.openInlines.get(j);
            Text textNode = new Text(gitLabInline.getChars());
            gitLabInline.insertBefore((Node)textNode);
            gitLabInline.unlink();
        }
        this.openInlines.clear();
    }

    public boolean parse(InlineParser inlineParser) {
        char firstChar = inlineParser.peek();
        char secondChar = inlineParser.peek(1);
        if ((firstChar == '{' || firstChar == '[') && (this.options.insParser && secondChar == '+' || this.options.delParser && secondChar == '-')) {
            BasedSequence input = (BasedSequence)inlineParser.getInput().subSequence(inlineParser.getIndex());
            GitLabInline open = secondChar == '+' ? new GitLabIns((BasedSequence)input.subSequence(0, 2)) : new GitLabDel((BasedSequence)input.subSequence(0, 2));
            inlineParser.flushTextNode();
            inlineParser.getBlock().appendChild((Node)open);
            this.openInlines.add(open);
            inlineParser.setIndex(inlineParser.getIndex() + 2);
            return true;
        }
        if ((this.options.insParser && firstChar == '+' || this.options.delParser && firstChar == '-') && (secondChar == ']' || secondChar == '}')) {
            BasedSequence input = (BasedSequence)inlineParser.getInput().subSequence(inlineParser.getIndex());
            BasedSequence matchOpen = BasedSequenceImpl.of((CharSequence)(secondChar == ']' ? (firstChar == '+' ? "[+" : "[-") : (firstChar == '+' ? "{+" : "{-")));
            int i = this.openInlines.size();
            while (i-- > 0) {
                GitLabInline open = this.openInlines.get(i);
                BasedSequence openMarker = open.getChars();
                if (!openMarker.equals(matchOpen)) continue;
                inlineParser.setIndex(inlineParser.getIndex() + 2);
                BasedSequence closingMarker = (BasedSequence)input.subSequence(0, 2);
                open.setOpeningMarker(openMarker);
                open.setClosingMarker(closingMarker);
                open.setText(openMarker.baseSubSequence(openMarker.getEndOffset(), closingMarker.getStartOffset()));
                inlineParser.flushTextNode();
                Node last = inlineParser.getBlock().getLastChild();
                inlineParser.moveNodes((Node)open, last);
                if (i == 0) {
                    this.openInlines.clear();
                } else {
                    this.openInlines.subList(i, this.openInlines.size()).clear();
                }
                return true;
            }
        }
        return false;
    }

    public static class Factory
    implements InlineParserExtensionFactory {
        public Set<Class<? extends InlineParserExtensionFactory>> getAfterDependents() {
            return null;
        }

        public CharSequence getCharacters() {
            return "{[-+";
        }

        public Set<Class<? extends InlineParserExtensionFactory>> getBeforeDependents() {
            return null;
        }

        public InlineParserExtension apply(InlineParser inlineParser) {
            return new GitLabInlineParser(inlineParser);
        }

        public boolean affectsGlobalScope() {
            return false;
        }
    }
}

