/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.footnotes.internal;

import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.footnotes.Footnote;
import com.vladsch.flexmark.ext.footnotes.FootnoteBlock;
import com.vladsch.flexmark.ext.footnotes.FootnoteExtension;
import com.vladsch.flexmark.ext.footnotes.internal.FootnoteRepository;
import com.vladsch.flexmark.parser.LinkRefProcessor;
import com.vladsch.flexmark.parser.LinkRefProcessorFactory;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public class FootnoteLinkRefProcessor
implements LinkRefProcessor {
    static final boolean WANT_EXCLAMATION_PREFIX = false;
    static final int BRACKET_NESTING_LEVEL = 0;
    private final FootnoteRepository footnoteRepository;

    public FootnoteLinkRefProcessor(Document document) {
        this.footnoteRepository = (FootnoteRepository)((Object)document.get(FootnoteExtension.FOOTNOTES));
    }

    public boolean getWantExclamationPrefix() {
        return false;
    }

    public int getBracketNestingLevel() {
        return 0;
    }

    public boolean isMatch(BasedSequence nodeChars) {
        return nodeChars.length() >= 3 && nodeChars.charAt(0) == '[' && nodeChars.charAt(1) == '^' && nodeChars.endCharAt(1) == ']';
    }

    public Node createNode(BasedSequence nodeChars) {
        BasedSequence footnoteId = nodeChars.midSequence(2, -1).trim();
        FootnoteBlock footnoteBlock = footnoteId.length() > 0 ? (FootnoteBlock)((Object)this.footnoteRepository.get(footnoteId.toString())) : null;
        Footnote footnote = new Footnote(nodeChars.subSequence(0, 2), footnoteId, nodeChars.endSequence(1));
        footnote.setFootnoteBlock(footnoteBlock);
        if (footnoteBlock != null) {
            this.footnoteRepository.addFootnoteReference(footnoteBlock, footnote);
        }
        return footnote;
    }

    public void adjustInlineText(Node node) {
        Node firstChild = node.getFirstChild();
        if (firstChild != null) {
            if (firstChild.getChars().length() == 1) {
                firstChild.unlink();
            } else {
                firstChild.setChars(firstChild.getChars().subSequence(1));
            }
        }
    }

    public static class Factory
    implements LinkRefProcessorFactory {
        public LinkRefProcessor create(Document document) {
            return new FootnoteLinkRefProcessor(document);
        }

        public boolean getWantExclamationPrefix(DataHolder options) {
            return false;
        }

        public int getBracketNestingLevel(DataHolder options) {
            return 0;
        }
    }
}

