/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.footnotes;

import com.vladsch.flexmark.ext.footnotes.internal.FootnoteBlockParser;
import com.vladsch.flexmark.ext.footnotes.internal.FootnoteLinkRefProcessor;
import com.vladsch.flexmark.ext.footnotes.internal.FootnoteNodeFormatter;
import com.vladsch.flexmark.ext.footnotes.internal.FootnoteNodeRenderer;
import com.vladsch.flexmark.ext.footnotes.internal.FootnoteRepository;
import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.parser.LinkRefProcessorFactory;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.util.ast.KeepType;
import com.vladsch.flexmark.util.ast.NodeRepository;
import com.vladsch.flexmark.util.builder.Extension;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.format.options.ElementPlacement;
import com.vladsch.flexmark.util.format.options.ElementPlacementSort;

public class FootnoteExtension
implements Parser.ParserExtension,
HtmlRenderer.HtmlRendererExtension,
Parser.ReferenceHoldingExtension,
Formatter.FormatterExtension {
    public static final DataKey<KeepType> FOOTNOTES_KEEP = new DataKey("FOOTNOTES_KEEP", (Object)KeepType.FIRST);
    public static final DataKey<FootnoteRepository> FOOTNOTES = new DataKey("FOOTNOTES", FootnoteRepository::new);
    public static final DataKey<String> FOOTNOTE_REF_PREFIX = new DataKey("FOOTNOTE_REF_PREFIX", (Object)"");
    public static final DataKey<String> FOOTNOTE_REF_SUFFIX = new DataKey("FOOTNOTE_REF_SUFFIX", (Object)"");
    public static final DataKey<String> FOOTNOTE_BACK_REF_STRING = new DataKey("FOOTNOTE_BACK_REF_STRING", (Object)"&#8617;");
    public static final DataKey<String> FOOTNOTE_LINK_REF_CLASS = new DataKey("FOOTNOTE_LINK_REF_CLASS", (Object)"footnote-ref");
    public static final DataKey<String> FOOTNOTE_BACK_LINK_REF_CLASS = new DataKey("FOOTNOTE_BACK_LINK_REF_CLASS", (Object)"footnote-backref");
    public static final DataKey<ElementPlacement> FOOTNOTE_PLACEMENT = new DataKey("FOOTNOTE_PLACEMENT", (Object)ElementPlacement.AS_IS);
    public static final DataKey<ElementPlacementSort> FOOTNOTE_SORT = new DataKey("FOOTNOTE_SORT", (Object)ElementPlacementSort.AS_IS);

    private FootnoteExtension() {
    }

    public static Extension create() {
        return new FootnoteExtension();
    }

    public void extend(Formatter.Builder builder) {
        builder.nodeFormatterFactory((NodeFormatterFactory)new FootnoteNodeFormatter.Factory());
    }

    public void rendererOptions(MutableDataHolder options) {
    }

    public void parserOptions(MutableDataHolder options) {
    }

    public boolean transferReferences(MutableDataHolder document, DataHolder included) {
        if (document.contains(FOOTNOTES) && included.contains(FOOTNOTES)) {
            return Parser.transferReferences((NodeRepository)((NodeRepository)FOOTNOTES.getFrom((DataHolder)document)), (NodeRepository)((NodeRepository)FOOTNOTES.getFrom(included)), (FOOTNOTES_KEEP.getFrom((DataHolder)document) == KeepType.FIRST ? 1 : 0) != 0);
        }
        return false;
    }

    public void extend(Parser.Builder parserBuilder) {
        parserBuilder.customBlockParserFactory((CustomBlockParserFactory)new FootnoteBlockParser.Factory());
        parserBuilder.linkRefProcessorFactory((LinkRefProcessorFactory)new FootnoteLinkRefProcessor.Factory());
    }

    public void extend(HtmlRenderer.Builder rendererBuilder, String rendererType) {
        if (rendererBuilder.isRendererType("HTML")) {
            rendererBuilder.nodeRendererFactory((NodeRendererFactory)new FootnoteNodeRenderer.Factory());
        } else if (rendererBuilder.isRendererType("JIRA")) {
            // empty if block
        }
    }
}

