/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.footnotes.internal;

import com.vladsch.flexmark.ast.Block;
import com.vladsch.flexmark.ast.BlockContent;
import com.vladsch.flexmark.ext.footnotes.FootnoteBlock;
import com.vladsch.flexmark.ext.footnotes.FootnoteExtension;
import com.vladsch.flexmark.ext.footnotes.internal.FootnoteOptions;
import com.vladsch.flexmark.ext.footnotes.internal.FootnoteRepository;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FootnoteBlockParser
extends AbstractBlockParser {
    static String FOOTNOTE_ID = ".*";
    static Pattern FOOTNOTE_ID_PATTERN = Pattern.compile("\\[\\^\\s*(" + FOOTNOTE_ID + ")\\s*\\]");
    static Pattern FOOTNOTE_DEF_PATTERN = Pattern.compile("^\\[\\^\\s*(" + FOOTNOTE_ID + ")\\s*\\]:");
    private final FootnoteBlock block = new FootnoteBlock();
    private final FootnoteOptions options;
    private final int contentOffset;
    private BlockContent content = new BlockContent();

    public FootnoteBlockParser(FootnoteOptions options, int contentOffset) {
        this.options = options;
        this.contentOffset = contentOffset;
    }

    public BlockContent getBlockContent() {
        return this.content;
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockContinue tryContinue(ParserState state) {
        int nonSpaceIndex = state.getNextNonSpaceIndex();
        if (state.isBlank()) {
            if (this.block.getFirstChild() == null) {
                return BlockContinue.none();
            }
            return BlockContinue.atIndex((int)nonSpaceIndex);
        }
        if (state.getIndent() >= this.options.contentIndent) {
            int contentIndent = state.getIndex() + this.options.contentIndent;
            return BlockContinue.atIndex((int)contentIndent);
        }
        return BlockContinue.none();
    }

    public void addLine(ParserState state, BasedSequence line) {
        this.content.add(line, state.getIndent());
    }

    public void closeBlock(ParserState state) {
        this.block.setCharsFromContent();
        this.block.setFootnote(this.block.getChars().subSequence(this.block.getClosingMarker().getEndOffset() - this.block.getChars().getStartOffset()).trimStart());
        FootnoteRepository footnoteMap = (FootnoteRepository)((Object)state.getProperties().get(FootnoteExtension.FOOTNOTES));
        footnoteMap.put(footnoteMap.normalizeKey((CharSequence)this.block.getText()), (Object)this.block);
        this.content = null;
    }

    public boolean isContainer() {
        return true;
    }

    public boolean canContain(Block block) {
        return true;
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private final FootnoteOptions options;

        private BlockFactory(DataHolder options) {
            super(options);
            this.options = new FootnoteOptions(options);
        }

        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            int nextNonSpace;
            if (state.getIndent() >= 4) {
                return BlockStart.none();
            }
            BasedSequence line = state.getLine();
            BasedSequence trySequence = line.subSequence(nextNonSpace = state.getNextNonSpaceIndex(), line.length());
            Matcher matcher = FOOTNOTE_DEF_PATTERN.matcher((CharSequence)trySequence);
            if (matcher.find()) {
                int openingStart = nextNonSpace + matcher.start();
                int openingEnd = nextNonSpace + matcher.end();
                BasedSequence openingMarker = line.subSequence(openingStart, openingStart + 2);
                BasedSequence text = line.subSequence(openingStart + 2, openingEnd - 2).trim();
                BasedSequence closingMarker = line.subSequence(openingEnd - 2, openingEnd);
                int contentOffset = this.options.contentIndent;
                FootnoteBlockParser footnoteBlockParser = new FootnoteBlockParser(this.options, contentOffset);
                footnoteBlockParser.block.setOpeningMarker(openingMarker);
                footnoteBlockParser.block.setText(text);
                footnoteBlockParser.block.setClosingMarker(closingMarker);
                return BlockStart.of((BlockParser[])new BlockParser[]{footnoteBlockParser}).atIndex(openingEnd);
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        public Set<Class<? extends CustomBlockParserFactory>> getAfterDependents() {
            return null;
        }

        public Set<Class<? extends CustomBlockParserFactory>> getBeforeDependents() {
            return null;
        }

        public boolean affectsGlobalScope() {
            return false;
        }

        public BlockParserFactory create(DataHolder options) {
            return new BlockFactory(options);
        }
    }
}

