/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.enumerated.reference.internal;

import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.NodeRepository;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceBase;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceBlock;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceExtension;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceLink;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceText;
import com.vladsch.flexmark.util.KeepType;
import com.vladsch.flexmark.util.ValueRunnable;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.DataKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EnumeratedReferenceRepository
extends NodeRepository<EnumeratedReferenceBlock> {
    private ArrayList<EnumeratedReferenceBlock> referencedEnumeratedReferenceBlocks = new ArrayList();

    public static String getType(String text) {
        int pos = text.indexOf(58);
        if (pos > 0) {
            return text.subSequence(0, pos).toString();
        }
        return "";
    }

    public List<EnumeratedReferenceBlock> getReferencedEnumeratedReferenceBlocks() {
        return this.referencedEnumeratedReferenceBlocks;
    }

    public EnumeratedReferenceRepository(DataHolder options) {
        super((KeepType)EnumeratedReferenceExtension.ENUMERATED_REFERENCES_KEEP.getFrom(options));
    }

    public DataKey<EnumeratedReferenceRepository> getDataKey() {
        return EnumeratedReferenceExtension.ENUMERATED_REFERENCES;
    }

    public DataKey<KeepType> getKeepDataKey() {
        return EnumeratedReferenceExtension.ENUMERATED_REFERENCES_KEEP;
    }

    public Set<EnumeratedReferenceBlock> getReferencedElements(Node parent) {
        final HashSet<EnumeratedReferenceBlock> references = new HashSet<EnumeratedReferenceBlock>();
        this.visitNodes(parent, (ValueRunnable)new ValueRunnable<Node>(){

            public void run(Node value) {
                EnumeratedReferenceBlock reference;
                if (value instanceof EnumeratedReferenceBase && (reference = ((EnumeratedReferenceBase)value).getReferenceNode(EnumeratedReferenceRepository.this)) != null) {
                    references.add(reference);
                }
            }
        }, new Class[]{EnumeratedReferenceText.class, EnumeratedReferenceLink.class});
        return references;
    }
}

