/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.enumerated.reference.internal;

import com.vladsch.flexmark.ast.DoNotCollectText;
import com.vladsch.flexmark.ast.HardLineBreak;
import com.vladsch.flexmark.ast.HtmlEntity;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.NodeVisitor;
import com.vladsch.flexmark.ast.SoftLineBreak;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ast.VisitHandler;
import com.vladsch.flexmark.ast.Visitor;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceLink;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceText;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.SegmentedSequenceBuilder;

public class EnumRefTextCollectingVisitor {
    private SegmentedSequenceBuilder out;
    private final NodeVisitor myVisitor = new NodeVisitor(new VisitHandler[]{new VisitHandler(Text.class, (Visitor)new Visitor<Text>(){

        public void visit(Text node) {
            EnumRefTextCollectingVisitor.this.visit(node);
        }
    }), new VisitHandler(TextBase.class, (Visitor)new Visitor<TextBase>(){

        public void visit(TextBase node) {
            EnumRefTextCollectingVisitor.this.visit(node);
        }
    }), new VisitHandler(HtmlEntity.class, (Visitor)new Visitor<HtmlEntity>(){

        public void visit(HtmlEntity node) {
            EnumRefTextCollectingVisitor.this.visit(node);
        }
    }), new VisitHandler(SoftLineBreak.class, (Visitor)new Visitor<SoftLineBreak>(){

        public void visit(SoftLineBreak node) {
            EnumRefTextCollectingVisitor.this.visit(node);
        }
    }), new VisitHandler(HardLineBreak.class, (Visitor)new Visitor<HardLineBreak>(){

        public void visit(HardLineBreak node) {
            EnumRefTextCollectingVisitor.this.visit(node);
        }
    }), new VisitHandler(EnumeratedReferenceText.class, (Visitor)new Visitor<EnumeratedReferenceText>(){

        public void visit(EnumeratedReferenceText node) {
            EnumRefTextCollectingVisitor.this.visit(node);
        }
    }), new VisitHandler(EnumeratedReferenceLink.class, (Visitor)new Visitor<EnumeratedReferenceLink>(){

        public void visit(EnumeratedReferenceLink node) {
            EnumRefTextCollectingVisitor.this.visit(node);
        }
    })});
    private final int ordinal;

    public EnumRefTextCollectingVisitor(int ordinal) {
        this.ordinal = ordinal;
    }

    public String getText() {
        return this.out.toString();
    }

    public void collect(Node node) {
        this.out = new SegmentedSequenceBuilder(node.getChars());
        this.myVisitor.visit(node);
    }

    public String collectAndGetText(Node node) {
        this.collect(node);
        return this.out.toString();
    }

    public BasedSequence[] collectAndGetSegments(Node node) {
        this.collect(node);
        return this.out.toSegments();
    }

    public BasedSequence collectAndGetSequence(Node node) {
        this.collect(node);
        return this.out.toBasedSequence();
    }

    private void visit(EnumeratedReferenceText node) {
        String text = node.getText().toString();
        if (text.isEmpty()) {
            this.out.append(String.valueOf(this.ordinal));
        }
    }

    private void visit(EnumeratedReferenceLink node) {
        String text = node.getText().toString();
        if (text.isEmpty()) {
            this.out.append(String.valueOf(this.ordinal));
        }
    }

    private void visit(SoftLineBreak node) {
        this.out.append(node.getChars());
    }

    private void visit(HardLineBreak node) {
        BasedSequence chars = node.getChars();
        this.out.append(chars.subSequence(chars.length() - 1, chars.length()));
    }

    private void visit(HtmlEntity node) {
        this.out.append(node.getChars().unescape());
    }

    private void visit(Text node) {
        if (!node.isOrDescendantOfType(new Class[]{DoNotCollectText.class})) {
            this.out.append(node.getChars());
        }
    }

    private void visit(TextBase node) {
        this.out.append(node.getChars());
    }
}

