/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.emoji.internal;

import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.emoji.Emoji;
import com.vladsch.flexmark.ext.emoji.EmojiExtension;
import com.vladsch.flexmark.ext.emoji.internal.EmojiCheatSheet;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class EmojiNodeRenderer
implements NodeRenderer {
    private final String rootImagePath;
    private final boolean useImageURL;
    private final String attrImageSize;
    private final String attrAlign;

    public EmojiNodeRenderer(DataHolder options) {
        this.rootImagePath = (String)options.get(EmojiExtension.ROOT_IMAGE_PATH);
        this.useImageURL = (Boolean)options.get(EmojiExtension.USE_IMAGE_URLS);
        this.attrImageSize = (String)options.get(EmojiExtension.ATTR_IMAGE_SIZE);
        this.attrAlign = (String)options.get(EmojiExtension.ATTR_ALIGN);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        return new HashSet(Collections.singletonList(new NodeRenderingHandler(Emoji.class, this::render)));
    }

    private void render(Emoji node, NodeRendererContext context, HtmlWriter html) {
        Emoji emoji = node;
        EmojiCheatSheet.EmojiShortcut shortcut = EmojiCheatSheet.shortCutMap.get(emoji.getText().toString());
        if (shortcut == null) {
            html.text(":");
            context.renderChildren((Node)node);
            html.text(":");
        } else {
            ResolvedLink resolvedLink = context.resolveLink(LinkType.IMAGE, this.useImageURL ? shortcut.url : this.rootImagePath + shortcut.image, null);
            html.attr("src", resolvedLink.getUrl());
            html.attr("alt", "emoji " + shortcut.category + ":" + shortcut.name);
            if (!this.attrImageSize.isEmpty()) {
                html.attr("height", this.attrImageSize).attr("width", this.attrImageSize);
            }
            if (!this.attrAlign.isEmpty()) {
                html.attr("align", this.attrAlign);
            }
            html.withAttr(resolvedLink);
            html.tagVoid("img");
        }
    }
}

