/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.definition.internal;

import com.vladsch.flexmark.ast.Block;
import com.vladsch.flexmark.ast.BlockContent;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ext.definition.DefinitionItem;
import com.vladsch.flexmark.ext.definition.DefinitionList;
import com.vladsch.flexmark.ext.definition.DefinitionTerm;
import com.vladsch.flexmark.ext.definition.internal.DefinitionOptions;
import com.vladsch.flexmark.internal.ParagraphParser;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockPreProcessor;
import com.vladsch.flexmark.parser.block.BlockPreProcessorFactory;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefinitionListBlockPreProcessor
implements BlockPreProcessor {
    private final DefinitionOptions options;

    public DefinitionListBlockPreProcessor(DataHolder options) {
        this.options = new DefinitionOptions(options);
    }

    public void preProcess(ParserState state, Block block) {
        if (block instanceof DefinitionItem) {
            DefinitionList definitionList;
            Node lastChild;
            DefinitionItem definitionItem = (DefinitionItem)block;
            Node previous = block.getPrevious();
            definitionItem.unlink();
            if (previous instanceof Paragraph) {
                Paragraph paragraph = (Paragraph)previous;
                Node paragraphPrevious = paragraph.getPrevious();
                Block paragraphParent = paragraph.getParent();
                paragraph.unlink();
                state.blockRemovedWithChildren((Block)paragraph);
                if (paragraphPrevious == null) {
                    paragraphPrevious = paragraphParent.getLastChild();
                }
                boolean hadPreviousList = paragraphPrevious instanceof DefinitionList;
                DefinitionList definitionList2 = new DefinitionList();
                List lines = paragraph.getContentLines();
                DefinitionTerm definitionTerm = null;
                int lineIndex = 0;
                for (BasedSequence line : lines) {
                    definitionTerm = new DefinitionTerm();
                    ParagraphParser parser = new ParagraphParser();
                    BlockContent content = new BlockContent();
                    content.add(line, paragraph.getLineIndent(lineIndex++));
                    parser.getBlock().setContent(content);
                    parser.getBlock().setCharsFromContent();
                    definitionTerm.appendChild((Node)parser.getBlock());
                    definitionTerm.setCharsFromContent();
                    state.blockParserAdded((BlockParser)parser);
                    definitionList2.appendChild((Node)definitionTerm);
                    state.blockAdded((Block)definitionTerm);
                }
                if (definitionTerm != null) {
                    definitionTerm.appendChild((Node)definitionItem);
                    if (hadPreviousList) {
                        DefinitionList previousList = (DefinitionList)paragraphPrevious;
                        previousList.takeChildren((Node)definitionList2);
                        for (Node node : definitionList2.getChildren()) {
                            node.unlink();
                            previousList.appendChild(node);
                            state.blockAddedWithChildren((Block)node);
                        }
                    } else {
                        if (paragraphPrevious != null) {
                            paragraphPrevious.insertAfter((Node)definitionList2);
                        } else {
                            paragraphParent.appendChild((Node)definitionList2);
                        }
                        state.blockAddedWithChildren((Block)definitionList2);
                    }
                }
            } else if (previous instanceof DefinitionList && (lastChild = (definitionList = (DefinitionList)previous).getLastChild()) instanceof DefinitionTerm) {
                DefinitionTerm definitionTerm = (DefinitionTerm)lastChild;
                definitionTerm.appendChild((Node)definitionItem);
                state.blockAddedWithChildren((Block)definitionItem);
            }
            if (definitionItem.getParent() == null) {
                state.blockRemovedWithChildren((Block)definitionItem);
            }
        }
    }

    public static class Factory
    implements BlockPreProcessorFactory {
        public Set<Class<? extends Block>> getBlockTypes() {
            HashSet<Class<? extends Block>> set = new HashSet<Class<? extends Block>>();
            set.add(DefinitionItem.class);
            return set;
        }

        public Set<Class<? extends BlockPreProcessorFactory>> getAfterDependents() {
            return null;
        }

        public Set<Class<? extends BlockPreProcessorFactory>> getBeforeDependents() {
            return null;
        }

        public boolean affectsGlobalScope() {
            return true;
        }

        public BlockPreProcessor create(ParserState state) {
            return new DefinitionListBlockPreProcessor((DataHolder)state.getProperties());
        }
    }
}

