/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.attributes.internal;

import com.vladsch.flexmark.ast.AnchorRefTarget;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.ParagraphItemContainer;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ext.attributes.AttributeNode;
import com.vladsch.flexmark.ext.attributes.AttributesDelimiter;
import com.vladsch.flexmark.ext.attributes.AttributesExtension;
import com.vladsch.flexmark.ext.attributes.AttributesNode;
import com.vladsch.flexmark.ext.attributes.internal.AttributesOptions;
import com.vladsch.flexmark.ext.attributes.internal.NodeAttributeRepository;
import com.vladsch.flexmark.parser.block.NodePostProcessor;
import com.vladsch.flexmark.parser.block.NodePostProcessorFactory;
import com.vladsch.flexmark.util.ast.BlankLine;
import com.vladsch.flexmark.util.ast.DoNotAttributeDecorate;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeTracker;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.ArrayList;

public class AttributesNodePostProcessor
extends NodePostProcessor {
    private final NodeAttributeRepository nodeAttributeRepository;
    private final AttributesOptions myOptions;

    public AttributesNodePostProcessor(Document document) {
        this.nodeAttributeRepository = (NodeAttributeRepository)AttributesExtension.NODE_ATTRIBUTES.getFrom((DataHolder)document);
        this.myOptions = new AttributesOptions((DataHolder)document);
    }

    public Node getAttributeOwner(NodeTracker state, AttributesNode attributesNode) {
        Object attributeOwner;
        Node previous = attributesNode.getPreviousAnyNot(new Class[]{BlankLine.class, DoNotAttributeDecorate.class});
        Node next = attributesNode.getNext();
        Node parent = attributesNode.getParent();
        if (previous == null) {
            Node parentPreviousNotBlankLine;
            attributeOwner = parent instanceof Paragraph ? (parent.getParent() instanceof ParagraphItemContainer ? ((parentPreviousNotBlankLine = parent.getPreviousAnyNot(new Class[]{BlankLine.class})) == null ? parent.getParent().getParent() : (attributesNode.getNextAnyNot(new Class[]{AttributesNode.class, BlankLine.class}) == null ? parentPreviousNotBlankLine : parent)) : (attributesNode.getNextAnyNot(new Class[]{AttributesNode.class, BlankLine.class}) == null ? ((parentPreviousNotBlankLine = parent.getPreviousAnyNot(new Class[]{BlankLine.class})) == null ? parent.getParent() : parentPreviousNotBlankLine) : parent)) : parent;
        } else if (!this.myOptions.assignTextAttributes && (previous instanceof Text || previous instanceof TextBase) || previous.getChars().getEndOffset() < attributesNode.getStartOffset()) {
            if (this.myOptions.useEmptyImplicitAsSpanDelimiter) {
                previous = AttributesNodePostProcessor.matchDelimitedSpans(state, attributesNode, previous);
            }
            attributeOwner = previous instanceof TextBase ? previous : (parent instanceof Paragraph && parent.getParent() instanceof ParagraphItemContainer ? parent.getParent() : parent);
        } else {
            if (this.myOptions.wrapNonAttributeText) {
                Node lastNonAttributesNode = null;
                boolean hadDoNotDecorate = false;
                for (Node first = attributesNode.getPrevious(); first != null && (first instanceof Text || first instanceof DoNotAttributeDecorate); first = first.getPrevious()) {
                    if (first instanceof DoNotAttributeDecorate) {
                        hadDoNotDecorate = true;
                    }
                    lastNonAttributesNode = first;
                }
                if (hadDoNotDecorate) {
                    TextBase textBase = new TextBase();
                    AttributesNodePostProcessor.textBaseWrap(state, lastNonAttributesNode, attributesNode, textBase);
                    previous = textBase;
                }
            }
            if (this.myOptions.useEmptyImplicitAsSpanDelimiter) {
                previous = AttributesNodePostProcessor.matchDelimitedSpans(state, attributesNode, previous);
            }
            if (previous instanceof Text) {
                TextBase textBase = new TextBase(previous.getChars());
                previous.insertBefore((Node)textBase);
                previous.unlink();
                state.nodeRemoved(previous);
                textBase.appendChild(previous);
                state.nodeAddedWithChildren((Node)textBase);
                attributeOwner = textBase;
            } else {
                attributeOwner = previous instanceof AttributesDelimiter ? null : (previous instanceof AttributesNode ? this.getAttributeOwner(state, (AttributesNode)previous) : previous);
            }
        }
        return attributeOwner;
    }

    static Node matchDelimitedSpans(NodeTracker state, AttributesNode attributesNode, Node previous) {
        Node previousNext;
        Node lastNonAttributesNode = null;
        ArrayList<Node> unmatchedAttributes = new ArrayList<Node>();
        for (Node first = attributesNode.getPrevious(); first != null; first = first.getPrevious()) {
            if (first instanceof AttributesDelimiter) {
                if (!unmatchedAttributes.isEmpty()) {
                    Node lastNode = (Node)unmatchedAttributes.remove(unmatchedAttributes.size() - 1);
                    if (lastNode != (lastNonAttributesNode = first.getNext())) {
                        TextBase textBase = new TextBase();
                        AttributesNodePostProcessor.textBaseWrap(state, lastNonAttributesNode, lastNode, textBase);
                        lastNonAttributesNode = textBase;
                        continue;
                    }
                    previous = first;
                    continue;
                }
                TextBase textBase = new TextBase();
                lastNonAttributesNode = first.getNext();
                if (lastNonAttributesNode != attributesNode) {
                    AttributesNodePostProcessor.textBaseWrap(state, lastNonAttributesNode, attributesNode, textBase);
                    previous = textBase;
                    break;
                }
                previous = first;
                break;
            }
            if (first instanceof AttributesNode) {
                unmatchedAttributes.add(first);
                continue;
            }
            lastNonAttributesNode = first;
        }
        if (!unmatchedAttributes.isEmpty() && (previousNext = (previous = (Node)unmatchedAttributes.get(0)).getNext()) != null && previousNext != attributesNode) {
            previous = previousNext;
        }
        return previous;
    }

    static void textBaseWrap(NodeTracker state, Node lastNonAttributesNode, Node lastNode, TextBase textBase) {
        while (lastNonAttributesNode != lastNode) {
            Node nextNode = lastNonAttributesNode.getNext();
            lastNonAttributesNode.unlink();
            state.nodeRemoved(lastNonAttributesNode);
            textBase.appendChild(lastNonAttributesNode);
            lastNonAttributesNode = nextNode;
        }
        textBase.setCharsFromContent();
        lastNode.insertBefore((Node)textBase);
        state.nodeAddedWithDescendants((Node)textBase);
    }

    public void process(NodeTracker state, Node node) {
        if (node instanceof AttributesNode) {
            Node attributeOwner;
            Node tmp;
            AttributesNode attributesNode = (AttributesNode)node;
            Node previous = attributesNode.getPrevious();
            Node next = attributesNode.getNext();
            if (previous == null && next != null && !(next instanceof AttributesNode)) {
                if (next.getChars().isBlank()) {
                    tmp = next;
                    next = next.getNext();
                    tmp.unlink();
                    state.nodeRemoved(tmp);
                } else {
                    next.setChars((BasedSequence)next.getChars().trimStart());
                }
            }
            if (next == null && previous != null && !(previous instanceof AttributesNode)) {
                if (previous.getChars().isBlank()) {
                    tmp = previous;
                    previous = previous.getPrevious();
                    tmp.unlink();
                    state.nodeRemoved(tmp);
                } else {
                    previous.setChars((BasedSequence)previous.getChars().trimEnd());
                }
            }
            if ((attributeOwner = this.getAttributeOwner(state, attributesNode)) != null) {
                this.nodeAttributeRepository.put(attributeOwner, attributesNode);
                if (attributeOwner instanceof AnchorRefTarget) {
                    for (Node attributeNode : attributesNode.getReversedChildren()) {
                        if (!(attributeNode instanceof AttributeNode) || !((AttributeNode)attributeNode).isId()) continue;
                        ((AnchorRefTarget)attributeOwner).setAnchorRefId(((AttributeNode)attributeNode).getValue().toString());
                        break;
                    }
                }
            }
        }
    }

    public static class Factory
    extends NodePostProcessorFactory {
        public Factory() {
            super(false);
            this.addNodes(new Class[]{AttributesNode.class});
        }

        public NodePostProcessor apply(Document document) {
            return new AttributesNodePostProcessor(document);
        }
    }
}

