/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.attributes.internal;

import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.attributes.AttributeNode;
import com.vladsch.flexmark.ext.attributes.AttributesExtension;
import com.vladsch.flexmark.ext.attributes.AttributesNode;
import com.vladsch.flexmark.ext.attributes.internal.NodeAttributeRepository;
import com.vladsch.flexmark.html.AttributeProvider;
import com.vladsch.flexmark.html.IndependentAttributeProviderFactory;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.ArrayList;
import java.util.Iterator;

public class AttributesAttributeProvider
implements AttributeProvider {
    private final NodeAttributeRepository nodeAttributeRepository;

    public AttributesAttributeProvider(NodeRendererContext context) {
        DataHolder options = context.getOptions();
        this.nodeAttributeRepository = (NodeAttributeRepository)AttributesExtension.NODE_ATTRIBUTES.getFrom(options);
    }

    public void setAttributes(Node node, AttributablePart part, Attributes attributes) {
        Object nodeAttributesList = this.nodeAttributeRepository.get(node);
        if (nodeAttributesList != null) {
            Iterator iterator = ((ArrayList)nodeAttributesList).iterator();
            while (iterator.hasNext()) {
                AttributesNode nodeAttributes = (AttributesNode)((Object)iterator.next());
                for (Node attribute : nodeAttributes.getChildren()) {
                    if (!(attribute instanceof AttributeNode)) continue;
                    AttributeNode attributeNode = (AttributeNode)attribute;
                    if (!attributeNode.isImplicitName()) {
                        BasedSequence attributeNodeName = attributeNode.getName();
                        if (!attributeNodeName.isNotNull() || attributeNodeName.isBlank()) continue;
                        if (!attributeNodeName.equals("class")) {
                            attributes.remove((CharSequence)attributeNodeName);
                        }
                        attributes.addValue((CharSequence)attributeNodeName, (CharSequence)attributeNode.getValue());
                        continue;
                    }
                    if (attributeNode.isClass()) {
                        attributes.addValue((CharSequence)"class", (CharSequence)attributeNode.getImplicitNameValue());
                        continue;
                    }
                    if (attributeNode.isId()) {
                        attributes.remove((CharSequence)"id");
                        attributes.addValue((CharSequence)"id", (CharSequence)attributeNode.getImplicitNameValue());
                        continue;
                    }
                    throw new IllegalStateException("Implicit attribute yet not class or id");
                }
            }
        }
    }

    public static class Factory
    extends IndependentAttributeProviderFactory {
        public AttributeProvider create(NodeRendererContext context) {
            return new AttributesAttributeProvider(context);
        }
    }
}

