/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.anchorlink.internal;

import com.vladsch.flexmark.ast.BlockQuote;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ext.anchorlink.AnchorLink;
import com.vladsch.flexmark.ext.anchorlink.AnchorLinkExtension;
import com.vladsch.flexmark.ext.anchorlink.internal.AnchorLinkOptions;
import com.vladsch.flexmark.parser.block.NodePostProcessor;
import com.vladsch.flexmark.parser.block.NodePostProcessorFactory;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeTracker;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public class AnchorLinkNodePostProcessor
extends NodePostProcessor {
    private final AnchorLinkOptions options;

    public AnchorLinkNodePostProcessor(DataHolder options) {
        this.options = new AnchorLinkOptions(options);
    }

    public void process(NodeTracker state, Node node) {
        if (node instanceof Heading) {
            Heading heading;
            if (node.isOrDescendantOfType(new Class[]{BlockQuote.class})) {
                boolean bl = false;
            }
            if ((heading = (Heading)node).getText().isNotNull()) {
                AnchorLink anchor = new AnchorLink();
                if (!this.options.wrapText) {
                    if (heading.getFirstChild() == null) {
                        anchor.setChars((BasedSequence)heading.getText().subSequence(0, 0));
                        heading.appendChild((Node)anchor);
                    } else {
                        anchor.setChars((BasedSequence)heading.getFirstChild().getChars().subSequence(0, 0));
                        heading.getFirstChild().insertBefore((Node)anchor);
                    }
                } else {
                    anchor.takeChildren((Node)heading);
                    heading.appendChild((Node)anchor);
                }
                anchor.setCharsFromContent();
                state.nodeAdded((Node)anchor);
            }
        } else {
            boolean bl = false;
        }
    }

    public static class Factory
    extends NodePostProcessorFactory {
        public Factory(DataHolder options) {
            super(false);
            if (((Boolean)options.get(AnchorLinkExtension.ANCHORLINKS_NO_BLOCK_QUOTE)).booleanValue()) {
                this.addNodeWithExclusions(Heading.class, new Class[]{BlockQuote.class});
            } else {
                this.addNodes(new Class[]{Heading.class});
            }
        }

        public NodePostProcessor apply(Document document) {
            return new AnchorLinkNodePostProcessor((DataHolder)document);
        }
    }
}

