/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.admonition.internal;

import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.admonition.AdmonitionBlock;
import com.vladsch.flexmark.ext.admonition.internal.AdmonitionOptions;
import com.vladsch.flexmark.formatter.CustomNodeFormatter;
import com.vladsch.flexmark.formatter.internal.MarkdownWriter;
import com.vladsch.flexmark.formatter.internal.NodeFormatter;
import com.vladsch.flexmark.formatter.internal.NodeFormatterContext;
import com.vladsch.flexmark.formatter.internal.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.internal.NodeFormattingHandler;
import com.vladsch.flexmark.util.format.Table;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.RepeatedCharSequence;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class AdmonitionNodeFormatter
implements NodeFormatter {
    private final AdmonitionOptions options;
    private Table myTable;

    public AdmonitionNodeFormatter(DataHolder options) {
        this.options = new AdmonitionOptions(options);
    }

    public Set<Class<?>> getNodeClasses() {
        return null;
    }

    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler(AdmonitionBlock.class, (CustomNodeFormatter)new CustomNodeFormatter<AdmonitionBlock>(){

            public void render(AdmonitionBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
                AdmonitionNodeFormatter.this.render(node, context, markdown);
            }
        })));
    }

    private void render(AdmonitionBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.blankLine();
        markdown.append((CharSequence)node.getOpeningMarker()).append(' ');
        markdown.append((CharSequence)node.getInfo());
        if (node.getTitle().isNotNull()) {
            markdown.append(' ').append('\"').append((CharSequence)node.getTitle()).append('\"');
        }
        markdown.line();
        markdown.pushPrefix().addPrefix((CharSequence)RepeatedCharSequence.of((CharSequence)" ", (int)this.options.contentIndent).toString());
        context.renderChildren((Node)node);
        markdown.blankLine();
        markdown.popPrefix();
    }

    public static class Factory
    implements NodeFormatterFactory {
        public NodeFormatter create(DataHolder options) {
            return new AdmonitionNodeFormatter(options);
        }
    }
}

