/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.abbreviation.internal;

import com.vladsch.flexmark.ast.DoNotDecorate;
import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.NodeVisitor;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ast.VisitHandler;
import com.vladsch.flexmark.ext.abbreviation.Abbreviation;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationBlock;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationExtension;
import com.vladsch.flexmark.ext.abbreviation.internal.AbbreviationRepository;
import com.vladsch.flexmark.ext.autolink.internal.AutolinkPostProcessor;
import com.vladsch.flexmark.parser.PostProcessorFactory;
import com.vladsch.flexmark.parser.block.DocumentPostProcessor;
import com.vladsch.flexmark.parser.block.DocumentPostProcessorFactory;
import com.vladsch.flexmark.util.Escaping;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AbbreviationPostProcessor
extends DocumentPostProcessor {
    private Pattern abbreviations = null;
    private HashMap<String, String> abbreviationMap = null;
    private final NodeVisitor myVisitor = new NodeVisitor(new VisitHandler[]{new VisitHandler(Text.class, this::visit)});

    AbbreviationPostProcessor(Document document) {
        AbbreviationRepository abbrRepository = (AbbreviationRepository)((Object)document.get(AbbreviationExtension.ABBREVIATIONS));
        if (!abbrRepository.isEmpty()) {
            this.abbreviationMap = new HashMap();
            StringBuilder sb = new StringBuilder();
            for (String abbr : abbrRepository.keySet()) {
                AbbreviationBlock abbreviationBlock = (AbbreviationBlock)((Object)abbrRepository.get(abbr));
                BasedSequence abbreviation = abbreviationBlock.getAbbreviation();
                if (abbreviation.isEmpty()) continue;
                this.abbreviationMap.put(abbr, abbreviation.toString());
                if (sb.length() > 0) {
                    sb.append("|");
                }
                if (Character.isLetterOrDigit(abbr.charAt(0))) {
                    sb.append("\\b");
                }
                sb.append("\\Q").append(abbr).append("\\E");
                if (!Character.isLetterOrDigit(abbr.charAt(abbr.length() - 1))) continue;
                sb.append("\\b");
            }
            if (sb.length() > 0) {
                this.abbreviations = Pattern.compile(sb.toString());
            }
        }
    }

    public Document processDocument(Document document) {
        if (this.abbreviations != null) {
            this.myVisitor.visit((Node)document);
        }
        return document;
    }

    private void visit(Text text) {
        if (!text.isOrDescendantOfType(new Class[]{DoNotDecorate.class})) {
            this.process(text);
        }
    }

    private Node process(Text node) {
        BasedSequence original = node.getChars();
        ReplacedTextMapper textMapper = new ReplacedTextMapper(original);
        BasedSequence literal = Escaping.unescape((BasedSequence)original, (ReplacedTextMapper)textMapper);
        Matcher m = this.abbreviations.matcher((CharSequence)literal);
        Object lastNode = node;
        int lastEscaped = 0;
        boolean wrapInTextBase = !(node.getParent() instanceof TextBase);
        TextBase textBase = null;
        while (m.find()) {
            if (!this.abbreviationMap.containsKey(m.group(0))) continue;
            String abbreviation = this.abbreviationMap.get(m.group(0));
            int startOffset = textMapper.originalOffset(m.start(0));
            int endOffset = textMapper.originalOffset(m.end(0));
            if (wrapInTextBase) {
                wrapInTextBase = false;
                textBase = new TextBase(original);
                node.insertBefore((Node)textBase);
                textBase.appendChild((Node)node);
            }
            if (startOffset != lastEscaped) {
                BasedSequence escapedChars = original.subSequence(lastEscaped, startOffset);
                Text node1 = new Text(escapedChars);
                lastNode.insertAfter((Node)node1);
                lastNode = node1;
            }
            BasedSequence origAbbrText = original.subSequence(startOffset, endOffset);
            Abbreviation abbrNode = new Abbreviation(origAbbrText, abbreviation);
            lastNode.insertAfter((Node)abbrNode);
            lastNode = abbrNode;
            lastEscaped = endOffset;
        }
        if (lastEscaped != original.length()) {
            BasedSequence escapedChars = original.subSequence(lastEscaped, original.length());
            Text node1 = new Text(escapedChars);
            lastNode.insertAfter((Node)node1);
        }
        lastNode = node.getNext();
        node.unlink();
        return lastNode;
    }

    public static class Factory
    extends DocumentPostProcessorFactory {
        public Set<Class<? extends PostProcessorFactory>> getAfterDependents() {
            return Collections.singleton(AutolinkPostProcessor.Factory.class);
        }

        public DocumentPostProcessor create(Document document) {
            return new AbbreviationPostProcessor(document);
        }
    }
}

