/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.abbreviation.internal;

import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.abbreviation.Abbreviation;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationBlock;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationExtension;
import com.vladsch.flexmark.ext.abbreviation.internal.AbbreviationRepository;
import com.vladsch.flexmark.ext.abbreviation.internal.FormatOptions;
import com.vladsch.flexmark.formatter.CustomNodeFormatter;
import com.vladsch.flexmark.formatter.internal.MarkdownWriter;
import com.vladsch.flexmark.formatter.internal.NodeFormatter;
import com.vladsch.flexmark.formatter.internal.NodeFormatterContext;
import com.vladsch.flexmark.formatter.internal.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.internal.NodeFormattingHandler;
import com.vladsch.flexmark.formatter.internal.NodeRepositoryFormatter;
import com.vladsch.flexmark.formatter.options.ElementPlacement;
import com.vladsch.flexmark.formatter.options.ElementPlacementSort;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class AbbreviationNodeFormatter
extends NodeRepositoryFormatter<AbbreviationRepository, AbbreviationBlock, Abbreviation> {
    private final FormatOptions options;

    public AbbreviationNodeFormatter(DataHolder options) {
        super(options);
        this.options = new FormatOptions(options);
    }

    public AbbreviationRepository getRepository(DataHolder options) {
        return (AbbreviationRepository)((Object)AbbreviationExtension.ABBREVIATIONS.getFrom(options));
    }

    public ElementPlacement getReferencePlacement() {
        return this.options.abbreviationsPlacement;
    }

    public ElementPlacementSort getReferenceSort() {
        return this.options.abbreviationsSort;
    }

    public void renderReferenceBlock(AbbreviationBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.append((CharSequence)node.getOpeningMarker()).append((CharSequence)node.getText()).append((CharSequence)node.getClosingMarker()).append(' ');
        markdown.append((CharSequence)node.getAbbreviation()).line();
    }

    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler(Abbreviation.class, (CustomNodeFormatter)new CustomNodeFormatter<Abbreviation>(){

            public void render(Abbreviation node, NodeFormatterContext context, MarkdownWriter markdown) {
                AbbreviationNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(AbbreviationBlock.class, (CustomNodeFormatter)new CustomNodeFormatter<AbbreviationBlock>(){

            public void render(AbbreviationBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
                AbbreviationNodeFormatter.this.render(node, context, markdown);
            }
        })));
    }

    public Set<Class<?>> getNodeClasses() {
        if (this.options.abbreviationsPlacement != ElementPlacement.AS_IS && this.options.abbreviationsSort != ElementPlacementSort.SORT_UNUSED_LAST) {
            return null;
        }
        return new HashSet(Arrays.asList(Abbreviation.class));
    }

    private void render(AbbreviationBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.renderReference((Node)node, context, markdown);
    }

    private void render(Abbreviation node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.append((CharSequence)node.getChars());
    }

    public static class Factory
    implements NodeFormatterFactory {
        public NodeFormatter create(DataHolder options) {
            return new AbbreviationNodeFormatter(options);
        }
    }
}

