/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.docx.converter.util;

import com.vladsch.flexmark.docx.converter.util.BlockFormatProvider;
import com.vladsch.flexmark.docx.converter.util.BlockFormatProviderBase;
import com.vladsch.flexmark.docx.converter.util.DocxContext;
import com.vladsch.flexmark.docx.converter.util.DocxHelper;
import java.math.BigInteger;
import org.docx4j.model.styles.StyleUtil;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.Style;

public class ListItemBlockFormatProvider<T>
extends BlockFormatProviderBase<T> {
    private final DocxContext<T> myDocx;
    private final String mySpacingStyleId;
    private final long myIdNum;
    private final int myListLevel;
    private final Class[] mySkipContextFrameClasses;

    public ListItemBlockFormatProvider(DocxContext<T> docx, String listStyle, String listSpacingStyle, long idNum, int listLevel, Class ... skipContextFrameClasses) {
        super(docx, listStyle);
        this.mySpacingStyleId = listSpacingStyle;
        this.myDocx = docx;
        this.myIdNum = idNum;
        this.myListLevel = listLevel;
        this.mySkipContextFrameClasses = skipContextFrameClasses;
    }

    @Override
    public void getPPr(PPr pPr) {
        if (this.myPCount == 0) {
            PPrBase.NumPr numPr = this.myDocx.getFactory().createPPrBaseNumPr();
            pPr.setNumPr(numPr);
            PPrBase.NumPr.NumId numId = this.myDocx.getFactory().createPPrBaseNumPrNumId();
            numPr.setNumId(numId);
            numId.setVal(BigInteger.valueOf(this.myIdNum));
            PPrBase.NumPr.Ilvl ilvl = this.myDocx.getFactory().createPPrBaseNumPrIlvl();
            numPr.setIlvl(ilvl);
            ilvl.setVal(BigInteger.valueOf(this.myListLevel));
        } else {
            NumberingDefinitionsPart ndp = this.myDocx.getDocxDocument().getNumberingDefinitionsPart();
            PPrBase.Ind ind = ndp.getInd(String.valueOf(this.myIdNum), String.valueOf(this.myListLevel));
            if (ind != null) {
                DocxHelper helper = this.myDocx.getHelper();
                helper.ensureInd((PPrBase)pPr);
                pPr.getInd().setLeft(helper.safeIndLeft(ind));
                pPr.getInd().setHanging(BigInteger.ZERO);
            }
        }
        super.getPPr(pPr);
    }

    @Override
    protected void adjustPPr(PPr pPrBase) {
        Style style;
        if (this.mySpacingStyleId != null && !this.mySpacingStyleId.equals(this.myBaseStyleId) && (style = this.myDocx.getStyle(this.mySpacingStyleId)) != null && style.getPPr() != null) {
            PPr pPr = this.myDocx.getHelper().getExplicitPPr(style.getPPr());
            PPr pPrExplicitBase = this.myDocx.getHelper().getExplicitPPr(pPrBase);
            PPrBase pPrDiff = this.myDocx.getHelper().keepDiff((PPrBase)pPr, (PPrBase)pPrExplicitBase);
            StyleUtil.apply((PPrBase)pPrDiff, (PPrBase)pPrBase);
        }
    }

    private boolean containsClass(Class[] list, Object item) {
        for (Class nodeType : list) {
            if (!nodeType.isInstance(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected BlockFormatProvider<T> getStyleParent() {
        BlockFormatProvider parent;
        for (parent = this.myParent; parent != null && this.containsClass(this.mySkipContextFrameClasses, parent.getProviderFrame()); parent = parent.getBlockParent()) {
        }
        return parent;
    }

    @Override
    protected void inheritBdr(PPr pPr, PPr parentPPr) {
        super.inheritBdr(pPr, parentPPr);
    }
}

