/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.docx.converter.internal;

import com.vladsch.flexmark.ast.Image;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.docx.converter.DocxRenderer;
import com.vladsch.flexmark.html.LinkResolver;
import com.vladsch.flexmark.html.LinkResolverFactory;
import com.vladsch.flexmark.html.renderer.LinkResolverContext;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.misc.Utils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocxLinkResolver
implements LinkResolver {
    private final String docRelativeURL;
    private final String docRootURL;
    private final String[] relativeParts;
    private final boolean prefixWwwLinks;

    public DocxLinkResolver(LinkResolverContext context) {
        String docRootURL;
        String docRelativeURL = (String)DocxRenderer.DOC_RELATIVE_URL.get(context.getOptions());
        if (docRelativeURL != null) {
            docRelativeURL = Utils.removePrefix((String)docRelativeURL, (char)'/');
        }
        if ((docRootURL = (String)DocxRenderer.DOC_ROOT_URL.get(context.getOptions())) != null) {
            docRootURL = Utils.removePrefix((String)docRootURL, (char)'/');
        }
        this.docRelativeURL = docRelativeURL;
        this.docRootURL = docRootURL;
        this.relativeParts = docRelativeURL.split("/");
        this.prefixWwwLinks = (Boolean)DocxRenderer.PREFIX_WWW_LINKS.get(context.getOptions());
    }

    @NotNull
    public ResolvedLink resolveLink(@NotNull Node node, @NotNull LinkResolverContext context, @NotNull ResolvedLink link) {
        if (node instanceof Image || node instanceof Link || node instanceof Reference) {
            String url = link.getUrl();
            if (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("ftp://") || url.startsWith("sftp://")) {
                return link.withStatus(LinkStatus.VALID).withUrl((CharSequence)url);
            }
            if (url.startsWith("file:/")) {
                return link.withStatus(LinkStatus.VALID).withUrl((CharSequence)url);
            }
            if (url.startsWith("emoji:")) {
                return link.withStatus(LinkStatus.VALID).withUrl((CharSequence)url);
            }
            if (url.startsWith("/")) {
                if (this.docRootURL != null && !this.docRootURL.isEmpty()) {
                    url = this.docRootURL + url;
                    return link.withStatus(LinkStatus.VALID).withUrl((CharSequence)url);
                }
            } else {
                if (this.prefixWwwLinks && url.startsWith("www.")) {
                    return link.withStatus(LinkStatus.INVALID).withUrl((CharSequence)("http://" + url));
                }
                if (!url.matches("^(?:[a-z]+:|#|\\?)")) {
                    String pageRef = url;
                    String suffix = "";
                    int pos = url.indexOf(35);
                    if (pos == 0) {
                        return link.withStatus(LinkStatus.VALID);
                    }
                    if (pos > 0) {
                        suffix = url.substring(pos);
                        pageRef = url.substring(0, pos);
                    } else if (url.contains("?")) {
                        suffix = url.substring(pos);
                        pageRef = url.substring(0, pos);
                    }
                    String[] pathParts = pageRef.split("/");
                    int docParts = this.relativeParts.length;
                    int iMax = pathParts.length;
                    StringBuilder resolved = new StringBuilder();
                    String sep = "";
                    for (int i = 0; i < iMax; ++i) {
                        String part = pathParts[i];
                        if (part.equals(".")) continue;
                        if (part.equals("..")) {
                            if (docParts == 0) {
                                return link;
                            }
                            --docParts;
                            continue;
                        }
                        resolved.append(sep);
                        resolved.append(part);
                        sep = "/";
                    }
                    sep = this.docRelativeURL.startsWith("/") ? "/" : "";
                    StringBuilder resolvedURL = new StringBuilder();
                    iMax = docParts;
                    for (int i = 0; i < iMax; ++i) {
                        resolvedURL.append(sep);
                        resolvedURL.append(this.relativeParts[i]);
                        sep = "/";
                    }
                    resolvedURL.append('/').append((CharSequence)resolved).append(suffix);
                    return link.withStatus(LinkStatus.VALID).withUrl((CharSequence)resolvedURL.toString());
                }
            }
        }
        return link;
    }

    public static class Factory
    implements LinkResolverFactory {
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return null;
        }

        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return null;
        }

        public boolean affectsGlobalScope() {
            return false;
        }

        @NotNull
        public LinkResolver apply(@NotNull LinkResolverContext context) {
            return new DocxLinkResolver(context);
        }
    }
}

