/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.docx.converter.internal;

import com.vladsch.flexmark.ast.AutoLink;
import com.vladsch.flexmark.ast.BlockQuote;
import com.vladsch.flexmark.ast.BulletList;
import com.vladsch.flexmark.ast.BulletListItem;
import com.vladsch.flexmark.ast.Code;
import com.vladsch.flexmark.ast.Emphasis;
import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.ast.HardLineBreak;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.HtmlBlock;
import com.vladsch.flexmark.ast.HtmlBlockBase;
import com.vladsch.flexmark.ast.HtmlCommentBlock;
import com.vladsch.flexmark.ast.HtmlEntity;
import com.vladsch.flexmark.ast.HtmlInline;
import com.vladsch.flexmark.ast.HtmlInlineBase;
import com.vladsch.flexmark.ast.HtmlInlineComment;
import com.vladsch.flexmark.ast.HtmlInnerBlock;
import com.vladsch.flexmark.ast.HtmlInnerBlockComment;
import com.vladsch.flexmark.ast.Image;
import com.vladsch.flexmark.ast.ImageRef;
import com.vladsch.flexmark.ast.IndentedCodeBlock;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.ast.LinkRef;
import com.vladsch.flexmark.ast.ListBlock;
import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.MailLink;
import com.vladsch.flexmark.ast.OrderedList;
import com.vladsch.flexmark.ast.OrderedListItem;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.ParagraphItemContainer;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.ast.SoftLineBreak;
import com.vladsch.flexmark.ast.StrongEmphasis;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ast.ThematicBreak;
import com.vladsch.flexmark.ast.util.ReferenceRepository;
import com.vladsch.flexmark.ast.util.TextCollectingVisitor;
import com.vladsch.flexmark.docx.converter.CustomNodeDocxRenderer;
import com.vladsch.flexmark.docx.converter.DocxRenderer;
import com.vladsch.flexmark.docx.converter.DocxRendererContext;
import com.vladsch.flexmark.docx.converter.DocxRendererOptions;
import com.vladsch.flexmark.docx.converter.DocxRendererPhase;
import com.vladsch.flexmark.docx.converter.NodeDocxRendererHandler;
import com.vladsch.flexmark.docx.converter.PhasedNodeDocxRenderer;
import com.vladsch.flexmark.docx.converter.util.BlockFormatProviderBase;
import com.vladsch.flexmark.docx.converter.util.BoldRunFormatProvider;
import com.vladsch.flexmark.docx.converter.util.ContentContainer;
import com.vladsch.flexmark.docx.converter.util.FootnoteBlockFormatProvider;
import com.vladsch.flexmark.docx.converter.util.FootnoteRunFormatProvider;
import com.vladsch.flexmark.docx.converter.util.HeadingBlockFormatProvider;
import com.vladsch.flexmark.docx.converter.util.IsolatingBlockFormatProvider;
import com.vladsch.flexmark.docx.converter.util.ItalicRunFormatProvider;
import com.vladsch.flexmark.docx.converter.util.ListItemBlockFormatProvider;
import com.vladsch.flexmark.docx.converter.util.ParaContainer;
import com.vladsch.flexmark.docx.converter.util.QuotedFormatProvider;
import com.vladsch.flexmark.docx.converter.util.RunContainer;
import com.vladsch.flexmark.docx.converter.util.RunFormatProviderBase;
import com.vladsch.flexmark.docx.converter.util.SourceCodeRunFormatProvider;
import com.vladsch.flexmark.docx.converter.util.StrikethroughRunFormatProvider;
import com.vladsch.flexmark.docx.converter.util.SubscriptRunFormatProvider;
import com.vladsch.flexmark.docx.converter.util.SuperscriptRunFormatProvider;
import com.vladsch.flexmark.docx.converter.util.UnderlineRunFormatProvider;
import com.vladsch.flexmark.ext.aside.AsideBlock;
import com.vladsch.flexmark.ext.attributes.AttributesNode;
import com.vladsch.flexmark.ext.emoji.Emoji;
import com.vladsch.flexmark.ext.emoji.EmojiExtension;
import com.vladsch.flexmark.ext.emoji.EmojiImageType;
import com.vladsch.flexmark.ext.emoji.EmojiShortcutType;
import com.vladsch.flexmark.ext.emoji.internal.EmojiOptions;
import com.vladsch.flexmark.ext.emoji.internal.EmojiResolvedShortcut;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedOrdinalRenderer;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceBlock;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceExtension;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceLink;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceRendering;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceRepository;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceText;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferences;
import com.vladsch.flexmark.ext.enumerated.reference.internal.EnumRefTextCollectingVisitor;
import com.vladsch.flexmark.ext.footnotes.Footnote;
import com.vladsch.flexmark.ext.footnotes.FootnoteBlock;
import com.vladsch.flexmark.ext.gfm.strikethrough.Strikethrough;
import com.vladsch.flexmark.ext.gfm.strikethrough.Subscript;
import com.vladsch.flexmark.ext.gitlab.GitLabBlockQuote;
import com.vladsch.flexmark.ext.gitlab.GitLabDel;
import com.vladsch.flexmark.ext.gitlab.GitLabIns;
import com.vladsch.flexmark.ext.ins.Ins;
import com.vladsch.flexmark.ext.macros.MacroDefinitionBlock;
import com.vladsch.flexmark.ext.macros.MacroReference;
import com.vladsch.flexmark.ext.tables.TableBlock;
import com.vladsch.flexmark.ext.tables.TableBody;
import com.vladsch.flexmark.ext.tables.TableCaption;
import com.vladsch.flexmark.ext.tables.TableCell;
import com.vladsch.flexmark.ext.tables.TableHead;
import com.vladsch.flexmark.ext.tables.TableRow;
import com.vladsch.flexmark.ext.tables.TableSeparator;
import com.vladsch.flexmark.ext.toc.SimTocBlock;
import com.vladsch.flexmark.ext.toc.TocBlock;
import com.vladsch.flexmark.ext.toc.TocBlockBase;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.HeaderIdGenerator;
import com.vladsch.flexmark.html.renderer.HtmlIdGenerator;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.parser.ListOptions;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.superscript.Superscript;
import com.vladsch.flexmark.util.ImageUtils;
import com.vladsch.flexmark.util.Pair;
import com.vladsch.flexmark.util.ast.BlankLine;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NonRenderingInline;
import com.vladsch.flexmark.util.format.options.ListSpacing;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.html.Escaping;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.DataKey;
import com.vladsch.flexmark.util.options.MutableScopedDataSet;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.awt.image.BufferedImage;
import java.io.File;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.model.structure.PageDimensions;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.model.styles.StyleUtil;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.AltChunkType;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.sharedtypes.STOnOff;
import org.docx4j.toc.TocException;
import org.docx4j.toc.TocGenerator;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTBorder;
import org.docx4j.wml.CTFtnEdn;
import org.docx4j.wml.CTShd;
import org.docx4j.wml.CTSignedHpsMeasure;
import org.docx4j.wml.CTTblCellMar;
import org.docx4j.wml.CTTblLook;
import org.docx4j.wml.CTTblPrBase;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.FldChar;
import org.docx4j.wml.HpsMeasure;
import org.docx4j.wml.Jc;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.RPrAbstract;
import org.docx4j.wml.STBorder;
import org.docx4j.wml.STFldCharType;
import org.docx4j.wml.Style;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblBorders;
import org.docx4j.wml.TblPr;
import org.docx4j.wml.TblWidth;
import org.docx4j.wml.Tc;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TcPrInner;
import org.docx4j.wml.Tr;
import org.docx4j.wml.TrPr;

public class CoreNodeDocxRenderer
implements PhasedNodeDocxRenderer {
    public static final DataKey<Integer> LIST_ITEM_NUMBER = new DataKey("LIST_ITEM_NUMBER", (Object)0);
    public static final DataKey<ListSpacing> LIST_ITEM_SPACING = new DataKey("LIST_ITEM_SPACING", (Object)null);
    public static final HashSet<DocxRendererPhase> RENDERING_PHASES = new HashSet<DocxRendererPhase>(Arrays.asList(DocxRendererPhase.COLLECT, DocxRendererPhase.DOCUMENT_TOP, DocxRendererPhase.DOCUMENT_BOTTOM));
    protected final ReferenceRepository referenceRepository;
    DocxRendererOptions options;
    final EmojiOptions emojiOptions;
    private final ListOptions listOptions;
    protected boolean recheckUndefinedReferences;
    protected boolean repositoryNodesDone;
    protected final boolean linebreakOnInlineHtmlBr;
    protected final boolean tableCaptionToParagraph;
    protected final boolean tableCaptionBeforeTable;
    protected final int tablePreferredWidthPct;
    protected final int tableLeftIndent;
    protected final String tableStyle;
    private int imageId;
    private final HashMap<Node, BigInteger> footnoteIDs;
    private TocBlockBase lastTocBlock;
    private long[] numberedLists = new long[128];
    private long[] bulletLists = new long[128];
    private EnumeratedReferences enumeratedOrdinals;
    Runnable ordinalRunnable;
    private final HtmlIdGenerator headerIdGenerator;
    private Tbl myTbl;
    private Tr myTr;

    private void ensureNumberedListLength(int level) {
        if (this.numberedLists.length < level) {
            long[] newList = new long[(level / 128 + 1) * 128];
            System.arraycopy(this.numberedLists, 0, newList, 0, this.numberedLists.length);
            this.numberedLists = newList;
        }
    }

    private void ensureBulletListLength(int level) {
        if (this.bulletLists.length < level) {
            long[] newList = new long[(level / 128 + 1) * 128];
            System.arraycopy(this.bulletLists, 0, newList, 0, this.bulletLists.length);
            this.bulletLists = newList;
        }
    }

    public CoreNodeDocxRenderer(DataHolder options) {
        this.referenceRepository = this.getRepository(options);
        this.recheckUndefinedReferences = (Boolean)DocxRenderer.RECHECK_UNDEFINED_REFERENCES.getFrom(options);
        this.linebreakOnInlineHtmlBr = (Boolean)DocxRenderer.LINEBREAK_ON_INLINE_HTML_BR.getFrom(options);
        this.tableCaptionToParagraph = (Boolean)DocxRenderer.TABLE_CAPTION_TO_PARAGRAPH.getFrom(options);
        this.tableCaptionBeforeTable = (Boolean)DocxRenderer.TABLE_CAPTION_BEFORE_TABLE.getFrom(options);
        this.tablePreferredWidthPct = (Integer)DocxRenderer.TABLE_PREFERRED_WIDTH_PCT.getFrom(options);
        this.tableLeftIndent = (Integer)DocxRenderer.TABLE_LEFT_INDENT.getFrom(options);
        this.tableStyle = (String)DocxRenderer.TABLE_STYLE.getFrom(options);
        this.repositoryNodesDone = false;
        this.options = new DocxRendererOptions(options);
        this.listOptions = ListOptions.getFrom((DataHolder)options);
        this.footnoteIDs = new HashMap();
        this.lastTocBlock = null;
        this.ordinalRunnable = null;
        MutableScopedDataSet options1 = new MutableScopedDataSet(options);
        options1.set(EmojiExtension.ROOT_IMAGE_PATH, DocxRenderer.DOC_EMOJI_ROOT_IMAGE_PATH.getFrom(options));
        this.emojiOptions = new EmojiOptions((DataHolder)options1);
        this.headerIdGenerator = new HeaderIdGenerator.Factory().create();
    }

    @Override
    public Set<DocxRendererPhase> getFormattingPhases() {
        return RENDERING_PHASES;
    }

    @Override
    public void renderDocument(DocxRendererContext docx, Document document, DocxRendererPhase phase) {
        switch (phase) {
            case COLLECT: {
                this.options = docx.getDocxRendererOptions();
                this.headerIdGenerator.generateIds(document);
                break;
            }
            case DOCUMENT_TOP: {
                this.enumeratedOrdinals = (EnumeratedReferences)EnumeratedReferenceExtension.ENUMERATED_REFERENCE_ORDINALS.getFrom((DataHolder)document);
                break;
            }
            case DOCUMENT_BOTTOM: {
                if (!this.options.tocGenerate && this.lastTocBlock == null) break;
                TocGenerator tocGenerator = null;
                try {
                    tocGenerator = new TocGenerator(docx.getPackage());
                    tocGenerator.setStartingIdForNewBookmarks(docx.getBookmarkIdAtomic());
                    tocGenerator.generateToc(0, this.options.tocInstruction, true);
                }
                catch (TocException e) {
                    if (tocGenerator != null && e.getMessage().contains("use updateToc instead")) {
                        try {
                            tocGenerator.updateToc(true);
                        }
                        catch (TocException e1) {
                            e1.printStackTrace();
                        }
                        break;
                    }
                    e.printStackTrace();
                }
                break;
            }
        }
    }

    @Override
    public Set<Class<?>> getNodeClasses() {
        return null;
    }

    @Override
    public Set<Class<?>> getBookmarkWrapsChildrenClasses() {
        return null;
    }

    public ReferenceRepository getRepository(DataHolder options) {
        return (ReferenceRepository)options.get(Parser.REFERENCES);
    }

    @Override
    public Set<NodeDocxRendererHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeDocxRendererHandler<Node>(Node.class, new CustomNodeDocxRenderer<Node>(){

            @Override
            public void render(Node node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<AutoLink>(AutoLink.class, new CustomNodeDocxRenderer<AutoLink>(){

            @Override
            public void render(AutoLink node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<BlankLine>(BlankLine.class, new CustomNodeDocxRenderer<BlankLine>(){

            @Override
            public void render(BlankLine node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<BlockQuote>(BlockQuote.class, new CustomNodeDocxRenderer<BlockQuote>(){

            @Override
            public void render(BlockQuote node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<GitLabBlockQuote>(GitLabBlockQuote.class, new CustomNodeDocxRenderer<GitLabBlockQuote>(){

            @Override
            public void render(GitLabBlockQuote node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<AsideBlock>(AsideBlock.class, new CustomNodeDocxRenderer<AsideBlock>(){

            @Override
            public void render(AsideBlock node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<Code>(Code.class, new CustomNodeDocxRenderer<Code>(){

            @Override
            public void render(Code node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<Document>(Document.class, new CustomNodeDocxRenderer<Document>(){

            @Override
            public void render(Document node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<Emphasis>(Emphasis.class, new CustomNodeDocxRenderer<Emphasis>(){

            @Override
            public void render(Emphasis node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<StrongEmphasis>(StrongEmphasis.class, new CustomNodeDocxRenderer<StrongEmphasis>(){

            @Override
            public void render(StrongEmphasis node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<Ins>(Ins.class, new CustomNodeDocxRenderer<Ins>(){

            @Override
            public void render(Ins node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<GitLabIns>(GitLabIns.class, new CustomNodeDocxRenderer<GitLabIns>(){

            @Override
            public void render(GitLabIns node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<MacroReference>(MacroReference.class, new CustomNodeDocxRenderer<MacroReference>(){

            @Override
            public void render(MacroReference node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<MacroDefinitionBlock>(MacroDefinitionBlock.class, new CustomNodeDocxRenderer<MacroDefinitionBlock>(){

            @Override
            public void render(MacroDefinitionBlock node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<Strikethrough>(Strikethrough.class, new CustomNodeDocxRenderer<Strikethrough>(){

            @Override
            public void render(Strikethrough node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<GitLabDel>(GitLabDel.class, new CustomNodeDocxRenderer<GitLabDel>(){

            @Override
            public void render(GitLabDel node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<Superscript>(Superscript.class, new CustomNodeDocxRenderer<Superscript>(){

            @Override
            public void render(Superscript node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<Subscript>(Subscript.class, new CustomNodeDocxRenderer<Subscript>(){

            @Override
            public void render(Subscript node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<FencedCodeBlock>(FencedCodeBlock.class, new CustomNodeDocxRenderer<FencedCodeBlock>(){

            @Override
            public void render(FencedCodeBlock node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<Footnote>(Footnote.class, new CustomNodeDocxRenderer<Footnote>(){

            @Override
            public void render(Footnote node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<FootnoteBlock>(FootnoteBlock.class, new CustomNodeDocxRenderer<FootnoteBlock>(){

            @Override
            public void render(FootnoteBlock node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<HardLineBreak>(HardLineBreak.class, new CustomNodeDocxRenderer<HardLineBreak>(){

            @Override
            public void render(HardLineBreak node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<Heading>(Heading.class, new CustomNodeDocxRenderer<Heading>(){

            @Override
            public void render(Heading node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<HtmlBlock>(HtmlBlock.class, new CustomNodeDocxRenderer<HtmlBlock>(){

            @Override
            public void render(HtmlBlock node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<HtmlCommentBlock>(HtmlCommentBlock.class, new CustomNodeDocxRenderer<HtmlCommentBlock>(){

            @Override
            public void render(HtmlCommentBlock node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<HtmlInnerBlock>(HtmlInnerBlock.class, new CustomNodeDocxRenderer<HtmlInnerBlock>(){

            @Override
            public void render(HtmlInnerBlock node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<HtmlInnerBlockComment>(HtmlInnerBlockComment.class, new CustomNodeDocxRenderer<HtmlInnerBlockComment>(){

            @Override
            public void render(HtmlInnerBlockComment node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<HtmlEntity>(HtmlEntity.class, new CustomNodeDocxRenderer<HtmlEntity>(){

            @Override
            public void render(HtmlEntity node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<HtmlInline>(HtmlInline.class, new CustomNodeDocxRenderer<HtmlInline>(){

            @Override
            public void render(HtmlInline node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<HtmlInlineComment>(HtmlInlineComment.class, new CustomNodeDocxRenderer<HtmlInlineComment>(){

            @Override
            public void render(HtmlInlineComment node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<Image>(Image.class, new CustomNodeDocxRenderer<Image>(){

            @Override
            public void render(Image node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<ImageRef>(ImageRef.class, new CustomNodeDocxRenderer<ImageRef>(){

            @Override
            public void render(ImageRef node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<IndentedCodeBlock>(IndentedCodeBlock.class, new CustomNodeDocxRenderer<IndentedCodeBlock>(){

            @Override
            public void render(IndentedCodeBlock node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<Link>(Link.class, new CustomNodeDocxRenderer<Link>(){

            @Override
            public void render(Link node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<LinkRef>(LinkRef.class, new CustomNodeDocxRenderer<LinkRef>(){

            @Override
            public void render(LinkRef node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<BulletList>(BulletList.class, new CustomNodeDocxRenderer<BulletList>(){

            @Override
            public void render(BulletList node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<OrderedList>(OrderedList.class, new CustomNodeDocxRenderer<OrderedList>(){

            @Override
            public void render(OrderedList node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<BulletListItem>(BulletListItem.class, new CustomNodeDocxRenderer<BulletListItem>(){

            @Override
            public void render(BulletListItem node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<OrderedListItem>(OrderedListItem.class, new CustomNodeDocxRenderer<OrderedListItem>(){

            @Override
            public void render(OrderedListItem node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<MailLink>(MailLink.class, new CustomNodeDocxRenderer<MailLink>(){

            @Override
            public void render(MailLink node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<Paragraph>(Paragraph.class, new CustomNodeDocxRenderer<Paragraph>(){

            @Override
            public void render(Paragraph node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<Reference>(Reference.class, new CustomNodeDocxRenderer<Reference>(){

            @Override
            public void render(Reference node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<SoftLineBreak>(SoftLineBreak.class, new CustomNodeDocxRenderer<SoftLineBreak>(){

            @Override
            public void render(SoftLineBreak node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<StrongEmphasis>(StrongEmphasis.class, new CustomNodeDocxRenderer<StrongEmphasis>(){

            @Override
            public void render(StrongEmphasis node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<Text>(Text.class, new CustomNodeDocxRenderer<Text>(){

            @Override
            public void render(Text node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<TextBase>(TextBase.class, new CustomNodeDocxRenderer<TextBase>(){

            @Override
            public void render(TextBase node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<ThematicBreak>(ThematicBreak.class, new CustomNodeDocxRenderer<ThematicBreak>(){

            @Override
            public void render(ThematicBreak node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<TableBlock>(TableBlock.class, new CustomNodeDocxRenderer<TableBlock>(){

            @Override
            public void render(TableBlock node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<TableHead>(TableHead.class, new CustomNodeDocxRenderer<TableHead>(){

            @Override
            public void render(TableHead node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<TableSeparator>(TableSeparator.class, new CustomNodeDocxRenderer<TableSeparator>(){

            @Override
            public void render(TableSeparator node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<TableBody>(TableBody.class, new CustomNodeDocxRenderer<TableBody>(){

            @Override
            public void render(TableBody node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<TableRow>(TableRow.class, new CustomNodeDocxRenderer<TableRow>(){

            @Override
            public void render(TableRow node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<TableCell>(TableCell.class, new CustomNodeDocxRenderer<TableCell>(){

            @Override
            public void render(TableCell node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<TableCaption>(TableCaption.class, new CustomNodeDocxRenderer<TableCaption>(){

            @Override
            public void render(TableCaption node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<TocBlock>(TocBlock.class, new CustomNodeDocxRenderer<TocBlock>(){

            @Override
            public void render(TocBlock node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<SimTocBlock>(SimTocBlock.class, new CustomNodeDocxRenderer<SimTocBlock>(){

            @Override
            public void render(SimTocBlock node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<EnumeratedReferenceText>(EnumeratedReferenceText.class, new CustomNodeDocxRenderer<EnumeratedReferenceText>(){

            @Override
            public void render(EnumeratedReferenceText node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<EnumeratedReferenceLink>(EnumeratedReferenceLink.class, new CustomNodeDocxRenderer<EnumeratedReferenceLink>(){

            @Override
            public void render(EnumeratedReferenceLink node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<EnumeratedReferenceBlock>(EnumeratedReferenceBlock.class, new CustomNodeDocxRenderer<EnumeratedReferenceBlock>(){

            @Override
            public void render(EnumeratedReferenceBlock node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<AttributesNode>(AttributesNode.class, new CustomNodeDocxRenderer<AttributesNode>(){

            @Override
            public void render(AttributesNode node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        }), new NodeDocxRendererHandler<Emoji>(Emoji.class, new CustomNodeDocxRenderer<Emoji>(){

            @Override
            public void render(Emoji node, DocxRendererContext docx) {
                CoreNodeDocxRenderer.this.render(node, docx);
            }
        })));
    }

    private void render(Node node, DocxRendererContext docx) {
        BasedSequence chars = node.getChars();
        MainDocumentPart mdp = docx.getDocxDocument();
        if (node instanceof Block) {
            docx.setBlockFormatProvider(new BlockFormatProviderBase<Node>(docx, docx.getDocxRendererOptions().LOOSE_PARAGRAPH_STYLE));
            docx.createP();
            docx.renderChildren(node);
        } else {
            docx.text(chars.unescape());
        }
    }

    private void render(BlankLine node, DocxRendererContext docx) {
    }

    private void render(Document node, DocxRendererContext docx) {
        docx.renderChildren((Node)node);
    }

    private void render(Paragraph node, DocxRendererContext docx) {
        if (node.getParent() instanceof EnumeratedReferenceBlock) {
            docx.renderChildren((Node)node);
        } else if (!(node.getParent() instanceof ParagraphItemContainer) || !((ParagraphItemContainer)node.getParent()).isItemParagraph(node)) {
            if (node.getParent() instanceof BlockQuote || node.getParent() instanceof AsideBlock) {
                docx.createP();
                docx.renderChildren((Node)node);
            } else if (node.getFirstChildAnyNot(new Class[]{NonRenderingInline.class}) != null) {
                docx.setBlockFormatProvider(new BlockFormatProviderBase<Node>(docx, docx.getDocxRendererOptions().LOOSE_PARAGRAPH_STYLE));
                docx.createP();
                docx.renderChildren((Node)node);
            }
        } else if (node.getParent() instanceof FootnoteBlock) {
            docx.renderChildren((Node)node);
        } else {
            docx.createP();
            docx.renderChildren((Node)node);
        }
    }

    private void render(Text node, DocxRendererContext docx) {
        docx.text(node.getChars().unescape());
    }

    private void render(TextBase node, DocxRendererContext docx) {
        docx.renderChildren((Node)node);
    }

    private void render(Emphasis node, DocxRendererContext docx) {
        docx.setRunFormatProvider(new ItalicRunFormatProvider<Node>(docx, this.options.noCharacterStyles));
        docx.renderChildren((Node)node);
    }

    private void render(StrongEmphasis node, DocxRendererContext docx) {
        docx.setRunFormatProvider(new BoldRunFormatProvider<Node>(docx, this.options.noCharacterStyles));
        docx.renderChildren((Node)node);
    }

    private void render(Subscript node, DocxRendererContext docx) {
        docx.setRunFormatProvider(new SubscriptRunFormatProvider<Node>(docx, this.options.noCharacterStyles));
        docx.renderChildren((Node)node);
    }

    private void render(Superscript node, DocxRendererContext docx) {
        docx.setRunFormatProvider(new SuperscriptRunFormatProvider<Node>(docx, this.options.noCharacterStyles));
        docx.renderChildren((Node)node);
    }

    private void render(Strikethrough node, DocxRendererContext docx) {
        docx.setRunFormatProvider(new StrikethroughRunFormatProvider<Node>(docx, this.options.noCharacterStyles));
        docx.renderChildren((Node)node);
    }

    private void render(GitLabDel node, DocxRendererContext docx) {
        docx.setRunFormatProvider(new StrikethroughRunFormatProvider<Node>(docx, this.options.noCharacterStyles));
        docx.renderChildren((Node)node);
    }

    private void render(Ins node, DocxRendererContext docx) {
        docx.setRunFormatProvider(new UnderlineRunFormatProvider<Node>(docx, this.options.noCharacterStyles));
        docx.renderChildren((Node)node);
    }

    private void render(GitLabIns node, DocxRendererContext docx) {
        docx.setRunFormatProvider(new UnderlineRunFormatProvider<Node>(docx, this.options.noCharacterStyles));
        docx.renderChildren((Node)node);
    }

    private void render(Code node, DocxRendererContext docx) {
        docx.setRunFormatProvider(new SourceCodeRunFormatProvider<Node>(docx, this.options.noCharacterStyles, this.options.codeHighlightShading));
        docx.renderChildren((Node)node);
    }

    private void render(Heading node, DocxRendererContext docx) {
        docx.setBlockFormatProvider(new HeadingBlockFormatProvider<Node>(docx, node.getLevel() - 1));
        docx.createP();
        docx.renderChildren((Node)node);
    }

    private void render(BlockQuote node, DocxRendererContext docx) {
        int level = node.countDirectAncestorsOfType(null, new Class[]{BlockQuote.class}) + 1;
        docx.setBlockFormatProvider(new QuotedFormatProvider<Node>(docx, level, docx.getRenderingOptions().BLOCK_QUOTE_STYLE));
        docx.renderChildren((Node)node);
    }

    private void render(GitLabBlockQuote node, DocxRendererContext docx) {
        int level = node.countDirectAncestorsOfType(null, new Class[]{BlockQuote.class}) + 1;
        docx.setBlockFormatProvider(new QuotedFormatProvider<Node>(docx, level, docx.getRenderingOptions().BLOCK_QUOTE_STYLE));
        docx.renderChildren((Node)node);
    }

    private void render(AsideBlock node, DocxRendererContext docx) {
        int level = node.countDirectAncestorsOfType(null, new Class[]{BlockQuote.class}) + 1;
        docx.setBlockFormatProvider(new QuotedFormatProvider<Node>(docx, level, docx.getRenderingOptions().ASIDE_BLOCK_STYLE));
        docx.renderChildren((Node)node);
    }

    private void render(ThematicBreak node, DocxRendererContext docx) {
        docx.setBlockFormatProvider(new BlockFormatProviderBase<Node>(docx, docx.getDocxRendererOptions().HORIZONTAL_LINE_STYLE));
        docx.createP();
        docx.createR();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void render(MacroReference node, DocxRendererContext docx) {
        MacroDefinitionBlock macroDefinitionBlock = node.getReferenceNode(docx.getDocument());
        if (macroDefinitionBlock != null) {
            if (macroDefinitionBlock.hasChildren() && !macroDefinitionBlock.isInExpansion()) {
                try {
                    macroDefinitionBlock.setInExpansion(true);
                    Node child = macroDefinitionBlock.getFirstChild();
                    if (child instanceof Paragraph && child == macroDefinitionBlock.getLastChild()) {
                        docx.renderChildren(child);
                    }
                    docx.renderChildren((Node)macroDefinitionBlock);
                }
                finally {
                    macroDefinitionBlock.setInExpansion(false);
                }
            }
        } else {
            docx.text(node.getChars().unescape());
        }
    }

    private void render(MacroDefinitionBlock node, DocxRendererContext docx) {
    }

    private void render(FencedCodeBlock node, DocxRendererContext docx) {
        List lines = node.getContentLines();
        docx.renderFencedCodeLines(lines);
    }

    private void render(IndentedCodeBlock node, DocxRendererContext docx) {
        List lines = node.getContentLines();
        docx.renderFencedCodeLines(lines);
    }

    public void renderList(ListBlock node, DocxRendererContext docx) {
        docx.renderChildren((Node)node);
    }

    private void render(BulletList node, DocxRendererContext docx) {
        this.renderList((ListBlock)node, docx);
    }

    private void render(OrderedList node, DocxRendererContext docx) {
        this.renderList((ListBlock)node, docx);
    }

    private void render(BulletListItem node, DocxRendererContext docx) {
        this.renderListItem((ListItem)node, docx);
    }

    private void render(OrderedListItem node, DocxRendererContext docx) {
        this.renderListItem((ListItem)node, docx);
    }

    private void renderListItem(ListItem node, DocxRendererContext docx) {
        int nesting = node.countDirectAncestorsOfType(ListItem.class, new Class[]{BulletList.class, OrderedList.class});
        DocxRendererOptions options = docx.getDocxRendererOptions();
        String listTextStyle = this.listOptions.isTightListItem(node) ? options.TIGHT_PARAGRAPH_STYLE : options.LOOSE_PARAGRAPH_STYLE;
        boolean wantNumbered = node instanceof OrderedListItem;
        long numId = wantNumbered ? 3 : 2;
        int newNum = 1;
        int listLevel = nesting - 1;
        NumberingDefinitionsPart ndp = docx.getDocxDocument().getNumberingDefinitionsPart();
        if (node.getParent() instanceof OrderedList) {
            if (node == node.getParent().getFirstChild()) {
                newNum = this.listOptions.isOrderedListManualStart() ? ((OrderedList)node.getParent()).getStartNumber() : 1;
                numId = ndp.restart(numId, (long)listLevel, (long)newNum);
                this.ensureNumberedListLength(listLevel);
                this.numberedLists[listLevel] = numId;
            } else {
                numId = this.numberedLists[listLevel];
            }
        } else if (node.getParent() instanceof BulletList) {
            if (node == node.getParent().getFirstChild()) {
                newNum = 1;
                numId = ndp.restart(numId, (long)listLevel, (long)newNum);
                this.ensureBulletListLength(listLevel);
                this.bulletLists[listLevel] = numId;
            } else {
                numId = this.bulletLists[listLevel];
            }
        }
        long idNum = numId;
        docx.setBlockFormatProvider(new ListItemBlockFormatProvider<Node>(docx, listTextStyle, idNum, listLevel, ListItem.class, ListBlock.class));
        docx.renderChildren((Node)node);
    }

    private void render(SoftLineBreak node, DocxRendererContext docx) {
        docx.text(" ");
    }

    private void render(HardLineBreak node, DocxRendererContext docx) {
        docx.addLineBreak();
    }

    private void render(HtmlBlock node, DocxRendererContext docx) {
        if (node.hasChildren()) {
            docx.renderChildren((Node)node);
        } else {
            this.renderHtmlBlock((HtmlBlockBase)node, docx, docx.getDocxRendererOptions().suppressHtmlBlocks, true);
        }
    }

    private void render(HtmlCommentBlock node, DocxRendererContext docx) {
        this.renderHtmlBlock((HtmlBlockBase)node, docx, docx.getDocxRendererOptions().suppressHtmlCommentBlocks, true);
    }

    private void render(HtmlInnerBlock node, DocxRendererContext docx) {
        this.renderHtmlBlock((HtmlBlockBase)node, docx, docx.getDocxRendererOptions().suppressHtmlBlocks, true);
    }

    private void render(HtmlInnerBlockComment node, DocxRendererContext docx) {
        this.renderHtmlBlock((HtmlBlockBase)node, docx, docx.getDocxRendererOptions().suppressHtmlCommentBlocks, true);
    }

    public void renderHtmlBlock(HtmlBlockBase node, DocxRendererContext docx, boolean suppress, boolean escape) {
        if (suppress) {
            return;
        }
        if (escape) {
            String normalizeEOL = node.getChars().normalizeEOL();
            if (node instanceof HtmlBlock && normalizeEOL.length() > 0 && normalizeEOL.charAt(normalizeEOL.length() - 1) == '\n') {
                normalizeEOL = normalizeEOL.substring(0, normalizeEOL.length() - 1);
            }
            docx.renderFencedCodeLines(node.getContentLines());
        } else {
            try {
                docx.getDocxDocument().addAltChunk(AltChunkType.Html, node.getChars().toString().getBytes(Charset.forName("UTF-8")));
            }
            catch (Docx4JException e) {
                e.printStackTrace();
            }
        }
    }

    private void render(HtmlInline node, DocxRendererContext docx) {
        this.renderInlineHtml((HtmlInlineBase)node, docx, docx.getDocxRendererOptions().suppressInlineHtml, true);
    }

    private void render(HtmlInlineComment node, DocxRendererContext docx) {
        this.renderInlineHtml((HtmlInlineBase)node, docx, docx.getDocxRendererOptions().suppressInlineHtmlComments, true);
    }

    public void renderInlineHtml(final HtmlInlineBase node, final DocxRendererContext docx, boolean suppress, boolean escape) {
        if (this.linebreakOnInlineHtmlBr && node.getChars().unescape().matches("<br\\s*/?>")) {
            docx.addLineBreak();
        } else {
            if (suppress) {
                return;
            }
            if (escape) {
                docx.contextFramed(new Runnable(){

                    @Override
                    public void run() {
                        docx.setRunFormatProvider(new SourceCodeRunFormatProvider<Node>(docx, CoreNodeDocxRenderer.this.options.noCharacterStyles, CoreNodeDocxRenderer.this.options.codeHighlightShading));
                        docx.text(node.getChars().normalizeEOL());
                    }
                });
            } else {
                try {
                    docx.getDocxDocument().addAltChunk(AltChunkType.Html, node.getChars().toString().getBytes());
                }
                catch (Docx4JException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void render(Reference node, DocxRendererContext docx) {
    }

    private void render(HtmlEntity node, DocxRendererContext docx) {
        docx.text(node.getChars().unescape());
    }

    private void renderURL(BasedSequence urlSource, DocxRendererContext docx, String linkUrl) {
        this.renderURL(urlSource, docx, linkUrl, linkUrl);
    }

    private void renderURL(BasedSequence urlSource, DocxRendererContext docx, String linkUrl, String linkText) {
        this.renderURL(urlSource, docx, linkUrl, null, new UrlRenderer(docx, linkText, linkUrl));
    }

    private void renderURL(BasedSequence urlSrc, DocxRendererContext docx, String linkUrl, Attributes attributes, Runnable runnable) {
        P p = docx.getP();
        String linkTitle = attributes != null && attributes.contains((CharSequence)"title") ? attributes.getValue((CharSequence)"title") : "";
        P.Hyperlink hyperlink = docx.getFactory().createPHyperlink();
        JAXBElement wrappedHyperlink = docx.getFactory().createPHyperlink(hyperlink);
        p.getContent().add(wrappedHyperlink);
        String highlightMissing = "";
        String linkTooltipText = linkTitle;
        String linkUrlText = linkUrl;
        if (linkUrl.startsWith("#")) {
            String nodeId = linkUrl.substring(1);
            if (docx.getNodeFromId(nodeId) == null) {
                highlightMissing = docx.getRenderingOptions().localHyperlinkMissingHighlight;
                linkTooltipText = String.format(docx.getRenderingOptions().localHyperlinkMissingFormat, nodeId);
                if (docx.getDocxRendererOptions().errorsToStdErr) {
                    Pair atIndex = urlSrc.getBaseSequence().getLineColumnAtIndex(urlSrc.getStartOffset());
                    String sourceFile = docx.getDocxRendererOptions().errorSourceFile;
                    sourceFile = sourceFile.isEmpty() ? "on line " : String.format("in %s:", sourceFile);
                    System.err.println(String.format(Locale.US, "    WARN: Invalid anchor target '%s' %s%d:%d", nodeId, sourceFile, (Integer)atIndex.getFirst() + 1, (Integer)atIndex.getSecond() + 2));
                }
            }
            String anchor = docx.getValidBookmarkName(nodeId) + this.options.localHyperlinkSuffix;
            hyperlink.setAnchor(anchor);
            linkUrlText = String.format("#%s", anchor);
        } else {
            Relationship rel = docx.getHyperlinkRelationship(linkUrl);
            hyperlink.setId(rel.getId());
        }
        if (linkTooltipText != null && !linkTooltipText.isEmpty()) {
            hyperlink.setTooltip(linkTooltipText);
        }
        docx.setRunFormatProvider(new RunFormatProviderBase<Node>(docx, docx.getDocxRendererOptions().HYPERLINK_STYLE, this.options.noCharacterStyles, highlightMissing));
        docx.setRunContainer(new UrlRunContainer(hyperlink));
        if (linkTitle != null && !linkTitle.isEmpty()) {
            R r = docx.getFactory().createR();
            hyperlink.getContent().add(r);
            FldChar fldchar = docx.getFactory().createFldChar();
            JAXBElement fldcharWrapped = docx.getFactory().createRFldChar(fldchar);
            r.getContent().add(fldcharWrapped);
            fldchar.setFldCharType(STFldCharType.BEGIN);
            R r2 = docx.getFactory().createR();
            hyperlink.getContent().add(r2);
            org.docx4j.wml.Text text = docx.getFactory().createText();
            JAXBElement textWrapped = docx.getFactory().createRInstrText(text);
            r2.getContent().add(textWrapped);
            text.setValue(String.format(" HYPERLINK \"%s\" \\o \"%s\" ", linkUrlText, linkTitle));
            text.setSpace("preserve");
            R r3 = docx.getFactory().createR();
            hyperlink.getContent().add(r3);
            FldChar fldchar2 = docx.getFactory().createFldChar();
            JAXBElement fldcharWrapped2 = docx.getFactory().createRFldChar(fldchar2);
            r3.getContent().add(fldcharWrapped2);
            fldchar2.setFldCharType(STFldCharType.SEPARATE);
        }
        runnable.run();
        if (linkTitle != null && !linkTitle.isEmpty()) {
            R r3 = docx.getFactory().createR();
            hyperlink.getContent().add(r3);
            FldChar fldchar2 = docx.getFactory().createFldChar();
            JAXBElement fldcharWrapped2 = docx.getFactory().createRFldChar(fldchar2);
            r3.getContent().add(fldcharWrapped2);
            fldchar2.setFldCharType(STFldCharType.END);
        }
    }

    private void render(AutoLink node, DocxRendererContext docx) {
        String url = node.getChars().unescape();
        this.renderURL(node.getChars(), docx, url);
    }

    private void render(MailLink node, DocxRendererContext docx) {
        String unescaped = node.getText().unescape();
        this.renderURL(node.getChars(), docx, "mailto:" + unescaped, unescaped);
    }

    private void render(Link node, DocxRendererContext docx) {
        ResolvedLink resolvedLink = docx.resolveLink(LinkType.LINK, node.getUrl().unescape(), null, null);
        Attributes attributes = resolvedLink.getNonNullAttributes();
        if (node.getTitle().isNotNull()) {
            attributes.replaceValue((CharSequence)"title", (CharSequence)node.getTitle().unescape());
        } else {
            attributes.remove((CharSequence)"title");
        }
        attributes = docx.extendRenderingNodeAttributes(AttributablePart.NODE, attributes);
        this.renderURL(node.getUrl(), docx, resolvedLink.getUrl(), attributes, new ChildRenderer(docx, (Node)node));
    }

    private void render(LinkRef node, DocxRendererContext docx) {
        ResolvedLink resolvedLink = null;
        if (!node.isDefined() && this.recheckUndefinedReferences && node.getReferenceNode(this.referenceRepository) != null) {
            node.setDefined(true);
        }
        BasedSequence urlSrc = node.getReference();
        Reference reference = null;
        if (node.isDefined()) {
            reference = node.getReferenceNode(this.referenceRepository);
            urlSrc = reference.getUrl();
            String url = urlSrc.unescape();
            resolvedLink = docx.resolveLink(LinkType.LINK, url, null, null);
            if (reference.getTitle().isNotNull()) {
                resolvedLink.getNonNullAttributes().replaceValue((CharSequence)"title", (CharSequence)reference.getTitle().unescape());
            } else {
                resolvedLink.getNonNullAttributes().remove((CharSequence)"title");
            }
        } else {
            String normalizeRef = node.getReference().unescape();
            resolvedLink = docx.resolveLink(LinkType.LINK_REF, normalizeRef, null, null);
            if (resolvedLink.getStatus() == LinkStatus.UNKNOWN) {
                resolvedLink = null;
            }
        }
        if (resolvedLink == null) {
            assert (!node.isDefined());
            if (!node.hasChildren()) {
                docx.text(node.getChars().unescape());
            } else {
                docx.text(node.getChars().prefixOf(node.getChildChars()).unescape());
                docx.renderChildren((Node)node);
                docx.text(node.getChars().suffixOf(node.getChildChars()).unescape());
            }
        } else {
            Attributes attributes = resolvedLink.getNonNullAttributes();
            if (reference != null) {
                attributes = docx.extendRenderingNodeAttributes((Node)reference, AttributablePart.NODE, attributes);
            }
            attributes = docx.extendRenderingNodeAttributes(AttributablePart.NODE, attributes);
            this.renderURL(urlSrc, docx, resolvedLink.getUrl(), attributes, new ChildRenderer(docx, (Node)node));
        }
    }

    private long getSizeInfo(Attributes attributes, String name, double pageDimension) {
        Double value = -1.0;
        if (attributes.contains((CharSequence)name)) {
            String attributeValue = attributes.getValue((CharSequence)name).trim();
            boolean relative = false;
            if (attributeValue.endsWith("%")) {
                attributeValue = attributeValue.substring(0, attributeValue.length() - 1);
                relative = true;
            }
            try {
                value = Double.parseDouble(attributeValue);
                value = value * (20.0 * this.options.docEmojiImageVertSize);
            }
            catch (Throwable ignored) {
                value = -1.0;
            }
            if (relative) {
                value = value * pageDimension;
            }
        }
        long longValue = -1L;
        try {
            longValue = value.longValue();
        }
        catch (Throwable ignored) {
            longValue = -1L;
        }
        return longValue;
    }

    public R newImage(DocxRendererContext docx, byte[] bytes, String filenameHint, Attributes attributes, int id1, int id2) {
        try {
            int maxWidth;
            BinaryPartAbstractImage imagePart = null;
            imagePart = BinaryPartAbstractImage.createImagePart((OpcPackage)docx.getPackage(), (Part)docx.getContainerPart(), (byte[])bytes);
            Inline inline = null;
            String altText = attributes.contains((CharSequence)"alt") ? attributes.getValue((CharSequence)"alt") : "";
            List sections = docx.getPackage().getDocumentModel().getSections();
            PageDimensions page = ((SectionWrapper)sections.get(sections.size() - 1)).getPageDimensions();
            double writableWidthTwips = page.getWritableWidthTwips();
            long cx = this.getSizeInfo(attributes, "width", page.getWritableWidthTwips());
            long cy = cx > 0L ? this.getSizeInfo(attributes, "height", page.getWritableHeightTwips()) : -1L;
            long longMaxWidth = this.getSizeInfo(attributes, "max-width", page.getWritableWidthTwips());
            int n = maxWidth = longMaxWidth > 0L && longMaxWidth <= Integer.MAX_VALUE ? (int)longMaxWidth : -1;
            if (cx > 0L && cy > 0L) {
                cx = UnitsOfMeasurement.twipToEMU((double)cx);
                cy = UnitsOfMeasurement.twipToEMU((double)cy);
                inline = imagePart.createImageInline(filenameHint, altText, id1, id2, cx, cy, false);
            } else {
                inline = cx > 0L ? imagePart.createImageInline(filenameHint, altText, id1, id2, cx, false) : (maxWidth > 0 ? imagePart.createImageInline(filenameHint, altText, id1, id2, false, maxWidth) : imagePart.createImageInline(filenameHint, altText, id1, id2, false));
            }
            R run = docx.createR();
            Drawing drawing = docx.getFactory().createDrawing();
            run.getContent().add(drawing);
            drawing.getAnchorOrInline().add(inline);
            return run;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void render(Image node, DocxRendererContext docx) {
        String altText = new TextCollectingVisitor(new Class[0]).collectAndGetText((Node)node);
        ResolvedLink resolvedLink = docx.resolveLink(LinkType.IMAGE, node.getUrl().unescape(), null, null);
        String url = resolvedLink.getUrl();
        Attributes attributes = resolvedLink.getNonNullAttributes();
        if (!node.getUrlContent().isEmpty()) {
            String content = Escaping.percentEncodeUrl((CharSequence)node.getUrlContent()).replace("+", "%2B").replace("%3D", "=").replace("%26", "&amp;");
            url = url + content;
        }
        if (!altText.isEmpty()) {
            attributes.replaceValue((CharSequence)"alt", (CharSequence)altText);
        }
        attributes = docx.extendRenderingNodeAttributes(AttributablePart.NODE, attributes);
        this.renderImage(docx, url, attributes);
    }

    private void render(Emoji node, DocxRendererContext docx) {
        EmojiResolvedShortcut shortcut = EmojiResolvedShortcut.getEmojiText((Emoji)node, (EmojiShortcutType)this.emojiOptions.useShortcutType, (EmojiImageType)this.emojiOptions.useImageType, (String)this.emojiOptions.rootImagePath);
        if (shortcut.emoji == null || shortcut.emojiText == null) {
            docx.text(":");
            docx.renderChildren((Node)node);
            docx.text(":");
        } else if (shortcut.isUnicode) {
            docx.text(shortcut.emojiText);
        } else {
            long adj;
            R r;
            ResolvedLink resolvedLink = docx.resolveLink(LinkType.IMAGE, shortcut.emojiText, null, null);
            String url = resolvedLink.getUrl();
            Attributes attributes = resolvedLink.getNonNullAttributes();
            if (shortcut.alt != null) {
                attributes.replaceValue((CharSequence)"alt", (CharSequence)shortcut.alt);
            }
            RPr rPr = docx.getFactory().createRPr();
            RPr paraRPr = docx.getFactory().createRPr();
            PPr pPr = docx.getFactory().createPPr();
            docx.getBlockFormatProvider().getPPr(pPr);
            docx.getBlockFormatProvider().getParaRPr(paraRPr);
            paraRPr = docx.getHelper().getExplicitRPr((RPrAbstract)paraRPr, pPr);
            docx.getRunFormatProvider().getRPr(rPr);
            rPr = docx.getHelper().getExplicitRPr(rPr);
            StyleUtil.apply((RPr)rPr, (RPr)paraRPr);
            StyleUtil.apply((RPr)paraRPr, (RPr)rPr);
            HpsMeasure sz = rPr.getSz();
            long l = -1L;
            if (sz != null) {
                l = sz.getVal().longValue();
                attributes.replaceValue((CharSequence)"height", (CharSequence)String.valueOf(Math.round((double)(l / 2L) / this.options.docEmojiImageVertSize)));
                attributes.replaceValue((CharSequence)"width", (CharSequence)String.valueOf(Math.round((double)(l / 2L) / this.options.docEmojiImageVertSize)));
            } else if (!this.emojiOptions.attrImageSize.isEmpty()) {
                attributes.replaceValue((CharSequence)"height", (CharSequence)this.emojiOptions.attrImageSize);
                attributes.replaceValue((CharSequence)"width", (CharSequence)this.emojiOptions.attrImageSize);
                l = this.getSizeInfo(attributes, "width", 100.0);
                l /= 20L;
            }
            if (!this.emojiOptions.attrAlign.isEmpty()) {
                attributes.replaceValue((CharSequence)"align", (CharSequence)this.emojiOptions.attrAlign);
            }
            if ((r = this.renderImage(docx, url, attributes = docx.extendRenderingNodeAttributes(AttributablePart.NODE, attributes))) != null && (adj = Math.round((double)l * this.options.docEmojiImageVertOffset)) < 0L) {
                RPr rPr1 = r.getRPr();
                if (rPr1 == null) {
                    rPr1 = docx.getFactory().createRPr();
                    r.setRPr(rPr1);
                }
                CTSignedHpsMeasure hpsMeasure = docx.getFactory().createCTSignedHpsMeasure();
                rPr1.setPosition(hpsMeasure);
                hpsMeasure.setVal(BigInteger.valueOf(adj));
            }
        }
    }

    private void render(ImageRef node, DocxRendererContext docx) {
        ResolvedLink resolvedLink;
        if (!node.isDefined() && this.recheckUndefinedReferences && node.getReferenceNode(this.referenceRepository) != null) {
            node.setDefined(true);
        }
        Reference reference = null;
        if (node.isDefined()) {
            reference = node.getReferenceNode(this.referenceRepository);
            String url = reference.getUrl().unescape();
            resolvedLink = docx.resolveLink(LinkType.IMAGE, url, null, null);
            if (reference.getTitle().isNotNull()) {
                resolvedLink.getNonNullAttributes().replaceValue((CharSequence)"title", (CharSequence)reference.getTitle().unescape());
            } else {
                resolvedLink.getNonNullAttributes().remove((CharSequence)"title");
            }
        } else {
            String normalizeRef = this.referenceRepository.normalizeKey((CharSequence)node.getReference());
            resolvedLink = docx.resolveLink(LinkType.IMAGE_REF, normalizeRef, null, null);
            if (resolvedLink.getStatus() == LinkStatus.UNKNOWN) {
                resolvedLink = null;
            }
        }
        if (resolvedLink == null) {
            docx.text(node.getChars().unescape());
            if (this.options.logImageProcessing) {
                System.out.println("render image ref of " + this.referenceRepository.normalizeKey((CharSequence)node.getReference()) + " skipped because it was not defined");
            }
        } else {
            String altText = new TextCollectingVisitor(new Class[0]).collectAndGetText((Node)node);
            String url = resolvedLink.getUrl();
            Attributes attributes = resolvedLink.getNonNullAttributes();
            if (!altText.isEmpty()) {
                attributes.replaceValue((CharSequence)"alt", (CharSequence)altText);
            }
            if (reference != null) {
                attributes = docx.extendRenderingNodeAttributes((Node)reference, AttributablePart.NODE, attributes);
            }
            attributes = docx.extendRenderingNodeAttributes(AttributablePart.NODE, attributes);
            this.renderImage(docx, url, attributes);
        }
    }

    private R renderImage(DocxRendererContext docx, String url, Attributes attributes) {
        BufferedImage image = null;
        int id1 = this.imageId++;
        int id2 = this.imageId++;
        String filenameHint = String.format(Locale.US, "Image%d", id1 / 2 + 1);
        if (url.startsWith("emoji:")) {
            url = this.getClass().getResource("/emoji/" + url.substring("emoji:".length())).toString();
            boolean bl = false;
        }
        if (url.startsWith("http:") || url.startsWith("https:") || url.startsWith("file:")) {
            if (url.startsWith("file:")) {
                try {
                    File imageFile = new File(new URI(url));
                    image = ImageUtils.loadImageFromFile((File)imageFile);
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            } else {
                image = ImageUtils.loadImageFromURL((String)url, (boolean)this.options.logImageProcessing);
            }
            if (image == null && this.options.logImageProcessing) {
                System.out.println("loadImageFromURL(" + url + ") returned null");
            }
        } else if (this.options.logImageProcessing) {
            System.out.println("renderImage of \"" + url + "\") skipped (not file:, http: or https:)");
        }
        if (image != null) {
            int width = image.getWidth();
            if (this.options.maxImageWidth > 0 && this.options.maxImageWidth < width) {
                int cx = this.options.maxImageWidth;
                attributes.replaceValue((CharSequence)"width", (CharSequence)String.valueOf(cx));
            }
            byte[] imageBytes = ImageUtils.getImageBytes((BufferedImage)image);
            return this.newImage(docx, imageBytes, filenameHint, attributes, id1, id2);
        }
        return null;
    }

    private void render(TableBlock node, DocxRendererContext docx) {
        Node caption = node.getFirstChildAny(new Class[]{TableCaption.class});
        if (caption != null && this.tableCaptionBeforeTable) {
            this.renderTableCaption((TableCaption)caption, docx);
        }
        Tbl savedTbl = this.myTbl;
        this.myTbl = docx.getFactory().createTbl();
        JAXBElement tblWrapped = docx.getFactory().createHdrTbl(this.myTbl);
        docx.getContent().add(tblWrapped);
        TblPr tblpr = docx.getFactory().createTblPr();
        this.myTbl.setTblPr(tblpr);
        Jc jc = docx.getFactory().createJc();
        tblpr.setJc(jc);
        jc.setVal(JcEnumeration.LEFT);
        if (!this.tableStyle.isEmpty()) {
            CTTblPrBase.TblStyle tblStyle = docx.getFactory().createCTTblPrBaseTblStyle();
            tblpr.setTblStyle(tblStyle);
            tblStyle.setVal(this.tableStyle);
        }
        TblWidth tblwidth = docx.getFactory().createTblWidth();
        tblpr.setTblW(tblwidth);
        if (this.tablePreferredWidthPct == 0) {
            tblwidth.setType("auto");
            tblwidth.setW(BigInteger.valueOf(0L));
        } else {
            tblwidth.setType("pct");
            tblwidth.setW(BigInteger.valueOf(this.tablePreferredWidthPct * 50));
        }
        int cellMargin = 80;
        PPr pPr = docx.getFactory().createPPr();
        docx.getHelper().ensureInd((PPrBase)pPr);
        PPrBase.Ind ind = pPr.getInd();
        ind.setLeft(null);
        PPr parentPPr = docx.getFactory().createPPr();
        docx.getBlockFormatProvider().getPPr(parentPPr);
        PPr styledPPr = docx.getHelper().getExplicitPPr(parentPPr);
        docx.getHelper().inheritInd(pPr, styledPPr);
        TblWidth tblInd = docx.getFactory().createTblWidth();
        tblpr.setTblInd(tblInd);
        tblInd.setType("dxa");
        BigInteger tableInd = BigInteger.valueOf(this.tableLeftIndent).add(docx.getHelper().safeIndLeft(pPr.getInd()));
        tblInd.setW(tableInd);
        docx.setBlockFormatProvider(new IsolatingBlockFormatProvider<Node>(docx));
        if (this.tableStyle.isEmpty()) {
            TblBorders tblborders = docx.getFactory().createTblBorders();
            tblpr.setTblBorders(tblborders);
            CTBorder border = docx.getFactory().createCTBorder();
            tblborders.setLeft(border);
            border.setVal(STBorder.SINGLE);
            border.setSz(BigInteger.valueOf(2L));
            border.setColor("000001");
            border.setSpace(BigInteger.valueOf(0L));
            CTBorder border2 = docx.getFactory().createCTBorder();
            tblborders.setRight(border2);
            border2.setVal(STBorder.SINGLE);
            border2.setSz(BigInteger.valueOf(2L));
            border2.setColor("000001");
            border2.setSpace(BigInteger.valueOf(0L));
            CTBorder border3 = docx.getFactory().createCTBorder();
            tblborders.setTop(border3);
            border3.setVal(STBorder.SINGLE);
            border3.setSz(BigInteger.valueOf(2L));
            border3.setColor("000001");
            border3.setSpace(BigInteger.valueOf(0L));
            CTBorder border4 = docx.getFactory().createCTBorder();
            tblborders.setBottom(border4);
            border4.setVal(STBorder.SINGLE);
            border4.setSz(BigInteger.valueOf(2L));
            border4.setColor("000001");
            border4.setSpace(BigInteger.valueOf(0L));
            CTBorder border5 = docx.getFactory().createCTBorder();
            tblborders.setInsideH(border5);
            border5.setVal(STBorder.SINGLE);
            border5.setSz(BigInteger.valueOf(2L));
            border5.setColor("000001");
            border5.setSpace(BigInteger.valueOf(0L));
            CTBorder border6 = docx.getFactory().createCTBorder();
            tblborders.setInsideV(border6);
            border6.setVal(STBorder.SINGLE);
            border6.setSz(BigInteger.valueOf(2L));
            border6.setColor("000001");
            border6.setSpace(BigInteger.valueOf(0L));
        }
        CTTblCellMar tblcellmar = docx.getFactory().createCTTblCellMar();
        tblpr.setTblCellMar(tblcellmar);
        TblWidth tblwidth3 = docx.getFactory().createTblWidth();
        tblcellmar.setLeft(tblwidth3);
        tblwidth3.setType("dxa");
        tblwidth3.setW(BigInteger.valueOf(80L));
        TblWidth tblwidth4 = docx.getFactory().createTblWidth();
        tblcellmar.setRight(tblwidth4);
        tblwidth4.setType("dxa");
        tblwidth4.setW(BigInteger.valueOf(80L));
        TblWidth tblwidth5 = docx.getFactory().createTblWidth();
        tblcellmar.setTop(tblwidth5);
        tblwidth5.setType("dxa");
        tblwidth5.setW(BigInteger.valueOf(80L));
        TblWidth tblwidth6 = docx.getFactory().createTblWidth();
        tblcellmar.setBottom(tblwidth6);
        tblwidth6.setType("dxa");
        tblwidth6.setW(BigInteger.valueOf(80L));
        CTTblLook tbllook = docx.getFactory().createCTTblLook();
        tblpr.setTblLook(tbllook);
        tbllook.setVal("04a0");
        tbllook.setLastRow(STOnOff.ZERO);
        tbllook.setLastColumn(STOnOff.ZERO);
        tbllook.setNoHBand(STOnOff.ZERO);
        tbllook.setNoVBand(STOnOff.ONE);
        tbllook.setFirstRow(STOnOff.ONE);
        tbllook.setFirstColumn(STOnOff.ONE);
        docx.renderChildren((Node)node);
        this.myTbl = savedTbl;
    }

    private void render(TableHead node, DocxRendererContext docx) {
        docx.renderChildren((Node)node);
    }

    private void render(TableSeparator tableSeparator, DocxRendererContext docx) {
    }

    private void render(TableBody node, DocxRendererContext docx) {
        docx.renderChildren((Node)node);
    }

    private void render(TableRow node, DocxRendererContext docx) {
        Tr savedTr = this.myTr;
        this.myTr = docx.getFactory().createTr();
        this.myTbl.getContent().add(this.myTr);
        TrPr trpr = docx.getFactory().createTrPr();
        this.myTr.setTrPr(trpr);
        if (node.getParent() instanceof TableHead) {
            BooleanDefaultTrue booleandefaulttrue = docx.getFactory().createBooleanDefaultTrue();
            JAXBElement booleandefaulttrueWrapped = docx.getFactory().createCTTrPrBaseTblHeader(booleandefaulttrue);
            trpr.getCnfStyleOrDivIdOrGridBefore().add(booleandefaulttrueWrapped);
        }
        docx.renderChildren((Node)node);
        this.myTr = savedTr;
    }

    private void render(TableCaption node, DocxRendererContext docx) {
        if (!this.tableCaptionBeforeTable) {
            this.renderTableCaption(node, docx);
        }
    }

    private void renderTableCaption(TableCaption node, DocxRendererContext docx) {
        if (this.tableCaptionToParagraph) {
            docx.contextFramed(new TableCaptionRenderer(docx, node));
        }
    }

    private void render(TableCell node, DocxRendererContext docx) {
        String styleName = node.isHeader() ? docx.getDocxRendererOptions().TABLE_HEADING : docx.getDocxRendererOptions().TABLE_CONTENTS;
        Tc tc = docx.getFactory().createTc();
        JAXBElement tcWrapped = docx.getFactory().createTrTc(tc);
        this.myTr.getContent().add(tcWrapped);
        TcPr tcpr = docx.getFactory().createTcPr();
        tc.setTcPr(tcpr);
        Style style = docx.getStyle(styleName);
        if (style != null && style.getPPr() != null && style.getPPr().getShd() != null) {
            CTShd shd = docx.getHelper().getCopy(style.getPPr().getShd(), false);
            tcpr.setShd(shd);
        }
        boolean[] firstP = new boolean[]{true};
        docx.setContentContainer(new TableCellContentContainer(tc, docx, firstP));
        docx.setBlockFormatProvider(new BlockFormatProviderBase<Node>(docx, styleName));
        docx.setParaContainer(new TableCellParaContainer(node, tc, docx, firstP));
        if (node.getSpan() > 1) {
            TcPrInner.GridSpan tcprinnergridspan = docx.getFactory().createTcPrInnerGridSpan();
            tcpr.setGridSpan(tcprinnergridspan);
            tcprinnergridspan.setVal(BigInteger.valueOf(node.getSpan()));
        }
        docx.renderChildren((Node)node);
        if (firstP[0]) {
            docx.createP();
        }
    }

    static JcEnumeration getAlignValue(TableCell.Alignment alignment) {
        switch (alignment) {
            case LEFT: {
                return JcEnumeration.LEFT;
            }
            case CENTER: {
                return JcEnumeration.CENTER;
            }
            case RIGHT: {
                return JcEnumeration.RIGHT;
            }
        }
        throw new IllegalStateException("Unknown alignment: " + alignment);
    }

    private void render(FootnoteBlock node, DocxRendererContext docx) {
    }

    private void render(Footnote node, DocxRendererContext docx) {
        FootnoteBlock footnoteBlock = node.getFootnoteBlock();
        if (footnoteBlock == null) {
            org.docx4j.wml.Text text = docx.addWrappedText();
            text.setValue("[^");
            docx.renderChildren((Node)node);
            org.docx4j.wml.Text text1 = docx.addWrappedText();
            text1.setValue("]");
        } else {
            try {
                BigInteger footnoteId = this.footnoteIDs.containsKey(footnoteBlock) ? this.footnoteIDs.get(footnoteBlock) : BigInteger.ZERO;
                CTFtnEdn ftnEdn = docx.addFootnote(footnoteId);
                BigInteger ftnEdnId = ftnEdn.getId();
                if (ftnEdnId.compareTo(footnoteId) != 0) {
                    docx.contextFramed(new FootnoteFrame(docx, ftnEdn, footnoteBlock));
                }
            }
            catch (Docx4JException e) {
                e.printStackTrace();
            }
        }
    }

    private void render(TocBlock node, DocxRendererContext docx) {
        this.lastTocBlock = node;
    }

    private void render(SimTocBlock node, DocxRendererContext docx) {
        this.lastTocBlock = node;
    }

    private void render(EnumeratedReferenceText node, DocxRendererContext docx) {
        String text = node.getText().toString();
        if (text.isEmpty()) {
            if (this.ordinalRunnable != null) {
                this.ordinalRunnable.run();
            }
        } else {
            Node parent;
            String type = EnumeratedReferenceRepository.getType((String)text.toString());
            if ((type.isEmpty() || text.equals(type + ":")) && (parent = node.getAncestorOfType(new Class[]{Heading.class})) instanceof Heading) {
                text = (type.isEmpty() ? text : type) + ":" + this.headerIdGenerator.getId(parent);
            }
            this.enumeratedOrdinals.renderReferenceOrdinals(text, (EnumeratedOrdinalRenderer)new OrdinalRenderer(this, docx));
        }
    }

    private void render(EnumeratedReferenceLink node, final DocxRendererContext docx) {
        String text = node.getText().toString();
        if (text.isEmpty()) {
            if (this.ordinalRunnable != null) {
                this.ordinalRunnable.run();
            }
        } else {
            final EnumeratedReferenceRendering[] renderings = this.enumeratedOrdinals.getEnumeratedReferenceOrdinals(text);
            String title = new EnumRefTextCollectingVisitor().collectAndGetText(node.getChars().getBaseSequence(), renderings, null);
            Attributes attributes = new Attributes();
            if (title != null) {
                attributes.replaceValue((CharSequence)"title", (CharSequence)title);
            }
            attributes = docx.extendRenderingNodeAttributes(AttributablePart.NODE, attributes);
            this.renderURL(node.getText(), docx, "#" + text, attributes, new Runnable(){

                @Override
                public void run() {
                    EnumeratedReferences.renderReferenceOrdinals((EnumeratedReferenceRendering[])renderings, (EnumeratedOrdinalRenderer)new OrdinalRenderer(CoreNodeDocxRenderer.this, docx));
                }
            });
        }
    }

    private void render(EnumeratedReferenceBlock node, DocxRendererContext docx) {
    }

    private void render(AttributesNode node, DocxRendererContext docx) {
    }

    private static class TableCellParaContainer
    implements ParaContainer {
        private final TableCell myNode;
        private final Tc myTc;
        private final DocxRendererContext myDocx;
        private final boolean[] myFirstP;

        public TableCellParaContainer(TableCell node, Tc tc, DocxRendererContext docx, boolean[] firstP) {
            this.myNode = node;
            this.myTc = tc;
            this.myDocx = docx;
            this.myFirstP = firstP;
        }

        @Override
        public void addP(P p) {
            this.myFirstP[0] = false;
            this.myTc.getContent().add(p);
        }

        @Override
        public P getLastP() {
            List content = this.myTc.getContent();
            if (this.myFirstP[0] && (content == null || content.size() == 0)) {
                P p = this.myDocx.createP();
                PPr ppr = p.getPPr();
                if (this.myNode.getAlignment() != null) {
                    JcEnumeration alignValue = CoreNodeDocxRenderer.getAlignValue(this.myNode.getAlignment());
                    Jc jc3 = this.myDocx.getFactory().createJc();
                    ppr.setJc(jc3);
                    jc3.setVal(alignValue);
                }
                this.myFirstP[0] = false;
            }
            if (content == null || content.size() == 0) {
                return null;
            }
            Object o = content.get(content.size() - 1);
            return o instanceof P ? (P)o : null;
        }
    }

    private static class TableCellContentContainer
    implements ContentContainer {
        private final Tc myTc;
        private final DocxRendererContext myDocx;
        private final Part myContainerPart;
        private final boolean[] myFirstP;

        public TableCellContentContainer(Tc tc, DocxRendererContext docx, boolean[] firstP) {
            this.myTc = tc;
            this.myDocx = docx;
            this.myFirstP = firstP;
            this.myContainerPart = this.myDocx.getContainerPart();
        }

        @Override
        public List<Object> getContent() {
            return this.myTc.getContent();
        }

        @Override
        public RelationshipsPart getRelationshipsPart() {
            return this.myContainerPart.relationships;
        }

        @Override
        public Part getContainerPart() {
            return this.myContainerPart;
        }

        @Override
        public Object getLastContentElement() {
            List content = this.myTc.getContent();
            return content != null && content.size() > 0 ? content.get(content.size() - 1) : null;
        }

        @Override
        public void addContentElement(Object element) {
            this.myTc.getContent().add(element);
            this.myFirstP[0] = false;
        }
    }

    private static class TableCaptionRenderer
    implements Runnable {
        private final DocxRendererContext myDocx;
        private final TableCaption myNode;

        public TableCaptionRenderer(DocxRendererContext docx, TableCaption node) {
            this.myDocx = docx;
            this.myNode = node;
        }

        @Override
        public void run() {
            this.myDocx.setBlockFormatProvider(new BlockFormatProviderBase<Node>(this.myDocx, this.myDocx.getDocxRendererOptions().TABLE_CAPTION));
            this.myDocx.createP();
            this.myDocx.renderChildren((Node)this.myNode);
        }
    }

    private static class FootnoteFrame
    implements Runnable {
        final DocxRendererContext myDocx;
        final CTFtnEdn myFtnEdn;
        private final FootnoteBlock myFootnoteBlock;

        public FootnoteFrame(DocxRendererContext docx, CTFtnEdn ftnEdn, FootnoteBlock footnoteBlock) {
            this.myDocx = docx;
            this.myFtnEdn = ftnEdn;
            this.myFootnoteBlock = footnoteBlock;
        }

        @Override
        public void run() {
            this.myDocx.setBlockFormatProvider(new FootnoteBlockFormatProvider<Node>(this.myDocx));
            this.myDocx.setRunFormatProvider(new FootnoteRunFormatProvider<Node>(this.myDocx));
            this.myDocx.setParaContainer(new ParaContainer(){

                @Override
                public void addP(P p) {
                    FootnoteFrame.this.myFtnEdn.getContent().add(p);
                }

                @Override
                public P getLastP() {
                    List content = FootnoteFrame.this.myFtnEdn.getContent();
                    if (content == null || content.size() == 0) {
                        return null;
                    }
                    Object o = content.get(content.size() - 1);
                    return o instanceof P ? (P)o : null;
                }
            });
            this.myDocx.setContentContainer(new ContentContainer(){

                @Override
                public RelationshipsPart getRelationshipsPart() {
                    try {
                        return FootnoteFrame.this.myDocx.getFootnotesPart().getRelationshipsPart();
                    }
                    catch (Docx4JException e) {
                        e.printStackTrace();
                        return FootnoteFrame.this.myDocx.getDocxDocument().getRelationshipsPart();
                    }
                }

                @Override
                public Part getContainerPart() {
                    try {
                        return FootnoteFrame.this.myDocx.getFootnotesPart();
                    }
                    catch (Docx4JException e) {
                        e.printStackTrace();
                        return FootnoteFrame.this.myDocx.getDocxDocument();
                    }
                }

                @Override
                public List<Object> getContent() {
                    return FootnoteFrame.this.myFtnEdn.getContent();
                }

                @Override
                public Object getLastContentElement() {
                    List<Object> content = this.getContent();
                    return content != null && content.size() > 0 ? content.get(content.size() - 1) : null;
                }

                @Override
                public void addContentElement(Object element) {
                    this.getContent().add(element);
                }
            });
            this.myDocx.renderChildren((Node)this.myFootnoteBlock);
        }
    }

    private static class ChildRenderer
    implements Runnable {
        private final DocxRendererContext myDocx;
        private final Node myNode;

        public ChildRenderer(DocxRendererContext docx, Node node) {
            this.myDocx = docx;
            this.myNode = node;
        }

        @Override
        public void run() {
            this.myDocx.renderChildren(this.myNode);
        }
    }

    private static class UrlRunContainer
    implements RunContainer {
        private final P.Hyperlink myHyperlink;

        public UrlRunContainer(P.Hyperlink hyperlink) {
            this.myHyperlink = hyperlink;
        }

        @Override
        public void addR(R r) {
            this.myHyperlink.getContent().add(r);
        }

        @Override
        public R getLastR() {
            List content = this.myHyperlink.getContent();
            if (content == null || content.size() == 0) {
                return null;
            }
            Object o = content.get(content.size() - 1);
            return o instanceof R ? (R)o : null;
        }
    }

    private static class UrlRenderer
    implements Runnable {
        private final DocxRendererContext myDocx;
        private final String myLinkText;
        private final String myLinkUrl;

        public UrlRenderer(DocxRendererContext docx, String linkText, String linkUrl) {
            this.myDocx = docx;
            this.myLinkText = linkText;
            this.myLinkUrl = linkUrl;
        }

        @Override
        public void run() {
            this.myDocx.text(this.myLinkText == null ? this.myLinkUrl : this.myLinkText);
        }
    }

    private static class OrdinalRenderer
    implements EnumeratedOrdinalRenderer {
        final CoreNodeDocxRenderer renderer;
        final DocxRendererContext docx;

        public OrdinalRenderer(CoreNodeDocxRenderer renderer, DocxRendererContext docx) {
            this.renderer = renderer;
            this.docx = docx;
        }

        public void startRendering(EnumeratedReferenceRendering[] renderings) {
        }

        public void setEnumOrdinalRunnable(Runnable runnable) {
            this.renderer.ordinalRunnable = runnable;
        }

        public Runnable getEnumOrdinalRunnable() {
            return this.renderer.ordinalRunnable;
        }

        public void render(final int referenceOrdinal, EnumeratedReferenceBlock referenceFormat, String defaultText, final boolean needSeparator) {
            final Runnable compoundRunnable = this.renderer.ordinalRunnable;
            if (referenceFormat != null) {
                this.renderer.ordinalRunnable = new Runnable(){

                    @Override
                    public void run() {
                        if (compoundRunnable != null) {
                            compoundRunnable.run();
                        }
                        OrdinalRenderer.this.docx.text(String.valueOf(referenceOrdinal));
                        if (needSeparator) {
                            OrdinalRenderer.this.docx.text(".");
                        }
                    }
                };
                this.docx.renderChildren((Node)referenceFormat);
            } else if (compoundRunnable != null) {
                this.docx.text(defaultText + " ");
                if (compoundRunnable != null) {
                    compoundRunnable.run();
                }
                this.docx.text(referenceOrdinal + (needSeparator ? "." : ""));
            } else {
                this.docx.text(defaultText + " " + referenceOrdinal + (needSeparator ? "." : ""));
            }
        }

        public void endRendering() {
        }
    }
}

