/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.docx.converter.util;

import com.vladsch.flexmark.docx.converter.internal.DocxRendererOptions;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.docx4j.model.PropertyResolver;
import org.docx4j.model.styles.StyleUtil;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.wml.CTBorder;
import org.docx4j.wml.CTCnf;
import org.docx4j.wml.CTEastAsianLayout;
import org.docx4j.wml.CTEm;
import org.docx4j.wml.CTFitText;
import org.docx4j.wml.CTFramePr;
import org.docx4j.wml.CTLanguage;
import org.docx4j.wml.CTShd;
import org.docx4j.wml.CTSignedHpsMeasure;
import org.docx4j.wml.CTSignedTwipsMeasure;
import org.docx4j.wml.CTTextEffect;
import org.docx4j.wml.CTTextScale;
import org.docx4j.wml.CTTextboxTightWrap;
import org.docx4j.wml.CTTrackChange;
import org.docx4j.wml.CTTrackChangeNumbering;
import org.docx4j.wml.CTVerticalAlignRun;
import org.docx4j.wml.Color;
import org.docx4j.wml.Highlight;
import org.docx4j.wml.HpsMeasure;
import org.docx4j.wml.Jc;
import org.docx4j.wml.Numbering;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.ParaRPr;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.RPr;
import org.docx4j.wml.RPrAbstract;
import org.docx4j.wml.RStyle;
import org.docx4j.wml.Style;
import org.docx4j.wml.Tabs;
import org.docx4j.wml.TextDirection;
import org.docx4j.wml.U;

public class DocxHelper {
    protected final WordprocessingMLPackage myPackage;
    protected final MainDocumentPart myDocumentPart;
    protected final ObjectFactory myFactory;
    protected PropertyResolver myResolver;
    protected final HashMap<String, BigInteger> myNumPrColorMap;
    protected final DocxRendererOptions myOptions;

    public DocxHelper(WordprocessingMLPackage mlPackage, ObjectFactory factory, DocxRendererOptions options) {
        this.myPackage = mlPackage;
        this.myFactory = factory;
        this.myOptions = options;
        this.myDocumentPart = mlPackage.getMainDocumentPart();
        this.myNumPrColorMap = new HashMap();
    }

    public Style getStyle(String styleId) {
        return this.myDocumentPart.getStyleDefinitionsPart().getStyleById(styleId);
    }

    public PropertyResolver getResolver() {
        if (this.myResolver == null) {
            try {
                this.myResolver = new PropertyResolver(this.myPackage);
            }
            catch (Docx4JException e) {
                e.printStackTrace();
            }
        }
        return this.myResolver;
    }

    public static BigInteger safeBigInt(BigInteger value) {
        return value == null ? BigInteger.ZERO : value;
    }

    public static BigInteger safeBigInt(BigInteger value, long nullValue) {
        return value == null ? BigInteger.valueOf(nullValue) : value;
    }

    public ObjectFactory getFactory() {
        return this.myFactory;
    }

    public void combine(PPrBase.Ind child, PPrBase.Ind parent, CombineBigInt left, CombineBigInt right) {
        if (parent != null) {
            child.setLeft(left.combine(child.getLeft(), parent.getLeft(), parent.getHanging()));
            child.setRight(right.combine(child.getRight(), parent.getRight(), parent.getHanging()));
        }
    }

    public void inheritInd(PPrBase child, PPrBase parent, CombineBigInt left, CombineBigInt right) {
        this.combine(child.getInd(), parent.getInd(), left, right);
    }

    public boolean has(Object value) {
        return value != null;
    }

    public BigInteger safeIndLeft(PPrBase pPrBase) {
        return pPrBase == null ? BigInteger.ZERO : this.safeIndLeft(pPrBase.getInd());
    }

    public BigInteger safeIndLeft(PPrBase pPrBase, long nullValue) {
        return pPrBase == null ? BigInteger.valueOf(nullValue) : this.safeIndLeft(pPrBase.getInd());
    }

    public BigInteger safeIndLeft(PPrBase.Ind ind) {
        return ind == null || ind.getLeft() == null ? BigInteger.ZERO : ind.getLeft();
    }

    public BigInteger safeIndLeft(PPrBase.Ind ind, long nullValue) {
        return ind == null || ind.getLeft() == null ? BigInteger.valueOf(nullValue) : ind.getLeft();
    }

    public BigInteger safeIndRight(PPrBase pPrBase) {
        return pPrBase == null ? BigInteger.ZERO : this.safeIndRight(pPrBase.getInd());
    }

    public BigInteger safeIndRight(PPrBase pPrBase, long nullValue) {
        return pPrBase == null ? BigInteger.valueOf(nullValue) : this.safeIndRight(pPrBase.getInd());
    }

    public BigInteger safeIndRight(PPrBase.Ind ind) {
        return ind == null || ind.getRight() == null ? BigInteger.ZERO : ind.getRight();
    }

    public BigInteger safeIndRight(PPrBase.Ind ind, long nullValue) {
        return ind == null || ind.getRight() == null ? BigInteger.valueOf(nullValue) : ind.getRight();
    }

    public BigInteger safeIndHanging(PPrBase pPrBase) {
        return pPrBase == null ? BigInteger.ZERO : this.safeIndHanging(pPrBase.getInd());
    }

    public BigInteger safeIndHanging(PPrBase pPrBase, long nullValue) {
        return pPrBase == null ? BigInteger.valueOf(nullValue) : this.safeIndHanging(pPrBase.getInd());
    }

    public BigInteger safeIndHanging(PPrBase.Ind ind) {
        return ind == null || ind.getHanging() == null ? BigInteger.ZERO : ind.getHanging();
    }

    public BigInteger safeIndHanging(PPrBase.Ind ind, long nullValue) {
        return ind == null || ind.getHanging() == null ? BigInteger.valueOf(nullValue) : ind.getHanging();
    }

    public BigInteger safeSpacingBefore(PPr pPr) {
        return pPr == null ? BigInteger.ZERO : this.safeSpacingBefore(pPr.getSpacing());
    }

    public BigInteger safeSpacingBefore(PPr pPr, long nullValue) {
        return pPr == null ? BigInteger.valueOf(nullValue) : this.safeSpacingBefore(pPr.getSpacing());
    }

    public BigInteger safeSpacingBefore(PPrBase.Spacing spacing) {
        return spacing == null || spacing.getBefore() == null ? BigInteger.ZERO : spacing.getBefore();
    }

    public BigInteger safeSpacingBefore(PPrBase.Spacing spacing, long nullValue) {
        return spacing == null || spacing.getBefore() == null ? BigInteger.valueOf(nullValue) : spacing.getBefore();
    }

    public BigInteger safeSpacingAfter(PPr pPr) {
        return pPr == null ? BigInteger.ZERO : this.safeSpacingAfter(pPr.getSpacing());
    }

    public BigInteger safeSpacingAfter(PPr pPr, long nullValue) {
        return pPr == null ? BigInteger.valueOf(nullValue) : this.safeSpacingAfter(pPr.getSpacing());
    }

    public BigInteger safeSpacingAfter(PPrBase.Spacing spacing) {
        return spacing == null || spacing.getAfter() == null ? BigInteger.ZERO : spacing.getAfter();
    }

    public BigInteger safeSpacingAfter(PPrBase.Spacing spacing, long nullValue) {
        return spacing == null || spacing.getAfter() == null ? BigInteger.valueOf(nullValue) : spacing.getAfter();
    }

    public BigInteger safeSpacingLine(PPr pPr) {
        return pPr == null ? BigInteger.ZERO : this.safeSpacingLine(pPr.getSpacing());
    }

    public BigInteger safeSpacingLine(PPr pPr, long nullValue) {
        return pPr == null ? BigInteger.valueOf(nullValue) : this.safeSpacingLine(pPr.getSpacing());
    }

    public BigInteger safeSpacingLine(PPrBase.Spacing spacing) {
        return spacing == null || spacing.getLine() == null ? BigInteger.ZERO : spacing.getLine();
    }

    public BigInteger safeSpacingLine(PPrBase.Spacing spacing, long nullValue) {
        return spacing == null || spacing.getLine() == null ? BigInteger.valueOf(nullValue) : spacing.getLine();
    }

    public PPrBase.PBdr ensurePBdr(PPrBase pPrBase) {
        if (pPrBase.getPBdr() == null) {
            PPrBase.PBdr pBdr = this.myFactory.createPPrBasePBdr();
            pPrBase.setPBdr(pBdr);
        }
        return pPrBase.getPBdr();
    }

    public PPrBase.Ind ensureInd(PPrBase pPrBase) {
        if (pPrBase.getInd() == null) {
            PPrBase.Ind ind = this.myFactory.createPPrBaseInd();
            pPrBase.setInd(ind);
        }
        return pPrBase.getInd();
    }

    public PPrBase.Spacing ensureSpacing(PPrBase pPrBase) {
        if (pPrBase.getSpacing() == null) {
            PPrBase.Spacing spacing = this.myFactory.createPPrBaseSpacing();
            pPrBase.setSpacing(spacing);
        }
        return pPrBase.getSpacing();
    }

    public void inheritPBdr(PPr child, PPr parent) {
        parent = this.getResolver().getEffectivePPr(parent);
        PPr styledChild = this.getResolver().getEffectivePPr(child);
        if (this.has(parent.getPBdr()) && (!this.has(styledChild.getPBdr()) || !this.has(styledChild.getPBdr().getLeft()) && this.has(parent.getPBdr().getLeft()))) {
            BigInteger indentDiff;
            PPrBase.Ind ndpInd;
            NumberingDefinitionsPart ndp;
            PPrBase.Ind cInd = this.getCopy(styledChild.getInd(), true);
            PPrBase.Ind pInd = this.getCopy(parent.getInd(), false);
            CTBorder leftBorder = this.getCopy(parent.getPBdr().getLeft(), true);
            PPrBase.NumPr numPr = styledChild.getNumPr();
            if (numPr != null && (ndp = this.myDocumentPart.getNumberingDefinitionsPart()) != null && (ndpInd = ndp.getInd(numPr)) != null) {
                if (cInd.getLeft() == null && ndpInd.getLeft() != null) {
                    cInd.setLeft(ndpInd.getLeft());
                }
                if (cInd.getRight() == null && ndpInd.getRight() != null) {
                    cInd.setRight(ndpInd.getRight());
                }
                if (cInd.getHanging() == null && ndpInd.getHanging() != null) {
                    cInd.setHanging(ndpInd.getHanging());
                }
            }
            if ((indentDiff = this.safeIndLeft(cInd).subtract(this.safeIndHanging(cInd)).subtract(this.safeIndLeft(pInd))).compareTo(BigInteger.ZERO) > 0) {
                BigInteger[] divideAndRemainder = indentDiff.divideAndRemainder(BigInteger.valueOf(20L));
                BigInteger space = DocxHelper.safeBigInt(leftBorder.getSpace()).add(divideAndRemainder[0]).min(BigInteger.valueOf(31L));
                leftBorder.setSpace(space);
                int remainder = divideAndRemainder[1].intValue();
                if (remainder > 0) {
                    this.ensureInd((PPrBase)child);
                    child.getInd().setLeft(BigInteger.ZERO.max(this.safeIndLeft(cInd).subtract(BigInteger.valueOf(remainder))));
                }
            }
            this.ensurePBdr((PPrBase)child).setLeft(leftBorder);
        }
    }

    public void inheritInd(PPr child, PPr parent) {
        if (parent != null && this.has(parent.getInd())) {
            PPrBase.Ind ndpInd;
            NumberingDefinitionsPart ndp;
            PPrBase.NumPr numPr;
            PPr styledChild = this.getResolver().getEffectivePPr(child);
            PPrBase.Ind cInd = this.getCopy(styledChild == null ? null : styledChild.getInd(), true);
            PPrBase.Ind pInd = parent.getInd();
            PPrBase.NumPr numPr2 = numPr = styledChild == null ? null : styledChild.getNumPr();
            if (numPr != null && (ndp = this.myDocumentPart.getNumberingDefinitionsPart()) != null && (ndpInd = ndp.getInd(numPr)) != null) {
                if (cInd.getLeft() == null && ndpInd.getLeft() != null) {
                    cInd.setLeft(ndpInd.getLeft());
                }
                if (cInd.getRight() == null && ndpInd.getRight() != null) {
                    cInd.setRight(ndpInd.getRight());
                }
                if (cInd.getHanging() == null && ndpInd.getHanging() != null) {
                    cInd.setHanging(ndpInd.getHanging());
                }
            }
            this.combine(cInd, pInd, CombineBigInt.ADD, CombineBigInt.NONE);
            cInd = this.keepDiff(cInd, styledChild == null ? null : styledChild.getInd());
            child.setInd(cInd);
        }
    }

    public BigInteger getNumPrFor(BigInteger baseNumID, Color color) {
        RPr rPr = this.getResolver().getEffectiveRPr(this.myOptions.PREFORMATTED_TEXT_STYLE);
        if (rPr != null && rPr.getColor() != null && this.keepDiff(rPr.getColor(), color) == null) {
            return baseNumID;
        }
        String colorID = String.format("%s:%s", baseNumID.toString(), color.getVal());
        BigInteger numID = this.myNumPrColorMap.get(colorID);
        if (numID != null) {
            return numID;
        }
        NumberingDefinitionsPart ndp = this.myDocumentPart.getNumberingDefinitionsPart();
        try {
            Numbering numbering = (Numbering)ndp.getContents();
            List num = numbering.getNum();
            List abstractNumList = numbering.getAbstractNum();
            for (Numbering.AbstractNum abstractNum : abstractNumList) {
                if (abstractNum.getAbstractNumId().compareTo(baseNumID) != 0) continue;
            }
            return null;
        }
        catch (Docx4JException e) {
            e.printStackTrace();
            return null;
        }
    }

    public PPr getExplicitPPr(PPr pPr) {
        return this.getResolver().getEffectivePPr(pPr);
    }

    public RPr getExplicitRPr(RPrAbstract rPr, PPr pPr) {
        RPr copyRPr = this.myFactory.createRPr();
        this.setRPr((RPrAbstract)copyRPr, rPr, false);
        return this.getResolver().getEffectiveRPr(copyRPr, pPr);
    }

    public RPr getExplicitRPr(RPr rPr) {
        int iMax;
        RPr styledRPr = this.myFactory.createRPr();
        ArrayList<Style> styles = new ArrayList<Style>();
        RStyle pStyle = rPr.getRStyle();
        if (pStyle != null) {
            String styleId = pStyle.getVal();
            Style style = this.getStyle(styleId);
            while (style != null) {
                styles.add(style);
                Style.BasedOn basedOn = style.getBasedOn();
                style = null;
                if (basedOn == null || (styleId = basedOn.getVal()) == null) continue;
                style = this.getStyle(basedOn.getVal());
            }
        }
        int i = iMax = styles.size();
        while (i-- > 0) {
            Style style = (Style)styles.get(i);
            StyleUtil.apply((RPr)style.getRPr(), (RPr)styledRPr);
        }
        StyleUtil.apply((RPr)rPr, (RPr)styledRPr);
        return styledRPr;
    }

    public PPrBase.Ind getCopy(PPrBase.Ind copy, boolean whenNull) {
        if (copy != null) {
            PPrBase.Ind result = this.myFactory.createPPrBaseInd();
            result.setLeft(copy.getLeft());
            result.setLeftChars(copy.getLeftChars());
            result.setRight(copy.getRight());
            result.setRightChars(copy.getRightChars());
            result.setHanging(copy.getHanging());
            result.setHangingChars(copy.getHangingChars());
            result.setFirstLine(copy.getFirstLine());
            result.setFirstLineChars(copy.getFirstLineChars());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createPPrBaseInd();
        }
        return null;
    }

    public PPrBase.Spacing getCopy(PPrBase.Spacing copy, boolean whenNull) {
        if (copy != null) {
            PPrBase.Spacing result = this.myFactory.createPPrBaseSpacing();
            result.setAfter(copy.getAfter());
            result.setAfterLines(copy.getAfterLines());
            result.setBefore(copy.getBefore());
            result.setBeforeLines(copy.getBeforeLines());
            result.setLine(copy.getLine());
            result.setAfterAutospacing(Boolean.valueOf(copy.isAfterAutospacing()));
            result.setBeforeAutospacing(Boolean.valueOf(copy.isBeforeAutospacing()));
            result.setLineRule(copy.getLineRule());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createPPrBaseSpacing();
        }
        return null;
    }

    public PPrBase.NumPr.Ilvl getCopy(PPrBase.NumPr.Ilvl copy, boolean whenNull) {
        if (copy != null) {
            PPrBase.NumPr.Ilvl result = this.myFactory.createPPrBaseNumPrIlvl();
            result.setVal(copy.getVal());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createPPrBaseNumPrIlvl();
        }
        return null;
    }

    public PPrBase.NumPr.NumId getCopy(PPrBase.NumPr.NumId copy, boolean whenNull) {
        if (copy != null) {
            PPrBase.NumPr.NumId result = this.myFactory.createPPrBaseNumPrNumId();
            result.setVal(copy.getVal());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createPPrBaseNumPrNumId();
        }
        return null;
    }

    public CTTrackChangeNumbering getCopy(CTTrackChangeNumbering copy, boolean whenNull) {
        if (copy != null) {
            CTTrackChangeNumbering result = this.myFactory.createCTTrackChangeNumbering();
            result.setOriginal(copy.getOriginal());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createCTTrackChangeNumbering();
        }
        return null;
    }

    public CTTrackChange getCopy(CTTrackChange copy, boolean whenNull) {
        if (copy != null) {
            CTTrackChange result = this.myFactory.createCTTrackChange();
            result.setDate((XMLGregorianCalendar)copy.getDate().clone());
            result.setAuthor(copy.getAuthor());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createCTTrackChange();
        }
        return null;
    }

    public PPrBase.NumPr getCopy(PPrBase.NumPr copy, boolean whenNull) {
        if (copy != null) {
            PPrBase.NumPr result = this.myFactory.createPPrBaseNumPr();
            result.setIlvl(this.getCopy(copy.getIlvl(), whenNull));
            result.setNumId(this.getCopy(copy.getNumId(), whenNull));
            result.setNumberingChange(this.getCopy(copy.getNumberingChange(), whenNull));
            result.setIns(this.getCopy(copy.getIns(), whenNull));
            return result;
        }
        if (whenNull) {
            PPrBase.NumPr result = this.myFactory.createPPrBaseNumPr();
            result.setIlvl(this.getCopy((PPrBase.NumPr.Ilvl)null, whenNull));
            result.setNumId(this.getCopy((PPrBase.NumPr.NumId)null, whenNull));
            result.setNumberingChange(this.getCopy((CTTrackChangeNumbering)null, whenNull));
            result.setIns(this.getCopy((CTTrackChange)null, whenNull));
            return result;
        }
        return null;
    }

    public CTBorder getCopy(CTBorder copy, boolean whenNull) {
        if (copy != null) {
            CTBorder result = this.myFactory.createCTBorder();
            result.setVal(copy.getVal());
            result.setThemeColor(copy.getThemeColor());
            result.setSpace(copy.getSpace());
            result.setSz(copy.getSz());
            result.setFrame(Boolean.valueOf(copy.isFrame()));
            result.setShadow(Boolean.valueOf(copy.isShadow()));
            result.setColor(copy.getColor());
            result.setThemeShade(copy.getThemeShade());
            result.setThemeTint(copy.getThemeTint());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createCTBorder();
        }
        return null;
    }

    public PPrBase.PBdr getCopy(PPrBase.PBdr copy, boolean whenNull) {
        if (copy != null) {
            PPrBase.PBdr result = this.myFactory.createPPrBasePBdr();
            result.setTop(this.getCopy(copy.getTop(), whenNull));
            result.setLeft(this.getCopy(copy.getLeft(), whenNull));
            result.setBottom(this.getCopy(copy.getBottom(), whenNull));
            result.setRight(this.getCopy(copy.getRight(), whenNull));
            result.setBetween(this.getCopy(copy.getBetween(), whenNull));
            result.setBar(this.getCopy(copy.getBar(), whenNull));
            return result;
        }
        if (whenNull) {
            PPrBase.PBdr result = this.myFactory.createPPrBasePBdr();
            result.setTop(this.getCopy((CTBorder)null, whenNull));
            result.setLeft(this.getCopy((CTBorder)null, whenNull));
            result.setBottom(this.getCopy((CTBorder)null, whenNull));
            result.setRight(this.getCopy((CTBorder)null, whenNull));
            result.setBetween(this.getCopy((CTBorder)null, whenNull));
            result.setBar(this.getCopy((CTBorder)null, whenNull));
            return result;
        }
        return null;
    }

    public PPrBase.PStyle getCopy(PPrBase.PStyle copy, boolean whenNull) {
        if (copy != null) {
            PPrBase.PStyle result = this.myFactory.createPPrBasePStyle();
            result.setVal(copy.getVal());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createPPrBasePStyle();
        }
        return null;
    }

    public CTFramePr getCopy(CTFramePr copy, boolean whenNull) {
        if (copy != null) {
            CTFramePr result = this.myFactory.createCTFramePr();
            result.setDropCap(copy.getDropCap());
            result.setLines(copy.getLines());
            result.setW(copy.getW());
            result.setH(copy.getH());
            result.setVSpace(copy.getVSpace());
            result.setHSpace(copy.getHSpace());
            result.setWrap(copy.getWrap());
            result.setHAnchor(copy.getHAnchor());
            result.setVAnchor(copy.getVAnchor());
            result.setX(copy.getX());
            result.setXAlign(copy.getXAlign());
            result.setY(copy.getY());
            result.setYAlign(copy.getYAlign());
            result.setHRule(copy.getHRule());
            result.setAnchorLock(Boolean.valueOf(copy.isAnchorLock()));
            return result;
        }
        if (whenNull) {
            return this.myFactory.createCTFramePr();
        }
        return null;
    }

    public CTShd getCopy(CTShd copy, boolean whenNull) {
        if (copy != null) {
            CTShd result = this.myFactory.createCTShd();
            result.setVal(copy.getVal());
            result.setColor(copy.getColor());
            result.setThemeColor(copy.getThemeColor());
            result.setThemeTint(copy.getThemeTint());
            result.setThemeShade(copy.getThemeShade());
            result.setFill(copy.getFill());
            result.setThemeFill(copy.getThemeFill());
            result.setThemeFillTint(copy.getThemeFillTint());
            result.setThemeFillShade(copy.getThemeFillShade());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createCTShd();
        }
        return null;
    }

    public Tabs getCopy(Tabs copy, boolean whenNull) {
        if (copy != null) {
            Tabs result = this.myFactory.createTabs();
            result.getTab().addAll(copy.getTab());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createTabs();
        }
        return null;
    }

    public Jc getCopy(Jc copy, boolean whenNull) {
        if (copy != null) {
            Jc result = this.myFactory.createJc();
            result.setVal(copy.getVal());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createJc();
        }
        return null;
    }

    public TextDirection getCopy(TextDirection copy, boolean whenNull) {
        if (copy != null) {
            TextDirection result = this.myFactory.createTextDirection();
            result.setVal(copy.getVal());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createTextDirection();
        }
        return null;
    }

    public PPrBase.TextAlignment getCopy(PPrBase.TextAlignment copy, boolean whenNull) {
        if (copy != null) {
            PPrBase.TextAlignment result = this.myFactory.createPPrBaseTextAlignment();
            result.setVal(copy.getVal());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createPPrBaseTextAlignment();
        }
        return null;
    }

    public CTTextboxTightWrap getCopy(CTTextboxTightWrap copy, boolean whenNull) {
        if (copy != null) {
            CTTextboxTightWrap result = this.myFactory.createCTTextboxTightWrap();
            result.setVal(copy.getVal());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createCTTextboxTightWrap();
        }
        return null;
    }

    public PPrBase.OutlineLvl getCopy(PPrBase.OutlineLvl copy, boolean whenNull) {
        if (copy != null) {
            PPrBase.OutlineLvl result = this.myFactory.createPPrBaseOutlineLvl();
            result.setVal(copy.getVal());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createPPrBaseOutlineLvl();
        }
        return null;
    }

    public PPrBase.DivId getCopy(PPrBase.DivId copy, boolean whenNull) {
        if (copy != null) {
            PPrBase.DivId result = this.myFactory.createPPrBaseDivId();
            result.setVal(copy.getVal());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createPPrBaseDivId();
        }
        return null;
    }

    public CTCnf getCopy(CTCnf copy, boolean whenNull) {
        if (copy != null) {
            CTCnf result = this.myFactory.createCTCnf();
            result.setVal(copy.getVal());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createCTCnf();
        }
        return null;
    }

    public PPrBase getCopy(PPrBase copy, boolean whenNull) {
        if (copy != null) {
            PPrBase result = this.myFactory.createPPrBase();
            this.setPPrBase(result, copy, whenNull);
            return result;
        }
        if (whenNull) {
            PPrBase result = this.myFactory.createPPrBase();
            result.setPStyle(this.getCopy((PPrBase.PStyle)null, whenNull));
            result.setFramePr(this.getCopy((CTFramePr)null, whenNull));
            result.setNumPr(this.getCopy((PPrBase.NumPr)null, whenNull));
            result.setPBdr(this.getCopy((PPrBase.PBdr)null, whenNull));
            result.setShd(this.getCopy((CTShd)null, whenNull));
            result.setTabs(this.getCopy((Tabs)null, whenNull));
            result.setSpacing(this.getCopy((PPrBase.Spacing)null, whenNull));
            result.setInd(this.getCopy((PPrBase.Ind)null, whenNull));
            result.setJc(this.getCopy((Jc)null, whenNull));
            result.setTextDirection(this.getCopy((TextDirection)null, whenNull));
            result.setTextAlignment(this.getCopy((PPrBase.TextAlignment)null, whenNull));
            result.setTextboxTightWrap(this.getCopy((CTTextboxTightWrap)null, whenNull));
            result.setOutlineLvl(this.getCopy((PPrBase.OutlineLvl)null, whenNull));
            result.setDivId(this.getCopy((PPrBase.DivId)null, whenNull));
            result.setCnfStyle(this.getCopy((CTCnf)null, whenNull));
            return result;
        }
        return null;
    }

    public ParaRPr getCopy(ParaRPr copy, boolean whenNull) {
        if (copy != null) {
            ParaRPr result = this.myFactory.createParaRPr();
            result.setIns(this.getCopy(copy.getIns(), whenNull));
            result.setDel(this.getCopy(copy.getDel(), whenNull));
            result.setMoveFrom(this.getCopy(copy.getMoveFrom(), whenNull));
            result.setMoveTo(this.getCopy(copy.getMoveTo(), whenNull));
            this.setRPr((RPrAbstract)result, (RPrAbstract)copy, whenNull);
            return result;
        }
        if (whenNull) {
            ParaRPr result = this.myFactory.createParaRPr();
            result.setIns(this.getCopy((CTTrackChange)null, whenNull));
            result.setDel(this.getCopy((CTTrackChange)null, whenNull));
            result.setMoveFrom(this.getCopy((CTTrackChange)null, whenNull));
            result.setMoveTo(this.getCopy((CTTrackChange)null, whenNull));
            this.setRPr((RPrAbstract)result, (RPrAbstract)copy, whenNull);
            return result;
        }
        return null;
    }

    public RPr getCopy(RPr copy, boolean whenNull) {
        if (copy != null) {
            RPr result = this.myFactory.createRPr();
            this.setRPr((RPrAbstract)result, (RPrAbstract)copy, whenNull);
            return result;
        }
        if (whenNull) {
            RPr result = this.myFactory.createRPr();
            this.setRPr((RPrAbstract)result, (RPrAbstract)copy, whenNull);
            return result;
        }
        return null;
    }

    public RStyle getCopy(RStyle copy, boolean whenNull) {
        if (copy != null) {
            RStyle result = this.myFactory.createRStyle();
            result.setVal(copy.getVal());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createRStyle();
        }
        return null;
    }

    public RFonts getCopy(RFonts copy, boolean whenNull) {
        if (copy != null) {
            RFonts result = this.myFactory.createRFonts();
            result.setHint(copy.getHint());
            result.setAscii(copy.getAscii());
            result.setHAnsi(copy.getHAnsi());
            result.setEastAsia(copy.getEastAsia());
            result.setCs(copy.getCs());
            result.setAsciiTheme(copy.getAsciiTheme());
            result.setHAnsiTheme(copy.getHAnsiTheme());
            result.setEastAsiaTheme(copy.getEastAsiaTheme());
            result.setCstheme(copy.getCstheme());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createRFonts();
        }
        return null;
    }

    public Color getCopy(Color copy, boolean whenNull) {
        if (copy != null) {
            Color result = this.myFactory.createColor();
            result.setVal(copy.getVal());
            result.setThemeColor(copy.getThemeColor());
            result.setThemeTint(copy.getThemeTint());
            result.setThemeShade(copy.getThemeShade());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createColor();
        }
        return null;
    }

    public CTSignedTwipsMeasure getCopy(CTSignedTwipsMeasure copy, boolean whenNull) {
        if (copy != null) {
            CTSignedTwipsMeasure result = this.myFactory.createCTSignedTwipsMeasure();
            result.setVal(copy.getVal());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createCTSignedTwipsMeasure();
        }
        return null;
    }

    public CTTextScale getCopy(CTTextScale copy, boolean whenNull) {
        if (copy != null) {
            CTTextScale result = this.myFactory.createCTTextScale();
            result.setVal(copy.getVal());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createCTTextScale();
        }
        return null;
    }

    public HpsMeasure getCopy(HpsMeasure copy, boolean whenNull) {
        if (copy != null) {
            HpsMeasure result = this.myFactory.createHpsMeasure();
            result.setVal(copy.getVal());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createHpsMeasure();
        }
        return null;
    }

    public CTSignedHpsMeasure getCopy(CTSignedHpsMeasure copy, boolean whenNull) {
        if (copy != null) {
            CTSignedHpsMeasure result = this.myFactory.createCTSignedHpsMeasure();
            result.setVal(copy.getVal());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createCTSignedHpsMeasure();
        }
        return null;
    }

    public Highlight getCopy(Highlight copy, boolean whenNull) {
        if (copy != null) {
            Highlight result = this.myFactory.createHighlight();
            result.setVal(copy.getVal());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createHighlight();
        }
        return null;
    }

    public U getCopy(U copy, boolean whenNull) {
        if (copy != null) {
            U result = this.myFactory.createU();
            result.setVal(copy.getVal());
            result.setColor(copy.getColor());
            result.setThemeColor(copy.getThemeColor());
            result.setThemeTint(copy.getThemeTint());
            result.setThemeShade(copy.getThemeShade());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createU();
        }
        return null;
    }

    public CTTextEffect getCopy(CTTextEffect copy, boolean whenNull) {
        if (copy != null) {
            CTTextEffect result = this.myFactory.createCTTextEffect();
            result.setVal(copy.getVal());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createCTTextEffect();
        }
        return null;
    }

    public CTFitText getCopy(CTFitText copy, boolean whenNull) {
        if (copy != null) {
            CTFitText result = this.myFactory.createCTFitText();
            result.setVal(copy.getVal());
            result.setId(copy.getId());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createCTFitText();
        }
        return null;
    }

    public CTVerticalAlignRun getCopy(CTVerticalAlignRun copy, boolean whenNull) {
        if (copy != null) {
            CTVerticalAlignRun result = this.myFactory.createCTVerticalAlignRun();
            result.setVal(copy.getVal());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createCTVerticalAlignRun();
        }
        return null;
    }

    public CTEm getCopy(CTEm copy, boolean whenNull) {
        if (copy != null) {
            CTEm result = this.myFactory.createCTEm();
            result.setVal(copy.getVal());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createCTEm();
        }
        return null;
    }

    public CTLanguage getCopy(CTLanguage copy, boolean whenNull) {
        if (copy != null) {
            CTLanguage result = this.myFactory.createCTLanguage();
            result.setVal(copy.getVal());
            result.setEastAsia(copy.getEastAsia());
            result.setBidi(copy.getBidi());
            return result;
        }
        if (whenNull) {
            return this.myFactory.createCTLanguage();
        }
        return null;
    }

    public CTEastAsianLayout getCopy(CTEastAsianLayout copy, boolean whenNull) {
        if (copy != null) {
            CTEastAsianLayout result = this.myFactory.createCTEastAsianLayout();
            result.setId(copy.getId());
            result.setCombine(Boolean.valueOf(copy.isCombine()));
            result.setCombineBrackets(copy.getCombineBrackets());
            result.setVert(Boolean.valueOf(copy.isVert()));
            result.setVertCompress(Boolean.valueOf(copy.isVertCompress()));
            return result;
        }
        if (whenNull) {
            return this.myFactory.createCTEastAsianLayout();
        }
        return null;
    }

    public void setRPr(RPrAbstract result, RPrAbstract from, boolean whenNull) {
        result.setRStyle(this.getCopy(from == null ? null : from.getRStyle(), whenNull));
        result.setRFonts(this.getCopy(from == null ? null : from.getRFonts(), whenNull));
        result.setColor(this.getCopy(from == null ? null : from.getColor(), whenNull));
        result.setSpacing(this.getCopy(from == null ? null : from.getSpacing(), whenNull));
        result.setW(this.getCopy(from == null ? null : from.getW(), whenNull));
        result.setKern(this.getCopy(from == null ? null : from.getKern(), whenNull));
        result.setPosition(this.getCopy(from == null ? null : from.getPosition(), whenNull));
        result.setSz(this.getCopy(from == null ? null : from.getSz(), whenNull));
        result.setSzCs(this.getCopy(from == null ? null : from.getSzCs(), whenNull));
        result.setHighlight(this.getCopy(from == null ? null : from.getHighlight(), whenNull));
        result.setU(this.getCopy(from == null ? null : from.getU(), whenNull));
        result.setEffect(this.getCopy(from == null ? null : from.getEffect(), whenNull));
        result.setBdr(this.getCopy(from == null ? null : from.getBdr(), whenNull));
        result.setShd(this.getCopy(from == null ? null : from.getShd(), whenNull));
        result.setFitText(this.getCopy(from == null ? null : from.getFitText(), whenNull));
        result.setVertAlign(this.getCopy(from == null ? null : from.getVertAlign(), whenNull));
        result.setEm(this.getCopy(from == null ? null : from.getEm(), whenNull));
        result.setLang(this.getCopy(from == null ? null : from.getLang(), whenNull));
        result.setEastAsianLayout(this.getCopy(from == null ? null : from.getEastAsianLayout(), whenNull));
        if (from != null) {
            result.setB(from.getB());
            result.setBCs(from.getBCs());
            result.setI(from.getI());
            result.setICs(from.getICs());
            result.setCaps(from.getCaps());
            result.setSmallCaps(from.getSmallCaps());
            result.setStrike(from.getStrike());
            result.setDstrike(from.getDstrike());
            result.setOutline(from.getOutline());
            result.setShadow(from.getShadow());
            result.setEmboss(from.getEmboss());
            result.setImprint(from.getImprint());
            result.setNoProof(from.getNoProof());
            result.setSnapToGrid(from.getSnapToGrid());
            result.setVanish(from.getVanish());
            result.setWebHidden(from.getWebHidden());
            result.setRtl(from.getRtl());
            result.setCs(from.getCs());
            result.setSpecVanish(from.getSpecVanish());
            result.setOMath(from.getOMath());
        }
    }

    public void setPPrBase(PPrBase result, PPrBase from, boolean whenNull) {
        result.setPStyle(from == null ? null : this.getCopy(from.getPStyle(), whenNull));
        result.setFramePr(from == null ? null : this.getCopy(from.getFramePr(), whenNull));
        result.setNumPr(from == null ? null : this.getCopy(from.getNumPr(), whenNull));
        result.setPBdr(from == null ? null : this.getCopy(from.getPBdr(), whenNull));
        result.setShd(from == null ? null : this.getCopy(from.getShd(), whenNull));
        result.setTabs(from == null ? null : this.getCopy(from.getTabs(), whenNull));
        result.setSpacing(from == null ? null : this.getCopy(from.getSpacing(), whenNull));
        result.setInd(from == null ? null : this.getCopy(from.getInd(), whenNull));
        result.setJc(from == null ? null : this.getCopy(from.getJc(), whenNull));
        result.setTextDirection(from == null ? null : this.getCopy(from.getTextDirection(), whenNull));
        result.setTextAlignment(from == null ? null : this.getCopy(from.getTextAlignment(), whenNull));
        result.setTextboxTightWrap(from == null ? null : this.getCopy(from.getTextboxTightWrap(), whenNull));
        result.setOutlineLvl(from == null ? null : this.getCopy(from.getOutlineLvl(), whenNull));
        result.setDivId(from == null ? null : this.getCopy(from.getDivId(), whenNull));
        result.setCnfStyle(from == null ? null : this.getCopy(from.getCnfStyle(), whenNull));
        if (from != null) {
            result.setKeepNext(from.getKeepNext());
            result.setKeepLines(from.getKeepLines());
            result.setPageBreakBefore(from.getPageBreakBefore());
            result.setWidowControl(from.getWidowControl());
            result.setSuppressLineNumbers(from.getSuppressLineNumbers());
            result.setSuppressAutoHyphens(from.getSuppressAutoHyphens());
            result.setKinsoku(from.getKinsoku());
            result.setWordWrap(from.getWordWrap());
            result.setOverflowPunct(from.getOverflowPunct());
            result.setTopLinePunct(from.getTopLinePunct());
            result.setAutoSpaceDE(from.getAutoSpaceDE());
            result.setAutoSpaceDN(from.getAutoSpaceDN());
            result.setBidi(from.getBidi());
            result.setAdjustRightInd(from.getAdjustRightInd());
            result.setSnapToGrid(from.getSnapToGrid());
            result.setContextualSpacing(from.getContextualSpacing());
            result.setMirrorIndents(from.getMirrorIndents());
            result.setSuppressOverlap(from.getSuppressOverlap());
            result.setCollapsed(from.getCollapsed());
        }
    }

    public PPrBase.Ind keepDiff(PPrBase.Ind orig, PPrBase.Ind from) {
        if (from != null && orig != null) {
            if (orig.getLeft() != null && from.getLeft() != null && orig.getLeft().compareTo(from.getLeft()) == 0) {
                orig.setLeft(null);
            }
            if (orig.getLeft() != null && from.getLeft() != null && orig.getLeft().compareTo(from.getLeft()) == 0) {
                orig.setLeft(null);
            }
            if (orig.getLeftChars() != null && from.getLeftChars() != null && orig.getLeftChars().compareTo(from.getLeftChars()) == 0) {
                orig.setLeftChars(null);
            }
            if (orig.getRight() != null && from.getRight() != null && orig.getRight().compareTo(from.getRight()) == 0) {
                orig.setRight(null);
            }
            if (orig.getRightChars() != null && from.getRightChars() != null && orig.getRightChars().compareTo(from.getRightChars()) == 0) {
                orig.setRightChars(null);
            }
            if (orig.getHanging() != null && from.getHanging() != null && orig.getHanging().compareTo(from.getHanging()) == 0) {
                orig.setHanging(null);
            }
            if (orig.getHangingChars() != null && from.getHangingChars() != null && orig.getHangingChars().compareTo(from.getHangingChars()) == 0) {
                orig.setHangingChars(null);
            }
            if (orig.getFirstLine() != null && from.getFirstLine() != null && orig.getFirstLine().compareTo(from.getFirstLine()) == 0) {
                orig.setFirstLine(null);
            }
            if (orig.getFirstLineChars() != null && from.getFirstLineChars() != null && orig.getFirstLineChars().compareTo(from.getFirstLineChars()) == 0) {
                orig.setFirstLineChars(null);
            }
        }
        return StyleUtil.isEmpty((PPrBase.Ind)orig) ? null : orig;
    }

    public PPrBase.Spacing keepDiff(PPrBase.Spacing orig, PPrBase.Spacing from) {
        if (from != null && orig != null) {
            if (orig.getAfter() != null && from.getAfter() != null && orig.getAfter().compareTo(from.getAfter()) == 0) {
                orig.setAfter(null);
            }
            if (orig.getAfterLines() != null && from.getAfterLines() != null && orig.getAfterLines().compareTo(from.getAfterLines()) == 0) {
                orig.setAfterLines(null);
            }
            if (orig.getBefore() != null && from.getBefore() != null && orig.getBefore().compareTo(from.getBefore()) == 0) {
                orig.setBefore(null);
            }
            if (orig.getBeforeLines() != null && from.getBeforeLines() != null && orig.getBeforeLines().compareTo(from.getBeforeLines()) == 0) {
                orig.setBeforeLines(null);
            }
            if (orig.getLine() != null && from.getLine() != null && orig.getLine().compareTo(from.getLine()) == 0) {
                orig.setLine(null);
            }
            if (orig.getLineRule() != null && from.getLineRule() != null && orig.getLineRule().compareTo((Enum)from.getLineRule()) == 0) {
                orig.setLineRule(null);
            }
            if (orig.isAfterAutospacing() == from.isAfterAutospacing()) {
                orig.setAfterAutospacing(null);
            }
            if (orig.isBeforeAutospacing() == from.isBeforeAutospacing()) {
                orig.setBeforeAutospacing(null);
            }
        }
        return StyleUtil.isEmpty((PPrBase.Spacing)orig) ? null : orig;
    }

    public PPrBase.NumPr.Ilvl keepDiff(PPrBase.NumPr.Ilvl orig, PPrBase.NumPr.Ilvl from) {
        if (from != null && orig != null && orig.getVal() != null && from.getVal() != null && orig.getVal().compareTo(from.getVal()) == 0) {
            orig.setVal(null);
        }
        return orig == null || orig.getVal() == null ? null : orig;
    }

    public PPrBase.NumPr.NumId keepDiff(PPrBase.NumPr.NumId orig, PPrBase.NumPr.NumId from) {
        if (from != null && orig != null && orig.getVal() != null && from.getVal() != null && orig.getVal().compareTo(from.getVal()) == 0) {
            orig.setVal(null);
        }
        return orig == null || orig.getVal() == null ? null : orig;
    }

    public PPrBase.NumPr keepDiff(PPrBase.NumPr orig, PPrBase.NumPr from) {
        if (from != null && orig != null) {
            if (orig.getIlvl() != null) {
                orig.setIlvl(this.keepDiff(orig.getIlvl(), from.getIlvl()));
            }
            if (orig.getNumId() != null) {
                orig.setNumId(this.keepDiff(orig.getNumId(), from.getNumId()));
            }
        }
        return StyleUtil.isEmpty((PPrBase.NumPr)orig) ? null : orig;
    }

    public CTBorder keepDiff(CTBorder orig, CTBorder from) {
        if (from != null && orig != null) {
            if (orig.getVal() != null && from.getVal() != null && from.getVal() != null && orig.getVal().compareTo((Enum)from.getVal()) == 0) {
                orig.setVal(null);
            }
            if (orig.getThemeColor() != null && from.getThemeColor() != null && orig.getThemeColor().compareTo((Enum)from.getThemeColor()) == 0) {
                orig.setThemeColor(null);
            }
            if (orig.getSpace() != null && from.getSpace() != null && orig.getSpace().compareTo(from.getSpace()) == 0) {
                orig.setSpace(null);
            }
            if (orig.getSz() != null && from.getSz() != null && orig.getSz().compareTo(from.getSz()) == 0) {
                orig.setSz(null);
            }
            if (orig.getColor() != null && from.getColor() != null && orig.getColor().compareTo(from.getColor()) == 0) {
                orig.setColor(null);
            }
            if (orig.getThemeShade() != null && from.getThemeShade() != null && orig.getThemeShade().compareTo(from.getThemeShade()) == 0) {
                orig.setThemeShade(null);
            }
            if (orig.getThemeTint() != null && from.getThemeTint() != null && orig.getThemeTint().compareTo(from.getThemeTint()) == 0) {
                orig.setThemeTint(null);
            }
            if (orig.isFrame() == from.isFrame()) {
                orig.setFrame(null);
            }
            if (orig.isShadow() == from.isShadow()) {
                orig.setShadow(null);
            }
        }
        return StyleUtil.isEmpty((CTBorder)orig) ? null : orig;
    }

    public PPrBase.PBdr keepDiff(PPrBase.PBdr orig, PPrBase.PBdr from) {
        if (from != null && orig != null) {
            if (orig.getTop() != null) {
                orig.setTop(this.keepDiff(orig.getTop(), from.getTop()));
            }
            if (orig.getLeft() != null) {
                orig.setLeft(this.keepDiff(orig.getLeft(), from.getLeft()));
            }
            if (orig.getBottom() != null) {
                orig.setBottom(this.keepDiff(orig.getBottom(), from.getBottom()));
            }
            if (orig.getRight() != null) {
                orig.setRight(this.keepDiff(orig.getRight(), from.getRight()));
            }
            if (orig.getBetween() != null) {
                orig.setBetween(this.keepDiff(orig.getBetween(), from.getBetween()));
            }
            if (orig.getBar() != null) {
                orig.setBar(this.keepDiff(orig.getBar(), from.getBar()));
            }
        }
        return StyleUtil.isEmpty((PPrBase.PBdr)orig) ? null : orig;
    }

    public PPrBase.PStyle keepDiff(PPrBase.PStyle orig, PPrBase.PStyle from) {
        if (from != null && orig != null && orig.getVal() != null && from.getVal() != null && orig.getVal().compareTo(from.getVal()) == 0) {
            orig.setVal(null);
        }
        return orig == null || orig.getVal() == null ? null : orig;
    }

    public CTFramePr keepDiff(CTFramePr orig, CTFramePr from) {
        if (from != null && orig != null) {
            if (orig.getDropCap() != null && from.getDropCap() != null && orig.getDropCap().compareTo((Enum)from.getDropCap()) == 0) {
                orig.setDropCap(null);
            }
            if (orig.getLines() != null && from.getLines() != null && orig.getLines().compareTo(from.getLines()) == 0) {
                orig.setLines(null);
            }
            if (orig.getW() != null && from.getW() != null && orig.getW().compareTo(from.getW()) == 0) {
                orig.setW(null);
            }
            if (orig.getH() != null && from.getH() != null && orig.getH().compareTo(from.getH()) == 0) {
                orig.setH(null);
            }
            if (orig.getVSpace() != null && from.getVSpace() != null && orig.getVSpace().compareTo(from.getVSpace()) == 0) {
                orig.setVSpace(null);
            }
            if (orig.getHSpace() != null && from.getHSpace() != null && orig.getHSpace().compareTo(from.getHSpace()) == 0) {
                orig.setHSpace(null);
            }
            if (orig.getWrap() != null && from.getWrap() != null && orig.getWrap().compareTo((Enum)from.getWrap()) == 0) {
                orig.setWrap(null);
            }
            if (orig.getHAnchor() != null && from.getHAnchor() != null && orig.getHAnchor().compareTo((Enum)from.getHAnchor()) == 0) {
                orig.setHAnchor(null);
            }
            if (orig.getVAnchor() != null && from.getVAnchor() != null && orig.getVAnchor().compareTo((Enum)from.getVAnchor()) == 0) {
                orig.setVAnchor(null);
            }
            if (orig.getX() != null && from.getX() != null && orig.getX().compareTo(from.getX()) == 0) {
                orig.setX(null);
            }
            if (orig.getXAlign() != null && from.getXAlign() != null && orig.getXAlign().compareTo((Enum)from.getXAlign()) == 0) {
                orig.setXAlign(null);
            }
            if (orig.getY() != null && from.getY() != null && orig.getY().compareTo(from.getY()) == 0) {
                orig.setY(null);
            }
            if (orig.getYAlign() != null && from.getYAlign() != null && orig.getYAlign().compareTo((Enum)from.getYAlign()) == 0) {
                orig.setYAlign(null);
            }
            if (orig.getHRule() != null && from.getHRule() != null && orig.getHRule().compareTo((Enum)from.getHRule()) == 0) {
                orig.setHRule(null);
            }
            if (orig.isAnchorLock() == from.isAnchorLock()) {
                orig.setAnchorLock(null);
            }
        }
        return StyleUtil.isEmpty((CTFramePr)orig) ? null : orig;
    }

    public CTShd keepDiff(CTShd orig, CTShd from) {
        if (from != null && orig != null) {
            if (orig.getVal() != null && from.getVal() != null && from.getVal() != null && orig.getVal().compareTo((Enum)from.getVal()) == 0) {
                orig.setVal(null);
            }
            if (orig.getColor() != null && from.getColor() != null && orig.getColor().compareTo(from.getColor()) == 0) {
                orig.setColor(null);
            }
            if (orig.getThemeColor() != null && from.getThemeColor() != null && orig.getThemeColor().compareTo((Enum)from.getThemeColor()) == 0) {
                orig.setThemeColor(null);
            }
            if (orig.getThemeTint() != null && from.getThemeTint() != null && orig.getThemeTint().compareTo(from.getThemeTint()) == 0) {
                orig.setThemeTint(null);
            }
            if (orig.getThemeShade() != null && from.getThemeShade() != null && orig.getThemeShade().compareTo(from.getThemeShade()) == 0) {
                orig.setThemeShade(null);
            }
            if (orig.getFill() != null && from.getFill() != null && orig.getFill().compareTo(from.getFill()) == 0) {
                orig.setFill(null);
            }
            if (orig.getThemeFill() != null && from.getThemeFill() != null && orig.getThemeFill().compareTo((Enum)from.getThemeFill()) == 0) {
                orig.setThemeFill(null);
            }
            if (orig.getThemeFillTint() != null && from.getThemeFillTint() != null && orig.getThemeFillTint().compareTo(from.getThemeFillTint()) == 0) {
                orig.setThemeFillTint(null);
            }
            if (orig.getThemeFillShade() != null && from.getThemeFillShade() != null && orig.getThemeFillShade().compareTo(from.getThemeFillShade()) == 0) {
                orig.setThemeFillShade(null);
            }
        }
        return StyleUtil.isEmpty((CTShd)orig) ? null : orig;
    }

    public Tabs keepDiff(Tabs orig, Tabs from) {
        return StyleUtil.isEmpty((Tabs)orig) ? null : orig;
    }

    public Jc keepDiff(Jc orig, Jc from) {
        if (from != null && orig != null && orig.getVal() != null && from.getVal() != null && orig.getVal().compareTo((Enum)from.getVal()) == 0) {
            orig.setVal(null);
        }
        return StyleUtil.isEmpty((Jc)orig) ? null : orig;
    }

    public TextDirection keepDiff(TextDirection orig, TextDirection from) {
        if (from != null && orig != null && orig.getVal() != null && from.getVal() != null && orig.getVal().compareTo(from.getVal()) == 0) {
            orig.setVal(null);
        }
        return StyleUtil.isEmpty((TextDirection)orig) ? null : orig;
    }

    public PPrBase.TextAlignment keepDiff(PPrBase.TextAlignment orig, PPrBase.TextAlignment from) {
        if (from != null && orig != null && orig.getVal() != null && from.getVal() != null && orig.getVal().compareTo(from.getVal()) == 0) {
            orig.setVal(null);
        }
        return StyleUtil.isEmpty((PPrBase.TextAlignment)orig) ? null : orig;
    }

    public CTTextboxTightWrap keepDiff(CTTextboxTightWrap orig, CTTextboxTightWrap from) {
        if (from != null && orig != null && orig.getVal() != null && from.getVal() != null && orig.getVal().compareTo((Enum)from.getVal()) == 0) {
            orig.setVal(null);
        }
        return StyleUtil.isEmpty((CTTextboxTightWrap)orig) ? null : orig;
    }

    public PPrBase.OutlineLvl keepDiff(PPrBase.OutlineLvl orig, PPrBase.OutlineLvl from) {
        if (from != null && orig != null && orig.getVal() != null && from.getVal() != null && orig.getVal().compareTo(from.getVal()) == 0) {
            orig.setVal(null);
        }
        return StyleUtil.isEmpty((PPrBase.OutlineLvl)orig) ? null : orig;
    }

    public PPrBase.DivId keepDiff(PPrBase.DivId orig, PPrBase.DivId from) {
        if (from != null && orig != null && orig.getVal() != null && from.getVal() != null && orig.getVal().compareTo(from.getVal()) == 0) {
            orig.setVal(null);
        }
        return orig == null || orig.getVal() == null ? null : orig;
    }

    public CTCnf keepDiff(CTCnf orig, CTCnf from) {
        if (from != null && orig != null && orig.getVal() != null && from.getVal() != null && orig.getVal().compareTo(from.getVal()) == 0) {
            orig.setVal(null);
        }
        return StyleUtil.isEmpty((CTCnf)orig) ? null : orig;
    }

    public ParaRPr keepDiff(ParaRPr orig, ParaRPr from) {
        return StyleUtil.isEmpty((ParaRPr)orig) ? null : orig;
    }

    public RStyle keepDiff(RStyle orig, RStyle from) {
        if (from != null && orig != null && orig.getVal() != null && from.getVal() != null && orig.getVal().compareTo(from.getVal()) == 0) {
            orig.setVal(null);
        }
        return StyleUtil.isEmpty((RStyle)orig) ? null : orig;
    }

    public RFonts keepDiff(RFonts orig, RFonts from) {
        if (from != null && orig != null) {
            if (orig.getHint() != null && from.getHint() != null && orig.getHint().compareTo((Enum)from.getHint()) == 0) {
                orig.setHint(null);
            }
            if (orig.getAscii() != null && from.getAscii() != null && orig.getAscii().compareTo(from.getAscii()) == 0) {
                orig.setAscii(null);
            }
            if (orig.getHAnsi() != null && from.getHAnsi() != null && orig.getHAnsi().compareTo(from.getHAnsi()) == 0) {
                orig.setHAnsi(null);
            }
            if (orig.getEastAsia() != null && from.getEastAsia() != null && orig.getEastAsia().compareTo(from.getEastAsia()) == 0) {
                orig.setEastAsia(null);
            }
            if (orig.getCs() != null && from.getCs() != null && orig.getCs().compareTo(from.getCs()) == 0) {
                orig.setCs(null);
            }
            if (orig.getAsciiTheme() != null && from.getAsciiTheme() != null && orig.getAsciiTheme().compareTo((Enum)from.getAsciiTheme()) == 0) {
                orig.setAsciiTheme(null);
            }
            if (orig.getHAnsiTheme() != null && from.getHAnsiTheme() != null && orig.getHAnsiTheme().compareTo((Enum)from.getHAnsiTheme()) == 0) {
                orig.setHAnsiTheme(null);
            }
            if (orig.getEastAsiaTheme() != null && from.getEastAsiaTheme() != null && orig.getEastAsiaTheme().compareTo((Enum)from.getEastAsiaTheme()) == 0) {
                orig.setEastAsiaTheme(null);
            }
            if (orig.getCstheme() != null && from.getCstheme() != null && orig.getCstheme().compareTo((Enum)from.getCstheme()) == 0) {
                orig.setCstheme(null);
            }
        }
        return StyleUtil.isEmpty((RFonts)orig) ? null : orig;
    }

    public Color keepDiff(Color orig, Color from) {
        if (from != null && orig != null) {
            if (orig.getVal() != null && from.getVal() != null && from.getVal() != null && orig.getVal().compareTo(from.getVal()) == 0) {
                orig.setVal(null);
            }
            if (orig.getThemeColor() != null && from.getThemeColor() != null && orig.getThemeColor().compareTo((Enum)from.getThemeColor()) == 0) {
                orig.setThemeColor(null);
            }
            if (orig.getThemeTint() != null && from.getThemeTint() != null && orig.getThemeTint().compareTo(from.getThemeTint()) == 0) {
                orig.setThemeTint(null);
            }
            if (orig.getThemeShade() != null && from.getThemeShade() != null && orig.getThemeShade().compareTo(from.getThemeShade()) == 0) {
                orig.setThemeShade(null);
            }
        }
        return StyleUtil.isEmpty((Color)orig) ? null : orig;
    }

    public CTSignedTwipsMeasure keepDiff(CTSignedTwipsMeasure orig, CTSignedTwipsMeasure from) {
        if (from != null && orig != null && orig.getVal() != null && from.getVal() != null && orig.getVal().compareTo(from.getVal()) == 0) {
            orig.setVal(null);
        }
        return StyleUtil.isEmpty((CTSignedTwipsMeasure)orig) ? null : orig;
    }

    public CTTextScale keepDiff(CTTextScale orig, CTTextScale from) {
        if (from != null && orig != null) {
            if (orig.getVal() != null && from.getVal() != null && orig.getVal().compareTo(from.getVal()) == 0) {
                orig.setVal(null);
            }
            return null;
        }
        return StyleUtil.isEmpty((CTTextScale)orig) ? null : orig;
    }

    public HpsMeasure keepDiff(HpsMeasure orig, HpsMeasure from) {
        if (from != null && orig != null && orig.getVal() != null && from.getVal() != null && orig.getVal().compareTo(from.getVal()) == 0) {
            orig.setVal(null);
        }
        return StyleUtil.isEmpty((HpsMeasure)orig) ? null : orig;
    }

    public CTSignedHpsMeasure keepDiff(CTSignedHpsMeasure orig, CTSignedHpsMeasure from) {
        if (from != null && orig != null && orig.getVal() != null && from.getVal() != null && orig.getVal().compareTo(from.getVal()) == 0) {
            orig.setVal(null);
        }
        return StyleUtil.isEmpty((CTSignedHpsMeasure)orig) ? null : orig;
    }

    public Highlight keepDiff(Highlight orig, Highlight from) {
        if (from != null && orig != null && orig.getVal() != null && from.getVal() != null && orig.getVal().compareTo(from.getVal()) == 0) {
            orig.setVal(null);
        }
        return StyleUtil.isEmpty((Highlight)orig) ? null : orig;
    }

    public U keepDiff(U orig, U from) {
        if (from != null && orig != null) {
            if (orig.getVal() != null && from.getVal() != null && orig.getVal().compareTo((Enum)from.getVal()) == 0) {
                orig.setVal(null);
            }
            if (orig.getColor() != null && from.getColor() != null && orig.getColor().compareTo(from.getColor()) == 0) {
                orig.setColor(null);
            }
            if (orig.getThemeColor() != null && from.getThemeColor() != null && orig.getThemeColor().compareTo((Enum)from.getThemeColor()) == 0) {
                orig.setThemeColor(null);
            }
            if (orig.getThemeTint() != null && from.getThemeTint() != null && orig.getThemeTint().compareTo(from.getThemeTint()) == 0) {
                orig.setThemeTint(null);
            }
            if (orig.getThemeShade() != null && from.getThemeShade() != null && orig.getThemeShade().compareTo(from.getThemeShade()) == 0) {
                orig.setThemeShade(null);
            }
        }
        return StyleUtil.isEmpty((U)orig) ? null : orig;
    }

    public CTTextEffect keepDiff(CTTextEffect orig, CTTextEffect from) {
        if (from != null && orig != null && orig.getVal() != null && from.getVal() != null && orig.getVal().compareTo((Enum)from.getVal()) == 0) {
            orig.setVal(null);
        }
        return StyleUtil.isEmpty((CTTextEffect)orig) ? null : orig;
    }

    public CTFitText keepDiff(CTFitText orig, CTFitText from) {
        if (from != null && orig != null) {
            if (orig.getVal() != null && from.getVal() != null && orig.getVal().compareTo(from.getVal()) == 0) {
                orig.setVal(null);
            }
            if (orig.getId() != null && from.getId() != null && orig.getId().compareTo(from.getId()) == 0) {
                orig.setId(null);
            }
        }
        return orig == null || orig.getVal() == null && orig.getId() == null ? null : orig;
    }

    public CTVerticalAlignRun keepDiff(CTVerticalAlignRun orig, CTVerticalAlignRun from) {
        if (from != null && orig != null && orig.getVal() != null && from.getVal() != null && orig.getVal().compareTo((Enum)from.getVal()) == 0) {
            orig.setVal(null);
        }
        return StyleUtil.isEmpty((CTVerticalAlignRun)orig) ? null : orig;
    }

    public CTEm keepDiff(CTEm orig, CTEm from) {
        if (from != null && orig != null && orig.getVal() != null && from.getVal() != null && orig.getVal().compareTo((Enum)from.getVal()) == 0) {
            orig.setVal(null);
        }
        return StyleUtil.isEmpty((CTEm)orig) ? null : orig;
    }

    public CTLanguage keepDiff(CTLanguage orig, CTLanguage from) {
        if (from != null && orig != null) {
            if (orig.getVal() != null && from.getVal() != null && orig.getVal().compareTo(from.getVal()) == 0) {
                orig.setVal(null);
            }
            if (orig.getEastAsia() != null && from.getEastAsia() != null && orig.getEastAsia().compareTo(from.getEastAsia()) == 0) {
                orig.setEastAsia(null);
            }
            if (orig.getBidi() != null && from.getBidi() != null && orig.getBidi().compareTo(from.getBidi()) == 0) {
                orig.setBidi(null);
            }
        }
        return orig == null || orig.getVal() == null ? null : orig;
    }

    public CTEastAsianLayout keepDiff(CTEastAsianLayout orig, CTEastAsianLayout from) {
        if (from != null && orig != null) {
            if (orig.getId() != null && orig.getId().compareTo(from.getId()) == 0) {
                orig.setId(null);
            }
            if (orig.getCombineBrackets() != null && from.getCombineBrackets() != null && orig.getCombineBrackets().compareTo((Enum)from.getCombineBrackets()) == 0) {
                orig.setCombineBrackets(null);
            }
            if (orig.isCombine() == from.isCombine()) {
                orig.setCombine(null);
            }
            if (orig.isVert() == from.isVert()) {
                orig.setVert(null);
            }
            if (orig.isVertCompress() == from.isVertCompress()) {
                orig.setVertCompress(null);
            }
        }
        return orig == null || orig.getId() == null && orig.getCombineBrackets() == null && !orig.isCombine() && !orig.isVert() && !orig.isVertCompress() ? null : orig;
    }

    public RPr keepDiff(RPr orig, RPrAbstract from) {
        if (from != null && orig != null) {
            if (orig.getRFonts() != null) {
                orig.setRFonts(this.keepDiff(orig.getRFonts(), from.getRFonts()));
            }
            if (orig.getColor() != null) {
                orig.setColor(this.keepDiff(orig.getColor(), from.getColor()));
            }
            if (orig.getBdr() != null) {
                orig.setBdr(this.keepDiff(orig.getBdr(), from.getBdr()));
            }
            if (orig.getU() != null) {
                orig.setU(this.keepDiff(orig.getU(), from.getU()));
            }
            if (orig.getShd() != null) {
                orig.setShd(this.keepDiff(orig.getShd(), from.getShd()));
            }
            if (orig.getFitText() != null) {
                orig.setFitText(this.keepDiff(orig.getFitText(), from.getFitText()));
            }
            if (orig.getLang() != null) {
                orig.setLang(this.keepDiff(orig.getLang(), from.getLang()));
            }
            if (orig.getEastAsianLayout() != null) {
                orig.setEastAsianLayout(this.keepDiff(orig.getEastAsianLayout(), from.getEastAsianLayout()));
            }
            if (orig.getKern() != null) {
                orig.setKern(this.keepDiff(orig.getKern(), from.getKern()));
            }
            if (orig.getSz() != null) {
                orig.setSz(this.keepDiff(orig.getSz(), from.getSz()));
            }
            if (orig.getSzCs() != null) {
                orig.setSzCs(this.keepDiff(orig.getSzCs(), from.getSzCs()));
            }
            if (orig.getPosition() != null) {
                orig.setPosition(this.keepDiff(orig.getPosition(), from.getPosition()));
            }
            if (orig.getSpacing() != null) {
                orig.setSpacing(this.keepDiff(orig.getSpacing(), from.getSpacing()));
            }
            if (orig.getRStyle() != null) {
                orig.setRStyle(this.keepDiff(orig.getRStyle(), from.getRStyle()));
            }
            if (orig.getHighlight() != null) {
                orig.setHighlight(this.keepDiff(orig.getHighlight(), from.getHighlight()));
            }
            if (orig.getEffect() != null) {
                orig.setEffect(this.keepDiff(orig.getEffect(), from.getEffect()));
            }
            if (orig.getW() != null) {
                orig.setW(this.keepDiff(orig.getW(), from.getW()));
            }
            if (orig.getVertAlign() != null) {
                orig.setVertAlign(this.keepDiff(orig.getVertAlign(), from.getVertAlign()));
            }
            if (orig.getEm() != null) {
                orig.setEm(this.keepDiff(orig.getEm(), from.getEm()));
            }
            if (orig.getB() != null == (from.getB() != null)) {
                orig.setB(null);
            }
            if (orig.getBCs() != null == (from.getBCs() != null)) {
                orig.setBCs(null);
            }
            if (orig.getI() != null == (from.getI() != null)) {
                orig.setI(null);
            }
            if (orig.getICs() != null == (from.getICs() != null)) {
                orig.setICs(null);
            }
            if (orig.getCaps() != null == (from.getCaps() != null)) {
                orig.setCaps(null);
            }
            if (orig.getSmallCaps() != null == (from.getSmallCaps() != null)) {
                orig.setSmallCaps(null);
            }
            if (orig.getStrike() != null == (from.getStrike() != null)) {
                orig.setStrike(null);
            }
            if (orig.getDstrike() != null == (from.getDstrike() != null)) {
                orig.setDstrike(null);
            }
            if (orig.getOutline() != null == (from.getOutline() != null)) {
                orig.setOutline(null);
            }
            if (orig.getShadow() != null == (from.getShadow() != null)) {
                orig.setShadow(null);
            }
            if (orig.getEmboss() != null == (from.getEmboss() != null)) {
                orig.setEmboss(null);
            }
            if (orig.getImprint() != null == (from.getImprint() != null)) {
                orig.setImprint(null);
            }
            if (orig.getNoProof() != null == (from.getNoProof() != null)) {
                orig.setNoProof(null);
            }
            if (orig.getSnapToGrid() != null == (from.getSnapToGrid() != null)) {
                orig.setSnapToGrid(null);
            }
            if (orig.getVanish() != null == (from.getVanish() != null)) {
                orig.setVanish(null);
            }
            if (orig.getWebHidden() != null == (from.getWebHidden() != null)) {
                orig.setWebHidden(null);
            }
            if (orig.getRtl() != null == (from.getRtl() != null)) {
                orig.setRtl(null);
            }
            if (orig.getCs() != null == (from.getCs() != null)) {
                orig.setCs(null);
            }
            if (orig.getSpecVanish() != null == (from.getSpecVanish() != null)) {
                orig.setSpecVanish(null);
            }
            if (orig.getOMath() != null == (from.getOMath() != null)) {
                orig.setOMath(null);
            }
        }
        return StyleUtil.isEmpty((RPr)orig) ? null : orig;
    }

    public PPrBase keepDiff(PPrBase orig, PPrBase from) {
        if (from != null && orig != null) {
            if (orig.getPStyle() != null) {
                orig.setPStyle(this.keepDiff(orig.getPStyle(), from.getPStyle()));
            }
            if (orig.getCnfStyle() != null) {
                orig.setCnfStyle(this.keepDiff(orig.getCnfStyle(), from.getCnfStyle()));
            }
            if (orig.getFramePr() != null) {
                orig.setFramePr(this.keepDiff(orig.getFramePr(), from.getFramePr()));
            }
            if (orig.getShd() != null) {
                orig.setShd(this.keepDiff(orig.getShd(), from.getShd()));
            }
            if (orig.getTextboxTightWrap() != null) {
                orig.setTextboxTightWrap(this.keepDiff(orig.getTextboxTightWrap(), from.getTextboxTightWrap()));
            }
            if (orig.getJc() != null) {
                orig.setJc(this.keepDiff(orig.getJc(), from.getJc()));
            }
            if (orig.getInd() != null) {
                orig.setInd(this.keepDiff(orig.getInd(), from.getInd()));
            }
            if (orig.getNumPr() != null) {
                orig.setNumPr(this.keepDiff(orig.getNumPr(), from.getNumPr()));
            }
            if (orig.getPBdr() != null) {
                orig.setPBdr(this.keepDiff(orig.getPBdr(), from.getPBdr()));
            }
            if (orig.getSpacing() != null) {
                orig.setSpacing(this.keepDiff(orig.getSpacing(), from.getSpacing()));
            }
            if (orig.getTextAlignment() != null) {
                orig.setTextAlignment(this.keepDiff(orig.getTextAlignment(), from.getTextAlignment()));
            }
            if (orig.getTabs() != null) {
                orig.setTabs(this.keepDiff(orig.getTabs(), from.getTabs()));
            }
            if (orig.getTextDirection() != null) {
                orig.setTextDirection(this.keepDiff(orig.getTextDirection(), from.getTextDirection()));
            }
            if (orig.getDivId() != null) {
                orig.setDivId(this.keepDiff(orig.getDivId(), from.getDivId()));
            }
            if (orig.getOutlineLvl() != null) {
                orig.setOutlineLvl(this.keepDiff(orig.getOutlineLvl(), from.getOutlineLvl()));
            }
            if (orig.getAdjustRightInd() != null == (from.getAdjustRightInd() != null)) {
                orig.setAdjustRightInd(null);
            }
            if (orig.getAutoSpaceDE() != null == (from.getAutoSpaceDE() != null)) {
                orig.setAutoSpaceDE(null);
            }
            if (orig.getAutoSpaceDN() != null == (from.getAutoSpaceDN() != null)) {
                orig.setAutoSpaceDN(null);
            }
            if (orig.getBidi() != null == (from.getBidi() != null)) {
                orig.setBidi(null);
            }
            if (orig.getContextualSpacing() != null == (from.getContextualSpacing() != null)) {
                orig.setContextualSpacing(null);
            }
            if (orig.getKeepLines() != null == (from.getKeepLines() != null)) {
                orig.setKeepLines(null);
            }
            if (orig.getKeepNext() != null == (from.getKeepNext() != null)) {
                orig.setKeepNext(null);
            }
            if (orig.getKinsoku() != null == (from.getKinsoku() != null)) {
                orig.setKinsoku(null);
            }
            if (orig.getMirrorIndents() != null == (from.getMirrorIndents() != null)) {
                orig.setMirrorIndents(null);
            }
            if (orig.getOverflowPunct() != null == (from.getOverflowPunct() != null)) {
                orig.setOverflowPunct(null);
            }
            if (orig.getPageBreakBefore() != null == (from.getPageBreakBefore() != null)) {
                orig.setPageBreakBefore(null);
            }
            if (orig.getSnapToGrid() != null == (from.getSnapToGrid() != null)) {
                orig.setSnapToGrid(null);
            }
            if (orig.getSuppressAutoHyphens() != null == (from.getSuppressAutoHyphens() != null)) {
                orig.setSuppressAutoHyphens(null);
            }
            if (orig.getSuppressLineNumbers() != null == (from.getSuppressLineNumbers() != null)) {
                orig.setSuppressLineNumbers(null);
            }
            if (orig.getSuppressOverlap() != null == (from.getSuppressOverlap() != null)) {
                orig.setSuppressOverlap(null);
            }
            if (orig.getTopLinePunct() != null == (from.getTopLinePunct() != null)) {
                orig.setTopLinePunct(null);
            }
            if (orig.getWidowControl() != null == (from.getWidowControl() != null)) {
                orig.setWidowControl(null);
            }
            if (orig.getWordWrap() != null == (from.getWordWrap() != null)) {
                orig.setWordWrap(null);
            }
        }
        return StyleUtil.isEmpty((PPrBase)orig) ? null : orig;
    }

    public static enum CombineBigInt {
        NONE,
        ADD,
        MAX,
        MIN,
        ADD_OTHER,
        MAX_OTHER,
        MIN_OTHER,
        RANGE;


        BigInteger combine(BigInteger orig, BigInteger copy, BigInteger other) {
            if (this == ADD) {
                return copy == null && orig == null ? null : DocxHelper.safeBigInt(copy).add(DocxHelper.safeBigInt(orig));
            }
            if (this == MAX) {
                return copy == null && orig == null ? null : DocxHelper.safeBigInt(copy).max(DocxHelper.safeBigInt(orig));
            }
            if (this == MIN) {
                return copy == null && orig == null ? null : DocxHelper.safeBigInt(copy).max(DocxHelper.safeBigInt(orig));
            }
            if (this == ADD_OTHER) {
                return copy == null && orig == null && other == null ? null : DocxHelper.safeBigInt(copy).add(DocxHelper.safeBigInt(orig).add(DocxHelper.safeBigInt(other)));
            }
            if (this == MAX_OTHER) {
                return copy == null && orig == null && other == null ? null : DocxHelper.safeBigInt(copy).max(DocxHelper.safeBigInt(orig).max(DocxHelper.safeBigInt(other)));
            }
            if (this == MIN_OTHER) {
                return copy == null && orig == null && other == null ? null : DocxHelper.safeBigInt(copy).min(DocxHelper.safeBigInt(orig).min(DocxHelper.safeBigInt(other)));
            }
            if (this == RANGE) {
                return copy == null && orig == null && other == null ? null : DocxHelper.safeBigInt(copy).max(DocxHelper.safeBigInt(orig).min(DocxHelper.safeBigInt(other)));
            }
            return copy;
        }
    }
}

