/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.docx.converter.internal;

import com.vladsch.flexmark.Extension;
import com.vladsch.flexmark.IRender;
import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.docx.converter.DocxRendererContext;
import com.vladsch.flexmark.docx.converter.NodeDocxRenderer;
import com.vladsch.flexmark.docx.converter.NodeDocxRendererFactory;
import com.vladsch.flexmark.docx.converter.PhasedNodeDocxRenderer;
import com.vladsch.flexmark.docx.converter.internal.CoreNodeDocxRenderer;
import com.vladsch.flexmark.docx.converter.internal.DocxLinkResolver;
import com.vladsch.flexmark.docx.converter.internal.DocxRendererOptions;
import com.vladsch.flexmark.docx.converter.internal.DocxRendererPhase;
import com.vladsch.flexmark.docx.converter.internal.NodeDocxRendererHandler;
import com.vladsch.flexmark.docx.converter.util.DocxContextImpl;
import com.vladsch.flexmark.docx.converter.util.XmlFormatter;
import com.vladsch.flexmark.html.AttributeProviderFactory;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.LinkResolver;
import com.vladsch.flexmark.html.LinkResolverFactory;
import com.vladsch.flexmark.html.renderer.HeaderIdGeneratorFactory;
import com.vladsch.flexmark.html.renderer.LinkResolverContext;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.collection.NodeCollectingVisitor;
import com.vladsch.flexmark.util.collection.SubClassingBag;
import com.vladsch.flexmark.util.dependency.FlatDependencyHandler;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.html.Escaping;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.DataKey;
import com.vladsch.flexmark.util.options.DataSet;
import com.vladsch.flexmark.util.options.MutableDataHolder;
import com.vladsch.flexmark.util.options.MutableDataSet;
import com.vladsch.flexmark.util.options.ScopedDataSet;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.wml.Numbering;
import org.docx4j.wml.Styles;

public class DocxRenderer
implements IRender {
    public static final DataKey<String> STYLES_XML = new DataKey("STYLES_XML", (Object)DocxRenderer.getResourceString("/styles.xml"));
    public static final DataKey<String> NUMBERING_XML = new DataKey("NUMBERING_XML", (Object)DocxRenderer.getResourceString("/numbering.xml"));
    public static final DataKey<Boolean> RENDER_BODY_ONLY = new DataKey("RENDER_BODY_ONLY", (Object)false);
    public static final DataKey<Integer> MAX_IMAGE_WIDTH = new DataKey("MAX_IMAGE_WIDTH", (Object)0);
    public static final DataKey<Boolean> DEFAULT_LINK_RESOLVER = new DataKey("DEFAULT_LINK_RESOLVER", (Object)true);
    public static final DataKey<String> DOC_RELATIVE_URL = new DataKey("DOC_RELATIVE_URL", (Object)"");
    public static final DataKey<String> DOC_ROOT_URL = new DataKey("DOC_ROOT_URL", (Object)"");
    public static final DataKey<Boolean> RECHECK_UNDEFINED_REFERENCES = HtmlRenderer.RECHECK_UNDEFINED_REFERENCES;
    public static final DataKey<Boolean> PERCENT_ENCODE_URLS = HtmlRenderer.PERCENT_ENCODE_URLS;
    public static final DataKey<Boolean> ESCAPE_HTML = HtmlRenderer.ESCAPE_HTML;
    public static final DataKey<Boolean> ESCAPE_HTML_BLOCKS = HtmlRenderer.ESCAPE_HTML_BLOCKS;
    public static final DataKey<Boolean> ESCAPE_HTML_COMMENT_BLOCKS = HtmlRenderer.ESCAPE_HTML_COMMENT_BLOCKS;
    public static final DataKey<Boolean> ESCAPE_INLINE_HTML = HtmlRenderer.ESCAPE_INLINE_HTML;
    public static final DataKey<Boolean> ESCAPE_INLINE_HTML_COMMENTS = HtmlRenderer.ESCAPE_INLINE_HTML_COMMENTS;
    public static final DataKey<Boolean> SUPPRESS_HTML = HtmlRenderer.SUPPRESS_HTML;
    public static final DataKey<Boolean> SUPPRESS_HTML_BLOCKS = HtmlRenderer.SUPPRESS_HTML_BLOCKS;
    public static final DataKey<Boolean> SUPPRESS_HTML_COMMENT_BLOCKS = HtmlRenderer.SUPPRESS_HTML_COMMENT_BLOCKS;
    public static final DataKey<Boolean> SUPPRESS_INLINE_HTML = HtmlRenderer.SUPPRESS_INLINE_HTML;
    public static final DataKey<Boolean> SUPPRESS_INLINE_HTML_COMMENTS = HtmlRenderer.SUPPRESS_INLINE_HTML_COMMENTS;
    public static final DataKey<Boolean> LINEBREAK_ON_INLINE_HTML_BR = new DataKey("LINEBREAK_ON_INLINE_HTML_BR", (Object)true);
    public static final DataKey<Boolean> TABLE_CAPTION_TO_PARAGRAPH = new DataKey("TABLE_CAPTION_TO_PARAGRAPH", (Object)true);
    public static final DataKey<Boolean> TABLE_CAPTION_BEFORE_TABLE = new DataKey("TABLE_CAPTION_BEFORE_TABLE", (Object)false);
    public static final DataKey<Boolean> TOC_GENERATE = new DataKey("TOC_GENERATE", (Object)false);
    public static final DataKey<String> TOC_INSTRUCTION = new DataKey("TOC_INSTRUCTION", (Object)"TOC \\o \"1-3\" \\h \\z \\u ");
    private final List<NodeDocxRendererFactory> nodeFormatterFactories;
    final DocxRendererOptions rendererOptions;
    private final DataHolder options;
    private final Builder builder;
    private final List<LinkResolverFactory> linkResolverFactories;
    private static final Iterator<? extends Node> NULL_ITERATOR = new Iterator<Node>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Node next() {
            return null;
        }

        @Override
        public void remove() {
        }
    };
    static final Iterable<? extends Node> NULL_ITERABLE = new Iterable<Node>(){

        @Override
        public Iterator<Node> iterator() {
            return null;
        }
    };

    private DocxRenderer(Builder builder) {
        this.builder = new Builder(builder);
        this.options = new DataSet((DataHolder)builder);
        this.rendererOptions = new DocxRendererOptions(this.options);
        this.nodeFormatterFactories = new ArrayList<NodeDocxRendererFactory>(builder.nodeDocxRendererFactories.size() + 1);
        this.nodeFormatterFactories.addAll(builder.nodeDocxRendererFactories);
        this.nodeFormatterFactories.add(new NodeDocxRendererFactory(){

            @Override
            public NodeDocxRenderer create(DataHolder options) {
                return new CoreNodeDocxRenderer(options);
            }
        });
        this.linkResolverFactories = FlatDependencyHandler.computeDependencies(builder.linkResolverFactories);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DataHolder options) {
        return new Builder(options);
    }

    public static WordprocessingMLPackage getDefaultTemplate() {
        return DocxRenderer.getDefaultTemplate("/empty.xml");
    }

    public static WordprocessingMLPackage getDefaultTemplate(String emptyXMLResourcePath) {
        InputStream inputStream = DocxRenderer.getResourceInputStream(emptyXMLResourcePath);
        return DocxRenderer.getDefaultTemplate(inputStream);
    }

    public static WordprocessingMLPackage getDefaultTemplate(InputStream inputStream) {
        try {
            WordprocessingMLPackage mlPackage = WordprocessingMLPackage.load((InputStream)inputStream);
            return mlPackage;
        }
        catch (Docx4JException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void setDefaultStyleAndNumbering(WordprocessingMLPackage out, DataHolder options) {
        try {
            MainDocumentPart documentPart = out.getMainDocumentPart();
            if (documentPart == null) {
                try {
                    documentPart = new MainDocumentPart();
                    out.addTargetPart((Part)documentPart);
                }
                catch (InvalidFormatException e) {
                    e.printStackTrace();
                }
            }
            if (documentPart.getStyleDefinitionsPart() == null) {
                StyleDefinitionsPart stylesPart = new StyleDefinitionsPart();
                Styles styles = (Styles)XmlUtils.unmarshalString((String)((String)STYLES_XML.getFrom(options)));
                stylesPart.setJaxbElement(styles);
                documentPart.addTargetPart((Part)stylesPart);
                assert (documentPart.getStyleDefinitionsPart() != null) : "Styles failed to set";
            }
            if (documentPart.getNumberingDefinitionsPart() == null) {
                NumberingDefinitionsPart numberingPart = new NumberingDefinitionsPart();
                Numbering numbering = (Numbering)XmlUtils.unmarshalString((String)((String)NUMBERING_XML.getFrom(options)));
                numberingPart.setJaxbElement((Object)numbering);
                documentPart.addTargetPart((Part)numberingPart);
                assert (documentPart.getNumberingDefinitionsPart() != null) : "Numbering failed to set";
            }
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void render(Node node, WordprocessingMLPackage output) {
        MainDocxRenderer renderer = new MainDocxRenderer(this.options, output, node.getDocument());
        renderer.render(node);
    }

    public String render(Node node) {
        WordprocessingMLPackage mlPackage = DocxRenderer.getDefaultTemplate();
        this.render(node, mlPackage);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            mlPackage.save((OutputStream)outputStream, 2);
            String s = (Boolean)this.options.get(RENDER_BODY_ONLY) != false ? XmlFormatter.formatDocumentBody(outputStream.toString("UTF-8")) : XmlFormatter.format(outputStream.toString("UTF-8"));
            return s;
        }
        catch (Docx4JException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void render(Node node, Appendable output) {
        String docx = this.render(node);
        try {
            output.append(docx);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public DocxRenderer withOptions(DataHolder options) {
        return options == null ? this : new DocxRenderer(new Builder(this.builder, options));
    }

    public static String getResourceString(String resourcePath) {
        try {
            String line;
            InputStream stream = DocxRenderer.getResourceInputStream(resourcePath);
            StringBuilder sb = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, Charset.forName("UTF-8")));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            return sb.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream getResourceInputStream(String resourcePath) {
        String specPath = resourcePath != null ? resourcePath : "/spec.txt";
        InputStream stream = DocxRenderer.class.getResourceAsStream(specPath);
        if (stream == null) {
            throw new IllegalStateException("Could not load " + resourcePath + " classpath resource");
        }
        return stream;
    }

    private class MainDocxRenderer
    extends DocxContextImpl<Node>
    implements DocxRendererContext {
        private final Document document;
        private final Map<Class<?>, NodeDocxRendererHandler> renderers;
        private final SubClassingBag<Node> collectedNodes;
        private final List<PhasedNodeDocxRenderer> phasedFormatters;
        private final Set<DocxRendererPhase> renderingPhases;
        private final DataHolder options;
        private DocxRendererPhase phase;
        Node renderingNode;
        private final LinkResolver[] myLinkResolvers;
        private final HashMap<LinkType, HashMap<String, ResolvedLink>> resolvedLinkMap;

        MainDocxRenderer(DataHolder options, WordprocessingMLPackage out, Document document) {
            int i;
            super(out);
            this.resolvedLinkMap = new HashMap();
            this.options = new ScopedDataSet(options, (DataHolder)document);
            this.document = document;
            this.renderers = new HashMap(32);
            this.renderingPhases = new HashSet<DocxRendererPhase>(DocxRendererPhase.values().length);
            HashSet collectNodeTypes = new HashSet(100);
            this.phasedFormatters = new ArrayList<PhasedNodeDocxRenderer>(DocxRenderer.this.nodeFormatterFactories.size());
            Boolean defaultLinkResolver = (Boolean)DEFAULT_LINK_RESOLVER.getFrom(options);
            this.myLinkResolvers = new LinkResolver[DocxRenderer.this.linkResolverFactories.size() + (defaultLinkResolver != false ? 1 : 0)];
            DocxRenderer.setDefaultStyleAndNumbering(out, this.options);
            this.myBlockFormatProviders.put(document, this);
            this.myRunFormatProviders.put(document, this);
            for (i = 0; i < DocxRenderer.this.linkResolverFactories.size(); ++i) {
                this.myLinkResolvers[i] = ((LinkResolverFactory)DocxRenderer.this.linkResolverFactories.get(i)).create((LinkResolverContext)this);
            }
            if (defaultLinkResolver.booleanValue()) {
                this.myLinkResolvers[((DocxRenderer)DocxRenderer.this).linkResolverFactories.size()] = new DocxLinkResolver.Factory().create(this);
            }
            for (i = DocxRenderer.this.nodeFormatterFactories.size() - 1; i >= 0; --i) {
                NodeDocxRendererFactory nodeDocxRendererFactory = (NodeDocxRendererFactory)DocxRenderer.this.nodeFormatterFactories.get(i);
                NodeDocxRenderer nodeDocxRenderer = nodeDocxRendererFactory.create(this.getOptions());
                Set<NodeDocxRendererHandler<?>> formattingHandlers = nodeDocxRenderer.getNodeFormattingHandlers();
                if (formattingHandlers == null) continue;
                for (NodeDocxRendererHandler<?> nodeType : formattingHandlers) {
                    this.renderers.put(nodeType.getNodeType(), nodeType);
                }
                Set<Class<?>> nodeClasses = nodeDocxRenderer.getNodeClasses();
                if (nodeClasses != null) {
                    collectNodeTypes.addAll(nodeClasses);
                }
                if (!(nodeDocxRenderer instanceof PhasedNodeDocxRenderer)) continue;
                Set<DocxRendererPhase> phases = ((PhasedNodeDocxRenderer)nodeDocxRenderer).getFormattingPhases();
                if (phases != null) {
                    if (phases.isEmpty()) {
                        throw new IllegalStateException("PhasedNodeDocxRenderer with empty Phases");
                    }
                    this.renderingPhases.addAll(phases);
                    this.phasedFormatters.add((PhasedNodeDocxRenderer)nodeDocxRenderer);
                    continue;
                }
                throw new IllegalStateException("PhasedNodeDocxRenderer with null Phases");
            }
            if (!collectNodeTypes.isEmpty()) {
                NodeCollectingVisitor collectingVisitor = new NodeCollectingVisitor(collectNodeTypes);
                collectingVisitor.collect((Node)document);
                this.collectedNodes = collectingVisitor.getSubClassingBag();
            } else {
                this.collectedNodes = null;
            }
        }

        public String encodeUrl(CharSequence url) {
            if (DocxRenderer.this.rendererOptions.percentEncodeUrls) {
                return Escaping.percentEncodeUrl((CharSequence)url);
            }
            return url instanceof String ? (String)url : String.valueOf(url);
        }

        public Node getCurrentNode() {
            return this.renderingNode;
        }

        @Override
        public Node getContextFrame() {
            return this.renderingNode;
        }

        public DataHolder getOptions() {
            return this.options;
        }

        @Override
        public DocxRendererOptions getDocxRendererOptions() {
            return DocxRenderer.this.rendererOptions;
        }

        public Document getDocument() {
            return this.document;
        }

        @Override
        public DocxRendererPhase getPhase() {
            return this.phase;
        }

        @Override
        public final Iterable<? extends Node> nodesOfType(Class<?>[] classes) {
            return this.collectedNodes == null ? NULL_ITERABLE : this.collectedNodes.itemsOfType(Node.class, (Class[])classes);
        }

        @Override
        public final Iterable<? extends Node> nodesOfType(Collection<Class<?>> classes) {
            return this.collectedNodes == null ? NULL_ITERABLE : this.collectedNodes.itemsOfType(Node.class, classes);
        }

        @Override
        public final Iterable<? extends Node> reversedNodesOfType(Class<?>[] classes) {
            return this.collectedNodes == null ? NULL_ITERABLE : this.collectedNodes.reversedItemsOfType(Node.class, (Class[])classes);
        }

        @Override
        public final Iterable<? extends Node> reversedNodesOfType(Collection<Class<?>> classes) {
            return this.collectedNodes == null ? NULL_ITERABLE : this.collectedNodes.reversedItemsOfType(Node.class, classes);
        }

        public ResolvedLink resolveLink(LinkType linkType, CharSequence url, Boolean urlEncode) {
            return this.resolveLink(linkType, url, null, urlEncode);
        }

        public ResolvedLink resolveLink(LinkType linkType, CharSequence url, Attributes attributes, Boolean urlEncode) {
            String urlSeq;
            ResolvedLink resolvedLink;
            HashMap<String, Object> resolvedLinks = this.resolvedLinkMap.get(linkType);
            if (resolvedLinks == null) {
                resolvedLinks = new HashMap();
                this.resolvedLinkMap.put(linkType, resolvedLinks);
            }
            if ((resolvedLink = (ResolvedLink)resolvedLinks.get(urlSeq = url instanceof String ? (String)url : String.valueOf(url))) == null) {
                resolvedLink = new ResolvedLink(linkType, (CharSequence)urlSeq, attributes);
                if (!urlSeq.isEmpty()) {
                    LinkResolver linkResolver;
                    Node currentNode = this.renderingNode;
                    LinkResolver[] linkResolverArray = this.myLinkResolvers;
                    int n = linkResolverArray.length;
                    for (int i = 0; i < n && (resolvedLink = (linkResolver = linkResolverArray[i]).resolveLink(currentNode, (LinkResolverContext)this, resolvedLink)).getStatus() == LinkStatus.UNKNOWN; ++i) {
                    }
                    if (urlEncode == null && DocxRenderer.this.rendererOptions.percentEncodeUrls || urlEncode != null && urlEncode.booleanValue()) {
                        resolvedLink = resolvedLink.withUrl((CharSequence)Escaping.percentEncodeUrl((CharSequence)resolvedLink.getUrl()));
                    }
                }
                resolvedLinks.put(urlSeq, resolvedLink);
            }
            return resolvedLink;
        }

        public void render(Node node) {
            if (node instanceof Document) {
                for (DocxRendererPhase phase : DocxRendererPhase.values()) {
                    if (phase != DocxRendererPhase.DOCUMENT && !this.renderingPhases.contains((Object)phase)) continue;
                    this.phase = phase;
                    if (this.phase == DocxRendererPhase.DOCUMENT) {
                        NodeDocxRendererHandler nodeRenderer = this.renderers.get(node.getClass());
                        if (nodeRenderer == null) continue;
                        this.renderingNode = node;
                        nodeRenderer.render(node, (DocxRendererContext)this);
                        this.renderingNode = null;
                        continue;
                    }
                    for (PhasedNodeDocxRenderer phasedFormatter : this.phasedFormatters) {
                        if (!phasedFormatter.getFormattingPhases().contains((Object)phase)) continue;
                        this.renderingNode = node;
                        phasedFormatter.renderDocument(this, (Document)node, phase);
                        this.renderingNode = null;
                    }
                }
            } else {
                NodeDocxRendererHandler nodeRenderer = this.renderers.get(node.getClass());
                if (nodeRenderer == null) {
                    nodeRenderer = this.renderers.get(Node.class);
                }
                if (nodeRenderer != null) {
                    final NodeDocxRendererHandler finalNodeRenderer = nodeRenderer;
                    final Node oldNode = this.renderingNode;
                    this.renderingNode = node;
                    this.contextFramed(new Runnable(){

                        @Override
                        public void run() {
                            finalNodeRenderer.render(MainDocxRenderer.this.renderingNode, (DocxRendererContext)MainDocxRenderer.this);
                            MainDocxRenderer.this.renderingNode = oldNode;
                        }
                    });
                } else {
                    throw new IllegalStateException("Core Node DocxRenderer should implement generic Node renderer");
                }
            }
        }

        public void renderChildren(Node parent) {
            Node node = parent.getFirstChild();
            while (node != null) {
                Node next = node.getNext();
                this.render(node);
                node = next;
            }
        }

        @Override
        public Node getProviderFrame() {
            return this.document;
        }
    }

    public static interface RendererExtension
    extends Extension {
        public void rendererOptions(MutableDataHolder var1);

        public void extend(Builder var1);
    }

    public static class Builder
    extends MutableDataSet {
        List<AttributeProviderFactory> attributeProviderFactories = new ArrayList<AttributeProviderFactory>();
        List<NodeDocxRendererFactory> nodeDocxRendererFactories = new ArrayList<NodeDocxRendererFactory>();
        List<LinkResolverFactory> linkResolverFactories = new ArrayList<LinkResolverFactory>();
        private final HashSet<RendererExtension> loadedExtensions = new HashSet();
        HeaderIdGeneratorFactory htmlIdGeneratorFactory = null;

        public Builder() {
        }

        public Builder(DataHolder options) {
            super(options);
            if (options.contains(Parser.EXTENSIONS)) {
                this.extensions((Iterable)this.get(Parser.EXTENSIONS));
            }
        }

        public Builder(Builder other) {
            super((DataHolder)other);
            this.attributeProviderFactories.addAll(other.attributeProviderFactories);
            this.nodeDocxRendererFactories.addAll(other.nodeDocxRendererFactories);
            this.linkResolverFactories.addAll(other.linkResolverFactories);
            this.loadedExtensions.addAll(other.loadedExtensions);
            this.htmlIdGeneratorFactory = other.htmlIdGeneratorFactory;
        }

        public Builder(Builder other, DataHolder options) {
            super((DataHolder)other);
            ArrayList<Extension> extensions = new ArrayList<Extension>();
            for (Extension extension : (Iterable)this.get(Parser.EXTENSIONS)) {
                extensions.add(extension);
            }
            if (options != null) {
                for (DataKey key : options.keySet()) {
                    if (key == Parser.EXTENSIONS) {
                        for (Extension extension : (Iterable)options.get(Parser.EXTENSIONS)) {
                            extensions.add(extension);
                        }
                        continue;
                    }
                    this.set(key, options.get(key));
                }
            }
            this.set(Parser.EXTENSIONS, extensions);
            this.extensions(extensions);
        }

        public DocxRenderer build() {
            return new DocxRenderer(this);
        }

        public Builder nodeFormatterFactory(NodeDocxRendererFactory nodeDocxRendererFactory) {
            this.nodeDocxRendererFactories.add(nodeDocxRendererFactory);
            return this;
        }

        public Builder linkResolverFactory(LinkResolverFactory linkResolverFactory) {
            this.linkResolverFactories.add(linkResolverFactory);
            return this;
        }

        public Builder extensions(Iterable<? extends Extension> extensions) {
            RendererExtension rendererExtension;
            for (Extension extension : extensions) {
                if (!(extension instanceof RendererExtension) || this.loadedExtensions.contains(extension)) continue;
                rendererExtension = (RendererExtension)extension;
                rendererExtension.rendererOptions((MutableDataHolder)this);
            }
            for (Extension extension : extensions) {
                if (!(extension instanceof RendererExtension) || this.loadedExtensions.contains(extension)) continue;
                rendererExtension = (RendererExtension)extension;
                rendererExtension.extend(this);
                this.loadedExtensions.add(rendererExtension);
            }
            return this;
        }
    }
}

