/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.docx.converter.util;

import com.vladsch.flexmark.docx.converter.util.DocxContext;
import com.vladsch.flexmark.docx.converter.util.RunFormatProvider;
import org.docx4j.model.styles.StyleUtil;
import org.docx4j.wml.RPr;
import org.docx4j.wml.RStyle;
import org.docx4j.wml.Style;

public class RunFormatProviderBase<T>
implements RunFormatProvider<T> {
    protected final DocxContext<T> myDocx;
    protected final T myFrame;
    protected final RunFormatProvider<T> myParent;
    protected final String myBaseStyleId;

    public RunFormatProviderBase(DocxContext<T> docx, String baseStyleId) {
        this.myDocx = docx;
        this.myFrame = docx.getContextFrame();
        this.myParent = docx.getRunFormatProvider();
        this.myBaseStyleId = baseStyleId;
    }

    @Override
    public T getProviderFrame() {
        return this.myFrame;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public Style getStyle() {
        return this.myDocx.getStyle(this.myBaseStyleId);
    }

    @Override
    public String getStyleId() {
        return this.myBaseStyleId;
    }

    @Override
    public RunFormatProvider<T> getRunParent() {
        return this.myParent;
    }

    protected RunFormatProvider<T> getStyleParent() {
        return this.myParent;
    }

    protected void inheritParentStyle(RPr rPr, RPr parentRPr) {
        RPr parentStyledRPr = this.myDocx.getHelper().getExplicitRPr(parentRPr);
        StyleUtil.apply((RPr)rPr, (RPr)parentStyledRPr);
        StyleUtil.apply((RPr)parentStyledRPr, (RPr)rPr);
        Style style = this.getStyle();
        if (style != null) {
            RPr styleRPr = this.myDocx.getHelper().getExplicitRPr(style.getRPr());
            StyleUtil.apply((RPr)rPr, (RPr)styleRPr);
            StyleUtil.apply((RPr)styleRPr, (RPr)rPr);
        }
    }

    @Override
    public void getRPr(RPr rPr) {
        RStyle rstyle = this.myDocx.getFactory().createRStyle();
        rPr.setRStyle(rstyle);
        rstyle.setVal(this.myBaseStyleId);
        RunFormatProvider<T> parent = this.myParent;
        if (parent != null) {
            RPr rpr1 = this.myDocx.getFactory().createRPr();
            parent.getRPr(rpr1);
            this.inheritParentStyle(rPr, rpr1);
        }
    }
}

