/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.docx.converter.util;

import com.vladsch.flexmark.docx.converter.util.DocxContext;
import com.vladsch.flexmark.docx.converter.util.RunFormatProvider;
import org.docx4j.model.styles.StyleUtil;
import org.docx4j.wml.ParaRPr;
import org.docx4j.wml.RPr;
import org.docx4j.wml.RPrAbstract;
import org.docx4j.wml.RStyle;
import org.docx4j.wml.Style;

public class RunFormatProviderBase<T>
implements RunFormatProvider<T> {
    protected final DocxContext<T> myDocx;
    protected final T myFrame;
    protected final RunFormatProvider<T> myParent;
    protected final String myBaseStyleId;
    protected final boolean myNoCharacterStyles;

    public RunFormatProviderBase(DocxContext<T> docx, String baseStyleId, boolean noCharacterStyles) {
        this.myDocx = docx;
        this.myFrame = docx.getContextFrame();
        this.myParent = docx.getRunFormatProvider();
        this.myBaseStyleId = baseStyleId;
        this.myNoCharacterStyles = noCharacterStyles;
    }

    @Override
    public T getProviderFrame() {
        return this.myFrame;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public Style getStyle() {
        return this.myDocx.getStyle(this.myBaseStyleId);
    }

    @Override
    public String getStyleId() {
        return this.myBaseStyleId;
    }

    @Override
    public RunFormatProvider<T> getRunParent() {
        return this.myParent;
    }

    protected RunFormatProvider<T> getStyleParent() {
        return this.myParent;
    }

    protected void inheritParentStyle(RPr rPr, RPr parentRPr) {
        RPr parentStyledRPr = this.myDocx.getHelper().getExplicitRPr(parentRPr);
        StyleUtil.apply((RPr)rPr, (RPr)parentStyledRPr);
        StyleUtil.apply((RPr)parentStyledRPr, (RPr)rPr);
        Style style = this.getStyle();
        if (style != null) {
            RPr styleRPr = this.myDocx.getHelper().getExplicitRPr(style.getRPr());
            StyleUtil.apply((RPr)rPr, (RPr)styleRPr);
            StyleUtil.apply((RPr)styleRPr, (RPr)rPr);
        }
    }

    @Override
    public void getRPr(RPr rPr) {
        Style thisStyle;
        RunFormatProvider<T> parent;
        if (!this.myNoCharacterStyles) {
            RStyle rstyle = this.myDocx.getFactory().createRStyle();
            rPr.setRStyle(rstyle);
            rstyle.setVal(this.myBaseStyleId);
        }
        if ((parent = this.myParent) != null) {
            RPr rpr1 = this.myDocx.getFactory().createRPr();
            parent.getRPr(rpr1);
            this.inheritParentStyle(rPr, rpr1);
        }
        if (this.myNoCharacterStyles && (thisStyle = this.myDocx.getStyle(this.myBaseStyleId)) != null) {
            RPr pr = this.myDocx.getHelper().getExplicitRPr(thisStyle.getRPr());
            ParaRPr paraRPr = this.myDocx.getP().getPPr().getRPr();
            this.myDocx.getHelper().keepDiff(rPr, (RPrAbstract)paraRPr);
        }
    }
}

