/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.pdf.converter;

import com.openhtmltopdf.DOMBuilder;
import com.openhtmltopdf.bidi.BidiReorderer;
import com.openhtmltopdf.bidi.BidiSplitterFactory;
import com.openhtmltopdf.bidi.support.ICUBidiReorderer;
import com.openhtmltopdf.bidi.support.ICUBidiSplitter;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.DataKey;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class PdfConverterExtension {
    public static final DataKey<PdfRendererBuilder.TextDirection> DEFAULT_TEXT_DIRECTION = new DataKey<PdfRendererBuilder.TextDirection>("DEFAULT_TEXT_DIRECTION", (PdfRendererBuilder.TextDirection)null);

    public static void exportToPdf(String out, String html, String url, DataHolder options) {
        PdfConverterExtension.exportToPdf(out, html, url, options.get(DEFAULT_TEXT_DIRECTION));
    }

    public static void exportToPdf(String out, String html, String url, PdfRendererBuilder.TextDirection defaultTextDirection) {
        try {
            FileOutputStream os = new FileOutputStream(out);
            PdfConverterExtension.exportToPdf((OutputStream)os, html, url, defaultTextDirection);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void exportToPdf(OutputStream os, String html, String url, DataHolder options) {
        PdfConverterExtension.exportToPdf(os, html, url, options.get(DEFAULT_TEXT_DIRECTION));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportToPdf(OutputStream os, String html, String url, PdfRendererBuilder.TextDirection defaultTextDirection) {
        try {
            PdfRendererBuilder builder = new PdfRendererBuilder();
            if (defaultTextDirection != null) {
                builder.useUnicodeBidiSplitter((BidiSplitterFactory)new ICUBidiSplitter.ICUBidiSplitterFactory());
                builder.useUnicodeBidiReorderer((BidiReorderer)new ICUBidiReorderer());
                builder.defaultTextDirection(defaultTextDirection);
            }
            Document doc = Jsoup.parse((String)html);
            org.w3c.dom.Document dom = DOMBuilder.jsoup2DOM((Document)doc);
            builder.withW3cDocument(dom, url);
            builder.toStream(os);
            builder.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
    }
}

