/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gfm.tables.internal;

import com.vladsch.flexmark.ast.Block;
import com.vladsch.flexmark.ast.BlockContent;
import com.vladsch.flexmark.ast.CustomNode;
import com.vladsch.flexmark.ext.gfm.tables.TableBlock;
import com.vladsch.flexmark.ext.gfm.tables.TableBody;
import com.vladsch.flexmark.ext.gfm.tables.TableCell;
import com.vladsch.flexmark.ext.gfm.tables.TableHead;
import com.vladsch.flexmark.ext.gfm.tables.TableRow;
import com.vladsch.flexmark.ext.gfm.tables.TableSeparator;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class TableBlockParser
extends AbstractBlockParser {
    private static String COL = "\\s*:?-{3,}:?\\s*";
    private static Pattern TABLE_HEADER_SEPARATOR = Pattern.compile("\\|" + COL + "\\|?\\s*|" + COL + "\\|\\s*|\\|?(?:" + COL + "\\|)+" + COL + "\\|?\\s*");
    private final TableBlock block = new TableBlock();
    private BlockContent content = new BlockContent();
    private boolean nextIsSeparatorLine = false;
    private BasedSequence separatorLine = BasedSequence.NULL;
    private int separatorLineNumber = 0;
    public static boolean bodyColumnsFilledToHead = true;
    public static boolean bodyColumnsTruncatedToHead = true;
    public static int maxHeaderRows = 1;

    private TableBlockParser() {
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        if (state.getLine().toString().contains("|")) {
            return BlockContinue.atIndex(state.getIndex());
        }
        return BlockContinue.none();
    }

    @Override
    public void addLine(ParserState state, BasedSequence line) {
        if (this.nextIsSeparatorLine) {
            this.nextIsSeparatorLine = false;
            this.separatorLine = line;
            this.separatorLineNumber = this.content.getLineCount();
        }
        this.content.add(line, state.getIndent());
    }

    @Override
    public void closeBlock(ParserState state) {
        this.block.setContent(this.content);
        this.content = null;
    }

    @Override
    public void parseInlines(InlineParser inlineParser) {
        CustomNode section = new TableHead();
        this.block.appendChild(section);
        List<TableCell.Alignment> alignments = TableBlockParser.parseAlignment(this.separatorLine);
        int rowNumber = 0;
        int separatorColumns = alignments.size();
        for (BasedSequence rowLine : this.block.getContentLines()) {
            int rowCells;
            if (rowNumber == this.separatorLineNumber) {
                section.setCharsFromContent();
                section = new TableSeparator();
                this.block.appendChild(section);
            } else if (rowNumber == this.separatorLineNumber + 1) {
                section.setCharsFromContent();
                section = new TableBody();
                this.block.appendChild(section);
            }
            List<BasedSequence> cells = TableBlockParser.split(rowLine);
            TableRow tableRow = new TableRow(rowLine.trimEOL());
            int maxColumns = rowCells = this.countCells(cells);
            if (bodyColumnsTruncatedToHead && maxColumns > separatorColumns) {
                maxColumns = separatorColumns;
            }
            if (rowNumber >= this.separatorLineNumber) {
                if (!bodyColumnsFilledToHead && rowCells < maxColumns) {
                    maxColumns = rowCells;
                } else if (bodyColumnsFilledToHead && maxColumns < separatorColumns) {
                    maxColumns = separatorColumns;
                }
            }
            int segmentOffset = 0;
            BasedSequence openingMarker = BasedSequence.NULL;
            for (int i = 0; i < maxColumns; ++i) {
                BasedSequence closingMarker;
                BasedSequence cell;
                BasedSequence basedSequence = cell = i < rowCells ? cells.get(i + segmentOffset) : BasedSequence.NULL;
                if (!this.isCell(cell)) {
                    openingMarker = cell;
                    cell = i < rowCells ? cells.get(i + ++segmentOffset) : BasedSequence.NULL;
                }
                TableCell.Alignment alignment = i < alignments.size() ? alignments.get(i) : null;
                TableCell tableCell = new TableCell();
                tableCell.setHeader(rowNumber < this.separatorLineNumber);
                tableCell.setAlignment(alignment);
                tableCell.setOpeningMarker(openingMarker);
                openingMarker = BasedSequence.NULL;
                if (i + segmentOffset + 1 < cells.size() && !this.isCell(closingMarker = cells.get(i + segmentOffset + 1))) {
                    ++segmentOffset;
                    tableCell.setClosingMarker(closingMarker);
                }
                BasedSequence trimmed = cell.trim();
                tableCell.setText(trimmed);
                inlineParser.parse(trimmed, tableCell);
                tableCell.setCharsFromContent();
                tableRow.appendChild(tableCell);
            }
            tableRow.setCharsFromContent();
            section.appendChild(tableRow);
            ++rowNumber;
        }
        if (section instanceof TableSeparator) {
            this.block.appendChild(new TableBody());
        }
        section.setCharsFromContent();
    }

    private int countCells(List<BasedSequence> segments) {
        int cells = 0;
        for (BasedSequence segment : segments) {
            if (!this.isCell(segment)) continue;
            ++cells;
        }
        return cells;
    }

    private boolean isCell(BasedSequence segment) {
        return segment.length() != 1 || segment.charAt(0) != '|';
    }

    private static List<TableCell.Alignment> parseAlignment(BasedSequence separatorLine) {
        List<BasedSequence> parts = TableBlockParser.split(separatorLine);
        ArrayList<TableCell.Alignment> alignments = new ArrayList<TableCell.Alignment>();
        for (BasedSequence part : parts) {
            BasedSequence trimmed = part.trim();
            boolean left = trimmed.startsWith(":");
            boolean right = trimmed.endsWith(":");
            TableCell.Alignment alignment = TableBlockParser.getAlignment(left, right);
            alignments.add(alignment);
        }
        return alignments;
    }

    private static List<BasedSequence> split(BasedSequence input) {
        BasedSequence line = input.trim();
        int lineLength = line.length();
        ArrayList<BasedSequence> segments = new ArrayList<BasedSequence>();
        if (line.startsWith("|")) {
            line = line.subSequence(1, lineLength);
            --lineLength;
        }
        boolean escape = false;
        int lastPos = 0;
        int cellChars = 0;
        block4: for (int i = 0; i < lineLength; ++i) {
            char c = line.charAt(i);
            if (escape) {
                escape = false;
                ++cellChars;
                continue;
            }
            switch (c) {
                case '\\': {
                    escape = true;
                    ++cellChars;
                    continue block4;
                }
                case '|': {
                    segments.add(line.subSequence(lastPos, i));
                    lastPos = i + 1;
                    cellChars = 0;
                    continue block4;
                }
                default: {
                    ++cellChars;
                }
            }
        }
        if (cellChars > 0) {
            segments.add(line.subSequence(lastPos, lineLength));
        }
        return segments;
    }

    private static TableCell.Alignment getAlignment(boolean left, boolean right) {
        if (left && right) {
            return TableCell.Alignment.CENTER;
        }
        if (left) {
            return TableCell.Alignment.LEFT;
        }
        if (right) {
            return TableCell.Alignment.RIGHT;
        }
        return null;
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private BlockFactory(DataHolder options) {
            super(options);
        }

        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            BasedSequence line = state.getLine();
            List<BasedSequence> paragraphLines = matchedBlockParser.getParagraphLines();
            if (paragraphLines != null && paragraphLines.size() >= 1 && paragraphLines.size() <= maxHeaderRows && paragraphLines.get(0).toString().contains("|")) {
                BasedSequence separatorLine = line.subSequence(state.getIndex(), line.length());
                if (TABLE_HEADER_SEPARATOR.matcher(separatorLine).matches()) {
                    BasedSequence paragraph = paragraphLines.get(0);
                    List headParts = TableBlockParser.split(paragraph);
                    List separatorParts = TableBlockParser.split(separatorLine);
                    if (separatorParts.size() >= headParts.size()) {
                        TableBlockParser tableBlockParser = new TableBlockParser();
                        tableBlockParser.addLine(state, paragraph);
                        tableBlockParser.nextIsSeparatorLine = true;
                        return BlockStart.of(tableBlockParser).atIndex(state.getIndex()).replaceActiveBlockParser();
                    }
                }
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        @Override
        public Set<Class<? extends CustomBlockParserFactory>> getAfterDependents() {
            return null;
        }

        @Override
        public Set<Class<? extends CustomBlockParserFactory>> getBeforeDependents() {
            return null;
        }

        @Override
        public boolean affectsGlobalScope() {
            return false;
        }

        @Override
        public BlockParserFactory create(DataHolder options) {
            return new BlockFactory(options);
        }
    }
}

