/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.footnotes.internal;

import com.vladsch.flexmark.ext.footnotes.Footnote;
import com.vladsch.flexmark.ext.footnotes.FootnoteBlock;
import com.vladsch.flexmark.ext.footnotes.FootnoteExtension;
import com.vladsch.flexmark.ext.footnotes.internal.FootnoteFormatOptions;
import com.vladsch.flexmark.ext.footnotes.internal.FootnoteRepository;
import com.vladsch.flexmark.formatter.CustomNodeFormatter;
import com.vladsch.flexmark.formatter.internal.MarkdownWriter;
import com.vladsch.flexmark.formatter.internal.NodeFormatter;
import com.vladsch.flexmark.formatter.internal.NodeFormatterContext;
import com.vladsch.flexmark.formatter.internal.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.internal.NodeFormattingHandler;
import com.vladsch.flexmark.formatter.internal.NodeRepositoryFormatter;
import com.vladsch.flexmark.util.format.options.ElementPlacement;
import com.vladsch.flexmark.util.format.options.ElementPlacementSort;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class FootnoteNodeFormatter
extends NodeRepositoryFormatter<FootnoteRepository, FootnoteBlock, Footnote> {
    private final FootnoteFormatOptions options;

    public FootnoteNodeFormatter(DataHolder options) {
        super(options);
        this.options = new FootnoteFormatOptions(options);
    }

    @Override
    public FootnoteRepository getRepository(DataHolder options) {
        return FootnoteExtension.FOOTNOTES.getFrom(options);
    }

    @Override
    public ElementPlacement getReferencePlacement() {
        return this.options.footnotePlacement;
    }

    @Override
    public ElementPlacementSort getReferenceSort() {
        return this.options.footnoteSort;
    }

    @Override
    public void renderReferenceBlock(FootnoteBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.blankLine().append("[^").append(node.getText()).append("]: ");
        markdown.pushPrefix().addPrefix("    ");
        context.renderChildren(node);
        markdown.popPrefix();
        markdown.blankLine();
    }

    @Override
    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler<Footnote>(Footnote.class, new CustomNodeFormatter<Footnote>(){

            @Override
            public void render(Footnote node, NodeFormatterContext context, MarkdownWriter markdown) {
                FootnoteNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<FootnoteBlock>(FootnoteBlock.class, new CustomNodeFormatter<FootnoteBlock>(){

            @Override
            public void render(FootnoteBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
                FootnoteNodeFormatter.this.render(node, context, markdown);
            }
        })));
    }

    @Override
    public Set<Class<?>> getNodeClasses() {
        if (this.options.footnotePlacement != ElementPlacement.AS_IS && this.options.footnoteSort != ElementPlacementSort.SORT_UNUSED_LAST) {
            return null;
        }
        return new HashSet(Arrays.asList(Footnote.class));
    }

    private void render(FootnoteBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.renderReference(node, context, markdown);
    }

    private void render(Footnote node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.append("[^");
        context.renderChildren(node);
        markdown.append("]");
    }

    public static class Factory
    implements NodeFormatterFactory {
        @Override
        public NodeFormatter create(DataHolder options) {
            return new FootnoteNodeFormatter(options);
        }
    }
}

