/*
 * Decompiled with CFR 0.152.
 */
package com.vkpapps.apmanager;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.location.LocationManager;
import android.net.Uri;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.app.ActivityCompat;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class APManager {
    private static APManager apManager;
    private final Utils utils;
    private String ssid;
    private String password;
    public static final int ERROR_GPS_PROVIDER_DISABLED = 0;
    public static final int ERROR_LOCATION_PERMISSION_DENIED = 4;
    public static final int ERROR_DISABLE_HOTSPOT = 1;
    public static final int ERROR_DISABLE_WIFI = 5;
    public static final int ERROR_WRITE_SETTINGS_PERMISSION_REQUIRED = 6;
    public static final int ERROR_UNKNOWN = 3;
    private final WifiManager wifiManager;
    private final LocationManager locationManager;
    private WifiManager.LocalOnlyHotspotReservation reservation;

    private APManager(Context context) {
        this.wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        this.locationManager = (LocationManager)context.getSystemService("location");
        this.utils = new Utils();
    }

    public static APManager getApManager(@NonNull Context context) {
        if (apManager == null) {
            apManager = new APManager(context);
        }
        return apManager;
    }

    public String getSSID() {
        return this.ssid;
    }

    public String getPassword() {
        return this.password;
    }

    public Utils getUtils() {
        return this.utils;
    }

    public void turnOnHotspot(Context context, final OnSuccessListener onSuccessListener, final OnFailureListener onFailureListener) {
        boolean providerEnabled = this.locationManager.isProviderEnabled("gps");
        if (this.wifiManager.getDhcpInfo().ipAddress != 0) {
            onFailureListener.onFailure(5, null);
            return;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            if (this.utils.checkLocationPermission(context) && providerEnabled && !this.isWifiApEnabled()) {
                try {
                    this.wifiManager.startLocalOnlyHotspot(new WifiManager.LocalOnlyHotspotCallback(){

                        public void onStarted(WifiManager.LocalOnlyHotspotReservation reservation) {
                            super.onStarted(reservation);
                            APManager.this.reservation = reservation;
                            try {
                                APManager.this.ssid = reservation.getWifiConfiguration().SSID;
                                APManager.this.password = reservation.getWifiConfiguration().preSharedKey;
                                onSuccessListener.onSuccess(APManager.this.ssid, APManager.this.password);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                onFailureListener.onFailure(3, e);
                            }
                        }

                        public void onFailed(int reason) {
                            super.onFailed(reason);
                            onFailureListener.onFailure(reason == 4 ? 1 : 3, null);
                        }
                    }, new Handler(Looper.getMainLooper()));
                }
                catch (Exception e) {
                    onFailureListener.onFailure(3, e);
                }
            } else if (!providerEnabled) {
                onFailureListener.onFailure(0, null);
            } else if (this.isWifiApEnabled()) {
                onFailureListener.onFailure(1, null);
            } else {
                onFailureListener.onFailure(4, null);
            }
        } else {
            if (Build.VERSION.SDK_INT >= 23) {
                if (!this.utils.checkLocationPermission(context)) {
                    onFailureListener.onFailure(4, null);
                    return;
                }
                if (!this.utils.checkWriteSettingPermission(context)) {
                    onFailureListener.onFailure(6, null);
                    return;
                }
            }
            try {
                this.ssid = "AndroidAP_" + new Random().nextInt(10000);
                this.password = this.getRandomPassword();
                WifiConfiguration wifiConfiguration = new WifiConfiguration();
                wifiConfiguration.SSID = this.ssid;
                wifiConfiguration.preSharedKey = this.password;
                wifiConfiguration.allowedAuthAlgorithms.set(1);
                wifiConfiguration.allowedProtocols.set(1);
                wifiConfiguration.allowedProtocols.set(0);
                wifiConfiguration.allowedKeyManagement.set(1);
                this.wifiManager.setWifiEnabled(false);
                this.setWifiApEnabled(wifiConfiguration, true);
                onSuccessListener.onSuccess(this.ssid, this.password);
            }
            catch (Exception e) {
                e.printStackTrace();
                onFailureListener.onFailure(4, e);
            }
        }
    }

    public void disableWifiAp() {
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                this.reservation.close();
            } else {
                this.setWifiApEnabled(null, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isWifiApEnabled() {
        try {
            Method method = this.wifiManager.getClass().getMethod("isWifiApEnabled", new Class[0]);
            return (Boolean)method.invoke((Object)this.wifiManager, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void setWifiApEnabled(WifiConfiguration wifiConfiguration, boolean enable) throws Exception {
        Method method = this.wifiManager.getClass().getMethod("setWifiApEnabled", WifiConfiguration.class, Boolean.TYPE);
        method.invoke((Object)this.wifiManager, wifiConfiguration, enable);
    }

    private String getRandomPassword() {
        try {
            MessageDigest ms = MessageDigest.getInstance("MD5");
            byte[] bytes = new byte[10];
            new Random().nextBytes(bytes);
            byte[] digest = ms.digest(bytes);
            BigInteger bigInteger = new BigInteger(1, digest);
            return bigInteger.toString(16).substring(0, 10);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "jfs82433#$2";
        }
    }

    public static class Utils {
        public boolean checkLocationPermission(Context context) {
            return ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
        }

        public void askLocationPermission(Activity activity, int requestCode) {
            ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION"}, (int)requestCode);
        }

        @RequiresApi(value=23)
        public void askWriteSettingPermission(@NonNull Activity activity) {
            Intent intent = new Intent("android.settings.action.MANAGE_WRITE_SETTINGS");
            intent.setData(Uri.parse((String)("package:" + activity.getPackageName())));
            activity.startActivity(intent);
        }

        @RequiresApi(value=23)
        public boolean checkWriteSettingPermission(@NonNull Context context) {
            return Settings.System.canWrite((Context)context);
        }

        public Intent getTetheringSettingIntent() {
            Intent intent = new Intent();
            intent.setClassName("com.android.settings", "com.android.settings.TetherSettings");
            return intent;
        }

        public void askForGpsProvider(Activity activity) {
            Intent intent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
            activity.startActivity(intent);
        }

        public void askForDisableWifi(Activity activity) {
            activity.startActivity(new Intent("android.settings.WIFI_SETTINGS"));
        }
    }

    public static interface OnSuccessListener {
        public void onSuccess(String var1, String var2);
    }

    public static interface OnFailureListener {
        public void onFailure(int var1, @Nullable Exception var2);
    }
}

