/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.data;

import com.vesoft.nebula.driver.graph.data.NLineString;
import com.vesoft.nebula.driver.graph.data.NPoint;
import com.vesoft.nebula.driver.graph.data.NPolygon;

public class Geography {
    private GeoShape shape;
    protected NPoint point;
    protected NLineString lineString;
    protected NPolygon polygon;

    public Geography(GeoShape shape) {
        this.shape = shape;
    }

    public GeoShape getShape() {
        return this.shape;
    }

    public NPoint asPoint() {
        if (this.shape != GeoShape.GeoShapePoint) {
            throw new RuntimeException("geo shape is " + this.shape.name());
        }
        return this.point;
    }

    public NLineString asLineString() {
        if (this.shape != GeoShape.GeoShapeLineString) {
            throw new RuntimeException("geo shape is " + this.shape.name());
        }
        return this.lineString;
    }

    public NPolygon asPolygon() {
        if (this.shape != GeoShape.GeoShapePolygon) {
            throw new RuntimeException("geo shape is " + this.shape.name());
        }
        return this.polygon;
    }

    public String toString() {
        switch (this.shape) {
            case GeoShapePoint: {
                return this.point.toString();
            }
            case GeoShapeLineString: {
                return this.lineString.toString();
            }
            case GeoShapePolygon: {
                return this.polygon.toString();
            }
        }
        throw new RuntimeException("do not support geo shape:" + (Object)((Object)this.shape));
    }

    public static enum GeoShape {
        GeoShapePoint(1),
        GeoShapeLineString(5),
        GeoShapePolygon(9);

        private final int shape;

        private GeoShape(int shape) {
            this.shape = shape;
        }

        public static GeoShape getGeoShape(int shape) {
            for (GeoShape geoShape : GeoShape.values()) {
                if (geoShape.shape != shape) continue;
                return geoShape;
            }
            throw new RuntimeException("does not define the GeoShape type:" + shape);
        }
    }
}

