/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.net;

import com.vesoft.nebula.driver.graph.data.ResultSet;
import com.vesoft.nebula.driver.graph.exception.AuthFailedException;
import com.vesoft.nebula.driver.graph.exception.IOErrorException;
import com.vesoft.nebula.driver.graph.net.NebulaClient;
import com.vesoft.nebula.driver.graph.net.NebulaPool;
import com.vesoft.nebula.driver.graph.net.RoundRobinLoadBalancer;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientPoolFactory
extends BasePooledObjectFactory<NebulaClient>
implements Serializable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RoundRobinLoadBalancer loadBalancer;
    private final NebulaPool.Builder builder;

    public ClientPoolFactory(RoundRobinLoadBalancer loadBalancer, NebulaPool.Builder builder) {
        this.loadBalancer = loadBalancer;
        this.builder = builder;
    }

    public NebulaClient create() throws IOErrorException, AuthFailedException {
        int tryCreate = 0;
        IOErrorException ioException = null;
        AuthFailedException authException = null;
        while (tryCreate++ < this.loadBalancer.addressSize()) {
            try {
                return this.createClient();
            }
            catch (IOErrorException e) {
                ioException = e;
            }
            catch (AuthFailedException e) {
                authException = e;
            }
        }
        if (authException != null) {
            throw authException;
        }
        if (ioException != null) {
            throw ioException;
        }
        throw new IOErrorException(1, "No servers host is available, please check your servers is up and network between client and server is connected.");
    }

    private NebulaClient createClient() throws AuthFailedException, IOErrorException {
        NebulaClient client = NebulaClient.builder(this.loadBalancer.getAddress().toString(), this.builder.userName).withAuthOptions(this.builder.authOptions).withConnectTimeoutMills(this.builder.connectTimeoutMills).withRequestTimeoutMills(this.builder.requestTimeoutMills).withScanParallel(this.builder.scanParallel).withEnableTls(this.builder.enableTls).withDisableVerifyServerCert(this.builder.disableVerifyServerCert).withTlsCa(this.builder.tlsCa).withTlsCert(this.builder.tlsCert, this.builder.tlsKey).build();
        switch (client.getVersion()) {
            default: 
        }
        try {
            String stmt;
            ResultSet resultSet;
            if (this.builder.schema != null && !this.builder.schema.isEmpty() && !(resultSet = client.execute(stmt = String.format("SESSION SET SCHEMA \"%s\"", this.builder.schema))).isSucceeded()) {
                throw new RuntimeException(String.format("%s failed for %s", stmt, resultSet.getErrorMessage()));
            }
            if (this.builder.graph != null && !this.builder.graph.isEmpty() && !(resultSet = client.execute(stmt = String.format("SESSION SET GRAPH \"%s\"", this.builder.graph))).isSucceeded()) {
                throw new RuntimeException(String.format("%s failed for %s", stmt, resultSet.getErrorMessage()));
            }
            for (Map.Entry<String, String> config : this.builder.sessionConfigs.entrySet()) {
                stmt = String.format("SESSION SET %s=%s", config.getKey(), config.getValue());
                resultSet = client.execute(stmt);
                if (resultSet.isSucceeded()) continue;
                throw new RuntimeException(String.format("%s failed for %s", stmt, resultSet.getErrorMessage()));
            }
            if (!this.builder.parameters.isEmpty()) {
                ResultSet result;
                StringBuilder parametersSetStatement = new StringBuilder();
                parametersSetStatement.append("SESSION SET VALUE ");
                for (Map.Entry entry : this.builder.parameters.entrySet()) {
                    parametersSetStatement.append("$").append((String)entry.getKey()).append("=").append((String)entry.getValue()).append(",");
                }
                parametersSetStatement.deleteCharAt(parametersSetStatement.length() - 1);
                if (!parametersSetStatement.toString().isEmpty() && !(result = client.execute(parametersSetStatement.toString())).isSucceeded()) {
                    throw new RuntimeException(String.format("%s failed for %s", parametersSetStatement, result.getErrorMessage()));
                }
            }
            for (String preStmt : this.builder.preStatements) {
                ResultSet resultSet2 = client.execute(preStmt);
                if (resultSet2.isSucceeded()) continue;
                throw new RuntimeException(String.format("%s failed for %s", preStmt, resultSet2.getErrorMessage()));
            }
        }
        catch (IOErrorException e) {
            client.close();
            throw e;
        }
        return client;
    }

    public PooledObject<NebulaClient> wrap(NebulaClient client) {
        return new DefaultPooledObject((Object)client);
    }

    public void destroyObject(PooledObject<NebulaClient> clientObject) throws Exception {
        NebulaClient client = (NebulaClient)clientObject.getObject();
        try {
            client.close();
        }
        catch (Exception e) {
            this.logger.warn("session release failed ", (Throwable)e);
        }
        super.destroyObject(clientObject);
    }

    public boolean validateObject(PooledObject<NebulaClient> clientObject) {
        NebulaClient client = (NebulaClient)clientObject.getObject();
        boolean isAlive = System.currentTimeMillis() - client.getCreateTime() < this.builder.maxLifeTimeMs;
        return client.ping(this.builder.serverPingTimeoutMills) && isAlive;
    }
}

