/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.scan;

import com.vesoft.nebula.driver.graph.data.ExtraInfo;
import com.vesoft.nebula.driver.graph.data.HostAddress;
import com.vesoft.nebula.driver.graph.data.ResultSet;
import com.vesoft.nebula.driver.graph.net.NebulaClient;
import com.vesoft.nebula.driver.graph.utils.GqlUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanResultIterator
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(ScanResultIterator.class);
    String serversAddress;
    protected boolean hasNext = true;
    protected final Map<Integer, String> partCursor = new HashMap<Integer, String>();
    protected final String graphName;
    protected final String labelName;
    protected List<String> propNames;
    protected int batchSize;
    protected final ExecutorService threadPool;
    protected final ConcurrentHashMap<Integer, NebulaClient> partClient = new ConcurrentHashMap();

    protected ScanResultIterator(String graphName, String labelName, List<String> propNames, List<Integer> parts, int batchSize, int parallel, List<HostAddress> servers, NebulaClient.Builder builder) {
        this.graphName = graphName;
        this.labelName = labelName;
        this.propNames = propNames;
        this.batchSize = batchSize;
        this.threadPool = Executors.newFixedThreadPool(parallel);
        this.serversAddress = servers.stream().map(HostAddress::toString).collect(Collectors.joining(","));
        for (int part : parts) {
            this.partCursor.put(part, "");
            try {
                this.partClient.put(part, NebulaClient.builder(builder).build());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    protected String getPropertyListString() {
        StringBuilder properties = new StringBuilder();
        String propertyListPrefix = "list[";
        properties.append(propertyListPrefix);
        for (String column : this.propNames) {
            properties.append("\"");
            properties.append(GqlUtil.escape(column));
            properties.append("\"");
            properties.append(",");
        }
        if (properties.length() > propertyListPrefix.length()) {
            properties.deleteCharAt(properties.length() - 1);
        }
        String propertyListSuffix = "]";
        properties.append(propertyListSuffix);
        return properties.toString();
    }

    protected ResultSet scan(String scanTemplate, Map.Entry<Integer, String> partCur) throws Exception {
        String producer = String.format(scanTemplate, GqlUtil.escape(this.graphName), GqlUtil.escape(this.graphName), GqlUtil.escape(this.labelName), this.getPropertyListString(), partCur.getKey(), partCur.getValue(), this.batchSize);
        NebulaClient client = this.partClient.get(partCur.getKey());
        return client.execute(producer);
    }

    protected String getCursor(ResultSet resultSet) {
        ExtraInfo extraInfo = resultSet.getExtraInfo();
        if (extraInfo.getCursor() == null) {
            throw new RuntimeException("result does not contain cursor in extra info.");
        }
        return extraInfo.getCursor();
    }

    protected void close() {
        for (NebulaClient client : this.partClient.values()) {
            client.close();
        }
    }
}

