/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.decode.struct;

import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class NodeHeader {
    private final ByteOrder byteOrder;
    private long nodeId;
    private int graphId;
    private int nodeTypeId;

    public NodeHeader(ByteString byteString, ByteOrder order) {
        this.byteOrder = order;
        ByteBuffer buffer = ByteBuffer.wrap(byteString.toByteArray()).order(this.byteOrder);
        this.nodeId = buffer.getLong();
        this.nodeTypeId = (int)(this.nodeId >> 48);
        this.graphId = this.bytesToInt(buffer.array(), 8, 4);
    }

    private int bytesToInt(byte[] bytes, int offset, int size) {
        ByteBuffer buffer = ByteBuffer.allocate(size).order(this.byteOrder);
        buffer.put(bytes, offset, size);
        buffer.flip();
        return buffer.getInt();
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public int getGraphId() {
        return this.graphId;
    }

    public int getNodeTypeId() {
        return this.nodeTypeId;
    }
}

