/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.driver.graph.decode.datatype;

import com.vesoft.nebula.driver.graph.decode.BytesReader;
import com.vesoft.nebula.driver.graph.decode.ColumnType;
import com.vesoft.nebula.driver.graph.decode.DecodeUtils;
import com.vesoft.nebula.driver.graph.decode.datatype.BasicType;
import com.vesoft.nebula.driver.graph.decode.datatype.DataType;
import com.vesoft.nebula.driver.graph.decode.datatype.EdgeType;
import com.vesoft.nebula.driver.graph.decode.datatype.ListType;
import com.vesoft.nebula.driver.graph.decode.datatype.NodeType;
import com.vesoft.nebula.driver.graph.decode.datatype.PathType;
import com.vesoft.nebula.driver.graph.decode.datatype.RecordType;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ValueTypeParser {
    private final ByteOrder byteOrder;

    public ValueTypeParser(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public DataType getDataType(BytesReader reader) {
        return this.decodeValueType(reader);
    }

    public DataType decodeValueType(BytesReader reader) {
        ColumnType type = ColumnType.getColumnType(DecodeUtils.bytesToUInt8(reader.read(1)));
        switch (type) {
            case COLUMN_TYPE_NULL: 
            case COLUMN_TYPE_BOOL: 
            case COLUMN_TYPE_INT8: 
            case COLUMN_TYPE_UINT8: 
            case COLUMN_TYPE_INT16: 
            case COLUMN_TYPE_UINT16: 
            case COLUMN_TYPE_INT32: 
            case COLUMN_TYPE_UINT32: 
            case COLUMN_TYPE_INT64: 
            case COLUMN_TYPE_UINT64: 
            case COLUMN_TYPE_FLOAT32: 
            case COLUMN_TYPE_FLOAT64: 
            case COLUMN_TYPE_STRING: 
            case COLUMN_TYPE_DATE: 
            case COLUMN_TYPE_LOCALTIME: 
            case COLUMN_TYPE_ZONEDTIME: 
            case COLUMN_TYPE_LOCALDATETIME: 
            case COLUMN_TYPE_ZONEDDATETIME: 
            case COLUMN_TYPE_DURATION: 
            case COLUMN_TYPE_REFERENCE: 
            case COLUMN_TYPE_ANY: 
            case COLUMN_TYPE_INVALID: {
                return new BasicType(type);
            }
            case COLUMN_TYPE_DECIMAL: {
                reader.read(4);
                return new BasicType(type);
            }
            case COLUMN_TYPE_NODE: {
                Map<Integer, Map<Integer, Map<String, DataType>>> nodeTypes = this.getPropertyNameAndTypeFromValueType(reader, 2, this.byteOrder);
                return new NodeType(nodeTypes);
            }
            case COLUMN_TYPE_EDGE: {
                Map<Integer, Map<Integer, Map<String, DataType>>> edgeTypes = this.getPropertyNameAndTypeFromValueType(reader, 4, this.byteOrder);
                return new EdgeType(edgeTypes);
            }
            case COLUMN_TYPE_PATH: {
                int elementNum = DecodeUtils.bytesToInt32(reader.read(4), this.byteOrder);
                ArrayList<DataType> dataTypes = new ArrayList<DataType>();
                for (int i = 0; i < elementNum; ++i) {
                    dataTypes.add(this.decodeValueType(reader));
                }
                return new PathType(dataTypes);
            }
            case COLUMN_TYPE_LIST: {
                DataType dataType = this.decodeValueType(reader);
                return new ListType(dataType);
            }
            case COLUMN_TYPE_RECORD: {
                int fieldNum = DecodeUtils.bytesToInt32(reader.read(4), this.byteOrder);
                HashMap<String, DataType> fieldTypes = new HashMap<String, DataType>();
                for (int i = 0; i < fieldNum; ++i) {
                    String fieldName = reader.readSizedString(this.byteOrder);
                    fieldTypes.put(fieldName, this.decodeValueType(reader));
                }
                return new RecordType(fieldTypes);
            }
        }
        throw new RuntimeException("unsupported type:" + (Object)((Object)type));
    }

    private Map<Integer, Map<Integer, Map<String, DataType>>> getPropertyNameAndTypeFromValueType(BytesReader reader, int typeIdSize, ByteOrder byteOrder) {
        int typeNum = DecodeUtils.bytesToInt32(reader.read(4), byteOrder);
        HashMap<Integer, Map<Integer, Map<String, DataType>>> graphTypeFields = new HashMap<Integer, Map<Integer, Map<String, DataType>>>();
        for (int i = 0; i < typeNum; ++i) {
            int graphId = DecodeUtils.bytesToInt32(reader.read(4), byteOrder);
            if (!graphTypeFields.containsKey(graphId)) {
                graphTypeFields.put(graphId, new HashMap());
            }
            int typeId = typeIdSize == 2 ? (int)DecodeUtils.bytesToInt16(reader.read(typeIdSize), byteOrder).shortValue() : DecodeUtils.bytesToInt32(reader.read(typeIdSize), byteOrder);
            int typePropertyNum = DecodeUtils.bytesToInt32(reader.read(4), byteOrder);
            HashMap<String, DataType> propertyAndType = new HashMap<String, DataType>();
            for (int j = 0; j < typePropertyNum; ++j) {
                String propertyName = reader.readSizedString(byteOrder);
                DataType dataType = this.decodeValueType(reader);
                propertyAndType.put(propertyName, dataType);
            }
            ((Map)graphTypeFields.get(graphId)).put(typeId, propertyAndType);
        }
        return graphTypeFields;
    }
}

